# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServerTypeResult',
    'AwaitableGetServerTypeResult',
    'get_server_type',
    'get_server_type_output',
]

@pulumi.output_type
class GetServerTypeResult:
    """
    A collection of values returned by getServerType.
    """
    def __init__(__self__, arch=None, availability=None, capabilities=None, cpu=None, end_of_service=None, gpu=None, hourly_price=None, id=None, name=None, networks=None, ram=None, volumes=None, zone=None):
        if arch and not isinstance(arch, str):
            raise TypeError("Expected argument 'arch' to be a str")
        pulumi.set(__self__, "arch", arch)
        if availability and not isinstance(availability, str):
            raise TypeError("Expected argument 'availability' to be a str")
        pulumi.set(__self__, "availability", availability)
        if capabilities and not isinstance(capabilities, list):
            raise TypeError("Expected argument 'capabilities' to be a list")
        pulumi.set(__self__, "capabilities", capabilities)
        if cpu and not isinstance(cpu, int):
            raise TypeError("Expected argument 'cpu' to be a int")
        pulumi.set(__self__, "cpu", cpu)
        if end_of_service and not isinstance(end_of_service, bool):
            raise TypeError("Expected argument 'end_of_service' to be a bool")
        pulumi.set(__self__, "end_of_service", end_of_service)
        if gpu and not isinstance(gpu, int):
            raise TypeError("Expected argument 'gpu' to be a int")
        pulumi.set(__self__, "gpu", gpu)
        if hourly_price and not isinstance(hourly_price, float):
            raise TypeError("Expected argument 'hourly_price' to be a float")
        pulumi.set(__self__, "hourly_price", hourly_price)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if networks and not isinstance(networks, list):
            raise TypeError("Expected argument 'networks' to be a list")
        pulumi.set(__self__, "networks", networks)
        if ram and not isinstance(ram, int):
            raise TypeError("Expected argument 'ram' to be a int")
        pulumi.set(__self__, "ram", ram)
        if volumes and not isinstance(volumes, list):
            raise TypeError("Expected argument 'volumes' to be a list")
        pulumi.set(__self__, "volumes", volumes)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def arch(self) -> _builtins.str:
        """
        The architecture of the server type.
        """
        return pulumi.get(self, "arch")

    @_builtins.property
    @pulumi.getter
    def availability(self) -> _builtins.str:
        """
        Whether the server type is available in the zone.
        """
        return pulumi.get(self, "availability")

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Sequence['outputs.GetServerTypeCapabilityResult']:
        """
        The specific capabilities of the server type.
        """
        return pulumi.get(self, "capabilities")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.int:
        """
        The number of CPU cores of the server type.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="endOfService")
    def end_of_service(self) -> _builtins.bool:
        """
        Whether the server type will soon reach End Of Service.
        """
        return pulumi.get(self, "end_of_service")

    @_builtins.property
    @pulumi.getter
    def gpu(self) -> _builtins.int:
        """
        The number of GPUs of the server type.
        """
        return pulumi.get(self, "gpu")

    @_builtins.property
    @pulumi.getter(name="hourlyPrice")
    def hourly_price(self) -> _builtins.float:
        """
        The hourly price of the server type (in euros).
        """
        return pulumi.get(self, "hourly_price")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Sequence['outputs.GetServerTypeNetworkResult']:
        """
        The network specifications of the server type.
        """
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter
    def ram(self) -> _builtins.int:
        """
        The amount of RAM of the server type (in bytes).
        """
        return pulumi.get(self, "ram")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetServerTypeVolumeResult']:
        """
        The specifications of volumes allowed for the server type.
        """
        return pulumi.get(self, "volumes")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "zone")


class AwaitableGetServerTypeResult(GetServerTypeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerTypeResult(
            arch=self.arch,
            availability=self.availability,
            capabilities=self.capabilities,
            cpu=self.cpu,
            end_of_service=self.end_of_service,
            gpu=self.gpu,
            hourly_price=self.hourly_price,
            id=self.id,
            name=self.name,
            networks=self.networks,
            ram=self.ram,
            volumes=self.volumes,
            zone=self.zone)


def get_server_type(name: Optional[_builtins.str] = None,
                    zone: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerTypeResult:
    """
    Gets information about a server type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    pro2_s = scaleway.instance.get_server_type(name="PRO2-S",
        zone="nl-ams-1")
    ```


    :param _builtins.str name: The name of the server type.
           Only one of `name` and `snapshot_id` should be specified.
    :param _builtins.str zone: `zone`) The zone of the server type (to check the availability of the server type for example).
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:instance/getServerType:getServerType', __args__, opts=opts, typ=GetServerTypeResult).value

    return AwaitableGetServerTypeResult(
        arch=pulumi.get(__ret__, 'arch'),
        availability=pulumi.get(__ret__, 'availability'),
        capabilities=pulumi.get(__ret__, 'capabilities'),
        cpu=pulumi.get(__ret__, 'cpu'),
        end_of_service=pulumi.get(__ret__, 'end_of_service'),
        gpu=pulumi.get(__ret__, 'gpu'),
        hourly_price=pulumi.get(__ret__, 'hourly_price'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        networks=pulumi.get(__ret__, 'networks'),
        ram=pulumi.get(__ret__, 'ram'),
        volumes=pulumi.get(__ret__, 'volumes'),
        zone=pulumi.get(__ret__, 'zone'))
def get_server_type_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                           zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServerTypeResult]:
    """
    Gets information about a server type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    pro2_s = scaleway.instance.get_server_type(name="PRO2-S",
        zone="nl-ams-1")
    ```


    :param _builtins.str name: The name of the server type.
           Only one of `name` and `snapshot_id` should be specified.
    :param _builtins.str zone: `zone`) The zone of the server type (to check the availability of the server type for example).
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:instance/getServerType:getServerType', __args__, opts=opts, typ=GetServerTypeResult)
    return __ret__.apply(lambda __response__: GetServerTypeResult(
        arch=pulumi.get(__response__, 'arch'),
        availability=pulumi.get(__response__, 'availability'),
        capabilities=pulumi.get(__response__, 'capabilities'),
        cpu=pulumi.get(__response__, 'cpu'),
        end_of_service=pulumi.get(__response__, 'end_of_service'),
        gpu=pulumi.get(__response__, 'gpu'),
        hourly_price=pulumi.get(__response__, 'hourly_price'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        networks=pulumi.get(__response__, 'networks'),
        ram=pulumi.get(__response__, 'ram'),
        volumes=pulumi.get(__response__, 'volumes'),
        zone=pulumi.get(__response__, 'zone')))
