# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ImageAdditionalVolume',
    'ImageRootVolume',
    'PrivateNicPrivateIp',
    'SecurityGroupInboundRule',
    'SecurityGroupOutboundRule',
    'SecurityGroupRulesInboundRule',
    'SecurityGroupRulesOutboundRule',
    'ServerFilesystem',
    'ServerPrivateIp',
    'ServerPrivateNetwork',
    'ServerPublicIp',
    'ServerRootVolume',
    'SnapshotImport',
    'GetPrivateNicPrivateIpResult',
    'GetSecurityGroupInboundRuleResult',
    'GetSecurityGroupOutboundRuleResult',
    'GetServerFilesystemResult',
    'GetServerPrivateIpResult',
    'GetServerPrivateNetworkResult',
    'GetServerPublicIpResult',
    'GetServerRootVolumeResult',
    'GetServerTypeCapabilityResult',
    'GetServerTypeNetworkResult',
    'GetServerTypeVolumeResult',
    'GetServersServerResult',
    'GetServersServerPrivateIpResult',
    'GetServersServerPublicIpResult',
    'GetSnapshotImportResult',
]

@pulumi.output_type
class ImageAdditionalVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageAdditionalVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageAdditionalVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageAdditionalVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 server: Optional[Mapping[str, _builtins.str]] = None,
                 size: Optional[_builtins.int] = None,
                 tags: Optional[Sequence[_builtins.str]] = None,
                 volume_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: ID of the server containing the volume.
        :param _builtins.str name: The name of the image. If not provided it will be randomly generated.
        :param Mapping[str, _builtins.str] server: Description of the server containing the volume (in case the image is a backup from a server).
        :param _builtins.int size: The size of the volume.
        :param Sequence[_builtins.str] tags: A list of tags to apply to the image.
        :param _builtins.str volume_type: The type of volume, possible values are `l_ssd` and `sbs_snapshot`.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of the server containing the volume.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the image. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def server(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Description of the server containing the volume (in case the image is a backup from a server).
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        The size of the volume.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of tags to apply to the image.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[_builtins.str]:
        """
        The type of volume, possible values are `l_ssd` and `sbs_snapshot`.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class ImageRootVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageRootVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageRootVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageRootVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 size: Optional[_builtins.int] = None,
                 volume_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: ID of the server containing the volume.
        :param _builtins.str name: The name of the image. If not provided it will be randomly generated.
        :param _builtins.int size: The size of the volume.
        :param _builtins.str volume_type: The type of volume, possible values are `l_ssd` and `sbs_snapshot`.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of the server containing the volume.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the image. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        The size of the volume.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[_builtins.str]:
        """
        The type of volume, possible values are `l_ssd` and `sbs_snapshot`.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class PrivateNicPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The private IP address.
        :param _builtins.str id: The ID of the IP address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class SecurityGroupInboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGroupInboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGroupInboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGroupInboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 ip: Optional[_builtins.str] = None,
                 ip_range: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 port_range: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param _builtins.str ip: The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param _builtins.str ip_range: The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param _builtins.int port: The port this rule applies to. If no `port` nor `port_range` are specified, the rule will apply to all port. Only one of `port` and `port_range` should be specified.
        :param _builtins.str port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param _builtins.str protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Ip address is deprecated. Please use ip_range instead""")
    def ip(self) -> Optional[_builtins.str]:
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[_builtins.str]:
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port this rule applies to. If no `port` nor `port_range` are specified, the rule will apply to all port. Only one of `port` and `port_range` should be specified.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[_builtins.str]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class SecurityGroupOutboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGroupOutboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGroupOutboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGroupOutboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 ip: Optional[_builtins.str] = None,
                 ip_range: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 port_range: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: Action when rule match request (drop or accept)
        :param _builtins.str ip: Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        :param _builtins.str ip_range: Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        :param _builtins.int port: Network port for this rule
        :param _builtins.str port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param _builtins.str protocol: Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        Action when rule match request (drop or accept)
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Ip address is deprecated. Please use ip_range instead""")
    def ip(self) -> Optional[_builtins.str]:
        """
        Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[_builtins.str]:
        """
        Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Network port for this rule
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[_builtins.str]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class SecurityGroupRulesInboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGroupRulesInboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGroupRulesInboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGroupRulesInboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 ip: Optional[_builtins.str] = None,
                 ip_range: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 port_range: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param _builtins.str ip: The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param _builtins.str ip_range: The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param _builtins.int port: The port this rule apply to. If no port is specified, rule will apply to all port.
        :param _builtins.str port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param _builtins.str protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Ip address is deprecated. Please use ip_range instead""")
    def ip(self) -> Optional[_builtins.str]:
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[_builtins.str]:
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port this rule apply to. If no port is specified, rule will apply to all port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[_builtins.str]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class SecurityGroupRulesOutboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGroupRulesOutboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGroupRulesOutboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGroupRulesOutboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 ip: Optional[_builtins.str] = None,
                 ip_range: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 port_range: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: Action when rule match request (drop or accept)
        :param _builtins.str ip: Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        :param _builtins.str ip_range: Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        :param _builtins.int port: Network port for this rule
        :param _builtins.str port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param _builtins.str protocol: Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        Action when rule match request (drop or accept)
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Ip address is deprecated. Please use ip_range instead""")
    def ip(self) -> Optional[_builtins.str]:
        """
        Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[_builtins.str]:
        """
        Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Network port for this rule
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[_builtins.str]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ServerFilesystem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filesystemId":
            suggest = "filesystem_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerFilesystem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerFilesystem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerFilesystem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filesystem_id: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str filesystem_id: The unique ID of the filesystem attached to the server.
        :param _builtins.str status: The state of the filesystem
        """
        if filesystem_id is not None:
            pulumi.set(__self__, "filesystem_id", filesystem_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="filesystemId")
    def filesystem_id(self) -> Optional[_builtins.str]:
        """
        The unique ID of the filesystem attached to the server.
        """
        return pulumi.get(self, "filesystem_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The state of the filesystem
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ServerPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The private IP address.
        :param _builtins.str id: The ID of the IP address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ServerPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pnId":
            suggest = "pn_id"
        elif key == "macAddress":
            suggest = "mac_address"
        elif key == "pnicId":
            suggest = "pnic_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pn_id: _builtins.str,
                 mac_address: Optional[_builtins.str] = None,
                 pnic_id: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str pn_id: The Private Network ID
        :param _builtins.str mac_address: MAC address of the NIC
        :param _builtins.str pnic_id: The ID of the NIC
        :param _builtins.str status: The private NIC state
        :param _builtins.str zone: `zone`) The zone in which the server should be created.
        """
        pulumi.set(__self__, "pn_id", pn_id)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if pnic_id is not None:
            pulumi.set(__self__, "pnic_id", pnic_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> _builtins.str:
        """
        The Private Network ID
        """
        return pulumi.get(self, "pn_id")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[_builtins.str]:
        """
        MAC address of the NIC
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="pnicId")
    def pnic_id(self) -> Optional[_builtins.str]:
        """
        The ID of the NIC
        """
        return pulumi.get(self, "pnic_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The private NIC state
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class ServerPublicIp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningMode":
            suggest = "provisioning_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerPublicIp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerPublicIp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerPublicIp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 dynamic: Optional[_builtins.bool] = None,
                 family: Optional[_builtins.str] = None,
                 gateway: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 netmask: Optional[_builtins.str] = None,
                 provisioning_mode: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The address of the IP.
        :param _builtins.bool dynamic: Whether the IP is dynamic.
        :param _builtins.str family: The IP address' family.
        :param _builtins.str gateway: The IP of the Gateway associated with the IP.
        :param _builtins.str id: The ID of the IP.
        :param _builtins.str netmask: The CIDR netmask of the IP.
        :param _builtins.str provisioning_mode: The provisioning mode of the IP
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if dynamic is not None:
            pulumi.set(__self__, "dynamic", dynamic)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if netmask is not None:
            pulumi.set(__self__, "netmask", netmask)
        if provisioning_mode is not None:
            pulumi.set(__self__, "provisioning_mode", provisioning_mode)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The address of the IP.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def dynamic(self) -> Optional[_builtins.bool]:
        """
        Whether the IP is dynamic.
        """
        return pulumi.get(self, "dynamic")

    @_builtins.property
    @pulumi.getter
    def family(self) -> Optional[_builtins.str]:
        """
        The IP address' family.
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> Optional[_builtins.str]:
        """
        The IP of the Gateway associated with the IP.
        """
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IP.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def netmask(self) -> Optional[_builtins.str]:
        """
        The CIDR netmask of the IP.
        """
        return pulumi.get(self, "netmask")

    @_builtins.property
    @pulumi.getter(name="provisioningMode")
    def provisioning_mode(self) -> Optional[_builtins.str]:
        """
        The provisioning mode of the IP
        """
        return pulumi.get(self, "provisioning_mode")


@pulumi.output_type
class ServerRootVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "sbsIops":
            suggest = "sbs_iops"
        elif key == "sizeInGb":
            suggest = "size_in_gb"
        elif key == "volumeId":
            suggest = "volume_id"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerRootVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerRootVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerRootVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot: Optional[_builtins.bool] = None,
                 delete_on_termination: Optional[_builtins.bool] = None,
                 name: Optional[_builtins.str] = None,
                 sbs_iops: Optional[_builtins.int] = None,
                 size_in_gb: Optional[_builtins.int] = None,
                 volume_id: Optional[_builtins.str] = None,
                 volume_type: Optional[_builtins.str] = None):
        """
        :param _builtins.bool boot: Set the volume where the boot the server
        :param _builtins.bool delete_on_termination: Forces deletion of the root volume on instance termination.
        :param _builtins.str name: The name of the server.
        :param _builtins.int sbs_iops: Choose IOPS of your sbs volume, has to be used with `sbs_volume` for root volume type.
               
               > **Important:** Updates to `root_volume.size_in_gb` will be ignored after the creation of the server.
        :param _builtins.int size_in_gb: Size of the root volume in gigabytes.
               To find the right size use [this endpoint](https://www.scaleway.com/en/developers/api/instance/#path-instances-list-all-instances) and
               check the `volumes_constraint.{min|max}_size` (in bytes) for your `commercial_type`.
               Depending on `volume_type`, updates to this field may recreate a new resource.
        :param _builtins.str volume_id: The volume ID of the root volume of the server, allows you to create server with an existing volume. If empty, will be computed to a created volume ID.
        :param _builtins.str volume_type: Volume type of root volume, can be `l_ssd` or `sbs_volume`, default value depends on server type
        """
        if boot is not None:
            pulumi.set(__self__, "boot", boot)
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sbs_iops is not None:
            pulumi.set(__self__, "sbs_iops", sbs_iops)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter
    def boot(self) -> Optional[_builtins.bool]:
        """
        Set the volume where the boot the server
        """
        return pulumi.get(self, "boot")

    @_builtins.property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[_builtins.bool]:
        """
        Forces deletion of the root volume on instance termination.
        """
        return pulumi.get(self, "delete_on_termination")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sbsIops")
    def sbs_iops(self) -> Optional[_builtins.int]:
        """
        Choose IOPS of your sbs volume, has to be used with `sbs_volume` for root volume type.

        > **Important:** Updates to `root_volume.size_in_gb` will be ignored after the creation of the server.
        """
        return pulumi.get(self, "sbs_iops")

    @_builtins.property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> Optional[_builtins.int]:
        """
        Size of the root volume in gigabytes.
        To find the right size use [this endpoint](https://www.scaleway.com/en/developers/api/instance/#path-instances-list-all-instances) and
        check the `volumes_constraint.{min|max}_size` (in bytes) for your `commercial_type`.
        Depending on `volume_type`, updates to this field may recreate a new resource.
        """
        return pulumi.get(self, "size_in_gb")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[_builtins.str]:
        """
        The volume ID of the root volume of the server, allows you to create server with an existing volume. If empty, will be computed to a created volume ID.
        """
        return pulumi.get(self, "volume_id")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[_builtins.str]:
        """
        Volume type of root volume, can be `l_ssd` or `sbs_volume`, default value depends on server type
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class SnapshotImport(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 key: _builtins.str):
        """
        :param _builtins.str bucket: Bucket name containing [qcow2](https://en.wikipedia.org/wiki/Qcow) to import
        :param _builtins.str key: Key of the object to import
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Bucket name containing [qcow2](https://en.wikipedia.org/wiki/Qcow) to import
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Key of the object to import
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class GetPrivateNicPrivateIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The private IP address
        :param _builtins.str id: The ID of the IP address resource
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The private IP address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the IP address resource
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetSecurityGroupInboundRuleResult(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 ip: _builtins.str,
                 ip_range: _builtins.str,
                 port: _builtins.int,
                 port_range: _builtins.str,
                 protocol: _builtins.str):
        """
        :param _builtins.str action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param _builtins.str ip: The ip this rule apply to.
        :param _builtins.str ip_range: The ip range (e.g `192.168.1.0/24`) this rule apply to.
        :param _builtins.int port: The port this rule apply to. If no port is specified, rule will apply to all port.
        :param _builtins.str port_range: The port range (e.g `22-23`) this rule applies to.
               If no `port` nor `port_range` are specified, rule will apply to all port.
               Only one of `port` and `port_range` should be specified.
        :param _builtins.str protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_range", port_range)
        pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The ip this rule apply to.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> _builtins.str:
        """
        The ip range (e.g `192.168.1.0/24`) this rule apply to.
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port this rule apply to. If no port is specified, rule will apply to all port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> _builtins.str:
        """
        The port range (e.g `22-23`) this rule applies to.
        If no `port` nor `port_range` are specified, rule will apply to all port.
        Only one of `port` and `port_range` should be specified.
        """
        return pulumi.get(self, "port_range")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetSecurityGroupOutboundRuleResult(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 ip: _builtins.str,
                 ip_range: _builtins.str,
                 port: _builtins.int,
                 port_range: _builtins.str,
                 protocol: _builtins.str):
        """
        :param _builtins.str action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param _builtins.str ip: The ip this rule apply to.
        :param _builtins.str ip_range: The ip range (e.g `192.168.1.0/24`) this rule apply to.
        :param _builtins.int port: The port this rule apply to. If no port is specified, rule will apply to all port.
        :param _builtins.str port_range: The port range (e.g `22-23`) this rule applies to.
               If no `port` nor `port_range` are specified, rule will apply to all port.
               Only one of `port` and `port_range` should be specified.
        :param _builtins.str protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_range", port_range)
        pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The ip this rule apply to.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> _builtins.str:
        """
        The ip range (e.g `192.168.1.0/24`) this rule apply to.
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port this rule apply to. If no port is specified, rule will apply to all port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> _builtins.str:
        """
        The port range (e.g `22-23`) this rule applies to.
        If no `port` nor `port_range` are specified, rule will apply to all port.
        Only one of `port` and `port_range` should be specified.
        """
        return pulumi.get(self, "port_range")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetServerFilesystemResult(dict):
    def __init__(__self__, *,
                 filesystem_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str filesystem_id: The filesystem ID attached to the server
        :param _builtins.str status: The state of the filesystem
        """
        pulumi.set(__self__, "filesystem_id", filesystem_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="filesystemId")
    def filesystem_id(self) -> _builtins.str:
        """
        The filesystem ID attached to the server
        """
        return pulumi.get(self, "filesystem_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The state of the filesystem
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetServerPrivateIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The private IP address.
        :param _builtins.str id: The ID of the IP address resource.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetServerPrivateNetworkResult(dict):
    def __init__(__self__, *,
                 mac_address: _builtins.str,
                 pn_id: _builtins.str,
                 pnic_id: _builtins.str,
                 status: _builtins.str,
                 zone: _builtins.str):
        """
        :param _builtins.str mac_address: MAC address of the NIC
        :param _builtins.str pn_id: The Private Network ID
        :param _builtins.str pnic_id: The ID of the NIC
        :param _builtins.str status: The private NIC state
        :param _builtins.str zone: `zone`) The zone in which the server exists.
        """
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "pn_id", pn_id)
        pulumi.set(__self__, "pnic_id", pnic_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> _builtins.str:
        """
        MAC address of the NIC
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> _builtins.str:
        """
        The Private Network ID
        """
        return pulumi.get(self, "pn_id")

    @_builtins.property
    @pulumi.getter(name="pnicId")
    def pnic_id(self) -> _builtins.str:
        """
        The ID of the NIC
        """
        return pulumi.get(self, "pnic_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The private NIC state
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        `zone`) The zone in which the server exists.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetServerPublicIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 dynamic: _builtins.bool,
                 family: _builtins.str,
                 gateway: _builtins.str,
                 id: _builtins.str,
                 netmask: _builtins.str,
                 provisioning_mode: _builtins.str):
        """
        :param _builtins.str address: The private IP address.
        :param _builtins.bool dynamic: Whether the IP is dynamic
        :param _builtins.str family: IP address family (inet or inet6)
        :param _builtins.str gateway: Gateway's IP address
        :param _builtins.str id: The ID of the IP address resource.
        :param _builtins.str netmask: CIDR netmask
        :param _builtins.str provisioning_mode: Provisioning mode of the IP address
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "dynamic", dynamic)
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "provisioning_mode", provisioning_mode)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def dynamic(self) -> _builtins.bool:
        """
        Whether the IP is dynamic
        """
        return pulumi.get(self, "dynamic")

    @_builtins.property
    @pulumi.getter
    def family(self) -> _builtins.str:
        """
        IP address family (inet or inet6)
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> _builtins.str:
        """
        Gateway's IP address
        """
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def netmask(self) -> _builtins.str:
        """
        CIDR netmask
        """
        return pulumi.get(self, "netmask")

    @_builtins.property
    @pulumi.getter(name="provisioningMode")
    def provisioning_mode(self) -> _builtins.str:
        """
        Provisioning mode of the IP address
        """
        return pulumi.get(self, "provisioning_mode")


@pulumi.output_type
class GetServerRootVolumeResult(dict):
    def __init__(__self__, *,
                 boot: _builtins.bool,
                 delete_on_termination: _builtins.bool,
                 name: _builtins.str,
                 sbs_iops: _builtins.int,
                 size_in_gb: _builtins.int,
                 volume_id: _builtins.str,
                 volume_type: _builtins.str):
        """
        :param _builtins.bool boot: Set the volume where the boot the server
        :param _builtins.bool delete_on_termination: Forces deletion of the root volume on instance termination.
        :param _builtins.str name: The server name. Only one of `name` and `server_id` should be specified.
        :param _builtins.int sbs_iops: SBS Volume IOPS, only with volume_type as sbs_volume
        :param _builtins.int size_in_gb: Size of the root volume in gigabytes.
        :param _builtins.str volume_id: The volume ID of the root volume of the server.
        :param _builtins.str volume_type: Volume type of the root volume
        """
        pulumi.set(__self__, "boot", boot)
        pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sbs_iops", sbs_iops)
        pulumi.set(__self__, "size_in_gb", size_in_gb)
        pulumi.set(__self__, "volume_id", volume_id)
        pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter
    def boot(self) -> _builtins.bool:
        """
        Set the volume where the boot the server
        """
        return pulumi.get(self, "boot")

    @_builtins.property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> _builtins.bool:
        """
        Forces deletion of the root volume on instance termination.
        """
        return pulumi.get(self, "delete_on_termination")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The server name. Only one of `name` and `server_id` should be specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sbsIops")
    def sbs_iops(self) -> _builtins.int:
        """
        SBS Volume IOPS, only with volume_type as sbs_volume
        """
        return pulumi.get(self, "sbs_iops")

    @_builtins.property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> _builtins.int:
        """
        Size of the root volume in gigabytes.
        """
        return pulumi.get(self, "size_in_gb")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> _builtins.str:
        """
        The volume ID of the root volume of the server.
        """
        return pulumi.get(self, "volume_id")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> _builtins.str:
        """
        Volume type of the root volume
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class GetServerTypeCapabilityResult(dict):
    def __init__(__self__, *,
                 boot_types: Sequence[_builtins.str],
                 max_file_systems: _builtins.int):
        """
        :param Sequence[_builtins.str] boot_types: The boot types allowed for the server type.
        :param _builtins.int max_file_systems: The maximum number of file systems that can be attached on the server type.
        """
        pulumi.set(__self__, "boot_types", boot_types)
        pulumi.set(__self__, "max_file_systems", max_file_systems)

    @_builtins.property
    @pulumi.getter(name="bootTypes")
    def boot_types(self) -> Sequence[_builtins.str]:
        """
        The boot types allowed for the server type.
        """
        return pulumi.get(self, "boot_types")

    @_builtins.property
    @pulumi.getter(name="maxFileSystems")
    def max_file_systems(self) -> _builtins.int:
        """
        The maximum number of file systems that can be attached on the server type.
        """
        return pulumi.get(self, "max_file_systems")


@pulumi.output_type
class GetServerTypeNetworkResult(dict):
    def __init__(__self__, *,
                 block_bandwidth: _builtins.int,
                 internal_bandwidth: _builtins.int,
                 public_bandwidth: _builtins.int):
        """
        :param _builtins.int block_bandwidth: The block bandwidth of the server type (in bytes/second).
        :param _builtins.int internal_bandwidth: The internal bandwidth of the server type (in bytes/second).
        :param _builtins.int public_bandwidth: The public bandwidth of the server type (in bytes/second).
        """
        pulumi.set(__self__, "block_bandwidth", block_bandwidth)
        pulumi.set(__self__, "internal_bandwidth", internal_bandwidth)
        pulumi.set(__self__, "public_bandwidth", public_bandwidth)

    @_builtins.property
    @pulumi.getter(name="blockBandwidth")
    def block_bandwidth(self) -> _builtins.int:
        """
        The block bandwidth of the server type (in bytes/second).
        """
        return pulumi.get(self, "block_bandwidth")

    @_builtins.property
    @pulumi.getter(name="internalBandwidth")
    def internal_bandwidth(self) -> _builtins.int:
        """
        The internal bandwidth of the server type (in bytes/second).
        """
        return pulumi.get(self, "internal_bandwidth")

    @_builtins.property
    @pulumi.getter(name="publicBandwidth")
    def public_bandwidth(self) -> _builtins.int:
        """
        The public bandwidth of the server type (in bytes/second).
        """
        return pulumi.get(self, "public_bandwidth")


@pulumi.output_type
class GetServerTypeVolumeResult(dict):
    def __init__(__self__, *,
                 block_storage: _builtins.bool,
                 max_size_per_local_volume: _builtins.int,
                 max_size_total: _builtins.int,
                 min_size_per_local_volume: _builtins.int,
                 min_size_total: _builtins.int,
                 scratch_storage_max_size: _builtins.int):
        """
        :param _builtins.bool block_storage: Whether block storage is allowed on the server type.
        :param _builtins.int max_size_per_local_volume: The maximum size in bytes per local volume allowed on the server type.
        :param _builtins.int max_size_total: The maximum total size in bytes of volumes allowed on the server type.
        :param _builtins.int min_size_per_local_volume: The minimum size in bytes per local volume allowed on the server type.
        :param _builtins.int min_size_total: The minimum total size in bytes of volumes allowed on the server type.
        :param _builtins.int scratch_storage_max_size: The maximum size in bytes of the scratch volume allowed on the server type.
        """
        pulumi.set(__self__, "block_storage", block_storage)
        pulumi.set(__self__, "max_size_per_local_volume", max_size_per_local_volume)
        pulumi.set(__self__, "max_size_total", max_size_total)
        pulumi.set(__self__, "min_size_per_local_volume", min_size_per_local_volume)
        pulumi.set(__self__, "min_size_total", min_size_total)
        pulumi.set(__self__, "scratch_storage_max_size", scratch_storage_max_size)

    @_builtins.property
    @pulumi.getter(name="blockStorage")
    def block_storage(self) -> _builtins.bool:
        """
        Whether block storage is allowed on the server type.
        """
        return pulumi.get(self, "block_storage")

    @_builtins.property
    @pulumi.getter(name="maxSizePerLocalVolume")
    def max_size_per_local_volume(self) -> _builtins.int:
        """
        The maximum size in bytes per local volume allowed on the server type.
        """
        return pulumi.get(self, "max_size_per_local_volume")

    @_builtins.property
    @pulumi.getter(name="maxSizeTotal")
    def max_size_total(self) -> _builtins.int:
        """
        The maximum total size in bytes of volumes allowed on the server type.
        """
        return pulumi.get(self, "max_size_total")

    @_builtins.property
    @pulumi.getter(name="minSizePerLocalVolume")
    def min_size_per_local_volume(self) -> _builtins.int:
        """
        The minimum size in bytes per local volume allowed on the server type.
        """
        return pulumi.get(self, "min_size_per_local_volume")

    @_builtins.property
    @pulumi.getter(name="minSizeTotal")
    def min_size_total(self) -> _builtins.int:
        """
        The minimum total size in bytes of volumes allowed on the server type.
        """
        return pulumi.get(self, "min_size_total")

    @_builtins.property
    @pulumi.getter(name="scratchStorageMaxSize")
    def scratch_storage_max_size(self) -> _builtins.int:
        """
        The maximum size in bytes of the scratch volume allowed on the server type.
        """
        return pulumi.get(self, "scratch_storage_max_size")


@pulumi.output_type
class GetServersServerResult(dict):
    def __init__(__self__, *,
                 boot_type: _builtins.str,
                 bootscript_id: _builtins.str,
                 enable_dynamic_ip: _builtins.bool,
                 id: _builtins.str,
                 image: _builtins.str,
                 name: _builtins.str,
                 organization_id: _builtins.str,
                 placement_group_id: _builtins.str,
                 placement_group_policy_respected: _builtins.bool,
                 private_ips: Sequence['outputs.GetServersServerPrivateIpResult'],
                 project_id: _builtins.str,
                 public_ips: Sequence['outputs.GetServersServerPublicIpResult'],
                 security_group_id: _builtins.str,
                 state: _builtins.str,
                 tags: Sequence[_builtins.str],
                 type: _builtins.str,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str boot_type: The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        :param _builtins.str bootscript_id: UUID of the bootscript
        :param _builtins.bool enable_dynamic_ip: If true a dynamic IP will be attached to the server.
        :param _builtins.str id: The ID of the IP
        :param _builtins.str image: The UUID or the label of the base image used by the server.
        :param _builtins.str name: The server name used as filter. Servers with a name like it are listed.
        :param _builtins.str organization_id: The organization ID the server is associated with.
        :param _builtins.str placement_group_id: The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the server is attached to.
        :param _builtins.bool placement_group_policy_respected: Whether the placement group policy respected or not
        :param Sequence['GetServersServerPrivateIpArgs'] private_ips: The list of private IPv4 and IPv6 addresses associated with the server.
        :param _builtins.str project_id: The ID of the project the server is associated with.
        :param Sequence['GetServersServerPublicIpArgs'] public_ips: The list of public IPs of the server
        :param _builtins.str security_group_id: The [security group](https://developers.scaleway.com/en/products/instance/api/#security-groups-8d7f89) the server is attached to.
        :param _builtins.str state: The state of the server. Possible values are: `started`, `stopped` or `standby`.
        :param Sequence[_builtins.str] tags: List of tags used as filter. Servers with these exact tags are listed.
        :param _builtins.str type: The commercial type of the server.
        :param _builtins.str zone: `zone`) The zone in which servers exist.
        """
        pulumi.set(__self__, "boot_type", boot_type)
        pulumi.set(__self__, "bootscript_id", bootscript_id)
        pulumi.set(__self__, "enable_dynamic_ip", enable_dynamic_ip)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "placement_group_id", placement_group_id)
        pulumi.set(__self__, "placement_group_policy_respected", placement_group_policy_respected)
        pulumi.set(__self__, "private_ips", private_ips)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "public_ips", public_ips)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="bootType")
    def boot_type(self) -> _builtins.str:
        """
        The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        """
        return pulumi.get(self, "boot_type")

    @_builtins.property
    @pulumi.getter(name="bootscriptId")
    @_utilities.deprecated("""bootscript are not supported""")
    def bootscript_id(self) -> _builtins.str:
        """
        UUID of the bootscript
        """
        return pulumi.get(self, "bootscript_id")

    @_builtins.property
    @pulumi.getter(name="enableDynamicIp")
    def enable_dynamic_ip(self) -> _builtins.bool:
        """
        If true a dynamic IP will be attached to the server.
        """
        return pulumi.get(self, "enable_dynamic_ip")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the IP
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        The UUID or the label of the base image used by the server.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The server name used as filter. Servers with a name like it are listed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        The organization ID the server is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> _builtins.str:
        """
        The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the server is attached to.
        """
        return pulumi.get(self, "placement_group_id")

    @_builtins.property
    @pulumi.getter(name="placementGroupPolicyRespected")
    def placement_group_policy_respected(self) -> _builtins.bool:
        """
        Whether the placement group policy respected or not
        """
        return pulumi.get(self, "placement_group_policy_respected")

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Sequence['outputs.GetServersServerPrivateIpResult']:
        """
        The list of private IPv4 and IPv6 addresses associated with the server.
        """
        return pulumi.get(self, "private_ips")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Sequence['outputs.GetServersServerPublicIpResult']:
        """
        The list of public IPs of the server
        """
        return pulumi.get(self, "public_ips")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        The [security group](https://developers.scaleway.com/en/products/instance/api/#security-groups-8d7f89) the server is attached to.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The state of the server. Possible values are: `started`, `stopped` or `standby`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        List of tags used as filter. Servers with these exact tags are listed.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The commercial type of the server.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        `zone`) The zone in which servers exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetServersServerPrivateIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The address of the IP
        :param _builtins.str id: The ID of the IP
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The address of the IP
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the IP
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetServersServerPublicIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The address of the IP
        :param _builtins.str id: The ID of the IP
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The address of the IP
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the IP
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetSnapshotImportResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 key: _builtins.str):
        """
        :param _builtins.str bucket: Bucket containing qcow
        :param _builtins.str key: Key of the qcow file in the specified bucket
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Bucket containing qcow
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Key of the qcow file in the specified bucket
        """
        return pulumi.get(self, "key")


