# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstancePrivateNicArgs', 'InstancePrivateNic']

@pulumi.input_type
class InstancePrivateNicArgs:
    def __init__(__self__, *,
                 private_network_id: pulumi.Input[_builtins.str],
                 server_id: pulumi.Input[_builtins.str],
                 ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipam_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePrivateNicPrivateIpArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a InstancePrivateNic resource.
        :param pulumi.Input[_builtins.str] private_network_id: The ID of the private network attached to.
        :param pulumi.Input[_builtins.str] server_id: The ID of the server associated with.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_ids: IPAM ip list, should be for internal use only
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipam_ip_ids: IPAM IDs of a pre-reserved IP addresses to assign to the Instance in the requested private network.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePrivateNicPrivateIpArgs']]] private_ips: The list of private IPv4 and IPv6 addresses associated with the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the private NIC.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the server must be created.
        """
        pulumi.set(__self__, "private_network_id", private_network_id)
        pulumi.set(__self__, "server_id", server_id)
        if ip_ids is not None:
            pulumi.set(__self__, "ip_ids", ip_ids)
        if ipam_ip_ids is not None:
            pulumi.set(__self__, "ipam_ip_ids", ipam_ip_ids)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the private network attached to.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_network_id", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the server associated with.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter(name="ipIds")
    def ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        IPAM ip list, should be for internal use only
        """
        return pulumi.get(self, "ip_ids")

    @ip_ids.setter
    def ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_ids", value)

    @_builtins.property
    @pulumi.getter(name="ipamIpIds")
    def ipam_ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        IPAM IDs of a pre-reserved IP addresses to assign to the Instance in the requested private network.
        """
        return pulumi.get(self, "ipam_ip_ids")

    @ipam_ip_ids.setter
    def ipam_ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipam_ip_ids", value)

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePrivateNicPrivateIpArgs']]]]:
        """
        The list of private IPv4 and IPv6 addresses associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePrivateNicPrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags associated with the private NIC.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `zone`) The zone in which the server must be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _InstancePrivateNicState:
    def __init__(__self__, *,
                 ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipam_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePrivateNicPrivateIpArgs']]]] = None,
                 private_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstancePrivateNic resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_ids: IPAM ip list, should be for internal use only
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipam_ip_ids: IPAM IDs of a pre-reserved IP addresses to assign to the Instance in the requested private network.
        :param pulumi.Input[_builtins.str] mac_address: The MAC address of the private NIC.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePrivateNicPrivateIpArgs']]] private_ips: The list of private IPv4 and IPv6 addresses associated with the resource.
        :param pulumi.Input[_builtins.str] private_network_id: The ID of the private network attached to.
        :param pulumi.Input[_builtins.str] server_id: The ID of the server associated with.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the private NIC.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the server must be created.
        """
        if ip_ids is not None:
            pulumi.set(__self__, "ip_ids", ip_ids)
        if ipam_ip_ids is not None:
            pulumi.set(__self__, "ipam_ip_ids", ipam_ip_ids)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_network_id is not None:
            pulumi.set(__self__, "private_network_id", private_network_id)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="ipIds")
    def ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        IPAM ip list, should be for internal use only
        """
        return pulumi.get(self, "ip_ids")

    @ip_ids.setter
    def ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_ids", value)

    @_builtins.property
    @pulumi.getter(name="ipamIpIds")
    def ipam_ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        IPAM IDs of a pre-reserved IP addresses to assign to the Instance in the requested private network.
        """
        return pulumi.get(self, "ipam_ip_ids")

    @ipam_ip_ids.setter
    def ipam_ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipam_ip_ids", value)

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The MAC address of the private NIC.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mac_address", value)

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePrivateNicPrivateIpArgs']]]]:
        """
        The list of private IPv4 and IPv6 addresses associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePrivateNicPrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the private network attached to.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_network_id", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the server associated with.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags associated with the private NIC.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `zone`) The zone in which the server must be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


warnings.warn("""scaleway.index/instanceprivatenic.InstancePrivateNic has been deprecated in favor of scaleway.instance/privatenic.PrivateNic""", DeprecationWarning)


@pulumi.type_token("scaleway:index/instancePrivateNic:InstancePrivateNic")
class InstancePrivateNic(pulumi.CustomResource):
    warnings.warn("""scaleway.index/instanceprivatenic.InstancePrivateNic has been deprecated in favor of scaleway.instance/privatenic.PrivateNic""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipam_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePrivateNicPrivateIpArgs', 'InstancePrivateNicPrivateIpArgsDict']]]]] = None,
                 private_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Instance Private NICs. For more information, see
        the [API documentation](https://www.scaleway.com/en/developers/api/instance/#path-private-nics-list-all-private-nics).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pnic01 = scaleway.instance.PrivateNic("pnic01",
            server_id="fr-par-1/11111111-1111-1111-1111-111111111111",
            private_network_id="fr-par-1/aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaaa")
        ```

        ### With zone

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="private_network_instance",
            region="fr-par")
        base = scaleway.instance.Server("base",
            image="ubuntu_jammy",
            type="DEV1-S",
            zone=pn01.zone)
        pnic01 = scaleway.instance.PrivateNic("pnic01",
            server_id=base.id,
            private_network_id=pn01.id,
            zone=pn01.zone)
        ```

        ### With IPAM IP IDs

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="vpc_instance")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="private_network_instance",
            ipv4_subnet={
                "subnet": "172.16.64.0/22",
            },
            vpc_id=vpc01.id)
        ip01 = scaleway.ipam.Ip("ip01",
            address="172.16.64.7",
            sources=[{
                "private_network_id": pn01.id,
            }])
        server01 = scaleway.instance.Server("server01",
            image="ubuntu_focal",
            type="PLAY2-MICRO")
        pnic01 = scaleway.instance.PrivateNic("pnic01",
            private_network_id=pn01.id,
            server_id=server01.id,
            ipam_ip_ids=[ip01.id])
        ```

        ## Import

        Private NICs can be imported using the `{zone}/{server_id}/{private_nic_id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/instancePrivateNic:InstancePrivateNic pnic01 fr-par-1/11111111-1111-1111-1111-111111111111/22222222-2222-2222-2222-222222222222
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_ids: IPAM ip list, should be for internal use only
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipam_ip_ids: IPAM IDs of a pre-reserved IP addresses to assign to the Instance in the requested private network.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstancePrivateNicPrivateIpArgs', 'InstancePrivateNicPrivateIpArgsDict']]]] private_ips: The list of private IPv4 and IPv6 addresses associated with the resource.
        :param pulumi.Input[_builtins.str] private_network_id: The ID of the private network attached to.
        :param pulumi.Input[_builtins.str] server_id: The ID of the server associated with.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the private NIC.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the server must be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstancePrivateNicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Instance Private NICs. For more information, see
        the [API documentation](https://www.scaleway.com/en/developers/api/instance/#path-private-nics-list-all-private-nics).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pnic01 = scaleway.instance.PrivateNic("pnic01",
            server_id="fr-par-1/11111111-1111-1111-1111-111111111111",
            private_network_id="fr-par-1/aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaaa")
        ```

        ### With zone

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="private_network_instance",
            region="fr-par")
        base = scaleway.instance.Server("base",
            image="ubuntu_jammy",
            type="DEV1-S",
            zone=pn01.zone)
        pnic01 = scaleway.instance.PrivateNic("pnic01",
            server_id=base.id,
            private_network_id=pn01.id,
            zone=pn01.zone)
        ```

        ### With IPAM IP IDs

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="vpc_instance")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            name="private_network_instance",
            ipv4_subnet={
                "subnet": "172.16.64.0/22",
            },
            vpc_id=vpc01.id)
        ip01 = scaleway.ipam.Ip("ip01",
            address="172.16.64.7",
            sources=[{
                "private_network_id": pn01.id,
            }])
        server01 = scaleway.instance.Server("server01",
            image="ubuntu_focal",
            type="PLAY2-MICRO")
        pnic01 = scaleway.instance.PrivateNic("pnic01",
            private_network_id=pn01.id,
            server_id=server01.id,
            ipam_ip_ids=[ip01.id])
        ```

        ## Import

        Private NICs can be imported using the `{zone}/{server_id}/{private_nic_id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/instancePrivateNic:InstancePrivateNic pnic01 fr-par-1/11111111-1111-1111-1111-111111111111/22222222-2222-2222-2222-222222222222
        ```

        :param str resource_name: The name of the resource.
        :param InstancePrivateNicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstancePrivateNicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipam_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePrivateNicPrivateIpArgs', 'InstancePrivateNicPrivateIpArgsDict']]]]] = None,
                 private_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""InstancePrivateNic is deprecated: scaleway.index/instanceprivatenic.InstancePrivateNic has been deprecated in favor of scaleway.instance/privatenic.PrivateNic""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstancePrivateNicArgs.__new__(InstancePrivateNicArgs)

            __props__.__dict__["ip_ids"] = ip_ids
            __props__.__dict__["ipam_ip_ids"] = ipam_ip_ids
            __props__.__dict__["private_ips"] = private_ips
            if private_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'private_network_id'")
            __props__.__dict__["private_network_id"] = private_network_id
            if server_id is None and not opts.urn:
                raise TypeError("Missing required property 'server_id'")
            __props__.__dict__["server_id"] = server_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["zone"] = zone
            __props__.__dict__["mac_address"] = None
        super(InstancePrivateNic, __self__).__init__(
            'scaleway:index/instancePrivateNic:InstancePrivateNic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ipam_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            mac_address: Optional[pulumi.Input[_builtins.str]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePrivateNicPrivateIpArgs', 'InstancePrivateNicPrivateIpArgsDict']]]]] = None,
            private_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            server_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'InstancePrivateNic':
        """
        Get an existing InstancePrivateNic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_ids: IPAM ip list, should be for internal use only
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipam_ip_ids: IPAM IDs of a pre-reserved IP addresses to assign to the Instance in the requested private network.
        :param pulumi.Input[_builtins.str] mac_address: The MAC address of the private NIC.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstancePrivateNicPrivateIpArgs', 'InstancePrivateNicPrivateIpArgsDict']]]] private_ips: The list of private IPv4 and IPv6 addresses associated with the resource.
        :param pulumi.Input[_builtins.str] private_network_id: The ID of the private network attached to.
        :param pulumi.Input[_builtins.str] server_id: The ID of the server associated with.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the private NIC.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the server must be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstancePrivateNicState.__new__(_InstancePrivateNicState)

        __props__.__dict__["ip_ids"] = ip_ids
        __props__.__dict__["ipam_ip_ids"] = ipam_ip_ids
        __props__.__dict__["mac_address"] = mac_address
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["private_network_id"] = private_network_id
        __props__.__dict__["server_id"] = server_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["zone"] = zone
        return InstancePrivateNic(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="ipIds")
    def ip_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        IPAM ip list, should be for internal use only
        """
        return pulumi.get(self, "ip_ids")

    @_builtins.property
    @pulumi.getter(name="ipamIpIds")
    def ipam_ip_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        IPAM IDs of a pre-reserved IP addresses to assign to the Instance in the requested private network.
        """
        return pulumi.get(self, "ipam_ip_ids")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> pulumi.Output[_builtins.str]:
        """
        The MAC address of the private NIC.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence['outputs.InstancePrivateNicPrivateIp']]:
        """
        The list of private IPv4 and IPv6 addresses associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the private network attached to.
        """
        return pulumi.get(self, "private_network_id")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the server associated with.
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The tags associated with the private NIC.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `zone`) The zone in which the server must be created.
        """
        return pulumi.get(self, "zone")

