# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeviceArgs', 'Device']

@pulumi.input_type
class DeviceArgs:
    def __init__(__self__, *,
                 hub_id: pulumi.Input[_builtins.str],
                 allow_insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_multiple_connections: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificate: Optional[pulumi.Input['DeviceCertificateArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 message_filters: Optional[pulumi.Input['DeviceMessageFiltersArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Device resource.
        :param pulumi.Input[_builtins.str] hub_id: The ID of the hub on which this device will be created.
        :param pulumi.Input[_builtins.bool] allow_insecure: Allow plain and server-authenticated TLS connections in addition to mutually-authenticated ones.
               
               > **Important:** Updates to `allow_insecure` can disconnect eventually connected devices.
        :param pulumi.Input[_builtins.bool] allow_multiple_connections: Allow more than one simultaneous connection using the same device credentials.
               
               > **Important:** Updates to `allow_multiple_connections` can disconnect eventually connected devices.
        :param pulumi.Input['DeviceCertificateArgs'] certificate: The certificate bundle of the device.
        :param pulumi.Input[_builtins.str] description: The description of the IoT device (e.g. `living room`).
        :param pulumi.Input['DeviceMessageFiltersArgs'] message_filters: Rules that define which messages are authorized or denied based on their topic.
        :param pulumi.Input[_builtins.str] name: The name of the IoT device you want to create (e.g. `my-device`).
               
               > **Important:** Updates to `name` will destroy and recreate a new resource.
        :param pulumi.Input[_builtins.str] region: The region you want to attach the resource to
        """
        pulumi.set(__self__, "hub_id", hub_id)
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if allow_multiple_connections is not None:
            pulumi.set(__self__, "allow_multiple_connections", allow_multiple_connections)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if message_filters is not None:
            pulumi.set(__self__, "message_filters", message_filters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="hubId")
    def hub_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the hub on which this device will be created.
        """
        return pulumi.get(self, "hub_id")

    @hub_id.setter
    def hub_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hub_id", value)

    @_builtins.property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow plain and server-authenticated TLS connections in addition to mutually-authenticated ones.

        > **Important:** Updates to `allow_insecure` can disconnect eventually connected devices.
        """
        return pulumi.get(self, "allow_insecure")

    @allow_insecure.setter
    def allow_insecure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_insecure", value)

    @_builtins.property
    @pulumi.getter(name="allowMultipleConnections")
    def allow_multiple_connections(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow more than one simultaneous connection using the same device credentials.

        > **Important:** Updates to `allow_multiple_connections` can disconnect eventually connected devices.
        """
        return pulumi.get(self, "allow_multiple_connections")

    @allow_multiple_connections.setter
    def allow_multiple_connections(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_multiple_connections", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input['DeviceCertificateArgs']]:
        """
        The certificate bundle of the device.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input['DeviceCertificateArgs']]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the IoT device (e.g. `living room`).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="messageFilters")
    def message_filters(self) -> Optional[pulumi.Input['DeviceMessageFiltersArgs']]:
        """
        Rules that define which messages are authorized or denied based on their topic.
        """
        return pulumi.get(self, "message_filters")

    @message_filters.setter
    def message_filters(self, value: Optional[pulumi.Input['DeviceMessageFiltersArgs']]):
        pulumi.set(self, "message_filters", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IoT device you want to create (e.g. `my-device`).

        > **Important:** Updates to `name` will destroy and recreate a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region you want to attach the resource to
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DeviceState:
    def __init__(__self__, *,
                 allow_insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_multiple_connections: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificate: Optional[pulumi.Input['DeviceCertificateArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_connected: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_activity_at: Optional[pulumi.Input[_builtins.str]] = None,
                 message_filters: Optional[pulumi.Input['DeviceMessageFiltersArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Device resources.
        :param pulumi.Input[_builtins.bool] allow_insecure: Allow plain and server-authenticated TLS connections in addition to mutually-authenticated ones.
               
               > **Important:** Updates to `allow_insecure` can disconnect eventually connected devices.
        :param pulumi.Input[_builtins.bool] allow_multiple_connections: Allow more than one simultaneous connection using the same device credentials.
               
               > **Important:** Updates to `allow_multiple_connections` can disconnect eventually connected devices.
        :param pulumi.Input['DeviceCertificateArgs'] certificate: The certificate bundle of the device.
        :param pulumi.Input[_builtins.str] created_at: The date and time the device was created.
        :param pulumi.Input[_builtins.str] description: The description of the IoT device (e.g. `living room`).
        :param pulumi.Input[_builtins.str] hub_id: The ID of the hub on which this device will be created.
        :param pulumi.Input[_builtins.bool] is_connected: The current connection status of the device.
        :param pulumi.Input[_builtins.str] last_activity_at: The last MQTT activity of the device.
        :param pulumi.Input['DeviceMessageFiltersArgs'] message_filters: Rules that define which messages are authorized or denied based on their topic.
        :param pulumi.Input[_builtins.str] name: The name of the IoT device you want to create (e.g. `my-device`).
               
               > **Important:** Updates to `name` will destroy and recreate a new resource.
        :param pulumi.Input[_builtins.str] region: The region you want to attach the resource to
        :param pulumi.Input[_builtins.str] status: The current status of the device.
        :param pulumi.Input[_builtins.str] updated_at: The date and time the device resource was updated.
        """
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if allow_multiple_connections is not None:
            pulumi.set(__self__, "allow_multiple_connections", allow_multiple_connections)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hub_id is not None:
            pulumi.set(__self__, "hub_id", hub_id)
        if is_connected is not None:
            pulumi.set(__self__, "is_connected", is_connected)
        if last_activity_at is not None:
            pulumi.set(__self__, "last_activity_at", last_activity_at)
        if message_filters is not None:
            pulumi.set(__self__, "message_filters", message_filters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow plain and server-authenticated TLS connections in addition to mutually-authenticated ones.

        > **Important:** Updates to `allow_insecure` can disconnect eventually connected devices.
        """
        return pulumi.get(self, "allow_insecure")

    @allow_insecure.setter
    def allow_insecure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_insecure", value)

    @_builtins.property
    @pulumi.getter(name="allowMultipleConnections")
    def allow_multiple_connections(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow more than one simultaneous connection using the same device credentials.

        > **Important:** Updates to `allow_multiple_connections` can disconnect eventually connected devices.
        """
        return pulumi.get(self, "allow_multiple_connections")

    @allow_multiple_connections.setter
    def allow_multiple_connections(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_multiple_connections", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input['DeviceCertificateArgs']]:
        """
        The certificate bundle of the device.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input['DeviceCertificateArgs']]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the device was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the IoT device (e.g. `living room`).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="hubId")
    def hub_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the hub on which this device will be created.
        """
        return pulumi.get(self, "hub_id")

    @hub_id.setter
    def hub_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hub_id", value)

    @_builtins.property
    @pulumi.getter(name="isConnected")
    def is_connected(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The current connection status of the device.
        """
        return pulumi.get(self, "is_connected")

    @is_connected.setter
    def is_connected(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_connected", value)

    @_builtins.property
    @pulumi.getter(name="lastActivityAt")
    def last_activity_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last MQTT activity of the device.
        """
        return pulumi.get(self, "last_activity_at")

    @last_activity_at.setter
    def last_activity_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_activity_at", value)

    @_builtins.property
    @pulumi.getter(name="messageFilters")
    def message_filters(self) -> Optional[pulumi.Input['DeviceMessageFiltersArgs']]:
        """
        Rules that define which messages are authorized or denied based on their topic.
        """
        return pulumi.get(self, "message_filters")

    @message_filters.setter
    def message_filters(self, value: Optional[pulumi.Input['DeviceMessageFiltersArgs']]):
        pulumi.set(self, "message_filters", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IoT device you want to create (e.g. `my-device`).

        > **Important:** Updates to `name` will destroy and recreate a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region you want to attach the resource to
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the device.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the device resource was updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("scaleway:iot/device:Device")
class Device(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_multiple_connections: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificate: Optional[pulumi.Input[Union['DeviceCertificateArgs', 'DeviceCertificateArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 message_filters: Optional[pulumi.Input[Union['DeviceMessageFiltersArgs', 'DeviceMessageFiltersArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.iot.Hub("main",
            name="test-iot",
            product_plan="plan_shared")
        main_device = scaleway.iot.Device("main",
            hub_id=main.id,
            name="test-iot")
        ```

        ### With custom certificate

        ```python
        import pulumi
        import pulumi_local as local
        import pulumiverse_scaleway as scaleway

        main = scaleway.iot.Hub("main",
            name="test-iot",
            product_plan="plan_shared")
        device_cert = local.get_file(filename="device-certificate.pem")
        main_device = scaleway.iot.Device("main",
            hub_id=main.id,
            name="test-iot",
            certificate={
                "crt": device_cert.content,
            })
        ```

        ## Import

        IoT devices can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:iot/device:Device device01 fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_insecure: Allow plain and server-authenticated TLS connections in addition to mutually-authenticated ones.
               
               > **Important:** Updates to `allow_insecure` can disconnect eventually connected devices.
        :param pulumi.Input[_builtins.bool] allow_multiple_connections: Allow more than one simultaneous connection using the same device credentials.
               
               > **Important:** Updates to `allow_multiple_connections` can disconnect eventually connected devices.
        :param pulumi.Input[Union['DeviceCertificateArgs', 'DeviceCertificateArgsDict']] certificate: The certificate bundle of the device.
        :param pulumi.Input[_builtins.str] description: The description of the IoT device (e.g. `living room`).
        :param pulumi.Input[_builtins.str] hub_id: The ID of the hub on which this device will be created.
        :param pulumi.Input[Union['DeviceMessageFiltersArgs', 'DeviceMessageFiltersArgsDict']] message_filters: Rules that define which messages are authorized or denied based on their topic.
        :param pulumi.Input[_builtins.str] name: The name of the IoT device you want to create (e.g. `my-device`).
               
               > **Important:** Updates to `name` will destroy and recreate a new resource.
        :param pulumi.Input[_builtins.str] region: The region you want to attach the resource to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeviceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.iot.Hub("main",
            name="test-iot",
            product_plan="plan_shared")
        main_device = scaleway.iot.Device("main",
            hub_id=main.id,
            name="test-iot")
        ```

        ### With custom certificate

        ```python
        import pulumi
        import pulumi_local as local
        import pulumiverse_scaleway as scaleway

        main = scaleway.iot.Hub("main",
            name="test-iot",
            product_plan="plan_shared")
        device_cert = local.get_file(filename="device-certificate.pem")
        main_device = scaleway.iot.Device("main",
            hub_id=main.id,
            name="test-iot",
            certificate={
                "crt": device_cert.content,
            })
        ```

        ## Import

        IoT devices can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:iot/device:Device device01 fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param DeviceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeviceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_multiple_connections: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificate: Optional[pulumi.Input[Union['DeviceCertificateArgs', 'DeviceCertificateArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 message_filters: Optional[pulumi.Input[Union['DeviceMessageFiltersArgs', 'DeviceMessageFiltersArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeviceArgs.__new__(DeviceArgs)

            __props__.__dict__["allow_insecure"] = allow_insecure
            __props__.__dict__["allow_multiple_connections"] = allow_multiple_connections
            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["description"] = description
            if hub_id is None and not opts.urn:
                raise TypeError("Missing required property 'hub_id'")
            __props__.__dict__["hub_id"] = hub_id
            __props__.__dict__["message_filters"] = message_filters
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["created_at"] = None
            __props__.__dict__["is_connected"] = None
            __props__.__dict__["last_activity_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/iotDevice:IotDevice")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Device, __self__).__init__(
            'scaleway:iot/device:Device',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_insecure: Optional[pulumi.Input[_builtins.bool]] = None,
            allow_multiple_connections: Optional[pulumi.Input[_builtins.bool]] = None,
            certificate: Optional[pulumi.Input[Union['DeviceCertificateArgs', 'DeviceCertificateArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            hub_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_connected: Optional[pulumi.Input[_builtins.bool]] = None,
            last_activity_at: Optional[pulumi.Input[_builtins.str]] = None,
            message_filters: Optional[pulumi.Input[Union['DeviceMessageFiltersArgs', 'DeviceMessageFiltersArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'Device':
        """
        Get an existing Device resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_insecure: Allow plain and server-authenticated TLS connections in addition to mutually-authenticated ones.
               
               > **Important:** Updates to `allow_insecure` can disconnect eventually connected devices.
        :param pulumi.Input[_builtins.bool] allow_multiple_connections: Allow more than one simultaneous connection using the same device credentials.
               
               > **Important:** Updates to `allow_multiple_connections` can disconnect eventually connected devices.
        :param pulumi.Input[Union['DeviceCertificateArgs', 'DeviceCertificateArgsDict']] certificate: The certificate bundle of the device.
        :param pulumi.Input[_builtins.str] created_at: The date and time the device was created.
        :param pulumi.Input[_builtins.str] description: The description of the IoT device (e.g. `living room`).
        :param pulumi.Input[_builtins.str] hub_id: The ID of the hub on which this device will be created.
        :param pulumi.Input[_builtins.bool] is_connected: The current connection status of the device.
        :param pulumi.Input[_builtins.str] last_activity_at: The last MQTT activity of the device.
        :param pulumi.Input[Union['DeviceMessageFiltersArgs', 'DeviceMessageFiltersArgsDict']] message_filters: Rules that define which messages are authorized or denied based on their topic.
        :param pulumi.Input[_builtins.str] name: The name of the IoT device you want to create (e.g. `my-device`).
               
               > **Important:** Updates to `name` will destroy and recreate a new resource.
        :param pulumi.Input[_builtins.str] region: The region you want to attach the resource to
        :param pulumi.Input[_builtins.str] status: The current status of the device.
        :param pulumi.Input[_builtins.str] updated_at: The date and time the device resource was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeviceState.__new__(_DeviceState)

        __props__.__dict__["allow_insecure"] = allow_insecure
        __props__.__dict__["allow_multiple_connections"] = allow_multiple_connections
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["hub_id"] = hub_id
        __props__.__dict__["is_connected"] = is_connected
        __props__.__dict__["last_activity_at"] = last_activity_at
        __props__.__dict__["message_filters"] = message_filters
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["updated_at"] = updated_at
        return Device(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Allow plain and server-authenticated TLS connections in addition to mutually-authenticated ones.

        > **Important:** Updates to `allow_insecure` can disconnect eventually connected devices.
        """
        return pulumi.get(self, "allow_insecure")

    @_builtins.property
    @pulumi.getter(name="allowMultipleConnections")
    def allow_multiple_connections(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Allow more than one simultaneous connection using the same device credentials.

        > **Important:** Updates to `allow_multiple_connections` can disconnect eventually connected devices.
        """
        return pulumi.get(self, "allow_multiple_connections")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output['outputs.DeviceCertificate']:
        """
        The certificate bundle of the device.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the device was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the IoT device (e.g. `living room`).
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="hubId")
    def hub_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the hub on which this device will be created.
        """
        return pulumi.get(self, "hub_id")

    @_builtins.property
    @pulumi.getter(name="isConnected")
    def is_connected(self) -> pulumi.Output[_builtins.bool]:
        """
        The current connection status of the device.
        """
        return pulumi.get(self, "is_connected")

    @_builtins.property
    @pulumi.getter(name="lastActivityAt")
    def last_activity_at(self) -> pulumi.Output[_builtins.str]:
        """
        The last MQTT activity of the device.
        """
        return pulumi.get(self, "last_activity_at")

    @_builtins.property
    @pulumi.getter(name="messageFilters")
    def message_filters(self) -> pulumi.Output[Optional['outputs.DeviceMessageFilters']]:
        """
        Rules that define which messages are authorized or denied based on their topic.
        """
        return pulumi.get(self, "message_filters")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the IoT device you want to create (e.g. `my-device`).

        > **Important:** Updates to `name` will destroy and recreate a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region you want to attach the resource to
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the device.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the device resource was updated.
        """
        return pulumi.get(self, "updated_at")

