# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobDefinitionArgs', 'JobDefinition']

@pulumi.input_type
class JobDefinitionArgs:
    def __init__(__self__, *,
                 cpu_limit: pulumi.Input[_builtins.int],
                 memory_limit: pulumi.Input[_builtins.int],
                 command: Optional[pulumi.Input[_builtins.str]] = None,
                 cron: Optional[pulumi.Input['JobDefinitionCronArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 env: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 image_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_references: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretReferenceArgs']]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a JobDefinition resource.
        :param pulumi.Input[_builtins.int] cpu_limit: The amount of vCPU computing resources to allocate to each container running the job.
        :param pulumi.Input[_builtins.int] memory_limit: The memory computing resources in MB to allocate to each container running the job.
        :param pulumi.Input[_builtins.str] command: The command that will be run in the container if specified.
        :param pulumi.Input['JobDefinitionCronArgs'] cron: The cron configuration
        :param pulumi.Input[_builtins.str] description: The description of the job
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] env: The environment variables of the container.
        :param pulumi.Input[_builtins.str] image_uri: The uri of the container image that will be used for the job run.
        :param pulumi.Input[_builtins.str] name: The name of the job.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the Job is associated with.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the Job.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretReferenceArgs']]] secret_references: A reference to a secret stored in Secret Manager.
        :param pulumi.Input[_builtins.str] timeout: The job run timeout, in Go Time format (ex: `2h30m25s`)
        """
        pulumi.set(__self__, "cpu_limit", cpu_limit)
        pulumi.set(__self__, "memory_limit", memory_limit)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if cron is not None:
            pulumi.set(__self__, "cron", cron)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_references is not None:
            pulumi.set(__self__, "secret_references", secret_references)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> pulumi.Input[_builtins.int]:
        """
        The amount of vCPU computing resources to allocate to each container running the job.
        """
        return pulumi.get(self, "cpu_limit")

    @cpu_limit.setter
    def cpu_limit(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "cpu_limit", value)

    @_builtins.property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> pulumi.Input[_builtins.int]:
        """
        The memory computing resources in MB to allocate to each container running the job.
        """
        return pulumi.get(self, "memory_limit")

    @memory_limit.setter
    def memory_limit(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "memory_limit", value)

    @_builtins.property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The command that will be run in the container if specified.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "command", value)

    @_builtins.property
    @pulumi.getter
    def cron(self) -> Optional[pulumi.Input['JobDefinitionCronArgs']]:
        """
        The cron configuration
        """
        return pulumi.get(self, "cron")

    @cron.setter
    def cron(self, value: Optional[pulumi.Input['JobDefinitionCronArgs']]):
        pulumi.set(self, "cron", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the job
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The environment variables of the container.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "env", value)

    @_builtins.property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The uri of the container image that will be used for the job run.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_uri", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the job.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the Job is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region of the Job.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretReferences")
    def secret_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretReferenceArgs']]]]:
        """
        A reference to a secret stored in Secret Manager.
        """
        return pulumi.get(self, "secret_references")

    @secret_references.setter
    def secret_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretReferenceArgs']]]]):
        pulumi.set(self, "secret_references", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The job run timeout, in Go Time format (ex: `2h30m25s`)
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class _JobDefinitionState:
    def __init__(__self__, *,
                 command: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 cron: Optional[pulumi.Input['JobDefinitionCronArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 env: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 image_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_references: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretReferenceArgs']]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering JobDefinition resources.
        :param pulumi.Input[_builtins.str] command: The command that will be run in the container if specified.
        :param pulumi.Input[_builtins.int] cpu_limit: The amount of vCPU computing resources to allocate to each container running the job.
        :param pulumi.Input['JobDefinitionCronArgs'] cron: The cron configuration
        :param pulumi.Input[_builtins.str] description: The description of the job
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] env: The environment variables of the container.
        :param pulumi.Input[_builtins.str] image_uri: The uri of the container image that will be used for the job run.
        :param pulumi.Input[_builtins.int] memory_limit: The memory computing resources in MB to allocate to each container running the job.
        :param pulumi.Input[_builtins.str] name: The name of the job.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the Job is associated with.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the Job.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretReferenceArgs']]] secret_references: A reference to a secret stored in Secret Manager.
        :param pulumi.Input[_builtins.str] timeout: The job run timeout, in Go Time format (ex: `2h30m25s`)
        """
        if command is not None:
            pulumi.set(__self__, "command", command)
        if cpu_limit is not None:
            pulumi.set(__self__, "cpu_limit", cpu_limit)
        if cron is not None:
            pulumi.set(__self__, "cron", cron)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if memory_limit is not None:
            pulumi.set(__self__, "memory_limit", memory_limit)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_references is not None:
            pulumi.set(__self__, "secret_references", secret_references)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The command that will be run in the container if specified.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "command", value)

    @_builtins.property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of vCPU computing resources to allocate to each container running the job.
        """
        return pulumi.get(self, "cpu_limit")

    @cpu_limit.setter
    def cpu_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_limit", value)

    @_builtins.property
    @pulumi.getter
    def cron(self) -> Optional[pulumi.Input['JobDefinitionCronArgs']]:
        """
        The cron configuration
        """
        return pulumi.get(self, "cron")

    @cron.setter
    def cron(self, value: Optional[pulumi.Input['JobDefinitionCronArgs']]):
        pulumi.set(self, "cron", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the job
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The environment variables of the container.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "env", value)

    @_builtins.property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The uri of the container image that will be used for the job run.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_uri", value)

    @_builtins.property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The memory computing resources in MB to allocate to each container running the job.
        """
        return pulumi.get(self, "memory_limit")

    @memory_limit.setter
    def memory_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_limit", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the job.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the Job is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region of the Job.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretReferences")
    def secret_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretReferenceArgs']]]]:
        """
        A reference to a secret stored in Secret Manager.
        """
        return pulumi.get(self, "secret_references")

    @secret_references.setter
    def secret_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionSecretReferenceArgs']]]]):
        pulumi.set(self, "secret_references", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The job run timeout, in Go Time format (ex: `2h30m25s`)
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timeout", value)


warnings.warn("""scaleway.index/jobdefinition.JobDefinition has been deprecated in favor of scaleway.job/definition.Definition""", DeprecationWarning)


@pulumi.type_token("scaleway:index/jobDefinition:JobDefinition")
class JobDefinition(pulumi.CustomResource):
    warnings.warn("""scaleway.index/jobdefinition.JobDefinition has been deprecated in favor of scaleway.job/definition.Definition""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 command: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 cron: Optional[pulumi.Input[Union['JobDefinitionCronArgs', 'JobDefinitionCronArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 env: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 image_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobDefinitionSecretReferenceArgs', 'JobDefinitionSecretReferenceArgsDict']]]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages a Scaleway Serverless Job Definition. For more information, see the [Go API documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/jobs/v1alpha1).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.job.Definition("main",
            name="testjob",
            cpu_limit=140,
            memory_limit=256,
            image_uri="docker.io/alpine:latest",
            command="ls",
            timeout="10m",
            env={
                "foo": "bar",
            },
            cron={
                "schedule": "5 4 1 * *",
                "timezone": "Europe/Paris",
            })
        ```

        ### With Secret Reference

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.job.Definition("main",
            name="testjob",
            cpu_limit=140,
            memory_limit=256,
            image_uri="docker.io/alpine:latest",
            command="ls",
            timeout="10m",
            cron={
                "schedule": "5 4 1 * *",
                "timezone": "Europe/Paris",
            },
            secret_references=[
                {
                    "secret_id": "11111111-1111-1111-1111-111111111111",
                    "file": "/home/dev/secret_file",
                },
                {
                    "secret_id": job_secret["id"],
                    "secret_version": "1",
                    "environment": "FOO",
                },
            ])
        ```

        ## Import

        Serverless Jobs can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/jobDefinition:JobDefinition job fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] command: The command that will be run in the container if specified.
        :param pulumi.Input[_builtins.int] cpu_limit: The amount of vCPU computing resources to allocate to each container running the job.
        :param pulumi.Input[Union['JobDefinitionCronArgs', 'JobDefinitionCronArgsDict']] cron: The cron configuration
        :param pulumi.Input[_builtins.str] description: The description of the job
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] env: The environment variables of the container.
        :param pulumi.Input[_builtins.str] image_uri: The uri of the container image that will be used for the job run.
        :param pulumi.Input[_builtins.int] memory_limit: The memory computing resources in MB to allocate to each container running the job.
        :param pulumi.Input[_builtins.str] name: The name of the job.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the Job is associated with.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the Job.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobDefinitionSecretReferenceArgs', 'JobDefinitionSecretReferenceArgsDict']]]] secret_references: A reference to a secret stored in Secret Manager.
        :param pulumi.Input[_builtins.str] timeout: The job run timeout, in Go Time format (ex: `2h30m25s`)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages a Scaleway Serverless Job Definition. For more information, see the [Go API documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/jobs/v1alpha1).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.job.Definition("main",
            name="testjob",
            cpu_limit=140,
            memory_limit=256,
            image_uri="docker.io/alpine:latest",
            command="ls",
            timeout="10m",
            env={
                "foo": "bar",
            },
            cron={
                "schedule": "5 4 1 * *",
                "timezone": "Europe/Paris",
            })
        ```

        ### With Secret Reference

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.job.Definition("main",
            name="testjob",
            cpu_limit=140,
            memory_limit=256,
            image_uri="docker.io/alpine:latest",
            command="ls",
            timeout="10m",
            cron={
                "schedule": "5 4 1 * *",
                "timezone": "Europe/Paris",
            },
            secret_references=[
                {
                    "secret_id": "11111111-1111-1111-1111-111111111111",
                    "file": "/home/dev/secret_file",
                },
                {
                    "secret_id": job_secret["id"],
                    "secret_version": "1",
                    "environment": "FOO",
                },
            ])
        ```

        ## Import

        Serverless Jobs can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/jobDefinition:JobDefinition job fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param JobDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 command: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 cron: Optional[pulumi.Input[Union['JobDefinitionCronArgs', 'JobDefinitionCronArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 env: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 image_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobDefinitionSecretReferenceArgs', 'JobDefinitionSecretReferenceArgsDict']]]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""JobDefinition is deprecated: scaleway.index/jobdefinition.JobDefinition has been deprecated in favor of scaleway.job/definition.Definition""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobDefinitionArgs.__new__(JobDefinitionArgs)

            __props__.__dict__["command"] = command
            if cpu_limit is None and not opts.urn:
                raise TypeError("Missing required property 'cpu_limit'")
            __props__.__dict__["cpu_limit"] = cpu_limit
            __props__.__dict__["cron"] = cron
            __props__.__dict__["description"] = description
            __props__.__dict__["env"] = env
            __props__.__dict__["image_uri"] = image_uri
            if memory_limit is None and not opts.urn:
                raise TypeError("Missing required property 'memory_limit'")
            __props__.__dict__["memory_limit"] = memory_limit
            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["secret_references"] = secret_references
            __props__.__dict__["timeout"] = timeout
        super(JobDefinition, __self__).__init__(
            'scaleway:index/jobDefinition:JobDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            command: Optional[pulumi.Input[_builtins.str]] = None,
            cpu_limit: Optional[pulumi.Input[_builtins.int]] = None,
            cron: Optional[pulumi.Input[Union['JobDefinitionCronArgs', 'JobDefinitionCronArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            env: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            image_uri: Optional[pulumi.Input[_builtins.str]] = None,
            memory_limit: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            secret_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobDefinitionSecretReferenceArgs', 'JobDefinitionSecretReferenceArgsDict']]]]] = None,
            timeout: Optional[pulumi.Input[_builtins.str]] = None) -> 'JobDefinition':
        """
        Get an existing JobDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] command: The command that will be run in the container if specified.
        :param pulumi.Input[_builtins.int] cpu_limit: The amount of vCPU computing resources to allocate to each container running the job.
        :param pulumi.Input[Union['JobDefinitionCronArgs', 'JobDefinitionCronArgsDict']] cron: The cron configuration
        :param pulumi.Input[_builtins.str] description: The description of the job
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] env: The environment variables of the container.
        :param pulumi.Input[_builtins.str] image_uri: The uri of the container image that will be used for the job run.
        :param pulumi.Input[_builtins.int] memory_limit: The memory computing resources in MB to allocate to each container running the job.
        :param pulumi.Input[_builtins.str] name: The name of the job.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the Job is associated with.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the Job.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobDefinitionSecretReferenceArgs', 'JobDefinitionSecretReferenceArgsDict']]]] secret_references: A reference to a secret stored in Secret Manager.
        :param pulumi.Input[_builtins.str] timeout: The job run timeout, in Go Time format (ex: `2h30m25s`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobDefinitionState.__new__(_JobDefinitionState)

        __props__.__dict__["command"] = command
        __props__.__dict__["cpu_limit"] = cpu_limit
        __props__.__dict__["cron"] = cron
        __props__.__dict__["description"] = description
        __props__.__dict__["env"] = env
        __props__.__dict__["image_uri"] = image_uri
        __props__.__dict__["memory_limit"] = memory_limit
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["secret_references"] = secret_references
        __props__.__dict__["timeout"] = timeout
        return JobDefinition(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def command(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The command that will be run in the container if specified.
        """
        return pulumi.get(self, "command")

    @_builtins.property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> pulumi.Output[_builtins.int]:
        """
        The amount of vCPU computing resources to allocate to each container running the job.
        """
        return pulumi.get(self, "cpu_limit")

    @_builtins.property
    @pulumi.getter
    def cron(self) -> pulumi.Output[Optional['outputs.JobDefinitionCron']]:
        """
        The cron configuration
        """
        return pulumi.get(self, "cron")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the job
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def env(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The environment variables of the container.
        """
        return pulumi.get(self, "env")

    @_builtins.property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The uri of the container image that will be used for the job run.
        """
        return pulumi.get(self, "image_uri")

    @_builtins.property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> pulumi.Output[_builtins.int]:
        """
        The memory computing resources in MB to allocate to each container running the job.
        """
        return pulumi.get(self, "memory_limit")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the job.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the project the Job is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `region`) The region of the Job.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretReferences")
    def secret_references(self) -> pulumi.Output[Optional[Sequence['outputs.JobDefinitionSecretReference']]]:
        """
        A reference to a secret stored in Secret Manager.
        """
        return pulumi.get(self, "secret_references")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[_builtins.str]:
        """
        The job run timeout, in Go Time format (ex: `2h30m25s`)
        """
        return pulumi.get(self, "timeout")

