# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KeyManagerKeyArgs', 'KeyManagerKey']

@pulumi.input_type
class KeyManagerKeyArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input[_builtins.str],
                 usage: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 origin: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_policy: Optional[pulumi.Input['KeyManagerKeyRotationPolicyArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 unprotected: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a KeyManagerKey resource.
        :param pulumi.Input[_builtins.str] algorithm: – The cryptographic algorithm to use. Valid values depend on the `usage`:
               - For `symmetric_encryption`:
        :param pulumi.Input[_builtins.str] usage: – The usage type of the key. Valid values:
        :param pulumi.Input[_builtins.str] description: – A description for the key.
        :param pulumi.Input[_builtins.str] name: The name of the key.
        :param pulumi.Input[_builtins.str] origin: – The origin of the key. Valid values are:
        :param pulumi.Input[_builtins.str] project_id: – The ID of the project the key belongs to.
               
               **Key Usage and Algorithm (both required):**
        :param pulumi.Input[_builtins.str] region: The region in which to create the key (e.g., `fr-par`).
        :param pulumi.Input['KeyManagerKeyRotationPolicyArgs'] rotation_policy: – Rotation policy for the key:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: – A list of tags to assign to the key.
        :param pulumi.Input[_builtins.bool] unprotected: – If `true`, the key can be deleted. Defaults to `false` (protected).
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "usage", usage)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rotation_policy is not None:
            pulumi.set(__self__, "rotation_policy", rotation_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if unprotected is not None:
            pulumi.set(__self__, "unprotected", unprotected)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input[_builtins.str]:
        """
        – The cryptographic algorithm to use. Valid values depend on the `usage`:
        - For `symmetric_encryption`:
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter
    def usage(self) -> pulumi.Input[_builtins.str]:
        """
        – The usage type of the key. Valid values:
        """
        return pulumi.get(self, "usage")

    @usage.setter
    def usage(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "usage", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        – A description for the key.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        – The origin of the key. Valid values are:
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        – The ID of the project the key belongs to.

        **Key Usage and Algorithm (both required):**
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the key (e.g., `fr-par`).
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="rotationPolicy")
    def rotation_policy(self) -> Optional[pulumi.Input['KeyManagerKeyRotationPolicyArgs']]:
        """
        – Rotation policy for the key:
        """
        return pulumi.get(self, "rotation_policy")

    @rotation_policy.setter
    def rotation_policy(self, value: Optional[pulumi.Input['KeyManagerKeyRotationPolicyArgs']]):
        pulumi.set(self, "rotation_policy", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        – A list of tags to assign to the key.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def unprotected(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        – If `true`, the key can be deleted. Defaults to `false` (protected).
        """
        return pulumi.get(self, "unprotected")

    @unprotected.setter
    def unprotected(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "unprotected", value)


@pulumi.input_type
class _KeyManagerKeyState:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 origin: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protected: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rotated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_count: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_policy: Optional[pulumi.Input['KeyManagerKeyRotationPolicyArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 unprotected: Optional[pulumi.Input[_builtins.bool]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 usage: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KeyManagerKey resources.
        :param pulumi.Input[_builtins.str] algorithm: – The cryptographic algorithm to use. Valid values depend on the `usage`:
               - For `symmetric_encryption`:
        :param pulumi.Input[_builtins.str] created_at: The date and time when the key was created.
        :param pulumi.Input[_builtins.str] description: – A description for the key.
        :param pulumi.Input[_builtins.bool] locked: Whether the key is locked.
        :param pulumi.Input[_builtins.str] name: The name of the key.
        :param pulumi.Input[_builtins.str] origin: – The origin of the key. Valid values are:
        :param pulumi.Input[_builtins.str] project_id: – The ID of the project the key belongs to.
               
               **Key Usage and Algorithm (both required):**
        :param pulumi.Input[_builtins.bool] protected: Whether the key is protected from deletion.
        :param pulumi.Input[_builtins.str] region: The region in which to create the key (e.g., `fr-par`).
        :param pulumi.Input[_builtins.str] rotated_at: The date and time when the key was last rotated.
        :param pulumi.Input[_builtins.int] rotation_count: The number of times the key has been rotated.
        :param pulumi.Input['KeyManagerKeyRotationPolicyArgs'] rotation_policy: – Rotation policy for the key:
        :param pulumi.Input[_builtins.str] state: The state of the key (e.g., `enabled`).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: – A list of tags to assign to the key.
        :param pulumi.Input[_builtins.bool] unprotected: – If `true`, the key can be deleted. Defaults to `false` (protected).
        :param pulumi.Input[_builtins.str] updated_at: The date and time when the key was last updated.
        :param pulumi.Input[_builtins.str] usage: – The usage type of the key. Valid values:
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if protected is not None:
            pulumi.set(__self__, "protected", protected)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rotated_at is not None:
            pulumi.set(__self__, "rotated_at", rotated_at)
        if rotation_count is not None:
            pulumi.set(__self__, "rotation_count", rotation_count)
        if rotation_policy is not None:
            pulumi.set(__self__, "rotation_policy", rotation_policy)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if unprotected is not None:
            pulumi.set(__self__, "unprotected", unprotected)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if usage is not None:
            pulumi.set(__self__, "usage", usage)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        – The cryptographic algorithm to use. Valid values depend on the `usage`:
        - For `symmetric_encryption`:
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the key was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        – A description for the key.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the key is locked.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "locked", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        – The origin of the key. Valid values are:
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        – The ID of the project the key belongs to.

        **Key Usage and Algorithm (both required):**
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def protected(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the key is protected from deletion.
        """
        return pulumi.get(self, "protected")

    @protected.setter
    def protected(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "protected", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the key (e.g., `fr-par`).
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="rotatedAt")
    def rotated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the key was last rotated.
        """
        return pulumi.get(self, "rotated_at")

    @rotated_at.setter
    def rotated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotated_at", value)

    @_builtins.property
    @pulumi.getter(name="rotationCount")
    def rotation_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of times the key has been rotated.
        """
        return pulumi.get(self, "rotation_count")

    @rotation_count.setter
    def rotation_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_count", value)

    @_builtins.property
    @pulumi.getter(name="rotationPolicy")
    def rotation_policy(self) -> Optional[pulumi.Input['KeyManagerKeyRotationPolicyArgs']]:
        """
        – Rotation policy for the key:
        """
        return pulumi.get(self, "rotation_policy")

    @rotation_policy.setter
    def rotation_policy(self, value: Optional[pulumi.Input['KeyManagerKeyRotationPolicyArgs']]):
        pulumi.set(self, "rotation_policy", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the key (e.g., `enabled`).
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        – A list of tags to assign to the key.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def unprotected(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        – If `true`, the key can be deleted. Defaults to `false` (protected).
        """
        return pulumi.get(self, "unprotected")

    @unprotected.setter
    def unprotected(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "unprotected", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the key was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def usage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        – The usage type of the key. Valid values:
        """
        return pulumi.get(self, "usage")

    @usage.setter
    def usage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "usage", value)


@pulumi.type_token("scaleway:index/keyManagerKey:KeyManagerKey")
class KeyManagerKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 origin: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_policy: Optional[pulumi.Input[Union['KeyManagerKeyRotationPolicyArgs', 'KeyManagerKeyRotationPolicyArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 unprotected: Optional[pulumi.Input[_builtins.bool]] = None,
                 usage: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Scaleway Key Manager Key resource.\\
        This resource allows you to create and manage cryptographic keys in Scaleway Key Manager (KMS).

        ## Example Usage

        ### Symmetric Encryption Key

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        symmetric = scaleway.KeyManagerKey("symmetric",
            name="my-kms-key",
            region="fr-par",
            project_id="your-project-id",
            usage="symmetric_encryption",
            algorithm="aes_256_gcm",
            description="Key for encrypting secrets",
            tags=[
                "env:prod",
                "kms",
            ],
            unprotected=True,
            rotation_policy={
                "rotation_period": "720h",
            })
        ```

        ### Asymmetric Encryption Key with RSA-4096

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        rsa4096 = scaleway.KeyManagerKey("rsa_4096",
            name="rsa-4096-key",
            region="fr-par",
            usage="asymmetric_encryption",
            algorithm="rsa_oaep_4096_sha256",
            description="Key for encrypting large files with RSA-4096",
            unprotected=True)
        ```

        ### Asymmetric Signing Key

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        signing = scaleway.KeyManagerKey("signing",
            name="signing-key",
            region="fr-par",
            usage="asymmetric_signing",
            algorithm="rsa_pss_2048_sha256",
            description="Key for signing documents",
            unprotected=True)
        ```

        ## Notes

        - **Protection**: By default, keys are protected and cannot be deleted. To allow deletion, set `unprotected = true` when creating the key.
        - **Rotation Policy**: The `rotation_policy` block allows you to set automatic rotation for your key.
        - **Origin**: The `origin` argument is optional and defaults to `scaleway_kms`. Use `external` if you want to import an external key (see Scaleway documentation for details).
        - **Project and Region**: If not specified, `project_id` and `region` will default to the provider configuration.
        - **Algorithm Validation**: The provider validates that the specified `algorithm` is compatible with the `usage` type at plan time, providing early feedback on configuration errors.

        ## Import

        You can import a key using its ID and region:

        ```sh
        $ pulumi import scaleway:index/keyManagerKey:KeyManagerKey main fr-par/11111111-2222-3333-4444-555555555555
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] algorithm: – The cryptographic algorithm to use. Valid values depend on the `usage`:
               - For `symmetric_encryption`:
        :param pulumi.Input[_builtins.str] description: – A description for the key.
        :param pulumi.Input[_builtins.str] name: The name of the key.
        :param pulumi.Input[_builtins.str] origin: – The origin of the key. Valid values are:
        :param pulumi.Input[_builtins.str] project_id: – The ID of the project the key belongs to.
               
               **Key Usage and Algorithm (both required):**
        :param pulumi.Input[_builtins.str] region: The region in which to create the key (e.g., `fr-par`).
        :param pulumi.Input[Union['KeyManagerKeyRotationPolicyArgs', 'KeyManagerKeyRotationPolicyArgsDict']] rotation_policy: – Rotation policy for the key:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: – A list of tags to assign to the key.
        :param pulumi.Input[_builtins.bool] unprotected: – If `true`, the key can be deleted. Defaults to `false` (protected).
        :param pulumi.Input[_builtins.str] usage: – The usage type of the key. Valid values:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeyManagerKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Scaleway Key Manager Key resource.\\
        This resource allows you to create and manage cryptographic keys in Scaleway Key Manager (KMS).

        ## Example Usage

        ### Symmetric Encryption Key

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        symmetric = scaleway.KeyManagerKey("symmetric",
            name="my-kms-key",
            region="fr-par",
            project_id="your-project-id",
            usage="symmetric_encryption",
            algorithm="aes_256_gcm",
            description="Key for encrypting secrets",
            tags=[
                "env:prod",
                "kms",
            ],
            unprotected=True,
            rotation_policy={
                "rotation_period": "720h",
            })
        ```

        ### Asymmetric Encryption Key with RSA-4096

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        rsa4096 = scaleway.KeyManagerKey("rsa_4096",
            name="rsa-4096-key",
            region="fr-par",
            usage="asymmetric_encryption",
            algorithm="rsa_oaep_4096_sha256",
            description="Key for encrypting large files with RSA-4096",
            unprotected=True)
        ```

        ### Asymmetric Signing Key

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        signing = scaleway.KeyManagerKey("signing",
            name="signing-key",
            region="fr-par",
            usage="asymmetric_signing",
            algorithm="rsa_pss_2048_sha256",
            description="Key for signing documents",
            unprotected=True)
        ```

        ## Notes

        - **Protection**: By default, keys are protected and cannot be deleted. To allow deletion, set `unprotected = true` when creating the key.
        - **Rotation Policy**: The `rotation_policy` block allows you to set automatic rotation for your key.
        - **Origin**: The `origin` argument is optional and defaults to `scaleway_kms`. Use `external` if you want to import an external key (see Scaleway documentation for details).
        - **Project and Region**: If not specified, `project_id` and `region` will default to the provider configuration.
        - **Algorithm Validation**: The provider validates that the specified `algorithm` is compatible with the `usage` type at plan time, providing early feedback on configuration errors.

        ## Import

        You can import a key using its ID and region:

        ```sh
        $ pulumi import scaleway:index/keyManagerKey:KeyManagerKey main fr-par/11111111-2222-3333-4444-555555555555
        ```

        :param str resource_name: The name of the resource.
        :param KeyManagerKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyManagerKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 origin: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_policy: Optional[pulumi.Input[Union['KeyManagerKeyRotationPolicyArgs', 'KeyManagerKeyRotationPolicyArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 unprotected: Optional[pulumi.Input[_builtins.bool]] = None,
                 usage: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyManagerKeyArgs.__new__(KeyManagerKeyArgs)

            if algorithm is None and not opts.urn:
                raise TypeError("Missing required property 'algorithm'")
            __props__.__dict__["algorithm"] = algorithm
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["origin"] = origin
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["rotation_policy"] = rotation_policy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["unprotected"] = unprotected
            if usage is None and not opts.urn:
                raise TypeError("Missing required property 'usage'")
            __props__.__dict__["usage"] = usage
            __props__.__dict__["created_at"] = None
            __props__.__dict__["locked"] = None
            __props__.__dict__["protected"] = None
            __props__.__dict__["rotated_at"] = None
            __props__.__dict__["rotation_count"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["updated_at"] = None
        super(KeyManagerKey, __self__).__init__(
            'scaleway:index/keyManagerKey:KeyManagerKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            locked: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            origin: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            protected: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            rotated_at: Optional[pulumi.Input[_builtins.str]] = None,
            rotation_count: Optional[pulumi.Input[_builtins.int]] = None,
            rotation_policy: Optional[pulumi.Input[Union['KeyManagerKeyRotationPolicyArgs', 'KeyManagerKeyRotationPolicyArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            unprotected: Optional[pulumi.Input[_builtins.bool]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            usage: Optional[pulumi.Input[_builtins.str]] = None) -> 'KeyManagerKey':
        """
        Get an existing KeyManagerKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] algorithm: – The cryptographic algorithm to use. Valid values depend on the `usage`:
               - For `symmetric_encryption`:
        :param pulumi.Input[_builtins.str] created_at: The date and time when the key was created.
        :param pulumi.Input[_builtins.str] description: – A description for the key.
        :param pulumi.Input[_builtins.bool] locked: Whether the key is locked.
        :param pulumi.Input[_builtins.str] name: The name of the key.
        :param pulumi.Input[_builtins.str] origin: – The origin of the key. Valid values are:
        :param pulumi.Input[_builtins.str] project_id: – The ID of the project the key belongs to.
               
               **Key Usage and Algorithm (both required):**
        :param pulumi.Input[_builtins.bool] protected: Whether the key is protected from deletion.
        :param pulumi.Input[_builtins.str] region: The region in which to create the key (e.g., `fr-par`).
        :param pulumi.Input[_builtins.str] rotated_at: The date and time when the key was last rotated.
        :param pulumi.Input[_builtins.int] rotation_count: The number of times the key has been rotated.
        :param pulumi.Input[Union['KeyManagerKeyRotationPolicyArgs', 'KeyManagerKeyRotationPolicyArgsDict']] rotation_policy: – Rotation policy for the key:
        :param pulumi.Input[_builtins.str] state: The state of the key (e.g., `enabled`).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: – A list of tags to assign to the key.
        :param pulumi.Input[_builtins.bool] unprotected: – If `true`, the key can be deleted. Defaults to `false` (protected).
        :param pulumi.Input[_builtins.str] updated_at: The date and time when the key was last updated.
        :param pulumi.Input[_builtins.str] usage: – The usage type of the key. Valid values:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyManagerKeyState.__new__(_KeyManagerKeyState)

        __props__.__dict__["algorithm"] = algorithm
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["locked"] = locked
        __props__.__dict__["name"] = name
        __props__.__dict__["origin"] = origin
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["protected"] = protected
        __props__.__dict__["region"] = region
        __props__.__dict__["rotated_at"] = rotated_at
        __props__.__dict__["rotation_count"] = rotation_count
        __props__.__dict__["rotation_policy"] = rotation_policy
        __props__.__dict__["state"] = state
        __props__.__dict__["tags"] = tags
        __props__.__dict__["unprotected"] = unprotected
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["usage"] = usage
        return KeyManagerKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        – The cryptographic algorithm to use. Valid values depend on the `usage`:
        - For `symmetric_encryption`:
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the key was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        – A description for the key.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def locked(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the key is locked.
        """
        return pulumi.get(self, "locked")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the key.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def origin(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        – The origin of the key. Valid values are:
        """
        return pulumi.get(self, "origin")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        – The ID of the project the key belongs to.

        **Key Usage and Algorithm (both required):**
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def protected(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the key is protected from deletion.
        """
        return pulumi.get(self, "protected")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region in which to create the key (e.g., `fr-par`).
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rotatedAt")
    def rotated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the key was last rotated.
        """
        return pulumi.get(self, "rotated_at")

    @_builtins.property
    @pulumi.getter(name="rotationCount")
    def rotation_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of times the key has been rotated.
        """
        return pulumi.get(self, "rotation_count")

    @_builtins.property
    @pulumi.getter(name="rotationPolicy")
    def rotation_policy(self) -> pulumi.Output[Optional['outputs.KeyManagerKeyRotationPolicy']]:
        """
        – Rotation policy for the key:
        """
        return pulumi.get(self, "rotation_policy")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the key (e.g., `enabled`).
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        – A list of tags to assign to the key.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def unprotected(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        – If `true`, the key can be deleted. Defaults to `false` (protected).
        """
        return pulumi.get(self, "unprotected")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the key was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def usage(self) -> pulumi.Output[_builtins.str]:
        """
        – The usage type of the key. Valid values:
        """
        return pulumi.get(self, "usage")

