# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AclAclRuleArgs',
    'AclAclRuleArgsDict',
    'ClusterAutoUpgradeArgs',
    'ClusterAutoUpgradeArgsDict',
    'ClusterAutoscalerConfigArgs',
    'ClusterAutoscalerConfigArgsDict',
    'ClusterKubeconfigArgs',
    'ClusterKubeconfigArgsDict',
    'ClusterOpenIdConnectConfigArgs',
    'ClusterOpenIdConnectConfigArgsDict',
    'PoolNodeArgs',
    'PoolNodeArgsDict',
    'PoolNodePrivateIpArgs',
    'PoolNodePrivateIpArgsDict',
    'PoolUpgradePolicyArgs',
    'PoolUpgradePolicyArgsDict',
]

MYPY = False

if not MYPY:
    class AclAclRuleArgsDict(TypedDict):
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        A text describing this rule.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the ACL resource. It is the same as the ID of the cluster.
        """
        ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IP range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)

        > **Important:** If the `ip` field is set, `scaleway_ranges` cannot be set to true in the same rule.
        """
        scaleway_ranges: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Allow access to cluster from all Scaleway ranges as defined in [Scaleway Network Information - IP ranges used by Scaleway](https://www.scaleway.com/en/docs/console/account/reference-content/scaleway-network-information/#ip-ranges-used-by-scaleway).
        Only one rule with this field set to true can be added.

        > **Important:** If the `scaleway_ranges` field is set to true, the `ip` field cannot be set on the same rule.
        """
elif False:
    AclAclRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AclAclRuleArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 scaleway_ranges: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] description: A text describing this rule.
        :param pulumi.Input[_builtins.str] id: The ID of the ACL resource. It is the same as the ID of the cluster.
        :param pulumi.Input[_builtins.str] ip: The IP range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
               
               > **Important:** If the `ip` field is set, `scaleway_ranges` cannot be set to true in the same rule.
        :param pulumi.Input[_builtins.bool] scaleway_ranges: Allow access to cluster from all Scaleway ranges as defined in [Scaleway Network Information - IP ranges used by Scaleway](https://www.scaleway.com/en/docs/console/account/reference-content/scaleway-network-information/#ip-ranges-used-by-scaleway).
               Only one rule with this field set to true can be added.
               
               > **Important:** If the `scaleway_ranges` field is set to true, the `ip` field cannot be set on the same rule.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if scaleway_ranges is not None:
            pulumi.set(__self__, "scaleway_ranges", scaleway_ranges)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A text describing this rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the ACL resource. It is the same as the ID of the cluster.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)

        > **Important:** If the `ip` field is set, `scaleway_ranges` cannot be set to true in the same rule.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="scalewayRanges")
    def scaleway_ranges(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow access to cluster from all Scaleway ranges as defined in [Scaleway Network Information - IP ranges used by Scaleway](https://www.scaleway.com/en/docs/console/account/reference-content/scaleway-network-information/#ip-ranges-used-by-scaleway).
        Only one rule with this field set to true can be added.

        > **Important:** If the `scaleway_ranges` field is set to true, the `ip` field cannot be set on the same rule.
        """
        return pulumi.get(self, "scaleway_ranges")

    @scaleway_ranges.setter
    def scaleway_ranges(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "scaleway_ranges", value)


if not MYPY:
    class ClusterAutoUpgradeArgsDict(TypedDict):
        enable: pulumi.Input[_builtins.bool]
        """
        Set to `true` to enable Kubernetes patch version auto upgrades.
        > **Important:** When enabling auto upgrades, the `version` field take a minor version like x.y (ie 1.18).
        """
        maintenance_window_day: pulumi.Input[_builtins.str]
        """
        The day of the auto upgrade maintenance window (`monday` to `sunday`, or `any`).
        """
        maintenance_window_start_hour: pulumi.Input[_builtins.int]
        """
        The start hour (UTC) of the 2-hour auto upgrade maintenance window (0 to 23).
        """
elif False:
    ClusterAutoUpgradeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterAutoUpgradeArgs:
    def __init__(__self__, *,
                 enable: pulumi.Input[_builtins.bool],
                 maintenance_window_day: pulumi.Input[_builtins.str],
                 maintenance_window_start_hour: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.bool] enable: Set to `true` to enable Kubernetes patch version auto upgrades.
               > **Important:** When enabling auto upgrades, the `version` field take a minor version like x.y (ie 1.18).
        :param pulumi.Input[_builtins.str] maintenance_window_day: The day of the auto upgrade maintenance window (`monday` to `sunday`, or `any`).
        :param pulumi.Input[_builtins.int] maintenance_window_start_hour: The start hour (UTC) of the 2-hour auto upgrade maintenance window (0 to 23).
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "maintenance_window_day", maintenance_window_day)
        pulumi.set(__self__, "maintenance_window_start_hour", maintenance_window_start_hour)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> pulumi.Input[_builtins.bool]:
        """
        Set to `true` to enable Kubernetes patch version auto upgrades.
        > **Important:** When enabling auto upgrades, the `version` field take a minor version like x.y (ie 1.18).
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowDay")
    def maintenance_window_day(self) -> pulumi.Input[_builtins.str]:
        """
        The day of the auto upgrade maintenance window (`monday` to `sunday`, or `any`).
        """
        return pulumi.get(self, "maintenance_window_day")

    @maintenance_window_day.setter
    def maintenance_window_day(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "maintenance_window_day", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowStartHour")
    def maintenance_window_start_hour(self) -> pulumi.Input[_builtins.int]:
        """
        The start hour (UTC) of the 2-hour auto upgrade maintenance window (0 to 23).
        """
        return pulumi.get(self, "maintenance_window_start_hour")

    @maintenance_window_start_hour.setter
    def maintenance_window_start_hour(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "maintenance_window_start_hour", value)


if not MYPY:
    class ClusterAutoscalerConfigArgsDict(TypedDict):
        balance_similar_node_groups: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Detect similar node groups and balance the number of nodes between them.
        """
        disable_scale_down: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Disables the scale down feature of the autoscaler.
        """
        estimator: NotRequired[pulumi.Input[_builtins.str]]
        """
        Type of resource estimator to be used in scale up.
        """
        expander: NotRequired[pulumi.Input[_builtins.str]]
        """
        Type of node group expander to be used in scale up.
        """
        expendable_pods_priority_cutoff: NotRequired[pulumi.Input[_builtins.int]]
        """
        Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
        """
        ignore_daemonsets_utilization: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Ignore DaemonSet pods when calculating resource utilization for scaling down.
        """
        max_graceful_termination_sec: NotRequired[pulumi.Input[_builtins.int]]
        """
        Maximum number of seconds the cluster autoscaler waits for pod termination when trying to scale down a node
        """
        scale_down_delay_after_add: NotRequired[pulumi.Input[_builtins.str]]
        """
        How long after scale up that scale down evaluation resumes.
        """
        scale_down_unneeded_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        How long a node should be unneeded before it is eligible for scale down.
        """
        scale_down_utilization_threshold: NotRequired[pulumi.Input[_builtins.float]]
        """
        Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        """
elif False:
    ClusterAutoscalerConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterAutoscalerConfigArgs:
    def __init__(__self__, *,
                 balance_similar_node_groups: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_scale_down: Optional[pulumi.Input[_builtins.bool]] = None,
                 estimator: Optional[pulumi.Input[_builtins.str]] = None,
                 expander: Optional[pulumi.Input[_builtins.str]] = None,
                 expendable_pods_priority_cutoff: Optional[pulumi.Input[_builtins.int]] = None,
                 ignore_daemonsets_utilization: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_graceful_termination_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 scale_down_delay_after_add: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_down_unneeded_time: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_down_utilization_threshold: Optional[pulumi.Input[_builtins.float]] = None):
        """
        :param pulumi.Input[_builtins.bool] balance_similar_node_groups: Detect similar node groups and balance the number of nodes between them.
        :param pulumi.Input[_builtins.bool] disable_scale_down: Disables the scale down feature of the autoscaler.
        :param pulumi.Input[_builtins.str] estimator: Type of resource estimator to be used in scale up.
        :param pulumi.Input[_builtins.str] expander: Type of node group expander to be used in scale up.
        :param pulumi.Input[_builtins.int] expendable_pods_priority_cutoff: Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
        :param pulumi.Input[_builtins.bool] ignore_daemonsets_utilization: Ignore DaemonSet pods when calculating resource utilization for scaling down.
        :param pulumi.Input[_builtins.int] max_graceful_termination_sec: Maximum number of seconds the cluster autoscaler waits for pod termination when trying to scale down a node
        :param pulumi.Input[_builtins.str] scale_down_delay_after_add: How long after scale up that scale down evaluation resumes.
        :param pulumi.Input[_builtins.str] scale_down_unneeded_time: How long a node should be unneeded before it is eligible for scale down.
        :param pulumi.Input[_builtins.float] scale_down_utilization_threshold: Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        """
        if balance_similar_node_groups is not None:
            pulumi.set(__self__, "balance_similar_node_groups", balance_similar_node_groups)
        if disable_scale_down is not None:
            pulumi.set(__self__, "disable_scale_down", disable_scale_down)
        if estimator is not None:
            pulumi.set(__self__, "estimator", estimator)
        if expander is not None:
            pulumi.set(__self__, "expander", expander)
        if expendable_pods_priority_cutoff is not None:
            pulumi.set(__self__, "expendable_pods_priority_cutoff", expendable_pods_priority_cutoff)
        if ignore_daemonsets_utilization is not None:
            pulumi.set(__self__, "ignore_daemonsets_utilization", ignore_daemonsets_utilization)
        if max_graceful_termination_sec is not None:
            pulumi.set(__self__, "max_graceful_termination_sec", max_graceful_termination_sec)
        if scale_down_delay_after_add is not None:
            pulumi.set(__self__, "scale_down_delay_after_add", scale_down_delay_after_add)
        if scale_down_unneeded_time is not None:
            pulumi.set(__self__, "scale_down_unneeded_time", scale_down_unneeded_time)
        if scale_down_utilization_threshold is not None:
            pulumi.set(__self__, "scale_down_utilization_threshold", scale_down_utilization_threshold)

    @_builtins.property
    @pulumi.getter(name="balanceSimilarNodeGroups")
    def balance_similar_node_groups(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Detect similar node groups and balance the number of nodes between them.
        """
        return pulumi.get(self, "balance_similar_node_groups")

    @balance_similar_node_groups.setter
    def balance_similar_node_groups(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "balance_similar_node_groups", value)

    @_builtins.property
    @pulumi.getter(name="disableScaleDown")
    def disable_scale_down(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disables the scale down feature of the autoscaler.
        """
        return pulumi.get(self, "disable_scale_down")

    @disable_scale_down.setter
    def disable_scale_down(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_scale_down", value)

    @_builtins.property
    @pulumi.getter
    def estimator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of resource estimator to be used in scale up.
        """
        return pulumi.get(self, "estimator")

    @estimator.setter
    def estimator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "estimator", value)

    @_builtins.property
    @pulumi.getter
    def expander(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of node group expander to be used in scale up.
        """
        return pulumi.get(self, "expander")

    @expander.setter
    def expander(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expander", value)

    @_builtins.property
    @pulumi.getter(name="expendablePodsPriorityCutoff")
    def expendable_pods_priority_cutoff(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
        """
        return pulumi.get(self, "expendable_pods_priority_cutoff")

    @expendable_pods_priority_cutoff.setter
    def expendable_pods_priority_cutoff(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expendable_pods_priority_cutoff", value)

    @_builtins.property
    @pulumi.getter(name="ignoreDaemonsetsUtilization")
    def ignore_daemonsets_utilization(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Ignore DaemonSet pods when calculating resource utilization for scaling down.
        """
        return pulumi.get(self, "ignore_daemonsets_utilization")

    @ignore_daemonsets_utilization.setter
    def ignore_daemonsets_utilization(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_daemonsets_utilization", value)

    @_builtins.property
    @pulumi.getter(name="maxGracefulTerminationSec")
    def max_graceful_termination_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of seconds the cluster autoscaler waits for pod termination when trying to scale down a node
        """
        return pulumi.get(self, "max_graceful_termination_sec")

    @max_graceful_termination_sec.setter
    def max_graceful_termination_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_graceful_termination_sec", value)

    @_builtins.property
    @pulumi.getter(name="scaleDownDelayAfterAdd")
    def scale_down_delay_after_add(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How long after scale up that scale down evaluation resumes.
        """
        return pulumi.get(self, "scale_down_delay_after_add")

    @scale_down_delay_after_add.setter
    def scale_down_delay_after_add(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scale_down_delay_after_add", value)

    @_builtins.property
    @pulumi.getter(name="scaleDownUnneededTime")
    def scale_down_unneeded_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How long a node should be unneeded before it is eligible for scale down.
        """
        return pulumi.get(self, "scale_down_unneeded_time")

    @scale_down_unneeded_time.setter
    def scale_down_unneeded_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scale_down_unneeded_time", value)

    @_builtins.property
    @pulumi.getter(name="scaleDownUtilizationThreshold")
    def scale_down_utilization_threshold(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        """
        return pulumi.get(self, "scale_down_utilization_threshold")

    @scale_down_utilization_threshold.setter
    def scale_down_utilization_threshold(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "scale_down_utilization_threshold", value)


if not MYPY:
    class ClusterKubeconfigArgsDict(TypedDict):
        cluster_ca_certificate: NotRequired[pulumi.Input[_builtins.str]]
        """
        The CA certificate of the Kubernetes API server.
        """
        config_file: NotRequired[pulumi.Input[_builtins.str]]
        """
        The raw kubeconfig file.
        """
        host: NotRequired[pulumi.Input[_builtins.str]]
        """
        The URL of the Kubernetes API server.
        """
        token: NotRequired[pulumi.Input[_builtins.str]]
        """
        The token to connect to the Kubernetes API server.
        """
elif False:
    ClusterKubeconfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterKubeconfigArgs:
    def __init__(__self__, *,
                 cluster_ca_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 config_file: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] cluster_ca_certificate: The CA certificate of the Kubernetes API server.
        :param pulumi.Input[_builtins.str] config_file: The raw kubeconfig file.
        :param pulumi.Input[_builtins.str] host: The URL of the Kubernetes API server.
        :param pulumi.Input[_builtins.str] token: The token to connect to the Kubernetes API server.
        """
        if cluster_ca_certificate is not None:
            pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        if config_file is not None:
            pulumi.set(__self__, "config_file", config_file)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @_builtins.property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CA certificate of the Kubernetes API server.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @cluster_ca_certificate.setter
    def cluster_ca_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ca_certificate", value)

    @_builtins.property
    @pulumi.getter(name="configFile")
    def config_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The raw kubeconfig file.
        """
        return pulumi.get(self, "config_file")

    @config_file.setter
    def config_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_file", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the Kubernetes API server.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The token to connect to the Kubernetes API server.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)


if not MYPY:
    class ClusterOpenIdConnectConfigArgsDict(TypedDict):
        client_id: pulumi.Input[_builtins.str]
        """
        A client id that all tokens must be issued for
        """
        issuer_url: pulumi.Input[_builtins.str]
        """
        URL of the provider which allows the API server to discover public signing keys
        """
        groups_claims: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        JWT claim to use as the user's group
        """
        groups_prefix: NotRequired[pulumi.Input[_builtins.str]]
        """
        Prefix prepended to group claims
        """
        required_claims: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Multiple key=value pairs that describes a required claim in the ID Token
        """
        username_claim: NotRequired[pulumi.Input[_builtins.str]]
        """
        JWT claim to use as the user name
        """
        username_prefix: NotRequired[pulumi.Input[_builtins.str]]
        """
        Prefix prepended to username
        """
elif False:
    ClusterOpenIdConnectConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterOpenIdConnectConfigArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[_builtins.str],
                 issuer_url: pulumi.Input[_builtins.str],
                 groups_claims: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 groups_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 required_claims: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 username_claim: Optional[pulumi.Input[_builtins.str]] = None,
                 username_prefix: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] client_id: A client id that all tokens must be issued for
        :param pulumi.Input[_builtins.str] issuer_url: URL of the provider which allows the API server to discover public signing keys
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_claims: JWT claim to use as the user's group
        :param pulumi.Input[_builtins.str] groups_prefix: Prefix prepended to group claims
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] required_claims: Multiple key=value pairs that describes a required claim in the ID Token
        :param pulumi.Input[_builtins.str] username_claim: JWT claim to use as the user name
        :param pulumi.Input[_builtins.str] username_prefix: Prefix prepended to username
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "issuer_url", issuer_url)
        if groups_claims is not None:
            pulumi.set(__self__, "groups_claims", groups_claims)
        if groups_prefix is not None:
            pulumi.set(__self__, "groups_prefix", groups_prefix)
        if required_claims is not None:
            pulumi.set(__self__, "required_claims", required_claims)
        if username_claim is not None:
            pulumi.set(__self__, "username_claim", username_claim)
        if username_prefix is not None:
            pulumi.set(__self__, "username_prefix", username_prefix)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[_builtins.str]:
        """
        A client id that all tokens must be issued for
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> pulumi.Input[_builtins.str]:
        """
        URL of the provider which allows the API server to discover public signing keys
        """
        return pulumi.get(self, "issuer_url")

    @issuer_url.setter
    def issuer_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "issuer_url", value)

    @_builtins.property
    @pulumi.getter(name="groupsClaims")
    def groups_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        JWT claim to use as the user's group
        """
        return pulumi.get(self, "groups_claims")

    @groups_claims.setter
    def groups_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups_claims", value)

    @_builtins.property
    @pulumi.getter(name="groupsPrefix")
    def groups_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prefix prepended to group claims
        """
        return pulumi.get(self, "groups_prefix")

    @groups_prefix.setter
    def groups_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "groups_prefix", value)

    @_builtins.property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Multiple key=value pairs that describes a required claim in the ID Token
        """
        return pulumi.get(self, "required_claims")

    @required_claims.setter
    def required_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "required_claims", value)

    @_builtins.property
    @pulumi.getter(name="usernameClaim")
    def username_claim(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JWT claim to use as the user name
        """
        return pulumi.get(self, "username_claim")

    @username_claim.setter
    def username_claim(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username_claim", value)

    @_builtins.property
    @pulumi.getter(name="usernamePrefix")
    def username_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prefix prepended to username
        """
        return pulumi.get(self, "username_prefix")

    @username_prefix.setter
    def username_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username_prefix", value)


if not MYPY:
    class PoolNodeArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the IP address resource.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name for the pool.

        > **Important:** Updates to this field will recreate a new resource.
        """
        private_ips: NotRequired[pulumi.Input[Sequence[pulumi.Input['PoolNodePrivateIpArgsDict']]]]
        """
        The list of private IPv4 and IPv6 addresses associated with the node.
        """
        public_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        The public IPv4. (Deprecated, Please use the official Kubernetes provider and the kubernetes_nodes data source)
        """
        public_ip_v6: NotRequired[pulumi.Input[_builtins.str]]
        """
        The public IPv6. (Deprecated, Please use the official Kubernetes provider and the kubernetes_nodes data source)
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        The status of the node.
        """
elif False:
    PoolNodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolNodeArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['PoolNodePrivateIpArgs']]]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_v6: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] id: The ID of the IP address resource.
        :param pulumi.Input[_builtins.str] name: The name for the pool.
               
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['PoolNodePrivateIpArgs']]] private_ips: The list of private IPv4 and IPv6 addresses associated with the node.
        :param pulumi.Input[_builtins.str] public_ip: The public IPv4. (Deprecated, Please use the official Kubernetes provider and the kubernetes_nodes data source)
        :param pulumi.Input[_builtins.str] public_ip_v6: The public IPv6. (Deprecated, Please use the official Kubernetes provider and the kubernetes_nodes data source)
        :param pulumi.Input[_builtins.str] status: The status of the node.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if public_ip is not None:
            warnings.warn("""Please use the official Kubernetes provider and the kubernetes_nodes data source""", DeprecationWarning)
            pulumi.log.warn("""public_ip is deprecated: Please use the official Kubernetes provider and the kubernetes_nodes data source""")
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if public_ip_v6 is not None:
            warnings.warn("""Please use the official Kubernetes provider and the kubernetes_nodes data source""", DeprecationWarning)
            pulumi.log.warn("""public_ip_v6 is deprecated: Please use the official Kubernetes provider and the kubernetes_nodes data source""")
        if public_ip_v6 is not None:
            pulumi.set(__self__, "public_ip_v6", public_ip_v6)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the pool.

        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolNodePrivateIpArgs']]]]:
        """
        The list of private IPv4 and IPv6 addresses associated with the node.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolNodePrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    @_utilities.deprecated("""Please use the official Kubernetes provider and the kubernetes_nodes data source""")
    def public_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public IPv4. (Deprecated, Please use the official Kubernetes provider and the kubernetes_nodes data source)
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter(name="publicIpV6")
    @_utilities.deprecated("""Please use the official Kubernetes provider and the kubernetes_nodes data source""")
    def public_ip_v6(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public IPv6. (Deprecated, Please use the official Kubernetes provider and the kubernetes_nodes data source)
        """
        return pulumi.get(self, "public_ip_v6")

    @public_ip_v6.setter
    def public_ip_v6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_v6", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the node.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


if not MYPY:
    class PoolNodePrivateIpArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The private IP address.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the IP address resource.
        """
elif False:
    PoolNodePrivateIpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolNodePrivateIpArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] address: The private IP address.
        :param pulumi.Input[_builtins.str] id: The ID of the IP address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class PoolUpgradePolicyArgsDict(TypedDict):
        max_surge: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum number of nodes to be created during the upgrade
        """
        max_unavailable: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum number of nodes that can be not ready at the same time
        """
elif False:
    PoolUpgradePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolUpgradePolicyArgs:
    def __init__(__self__, *,
                 max_surge: Optional[pulumi.Input[_builtins.int]] = None,
                 max_unavailable: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] max_surge: The maximum number of nodes to be created during the upgrade
        :param pulumi.Input[_builtins.int] max_unavailable: The maximum number of nodes that can be not ready at the same time
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @_builtins.property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of nodes to be created during the upgrade
        """
        return pulumi.get(self, "max_surge")

    @max_surge.setter
    def max_surge(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_surge", value)

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of nodes that can be not ready at the same time
        """
        return pulumi.get(self, "max_unavailable")

    @max_unavailable.setter
    def max_unavailable(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_unavailable", value)


