# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AclAclRule',
    'ClusterAutoUpgrade',
    'ClusterAutoscalerConfig',
    'ClusterKubeconfig',
    'ClusterOpenIdConnectConfig',
    'PoolNode',
    'PoolNodePrivateIp',
    'PoolUpgradePolicy',
    'GetClusterAutoUpgradeResult',
    'GetClusterAutoscalerConfigResult',
    'GetClusterKubeconfigResult',
    'GetClusterOpenIdConnectConfigResult',
    'GetPoolNodeResult',
    'GetPoolNodePrivateIpResult',
    'GetPoolUpgradePolicyResult',
]

@pulumi.output_type
class AclAclRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scalewayRanges":
            suggest = "scaleway_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclAclRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclAclRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclAclRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 ip: Optional[_builtins.str] = None,
                 scaleway_ranges: Optional[_builtins.bool] = None):
        """
        :param _builtins.str description: A text describing this rule.
        :param _builtins.str id: The ID of the ACL resource. It is the same as the ID of the cluster.
        :param _builtins.str ip: The IP range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
               
               > **Important:** If the `ip` field is set, `scaleway_ranges` cannot be set to true in the same rule.
        :param _builtins.bool scaleway_ranges: Allow access to cluster from all Scaleway ranges as defined in [Scaleway Network Information - IP ranges used by Scaleway](https://www.scaleway.com/en/docs/console/account/reference-content/scaleway-network-information/#ip-ranges-used-by-scaleway).
               Only one rule with this field set to true can be added.
               
               > **Important:** If the `scaleway_ranges` field is set to true, the `ip` field cannot be set on the same rule.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if scaleway_ranges is not None:
            pulumi.set(__self__, "scaleway_ranges", scaleway_ranges)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        A text describing this rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the ACL resource. It is the same as the ID of the cluster.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        The IP range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)

        > **Important:** If the `ip` field is set, `scaleway_ranges` cannot be set to true in the same rule.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="scalewayRanges")
    def scaleway_ranges(self) -> Optional[_builtins.bool]:
        """
        Allow access to cluster from all Scaleway ranges as defined in [Scaleway Network Information - IP ranges used by Scaleway](https://www.scaleway.com/en/docs/console/account/reference-content/scaleway-network-information/#ip-ranges-used-by-scaleway).
        Only one rule with this field set to true can be added.

        > **Important:** If the `scaleway_ranges` field is set to true, the `ip` field cannot be set on the same rule.
        """
        return pulumi.get(self, "scaleway_ranges")


@pulumi.output_type
class ClusterAutoUpgrade(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maintenanceWindowDay":
            suggest = "maintenance_window_day"
        elif key == "maintenanceWindowStartHour":
            suggest = "maintenance_window_start_hour"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutoUpgrade. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutoUpgrade.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutoUpgrade.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: _builtins.bool,
                 maintenance_window_day: _builtins.str,
                 maintenance_window_start_hour: _builtins.int):
        """
        :param _builtins.bool enable: Set to `true` to enable Kubernetes patch version auto upgrades.
               > **Important:** When enabling auto upgrades, the `version` field take a minor version like x.y (ie 1.18).
        :param _builtins.str maintenance_window_day: The day of the auto upgrade maintenance window (`monday` to `sunday`, or `any`).
        :param _builtins.int maintenance_window_start_hour: The start hour (UTC) of the 2-hour auto upgrade maintenance window (0 to 23).
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "maintenance_window_day", maintenance_window_day)
        pulumi.set(__self__, "maintenance_window_start_hour", maintenance_window_start_hour)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> _builtins.bool:
        """
        Set to `true` to enable Kubernetes patch version auto upgrades.
        > **Important:** When enabling auto upgrades, the `version` field take a minor version like x.y (ie 1.18).
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowDay")
    def maintenance_window_day(self) -> _builtins.str:
        """
        The day of the auto upgrade maintenance window (`monday` to `sunday`, or `any`).
        """
        return pulumi.get(self, "maintenance_window_day")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowStartHour")
    def maintenance_window_start_hour(self) -> _builtins.int:
        """
        The start hour (UTC) of the 2-hour auto upgrade maintenance window (0 to 23).
        """
        return pulumi.get(self, "maintenance_window_start_hour")


@pulumi.output_type
class ClusterAutoscalerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "balanceSimilarNodeGroups":
            suggest = "balance_similar_node_groups"
        elif key == "disableScaleDown":
            suggest = "disable_scale_down"
        elif key == "expendablePodsPriorityCutoff":
            suggest = "expendable_pods_priority_cutoff"
        elif key == "ignoreDaemonsetsUtilization":
            suggest = "ignore_daemonsets_utilization"
        elif key == "maxGracefulTerminationSec":
            suggest = "max_graceful_termination_sec"
        elif key == "scaleDownDelayAfterAdd":
            suggest = "scale_down_delay_after_add"
        elif key == "scaleDownUnneededTime":
            suggest = "scale_down_unneeded_time"
        elif key == "scaleDownUtilizationThreshold":
            suggest = "scale_down_utilization_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutoscalerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutoscalerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutoscalerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 balance_similar_node_groups: Optional[_builtins.bool] = None,
                 disable_scale_down: Optional[_builtins.bool] = None,
                 estimator: Optional[_builtins.str] = None,
                 expander: Optional[_builtins.str] = None,
                 expendable_pods_priority_cutoff: Optional[_builtins.int] = None,
                 ignore_daemonsets_utilization: Optional[_builtins.bool] = None,
                 max_graceful_termination_sec: Optional[_builtins.int] = None,
                 scale_down_delay_after_add: Optional[_builtins.str] = None,
                 scale_down_unneeded_time: Optional[_builtins.str] = None,
                 scale_down_utilization_threshold: Optional[_builtins.float] = None):
        """
        :param _builtins.bool balance_similar_node_groups: Detect similar node groups and balance the number of nodes between them.
        :param _builtins.bool disable_scale_down: Disables the scale down feature of the autoscaler.
        :param _builtins.str estimator: Type of resource estimator to be used in scale up.
        :param _builtins.str expander: Type of node group expander to be used in scale up.
        :param _builtins.int expendable_pods_priority_cutoff: Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
        :param _builtins.bool ignore_daemonsets_utilization: Ignore DaemonSet pods when calculating resource utilization for scaling down.
        :param _builtins.int max_graceful_termination_sec: Maximum number of seconds the cluster autoscaler waits for pod termination when trying to scale down a node
        :param _builtins.str scale_down_delay_after_add: How long after scale up that scale down evaluation resumes.
        :param _builtins.str scale_down_unneeded_time: How long a node should be unneeded before it is eligible for scale down.
        :param _builtins.float scale_down_utilization_threshold: Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        """
        if balance_similar_node_groups is not None:
            pulumi.set(__self__, "balance_similar_node_groups", balance_similar_node_groups)
        if disable_scale_down is not None:
            pulumi.set(__self__, "disable_scale_down", disable_scale_down)
        if estimator is not None:
            pulumi.set(__self__, "estimator", estimator)
        if expander is not None:
            pulumi.set(__self__, "expander", expander)
        if expendable_pods_priority_cutoff is not None:
            pulumi.set(__self__, "expendable_pods_priority_cutoff", expendable_pods_priority_cutoff)
        if ignore_daemonsets_utilization is not None:
            pulumi.set(__self__, "ignore_daemonsets_utilization", ignore_daemonsets_utilization)
        if max_graceful_termination_sec is not None:
            pulumi.set(__self__, "max_graceful_termination_sec", max_graceful_termination_sec)
        if scale_down_delay_after_add is not None:
            pulumi.set(__self__, "scale_down_delay_after_add", scale_down_delay_after_add)
        if scale_down_unneeded_time is not None:
            pulumi.set(__self__, "scale_down_unneeded_time", scale_down_unneeded_time)
        if scale_down_utilization_threshold is not None:
            pulumi.set(__self__, "scale_down_utilization_threshold", scale_down_utilization_threshold)

    @_builtins.property
    @pulumi.getter(name="balanceSimilarNodeGroups")
    def balance_similar_node_groups(self) -> Optional[_builtins.bool]:
        """
        Detect similar node groups and balance the number of nodes between them.
        """
        return pulumi.get(self, "balance_similar_node_groups")

    @_builtins.property
    @pulumi.getter(name="disableScaleDown")
    def disable_scale_down(self) -> Optional[_builtins.bool]:
        """
        Disables the scale down feature of the autoscaler.
        """
        return pulumi.get(self, "disable_scale_down")

    @_builtins.property
    @pulumi.getter
    def estimator(self) -> Optional[_builtins.str]:
        """
        Type of resource estimator to be used in scale up.
        """
        return pulumi.get(self, "estimator")

    @_builtins.property
    @pulumi.getter
    def expander(self) -> Optional[_builtins.str]:
        """
        Type of node group expander to be used in scale up.
        """
        return pulumi.get(self, "expander")

    @_builtins.property
    @pulumi.getter(name="expendablePodsPriorityCutoff")
    def expendable_pods_priority_cutoff(self) -> Optional[_builtins.int]:
        """
        Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
        """
        return pulumi.get(self, "expendable_pods_priority_cutoff")

    @_builtins.property
    @pulumi.getter(name="ignoreDaemonsetsUtilization")
    def ignore_daemonsets_utilization(self) -> Optional[_builtins.bool]:
        """
        Ignore DaemonSet pods when calculating resource utilization for scaling down.
        """
        return pulumi.get(self, "ignore_daemonsets_utilization")

    @_builtins.property
    @pulumi.getter(name="maxGracefulTerminationSec")
    def max_graceful_termination_sec(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds the cluster autoscaler waits for pod termination when trying to scale down a node
        """
        return pulumi.get(self, "max_graceful_termination_sec")

    @_builtins.property
    @pulumi.getter(name="scaleDownDelayAfterAdd")
    def scale_down_delay_after_add(self) -> Optional[_builtins.str]:
        """
        How long after scale up that scale down evaluation resumes.
        """
        return pulumi.get(self, "scale_down_delay_after_add")

    @_builtins.property
    @pulumi.getter(name="scaleDownUnneededTime")
    def scale_down_unneeded_time(self) -> Optional[_builtins.str]:
        """
        How long a node should be unneeded before it is eligible for scale down.
        """
        return pulumi.get(self, "scale_down_unneeded_time")

    @_builtins.property
    @pulumi.getter(name="scaleDownUtilizationThreshold")
    def scale_down_utilization_threshold(self) -> Optional[_builtins.float]:
        """
        Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        """
        return pulumi.get(self, "scale_down_utilization_threshold")


@pulumi.output_type
class ClusterKubeconfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterCaCertificate":
            suggest = "cluster_ca_certificate"
        elif key == "configFile":
            suggest = "config_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterKubeconfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterKubeconfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterKubeconfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_ca_certificate: Optional[_builtins.str] = None,
                 config_file: Optional[_builtins.str] = None,
                 host: Optional[_builtins.str] = None,
                 token: Optional[_builtins.str] = None):
        """
        :param _builtins.str cluster_ca_certificate: The CA certificate of the Kubernetes API server.
        :param _builtins.str config_file: The raw kubeconfig file.
        :param _builtins.str host: The URL of the Kubernetes API server.
        :param _builtins.str token: The token to connect to the Kubernetes API server.
        """
        if cluster_ca_certificate is not None:
            pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        if config_file is not None:
            pulumi.set(__self__, "config_file", config_file)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @_builtins.property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> Optional[_builtins.str]:
        """
        The CA certificate of the Kubernetes API server.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @_builtins.property
    @pulumi.getter(name="configFile")
    def config_file(self) -> Optional[_builtins.str]:
        """
        The raw kubeconfig file.
        """
        return pulumi.get(self, "config_file")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        The URL of the Kubernetes API server.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[_builtins.str]:
        """
        The token to connect to the Kubernetes API server.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class ClusterOpenIdConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "issuerUrl":
            suggest = "issuer_url"
        elif key == "groupsClaims":
            suggest = "groups_claims"
        elif key == "groupsPrefix":
            suggest = "groups_prefix"
        elif key == "requiredClaims":
            suggest = "required_claims"
        elif key == "usernameClaim":
            suggest = "username_claim"
        elif key == "usernamePrefix":
            suggest = "username_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOpenIdConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOpenIdConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOpenIdConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: _builtins.str,
                 issuer_url: _builtins.str,
                 groups_claims: Optional[Sequence[_builtins.str]] = None,
                 groups_prefix: Optional[_builtins.str] = None,
                 required_claims: Optional[Sequence[_builtins.str]] = None,
                 username_claim: Optional[_builtins.str] = None,
                 username_prefix: Optional[_builtins.str] = None):
        """
        :param _builtins.str client_id: A client id that all tokens must be issued for
        :param _builtins.str issuer_url: URL of the provider which allows the API server to discover public signing keys
        :param Sequence[_builtins.str] groups_claims: JWT claim to use as the user's group
        :param _builtins.str groups_prefix: Prefix prepended to group claims
        :param Sequence[_builtins.str] required_claims: Multiple key=value pairs that describes a required claim in the ID Token
        :param _builtins.str username_claim: JWT claim to use as the user name
        :param _builtins.str username_prefix: Prefix prepended to username
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "issuer_url", issuer_url)
        if groups_claims is not None:
            pulumi.set(__self__, "groups_claims", groups_claims)
        if groups_prefix is not None:
            pulumi.set(__self__, "groups_prefix", groups_prefix)
        if required_claims is not None:
            pulumi.set(__self__, "required_claims", required_claims)
        if username_claim is not None:
            pulumi.set(__self__, "username_claim", username_claim)
        if username_prefix is not None:
            pulumi.set(__self__, "username_prefix", username_prefix)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        A client id that all tokens must be issued for
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> _builtins.str:
        """
        URL of the provider which allows the API server to discover public signing keys
        """
        return pulumi.get(self, "issuer_url")

    @_builtins.property
    @pulumi.getter(name="groupsClaims")
    def groups_claims(self) -> Optional[Sequence[_builtins.str]]:
        """
        JWT claim to use as the user's group
        """
        return pulumi.get(self, "groups_claims")

    @_builtins.property
    @pulumi.getter(name="groupsPrefix")
    def groups_prefix(self) -> Optional[_builtins.str]:
        """
        Prefix prepended to group claims
        """
        return pulumi.get(self, "groups_prefix")

    @_builtins.property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Optional[Sequence[_builtins.str]]:
        """
        Multiple key=value pairs that describes a required claim in the ID Token
        """
        return pulumi.get(self, "required_claims")

    @_builtins.property
    @pulumi.getter(name="usernameClaim")
    def username_claim(self) -> Optional[_builtins.str]:
        """
        JWT claim to use as the user name
        """
        return pulumi.get(self, "username_claim")

    @_builtins.property
    @pulumi.getter(name="usernamePrefix")
    def username_prefix(self) -> Optional[_builtins.str]:
        """
        Prefix prepended to username
        """
        return pulumi.get(self, "username_prefix")


@pulumi.output_type
class PoolNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIps":
            suggest = "private_ips"
        elif key == "publicIp":
            suggest = "public_ip"
        elif key == "publicIpV6":
            suggest = "public_ip_v6"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 private_ips: Optional[Sequence['outputs.PoolNodePrivateIp']] = None,
                 public_ip: Optional[_builtins.str] = None,
                 public_ip_v6: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The ID of the IP address resource.
        :param _builtins.str name: The name for the pool.
               
               > **Important:** Updates to this field will recreate a new resource.
        :param Sequence['PoolNodePrivateIpArgs'] private_ips: The list of private IPv4 and IPv6 addresses associated with the node.
        :param _builtins.str public_ip: The public IPv4. (Deprecated, Please use the official Kubernetes provider and the kubernetes_nodes data source)
        :param _builtins.str public_ip_v6: The public IPv6. (Deprecated, Please use the official Kubernetes provider and the kubernetes_nodes data source)
        :param _builtins.str status: The status of the node.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if public_ip_v6 is not None:
            pulumi.set(__self__, "public_ip_v6", public_ip_v6)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name for the pool.

        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[Sequence['outputs.PoolNodePrivateIp']]:
        """
        The list of private IPv4 and IPv6 addresses associated with the node.
        """
        return pulumi.get(self, "private_ips")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    @_utilities.deprecated("""Please use the official Kubernetes provider and the kubernetes_nodes data source""")
    def public_ip(self) -> Optional[_builtins.str]:
        """
        The public IPv4. (Deprecated, Please use the official Kubernetes provider and the kubernetes_nodes data source)
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter(name="publicIpV6")
    @_utilities.deprecated("""Please use the official Kubernetes provider and the kubernetes_nodes data source""")
    def public_ip_v6(self) -> Optional[_builtins.str]:
        """
        The public IPv6. (Deprecated, Please use the official Kubernetes provider and the kubernetes_nodes data source)
        """
        return pulumi.get(self, "public_ip_v6")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the node.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PoolNodePrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The private IP address.
        :param _builtins.str id: The ID of the IP address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PoolUpgradePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSurge":
            suggest = "max_surge"
        elif key == "maxUnavailable":
            suggest = "max_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolUpgradePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolUpgradePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolUpgradePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_surge: Optional[_builtins.int] = None,
                 max_unavailable: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_surge: The maximum number of nodes to be created during the upgrade
        :param _builtins.int max_unavailable: The maximum number of nodes that can be not ready at the same time
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @_builtins.property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[_builtins.int]:
        """
        The maximum number of nodes to be created during the upgrade
        """
        return pulumi.get(self, "max_surge")

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[_builtins.int]:
        """
        The maximum number of nodes that can be not ready at the same time
        """
        return pulumi.get(self, "max_unavailable")


@pulumi.output_type
class GetClusterAutoUpgradeResult(dict):
    def __init__(__self__, *,
                 enable: _builtins.bool,
                 maintenance_window_day: _builtins.str,
                 maintenance_window_start_hour: _builtins.int):
        """
        :param _builtins.bool enable: True if Kubernetes patch version auto upgrades is enabled.
        :param _builtins.str maintenance_window_day: The day of the auto upgrade maintenance window (`monday` to `sunday`, or `any`).
        :param _builtins.int maintenance_window_start_hour: The start hour (UTC) of the 2-hour auto upgrade maintenance window (0 to 23).
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "maintenance_window_day", maintenance_window_day)
        pulumi.set(__self__, "maintenance_window_start_hour", maintenance_window_start_hour)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> _builtins.bool:
        """
        True if Kubernetes patch version auto upgrades is enabled.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowDay")
    def maintenance_window_day(self) -> _builtins.str:
        """
        The day of the auto upgrade maintenance window (`monday` to `sunday`, or `any`).
        """
        return pulumi.get(self, "maintenance_window_day")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowStartHour")
    def maintenance_window_start_hour(self) -> _builtins.int:
        """
        The start hour (UTC) of the 2-hour auto upgrade maintenance window (0 to 23).
        """
        return pulumi.get(self, "maintenance_window_start_hour")


@pulumi.output_type
class GetClusterAutoscalerConfigResult(dict):
    def __init__(__self__, *,
                 balance_similar_node_groups: _builtins.bool,
                 disable_scale_down: _builtins.bool,
                 estimator: _builtins.str,
                 expander: _builtins.str,
                 expendable_pods_priority_cutoff: _builtins.int,
                 ignore_daemonsets_utilization: _builtins.bool,
                 max_graceful_termination_sec: _builtins.int,
                 scale_down_delay_after_add: _builtins.str,
                 scale_down_unneeded_time: _builtins.str,
                 scale_down_utilization_threshold: _builtins.float):
        """
        :param _builtins.bool balance_similar_node_groups: True if detecting similar node groups and balance the number of nodes between them is enabled.
        :param _builtins.bool disable_scale_down: True if the scale down feature of the autoscaler is disabled.
        :param _builtins.str estimator: The type of resource estimator used in scale up.
        :param _builtins.str expander: The type of node group expander be used in scale up.
        :param _builtins.int expendable_pods_priority_cutoff: Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
        :param _builtins.bool ignore_daemonsets_utilization: True if ignoring DaemonSet pods when calculating resource utilization for scaling down is enabled.
        :param _builtins.int max_graceful_termination_sec: Maximum number of seconds the cluster autoscaler waits for pod termination when trying to scale down a node
        :param _builtins.str scale_down_delay_after_add: The duration after scale up that scale down evaluation resumes.
        :param _builtins.str scale_down_unneeded_time: The duration a node should be unneeded before it is eligible for scale down.
        :param _builtins.float scale_down_utilization_threshold: Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        """
        pulumi.set(__self__, "balance_similar_node_groups", balance_similar_node_groups)
        pulumi.set(__self__, "disable_scale_down", disable_scale_down)
        pulumi.set(__self__, "estimator", estimator)
        pulumi.set(__self__, "expander", expander)
        pulumi.set(__self__, "expendable_pods_priority_cutoff", expendable_pods_priority_cutoff)
        pulumi.set(__self__, "ignore_daemonsets_utilization", ignore_daemonsets_utilization)
        pulumi.set(__self__, "max_graceful_termination_sec", max_graceful_termination_sec)
        pulumi.set(__self__, "scale_down_delay_after_add", scale_down_delay_after_add)
        pulumi.set(__self__, "scale_down_unneeded_time", scale_down_unneeded_time)
        pulumi.set(__self__, "scale_down_utilization_threshold", scale_down_utilization_threshold)

    @_builtins.property
    @pulumi.getter(name="balanceSimilarNodeGroups")
    def balance_similar_node_groups(self) -> _builtins.bool:
        """
        True if detecting similar node groups and balance the number of nodes between them is enabled.
        """
        return pulumi.get(self, "balance_similar_node_groups")

    @_builtins.property
    @pulumi.getter(name="disableScaleDown")
    def disable_scale_down(self) -> _builtins.bool:
        """
        True if the scale down feature of the autoscaler is disabled.
        """
        return pulumi.get(self, "disable_scale_down")

    @_builtins.property
    @pulumi.getter
    def estimator(self) -> _builtins.str:
        """
        The type of resource estimator used in scale up.
        """
        return pulumi.get(self, "estimator")

    @_builtins.property
    @pulumi.getter
    def expander(self) -> _builtins.str:
        """
        The type of node group expander be used in scale up.
        """
        return pulumi.get(self, "expander")

    @_builtins.property
    @pulumi.getter(name="expendablePodsPriorityCutoff")
    def expendable_pods_priority_cutoff(self) -> _builtins.int:
        """
        Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
        """
        return pulumi.get(self, "expendable_pods_priority_cutoff")

    @_builtins.property
    @pulumi.getter(name="ignoreDaemonsetsUtilization")
    def ignore_daemonsets_utilization(self) -> _builtins.bool:
        """
        True if ignoring DaemonSet pods when calculating resource utilization for scaling down is enabled.
        """
        return pulumi.get(self, "ignore_daemonsets_utilization")

    @_builtins.property
    @pulumi.getter(name="maxGracefulTerminationSec")
    def max_graceful_termination_sec(self) -> _builtins.int:
        """
        Maximum number of seconds the cluster autoscaler waits for pod termination when trying to scale down a node
        """
        return pulumi.get(self, "max_graceful_termination_sec")

    @_builtins.property
    @pulumi.getter(name="scaleDownDelayAfterAdd")
    def scale_down_delay_after_add(self) -> _builtins.str:
        """
        The duration after scale up that scale down evaluation resumes.
        """
        return pulumi.get(self, "scale_down_delay_after_add")

    @_builtins.property
    @pulumi.getter(name="scaleDownUnneededTime")
    def scale_down_unneeded_time(self) -> _builtins.str:
        """
        The duration a node should be unneeded before it is eligible for scale down.
        """
        return pulumi.get(self, "scale_down_unneeded_time")

    @_builtins.property
    @pulumi.getter(name="scaleDownUtilizationThreshold")
    def scale_down_utilization_threshold(self) -> _builtins.float:
        """
        Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        """
        return pulumi.get(self, "scale_down_utilization_threshold")


@pulumi.output_type
class GetClusterKubeconfigResult(dict):
    def __init__(__self__, *,
                 cluster_ca_certificate: _builtins.str,
                 config_file: _builtins.str,
                 host: _builtins.str,
                 token: _builtins.str):
        """
        :param _builtins.str cluster_ca_certificate: The CA certificate of the Kubernetes API server.
        :param _builtins.str config_file: The raw kubeconfig file.
        :param _builtins.str host: The URL of the Kubernetes API server.
        :param _builtins.str token: The token to connect to the Kubernetes API server.
        """
        pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        pulumi.set(__self__, "config_file", config_file)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "token", token)

    @_builtins.property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> _builtins.str:
        """
        The CA certificate of the Kubernetes API server.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @_builtins.property
    @pulumi.getter(name="configFile")
    def config_file(self) -> _builtins.str:
        """
        The raw kubeconfig file.
        """
        return pulumi.get(self, "config_file")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The URL of the Kubernetes API server.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The token to connect to the Kubernetes API server.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class GetClusterOpenIdConnectConfigResult(dict):
    def __init__(__self__, *,
                 client_id: _builtins.str,
                 groups_claims: Sequence[_builtins.str],
                 groups_prefix: _builtins.str,
                 issuer_url: _builtins.str,
                 required_claims: Sequence[_builtins.str],
                 username_claim: _builtins.str,
                 username_prefix: _builtins.str):
        """
        :param _builtins.str client_id: A client id that all tokens must be issued for
        :param Sequence[_builtins.str] groups_claims: JWT claim to use as the user's group
        :param _builtins.str groups_prefix: Prefix prepended to group claims
        :param _builtins.str issuer_url: URL of the provider which allows the API server to discover public signing keys
        :param Sequence[_builtins.str] required_claims: Multiple key=value pairs that describes a required claim in the ID Token
        :param _builtins.str username_claim: JWT claim to use as the user name
        :param _builtins.str username_prefix: Prefix prepended to username
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "groups_claims", groups_claims)
        pulumi.set(__self__, "groups_prefix", groups_prefix)
        pulumi.set(__self__, "issuer_url", issuer_url)
        pulumi.set(__self__, "required_claims", required_claims)
        pulumi.set(__self__, "username_claim", username_claim)
        pulumi.set(__self__, "username_prefix", username_prefix)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        A client id that all tokens must be issued for
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="groupsClaims")
    def groups_claims(self) -> Sequence[_builtins.str]:
        """
        JWT claim to use as the user's group
        """
        return pulumi.get(self, "groups_claims")

    @_builtins.property
    @pulumi.getter(name="groupsPrefix")
    def groups_prefix(self) -> _builtins.str:
        """
        Prefix prepended to group claims
        """
        return pulumi.get(self, "groups_prefix")

    @_builtins.property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> _builtins.str:
        """
        URL of the provider which allows the API server to discover public signing keys
        """
        return pulumi.get(self, "issuer_url")

    @_builtins.property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Sequence[_builtins.str]:
        """
        Multiple key=value pairs that describes a required claim in the ID Token
        """
        return pulumi.get(self, "required_claims")

    @_builtins.property
    @pulumi.getter(name="usernameClaim")
    def username_claim(self) -> _builtins.str:
        """
        JWT claim to use as the user name
        """
        return pulumi.get(self, "username_claim")

    @_builtins.property
    @pulumi.getter(name="usernamePrefix")
    def username_prefix(self) -> _builtins.str:
        """
        Prefix prepended to username
        """
        return pulumi.get(self, "username_prefix")


@pulumi.output_type
class GetPoolNodeResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str,
                 private_ips: Sequence['outputs.GetPoolNodePrivateIpResult'],
                 public_ip: _builtins.str,
                 public_ip_v6: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str id: The ID of the pool.
        :param _builtins.str name: The pool name. Only one of `name` and `pool_id` should be specified. `cluster_id` should be specified with `name`.
        :param Sequence['GetPoolNodePrivateIpArgs'] private_ips: List of private IPv4 and IPv6 addresses associated with the node
        :param _builtins.str public_ip: The public IPv4.
        :param _builtins.str public_ip_v6: The public IPv6.
        :param _builtins.str status: The status of the node.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ips", private_ips)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "public_ip_v6", public_ip_v6)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the pool.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The pool name. Only one of `name` and `pool_id` should be specified. `cluster_id` should be specified with `name`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Sequence['outputs.GetPoolNodePrivateIpResult']:
        """
        List of private IPv4 and IPv6 addresses associated with the node
        """
        return pulumi.get(self, "private_ips")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> _builtins.str:
        """
        The public IPv4.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter(name="publicIpV6")
    def public_ip_v6(self) -> _builtins.str:
        """
        The public IPv6.
        """
        return pulumi.get(self, "public_ip_v6")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the node.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetPoolNodePrivateIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The private IP address
        :param _builtins.str id: The ID of the pool.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The private IP address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the pool.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetPoolUpgradePolicyResult(dict):
    def __init__(__self__, *,
                 max_surge: _builtins.int,
                 max_unavailable: _builtins.int):
        """
        :param _builtins.int max_surge: The maximum number of nodes to be created during the upgrade
        :param _builtins.int max_unavailable: The maximum number of nodes that can be not ready at the same time
        """
        pulumi.set(__self__, "max_surge", max_surge)
        pulumi.set(__self__, "max_unavailable", max_unavailable)

    @_builtins.property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> _builtins.int:
        """
        The maximum number of nodes to be created during the upgrade
        """
        return pulumi.get(self, "max_surge")

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> _builtins.int:
        """
        The maximum number of nodes that can be not ready at the same time
        """
        return pulumi.get(self, "max_unavailable")


