# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadbalancerAclArgs', 'LoadbalancerAcl']

@pulumi.input_type
class LoadbalancerAclArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['LoadbalancerAclActionArgs'],
                 frontend_id: pulumi.Input[_builtins.str],
                 index: pulumi.Input[_builtins.int],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 match: Optional[pulumi.Input['LoadbalancerAclMatchArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LoadbalancerAcl resource.
        :param pulumi.Input['LoadbalancerAclActionArgs'] action: Action to undertake when an ACL filter matches.
        :param pulumi.Input[_builtins.str] frontend_id: The ID of the Load Balancer frontend to attach the ACL to.
        :param pulumi.Input[_builtins.int] index: The priority of this ACL (ACLs are applied in ascending order, 0 is the first ACL executed).
        :param pulumi.Input[_builtins.str] description: The ACL description.
        :param pulumi.Input['LoadbalancerAclMatchArgs'] match: The ACL match rule. At least `ip_subnet` or `ips_edge_services` or `http_filter` and `http_filter_value` are required.
        :param pulumi.Input[_builtins.str] name: The ACL name. If not provided it will be randomly generated.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "frontend_id", frontend_id)
        pulumi.set(__self__, "index", index)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input['LoadbalancerAclActionArgs']:
        """
        Action to undertake when an ACL filter matches.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['LoadbalancerAclActionArgs']):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Load Balancer frontend to attach the ACL to.
        """
        return pulumi.get(self, "frontend_id")

    @frontend_id.setter
    def frontend_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "frontend_id", value)

    @_builtins.property
    @pulumi.getter
    def index(self) -> pulumi.Input[_builtins.int]:
        """
        The priority of this ACL (ACLs are applied in ascending order, 0 is the first ACL executed).
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "index", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ACL description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input['LoadbalancerAclMatchArgs']]:
        """
        The ACL match rule. At least `ip_subnet` or `ips_edge_services` or `http_filter` and `http_filter_value` are required.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input['LoadbalancerAclMatchArgs']]):
        pulumi.set(self, "match", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ACL name. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _LoadbalancerAclState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['LoadbalancerAclActionArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 frontend_id: Optional[pulumi.Input[_builtins.str]] = None,
                 index: Optional[pulumi.Input[_builtins.int]] = None,
                 match: Optional[pulumi.Input['LoadbalancerAclMatchArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LoadbalancerAcl resources.
        :param pulumi.Input['LoadbalancerAclActionArgs'] action: Action to undertake when an ACL filter matches.
        :param pulumi.Input[_builtins.str] created_at: IsDate and time of ACL's creation (RFC 3339 format)
        :param pulumi.Input[_builtins.str] description: The ACL description.
        :param pulumi.Input[_builtins.str] frontend_id: The ID of the Load Balancer frontend to attach the ACL to.
        :param pulumi.Input[_builtins.int] index: The priority of this ACL (ACLs are applied in ascending order, 0 is the first ACL executed).
        :param pulumi.Input['LoadbalancerAclMatchArgs'] match: The ACL match rule. At least `ip_subnet` or `ips_edge_services` or `http_filter` and `http_filter_value` are required.
        :param pulumi.Input[_builtins.str] name: The ACL name. If not provided it will be randomly generated.
        :param pulumi.Input[_builtins.str] updated_at: IsDate and time of ACL's update (RFC 3339 format)
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if frontend_id is not None:
            pulumi.set(__self__, "frontend_id", frontend_id)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['LoadbalancerAclActionArgs']]:
        """
        Action to undertake when an ACL filter matches.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['LoadbalancerAclActionArgs']]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IsDate and time of ACL's creation (RFC 3339 format)
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ACL description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Load Balancer frontend to attach the ACL to.
        """
        return pulumi.get(self, "frontend_id")

    @frontend_id.setter
    def frontend_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "frontend_id", value)

    @_builtins.property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The priority of this ACL (ACLs are applied in ascending order, 0 is the first ACL executed).
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "index", value)

    @_builtins.property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input['LoadbalancerAclMatchArgs']]:
        """
        The ACL match rule. At least `ip_subnet` or `ips_edge_services` or `http_filter` and `http_filter_value` are required.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input['LoadbalancerAclMatchArgs']]):
        pulumi.set(self, "match", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ACL name. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IsDate and time of ACL's update (RFC 3339 format)
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


warnings.warn("""scaleway.index/loadbalanceracl.LoadbalancerAcl has been deprecated in favor of scaleway.loadbalancers/acl.Acl""", DeprecationWarning)


@pulumi.type_token("scaleway:index/loadbalancerAcl:LoadbalancerAcl")
class LoadbalancerAcl(pulumi.CustomResource):
    warnings.warn("""scaleway.index/loadbalanceracl.LoadbalancerAcl has been deprecated in favor of scaleway.loadbalancers/acl.Acl""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['LoadbalancerAclActionArgs', 'LoadbalancerAclActionArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 frontend_id: Optional[pulumi.Input[_builtins.str]] = None,
                 index: Optional[pulumi.Input[_builtins.int]] = None,
                 match: Optional[pulumi.Input[Union['LoadbalancerAclMatchArgs', 'LoadbalancerAclMatchArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Load Balancer ACLs.

        For more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/reference-content/acls/) or [API documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-acls-get-an-acl).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        acl01 = scaleway.loadbalancers.Acl("acl01",
            frontend_id=frt01["id"],
            name="acl01",
            description="Exclude well-known IPs",
            index=0,
            action={
                "type": "allow",
            },
            match={
                "ip_subnets": [
                    "192.168.0.1",
                    "192.168.0.2",
                    "192.168.10.0/24",
                ],
            })
        ```

        ## Import

        Load Balancer ACLs can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/loadbalancerAcl:LoadbalancerAcl acl01 fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LoadbalancerAclActionArgs', 'LoadbalancerAclActionArgsDict']] action: Action to undertake when an ACL filter matches.
        :param pulumi.Input[_builtins.str] description: The ACL description.
        :param pulumi.Input[_builtins.str] frontend_id: The ID of the Load Balancer frontend to attach the ACL to.
        :param pulumi.Input[_builtins.int] index: The priority of this ACL (ACLs are applied in ascending order, 0 is the first ACL executed).
        :param pulumi.Input[Union['LoadbalancerAclMatchArgs', 'LoadbalancerAclMatchArgsDict']] match: The ACL match rule. At least `ip_subnet` or `ips_edge_services` or `http_filter` and `http_filter_value` are required.
        :param pulumi.Input[_builtins.str] name: The ACL name. If not provided it will be randomly generated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadbalancerAclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Load Balancer ACLs.

        For more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/reference-content/acls/) or [API documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-acls-get-an-acl).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        acl01 = scaleway.loadbalancers.Acl("acl01",
            frontend_id=frt01["id"],
            name="acl01",
            description="Exclude well-known IPs",
            index=0,
            action={
                "type": "allow",
            },
            match={
                "ip_subnets": [
                    "192.168.0.1",
                    "192.168.0.2",
                    "192.168.10.0/24",
                ],
            })
        ```

        ## Import

        Load Balancer ACLs can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/loadbalancerAcl:LoadbalancerAcl acl01 fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param LoadbalancerAclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadbalancerAclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['LoadbalancerAclActionArgs', 'LoadbalancerAclActionArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 frontend_id: Optional[pulumi.Input[_builtins.str]] = None,
                 index: Optional[pulumi.Input[_builtins.int]] = None,
                 match: Optional[pulumi.Input[Union['LoadbalancerAclMatchArgs', 'LoadbalancerAclMatchArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""LoadbalancerAcl is deprecated: scaleway.index/loadbalanceracl.LoadbalancerAcl has been deprecated in favor of scaleway.loadbalancers/acl.Acl""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadbalancerAclArgs.__new__(LoadbalancerAclArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["description"] = description
            if frontend_id is None and not opts.urn:
                raise TypeError("Missing required property 'frontend_id'")
            __props__.__dict__["frontend_id"] = frontend_id
            if index is None and not opts.urn:
                raise TypeError("Missing required property 'index'")
            __props__.__dict__["index"] = index
            __props__.__dict__["match"] = match
            __props__.__dict__["name"] = name
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        super(LoadbalancerAcl, __self__).__init__(
            'scaleway:index/loadbalancerAcl:LoadbalancerAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[Union['LoadbalancerAclActionArgs', 'LoadbalancerAclActionArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            frontend_id: Optional[pulumi.Input[_builtins.str]] = None,
            index: Optional[pulumi.Input[_builtins.int]] = None,
            match: Optional[pulumi.Input[Union['LoadbalancerAclMatchArgs', 'LoadbalancerAclMatchArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'LoadbalancerAcl':
        """
        Get an existing LoadbalancerAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LoadbalancerAclActionArgs', 'LoadbalancerAclActionArgsDict']] action: Action to undertake when an ACL filter matches.
        :param pulumi.Input[_builtins.str] created_at: IsDate and time of ACL's creation (RFC 3339 format)
        :param pulumi.Input[_builtins.str] description: The ACL description.
        :param pulumi.Input[_builtins.str] frontend_id: The ID of the Load Balancer frontend to attach the ACL to.
        :param pulumi.Input[_builtins.int] index: The priority of this ACL (ACLs are applied in ascending order, 0 is the first ACL executed).
        :param pulumi.Input[Union['LoadbalancerAclMatchArgs', 'LoadbalancerAclMatchArgsDict']] match: The ACL match rule. At least `ip_subnet` or `ips_edge_services` or `http_filter` and `http_filter_value` are required.
        :param pulumi.Input[_builtins.str] name: The ACL name. If not provided it will be randomly generated.
        :param pulumi.Input[_builtins.str] updated_at: IsDate and time of ACL's update (RFC 3339 format)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadbalancerAclState.__new__(_LoadbalancerAclState)

        __props__.__dict__["action"] = action
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["frontend_id"] = frontend_id
        __props__.__dict__["index"] = index
        __props__.__dict__["match"] = match
        __props__.__dict__["name"] = name
        __props__.__dict__["updated_at"] = updated_at
        return LoadbalancerAcl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output['outputs.LoadbalancerAclAction']:
        """
        Action to undertake when an ACL filter matches.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        IsDate and time of ACL's creation (RFC 3339 format)
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ACL description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Load Balancer frontend to attach the ACL to.
        """
        return pulumi.get(self, "frontend_id")

    @_builtins.property
    @pulumi.getter
    def index(self) -> pulumi.Output[_builtins.int]:
        """
        The priority of this ACL (ACLs are applied in ascending order, 0 is the first ACL executed).
        """
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter
    def match(self) -> pulumi.Output[Optional['outputs.LoadbalancerAclMatch']]:
        """
        The ACL match rule. At least `ip_subnet` or `ips_edge_services` or `http_filter` and `http_filter_value` are required.
        """
        return pulumi.get(self, "match")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The ACL name. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        IsDate and time of ACL's update (RFC 3339 format)
        """
        return pulumi.get(self, "updated_at")

