# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AclActionArgs',
    'AclActionArgsDict',
    'AclActionRedirectArgs',
    'AclActionRedirectArgsDict',
    'AclMatchArgs',
    'AclMatchArgsDict',
    'BackendHealthCheckHttpArgs',
    'BackendHealthCheckHttpArgsDict',
    'BackendHealthCheckHttpsArgs',
    'BackendHealthCheckHttpsArgsDict',
    'BackendHealthCheckTcpArgs',
    'BackendHealthCheckTcpArgsDict',
    'CertificateCustomCertificateArgs',
    'CertificateCustomCertificateArgsDict',
    'CertificateLetsencryptArgs',
    'CertificateLetsencryptArgsDict',
    'FrontendAclArgs',
    'FrontendAclArgsDict',
    'FrontendAclActionArgs',
    'FrontendAclActionArgsDict',
    'FrontendAclActionRedirectArgs',
    'FrontendAclActionRedirectArgsDict',
    'FrontendAclMatchArgs',
    'FrontendAclMatchArgsDict',
    'LoadBalancerPrivateIpArgs',
    'LoadBalancerPrivateIpArgsDict',
    'LoadBalancerPrivateNetworkArgs',
    'LoadBalancerPrivateNetworkArgsDict',
]

MYPY = False

if not MYPY:
    class AclActionArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        The action type. Possible values are: `allow` or `deny` or `redirect`.
        """
        redirects: NotRequired[pulumi.Input[Sequence[pulumi.Input['AclActionRedirectArgsDict']]]]
        """
        Redirect parameters when using an ACL with `redirect` action.
        """
elif False:
    AclActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AclActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 redirects: Optional[pulumi.Input[Sequence[pulumi.Input['AclActionRedirectArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] type: The action type. Possible values are: `allow` or `deny` or `redirect`.
        :param pulumi.Input[Sequence[pulumi.Input['AclActionRedirectArgs']]] redirects: Redirect parameters when using an ACL with `redirect` action.
        """
        pulumi.set(__self__, "type", type)
        if redirects is not None:
            pulumi.set(__self__, "redirects", redirects)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The action type. Possible values are: `allow` or `deny` or `redirect`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def redirects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclActionRedirectArgs']]]]:
        """
        Redirect parameters when using an ACL with `redirect` action.
        """
        return pulumi.get(self, "redirects")

    @redirects.setter
    def redirects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclActionRedirectArgs']]]]):
        pulumi.set(self, "redirects", value)


if not MYPY:
    class AclActionRedirectArgsDict(TypedDict):
        code: NotRequired[pulumi.Input[_builtins.int]]
        """
        The HTTP redirect code to use. Valid values are `301`, `302`, `303`, `307` and `308`.
        """
        target: NotRequired[pulumi.Input[_builtins.str]]
        """
        An URL can be used in case of a location redirect (e.g. `https://scaleway.com` will redirect to this same URL). A scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The redirect type. Possible values are: `location` or `scheme`.
        """
elif False:
    AclActionRedirectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AclActionRedirectArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[_builtins.int]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] code: The HTTP redirect code to use. Valid values are `301`, `302`, `303`, `307` and `308`.
        :param pulumi.Input[_builtins.str] target: An URL can be used in case of a location redirect (e.g. `https://scaleway.com` will redirect to this same URL). A scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme.
        :param pulumi.Input[_builtins.str] type: The redirect type. Possible values are: `location` or `scheme`.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The HTTP redirect code to use. Valid values are `301`, `302`, `303`, `307` and `308`.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "code", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An URL can be used in case of a location redirect (e.g. `https://scaleway.com` will redirect to this same URL). A scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The redirect type. Possible values are: `location` or `scheme`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class AclMatchArgsDict(TypedDict):
        http_filter: NotRequired[pulumi.Input[_builtins.str]]
        """
        The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
        It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
        Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        """
        http_filter_option: NotRequired[pulumi.Input[_builtins.str]]
        """
        If you have `http_filter` at `http_header_match`, you can use this field to filter on the HTTP header's value.
        """
        http_filter_values: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of possible values to match for the given HTTP filter.
        Keep in mind that in the case of `http_header_match` the HTTP header field name is case insensitive.
        """
        invert: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If set to `true`, the condition will be of type "unless".
        """
        ip_subnets: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of IPs, or CIDR v4/v6 addresses of the session client, to match. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        ips_edge_services: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Defines whether Edge Services IPs should be matched. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
elif False:
    AclMatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AclMatchArgs:
    def __init__(__self__, *,
                 http_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 http_filter_option: Optional[pulumi.Input[_builtins.str]] = None,
                 http_filter_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 invert: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ips_edge_services: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] http_filter: The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
               It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
               Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        :param pulumi.Input[_builtins.str] http_filter_option: If you have `http_filter` at `http_header_match`, you can use this field to filter on the HTTP header's value.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] http_filter_values: A list of possible values to match for the given HTTP filter.
               Keep in mind that in the case of `http_header_match` the HTTP header field name is case insensitive.
        :param pulumi.Input[_builtins.bool] invert: If set to `true`, the condition will be of type "unless".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_subnets: A list of IPs, or CIDR v4/v6 addresses of the session client, to match. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        :param pulumi.Input[_builtins.bool] ips_edge_services: Defines whether Edge Services IPs should be matched. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        if http_filter is not None:
            pulumi.set(__self__, "http_filter", http_filter)
        if http_filter_option is not None:
            pulumi.set(__self__, "http_filter_option", http_filter_option)
        if http_filter_values is not None:
            pulumi.set(__self__, "http_filter_values", http_filter_values)
        if invert is not None:
            pulumi.set(__self__, "invert", invert)
        if ip_subnets is not None:
            pulumi.set(__self__, "ip_subnets", ip_subnets)
        if ips_edge_services is not None:
            pulumi.set(__self__, "ips_edge_services", ips_edge_services)

    @_builtins.property
    @pulumi.getter(name="httpFilter")
    def http_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
        It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
        Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        """
        return pulumi.get(self, "http_filter")

    @http_filter.setter
    def http_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_filter", value)

    @_builtins.property
    @pulumi.getter(name="httpFilterOption")
    def http_filter_option(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If you have `http_filter` at `http_header_match`, you can use this field to filter on the HTTP header's value.
        """
        return pulumi.get(self, "http_filter_option")

    @http_filter_option.setter
    def http_filter_option(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_filter_option", value)

    @_builtins.property
    @pulumi.getter(name="httpFilterValues")
    def http_filter_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of possible values to match for the given HTTP filter.
        Keep in mind that in the case of `http_header_match` the HTTP header field name is case insensitive.
        """
        return pulumi.get(self, "http_filter_values")

    @http_filter_values.setter
    def http_filter_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "http_filter_values", value)

    @_builtins.property
    @pulumi.getter
    def invert(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, the condition will be of type "unless".
        """
        return pulumi.get(self, "invert")

    @invert.setter
    def invert(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "invert", value)

    @_builtins.property
    @pulumi.getter(name="ipSubnets")
    def ip_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IPs, or CIDR v4/v6 addresses of the session client, to match. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        return pulumi.get(self, "ip_subnets")

    @ip_subnets.setter
    def ip_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_subnets", value)

    @_builtins.property
    @pulumi.getter(name="ipsEdgeServices")
    def ips_edge_services(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether Edge Services IPs should be matched. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        return pulumi.get(self, "ips_edge_services")

    @ips_edge_services.setter
    def ips_edge_services(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ips_edge_services", value)


if not MYPY:
    class BackendHealthCheckHttpArgsDict(TypedDict):
        uri: pulumi.Input[_builtins.str]
        """
        The HTTP endpoint URL to call for HC requests
        """
        code: NotRequired[pulumi.Input[_builtins.int]]
        """
        The expected HTTP status code
        """
        host_header: NotRequired[pulumi.Input[_builtins.str]]
        """
        The HTTP host header to use for HC requests
        """
        method: NotRequired[pulumi.Input[_builtins.str]]
        """
        The HTTP method to use for HC requests
        """
elif False:
    BackendHealthCheckHttpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackendHealthCheckHttpArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[_builtins.str],
                 code: Optional[pulumi.Input[_builtins.int]] = None,
                 host_header: Optional[pulumi.Input[_builtins.str]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] uri: The HTTP endpoint URL to call for HC requests
        :param pulumi.Input[_builtins.int] code: The expected HTTP status code
        :param pulumi.Input[_builtins.str] host_header: The HTTP host header to use for HC requests
        :param pulumi.Input[_builtins.str] method: The HTTP method to use for HC requests
        """
        pulumi.set(__self__, "uri", uri)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if method is not None:
            pulumi.set(__self__, "method", method)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Input[_builtins.str]:
        """
        The HTTP endpoint URL to call for HC requests
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "uri", value)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The expected HTTP status code
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "code", value)

    @_builtins.property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTP host header to use for HC requests
        """
        return pulumi.get(self, "host_header")

    @host_header.setter
    def host_header(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_header", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTP method to use for HC requests
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "method", value)


if not MYPY:
    class BackendHealthCheckHttpsArgsDict(TypedDict):
        uri: pulumi.Input[_builtins.str]
        """
        The HTTPS endpoint URL to call for HC requests
        """
        code: NotRequired[pulumi.Input[_builtins.int]]
        """
        The expected HTTP status code
        """
        host_header: NotRequired[pulumi.Input[_builtins.str]]
        """
        The HTTP host header to use for HC requests
        """
        method: NotRequired[pulumi.Input[_builtins.str]]
        """
        The HTTP method to use for HC requests
        """
        sni: NotRequired[pulumi.Input[_builtins.str]]
        """
        The SNI to use for HC requests over SSL
        """
elif False:
    BackendHealthCheckHttpsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackendHealthCheckHttpsArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[_builtins.str],
                 code: Optional[pulumi.Input[_builtins.int]] = None,
                 host_header: Optional[pulumi.Input[_builtins.str]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 sni: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] uri: The HTTPS endpoint URL to call for HC requests
        :param pulumi.Input[_builtins.int] code: The expected HTTP status code
        :param pulumi.Input[_builtins.str] host_header: The HTTP host header to use for HC requests
        :param pulumi.Input[_builtins.str] method: The HTTP method to use for HC requests
        :param pulumi.Input[_builtins.str] sni: The SNI to use for HC requests over SSL
        """
        pulumi.set(__self__, "uri", uri)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if sni is not None:
            pulumi.set(__self__, "sni", sni)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Input[_builtins.str]:
        """
        The HTTPS endpoint URL to call for HC requests
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "uri", value)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The expected HTTP status code
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "code", value)

    @_builtins.property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTP host header to use for HC requests
        """
        return pulumi.get(self, "host_header")

    @host_header.setter
    def host_header(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_header", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTP method to use for HC requests
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "method", value)

    @_builtins.property
    @pulumi.getter
    def sni(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SNI to use for HC requests over SSL
        """
        return pulumi.get(self, "sni")

    @sni.setter
    def sni(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sni", value)


if not MYPY:
    class BackendHealthCheckTcpArgsDict(TypedDict):
        pass
elif False:
    BackendHealthCheckTcpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackendHealthCheckTcpArgs:
    def __init__(__self__):
        pass


if not MYPY:
    class CertificateCustomCertificateArgsDict(TypedDict):
        certificate_chain: pulumi.Input[_builtins.str]
        """
        The full PEM-formatted certificate chain
        """
elif False:
    CertificateCustomCertificateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateCustomCertificateArgs:
    def __init__(__self__, *,
                 certificate_chain: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] certificate_chain: The full PEM-formatted certificate chain
        """
        pulumi.set(__self__, "certificate_chain", certificate_chain)

    @_builtins.property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> pulumi.Input[_builtins.str]:
        """
        The full PEM-formatted certificate chain
        """
        return pulumi.get(self, "certificate_chain")

    @certificate_chain.setter
    def certificate_chain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_chain", value)


if not MYPY:
    class CertificateLetsencryptArgsDict(TypedDict):
        common_name: pulumi.Input[_builtins.str]
        """
        Main domain of the certificate
        """
        subject_alternative_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The alternative domain names of the certificate
        """
elif False:
    CertificateLetsencryptArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateLetsencryptArgs:
    def __init__(__self__, *,
                 common_name: pulumi.Input[_builtins.str],
                 subject_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] common_name: Main domain of the certificate
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subject_alternative_names: The alternative domain names of the certificate
        """
        pulumi.set(__self__, "common_name", common_name)
        if subject_alternative_names is not None:
            pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Input[_builtins.str]:
        """
        Main domain of the certificate
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "common_name", value)

    @_builtins.property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The alternative domain names of the certificate
        """
        return pulumi.get(self, "subject_alternative_names")

    @subject_alternative_names.setter
    def subject_alternative_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subject_alternative_names", value)


if not MYPY:
    class FrontendAclArgsDict(TypedDict):
        action: pulumi.Input['FrontendAclActionArgsDict']
        """
        Action to undertake when an ACL filter matches.
        """
        match: pulumi.Input['FrontendAclMatchArgsDict']
        """
        The ACL match rule. At least `ip_subnet` or `ips_edge_services` or `http_filter` and `http_filter_value` are required.
        """
        created_at: NotRequired[pulumi.Input[_builtins.str]]
        """
        The date and time the frontend was created.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        Description of the ACL
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ACL name. If not provided it will be randomly generated.
        """
        updated_at: NotRequired[pulumi.Input[_builtins.str]]
        """
        The date and time the frontend resource was updated.
        """
elif False:
    FrontendAclArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FrontendAclArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['FrontendAclActionArgs'],
                 match: pulumi.Input['FrontendAclMatchArgs'],
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input['FrontendAclActionArgs'] action: Action to undertake when an ACL filter matches.
        :param pulumi.Input['FrontendAclMatchArgs'] match: The ACL match rule. At least `ip_subnet` or `ips_edge_services` or `http_filter` and `http_filter_value` are required.
        :param pulumi.Input[_builtins.str] created_at: The date and time the frontend was created.
        :param pulumi.Input[_builtins.str] description: Description of the ACL
        :param pulumi.Input[_builtins.str] name: The ACL name. If not provided it will be randomly generated.
        :param pulumi.Input[_builtins.str] updated_at: The date and time the frontend resource was updated.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "match", match)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input['FrontendAclActionArgs']:
        """
        Action to undertake when an ACL filter matches.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['FrontendAclActionArgs']):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def match(self) -> pulumi.Input['FrontendAclMatchArgs']:
        """
        The ACL match rule. At least `ip_subnet` or `ips_edge_services` or `http_filter` and `http_filter_value` are required.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: pulumi.Input['FrontendAclMatchArgs']):
        pulumi.set(self, "match", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the frontend was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the ACL
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ACL name. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the frontend resource was updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


if not MYPY:
    class FrontendAclActionArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        The action type. Possible values are: `allow` or `deny` or `redirect`.
        """
        redirects: NotRequired[pulumi.Input[Sequence[pulumi.Input['FrontendAclActionRedirectArgsDict']]]]
        """
        Redirect parameters when using an ACL with `redirect` action.
        """
elif False:
    FrontendAclActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FrontendAclActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 redirects: Optional[pulumi.Input[Sequence[pulumi.Input['FrontendAclActionRedirectArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] type: The action type. Possible values are: `allow` or `deny` or `redirect`.
        :param pulumi.Input[Sequence[pulumi.Input['FrontendAclActionRedirectArgs']]] redirects: Redirect parameters when using an ACL with `redirect` action.
        """
        pulumi.set(__self__, "type", type)
        if redirects is not None:
            pulumi.set(__self__, "redirects", redirects)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The action type. Possible values are: `allow` or `deny` or `redirect`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def redirects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FrontendAclActionRedirectArgs']]]]:
        """
        Redirect parameters when using an ACL with `redirect` action.
        """
        return pulumi.get(self, "redirects")

    @redirects.setter
    def redirects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FrontendAclActionRedirectArgs']]]]):
        pulumi.set(self, "redirects", value)


if not MYPY:
    class FrontendAclActionRedirectArgsDict(TypedDict):
        code: NotRequired[pulumi.Input[_builtins.int]]
        """
        The HTTP redirect code to use. Valid values are `301`, `302`, `303`, `307` and `308`.
        """
        target: NotRequired[pulumi.Input[_builtins.str]]
        """
        A URL can be used in case of a location redirect (e.g. `https://scaleway.com` will redirect to this same URL). A scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The redirect type. Possible values are: `location` or `scheme`.
        """
elif False:
    FrontendAclActionRedirectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FrontendAclActionRedirectArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[_builtins.int]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] code: The HTTP redirect code to use. Valid values are `301`, `302`, `303`, `307` and `308`.
        :param pulumi.Input[_builtins.str] target: A URL can be used in case of a location redirect (e.g. `https://scaleway.com` will redirect to this same URL). A scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme.
        :param pulumi.Input[_builtins.str] type: The redirect type. Possible values are: `location` or `scheme`.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The HTTP redirect code to use. Valid values are `301`, `302`, `303`, `307` and `308`.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "code", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A URL can be used in case of a location redirect (e.g. `https://scaleway.com` will redirect to this same URL). A scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The redirect type. Possible values are: `location` or `scheme`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class FrontendAclMatchArgsDict(TypedDict):
        http_filter: NotRequired[pulumi.Input[_builtins.str]]
        """
        The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
        It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
        Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        """
        http_filter_option: NotRequired[pulumi.Input[_builtins.str]]
        """
        If you have `http_filter` at `http_header_match`, you can use this field to filter on the HTTP header's value.
        """
        http_filter_values: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of possible values to match for the given HTTP filter.
        Keep in mind that in the case of `http_header_match` the HTTP header field name is case insensitive.
        """
        invert: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If set to `true`, the condition will be of type "unless".
        """
        ip_subnets: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of IPs, or CIDR v4/v6 addresses of the session client, to match. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        ips_edge_services: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Defines whether Edge Services IPs should be matched. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
elif False:
    FrontendAclMatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FrontendAclMatchArgs:
    def __init__(__self__, *,
                 http_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 http_filter_option: Optional[pulumi.Input[_builtins.str]] = None,
                 http_filter_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 invert: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ips_edge_services: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] http_filter: The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
               It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
               Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        :param pulumi.Input[_builtins.str] http_filter_option: If you have `http_filter` at `http_header_match`, you can use this field to filter on the HTTP header's value.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] http_filter_values: A list of possible values to match for the given HTTP filter.
               Keep in mind that in the case of `http_header_match` the HTTP header field name is case insensitive.
        :param pulumi.Input[_builtins.bool] invert: If set to `true`, the condition will be of type "unless".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_subnets: A list of IPs, or CIDR v4/v6 addresses of the session client, to match. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        :param pulumi.Input[_builtins.bool] ips_edge_services: Defines whether Edge Services IPs should be matched. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        if http_filter is not None:
            pulumi.set(__self__, "http_filter", http_filter)
        if http_filter_option is not None:
            pulumi.set(__self__, "http_filter_option", http_filter_option)
        if http_filter_values is not None:
            pulumi.set(__self__, "http_filter_values", http_filter_values)
        if invert is not None:
            pulumi.set(__self__, "invert", invert)
        if ip_subnets is not None:
            pulumi.set(__self__, "ip_subnets", ip_subnets)
        if ips_edge_services is not None:
            pulumi.set(__self__, "ips_edge_services", ips_edge_services)

    @_builtins.property
    @pulumi.getter(name="httpFilter")
    def http_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
        It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
        Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        """
        return pulumi.get(self, "http_filter")

    @http_filter.setter
    def http_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_filter", value)

    @_builtins.property
    @pulumi.getter(name="httpFilterOption")
    def http_filter_option(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If you have `http_filter` at `http_header_match`, you can use this field to filter on the HTTP header's value.
        """
        return pulumi.get(self, "http_filter_option")

    @http_filter_option.setter
    def http_filter_option(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_filter_option", value)

    @_builtins.property
    @pulumi.getter(name="httpFilterValues")
    def http_filter_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of possible values to match for the given HTTP filter.
        Keep in mind that in the case of `http_header_match` the HTTP header field name is case insensitive.
        """
        return pulumi.get(self, "http_filter_values")

    @http_filter_values.setter
    def http_filter_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "http_filter_values", value)

    @_builtins.property
    @pulumi.getter
    def invert(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, the condition will be of type "unless".
        """
        return pulumi.get(self, "invert")

    @invert.setter
    def invert(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "invert", value)

    @_builtins.property
    @pulumi.getter(name="ipSubnets")
    def ip_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IPs, or CIDR v4/v6 addresses of the session client, to match. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        return pulumi.get(self, "ip_subnets")

    @ip_subnets.setter
    def ip_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_subnets", value)

    @_builtins.property
    @pulumi.getter(name="ipsEdgeServices")
    def ips_edge_services(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether Edge Services IPs should be matched. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        return pulumi.get(self, "ips_edge_services")

    @ips_edge_services.setter
    def ips_edge_services(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ips_edge_services", value)


if not MYPY:
    class LoadBalancerPrivateIpArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The private IP address.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the IP address resource.
        """
elif False:
    LoadBalancerPrivateIpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerPrivateIpArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] address: The private IP address.
        :param pulumi.Input[_builtins.str] id: The ID of the IP address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class LoadBalancerPrivateNetworkArgsDict(TypedDict):
        private_network_id: pulumi.Input[_builtins.str]
        """
        The ID of the Private Network to attach to.
        - > **Important:** Updates to `private_network` will recreate the attachment.
        """
        dhcp_config: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Set to true if you want to let DHCP assign IP addresses
        """
        ipam_ids: NotRequired[pulumi.Input[_builtins.str]]
        """
        IPAM ID of a pre-reserved IP address to assign to the Load Balancer on this Private Network.
        """
        static_configs: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Define an IP address in the subnet of your private network that will be assigned to your load balancer instance
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        The status of the private network connection.
        """
        zone: NotRequired[pulumi.Input[_builtins.str]]
        """
        `zone`) The zone of the Load Balancer.
        """
elif False:
    LoadBalancerPrivateNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerPrivateNetworkArgs:
    def __init__(__self__, *,
                 private_network_id: pulumi.Input[_builtins.str],
                 dhcp_config: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipam_ids: Optional[pulumi.Input[_builtins.str]] = None,
                 static_configs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] private_network_id: The ID of the Private Network to attach to.
               - > **Important:** Updates to `private_network` will recreate the attachment.
        :param pulumi.Input[_builtins.bool] dhcp_config: Set to true if you want to let DHCP assign IP addresses
        :param pulumi.Input[_builtins.str] ipam_ids: IPAM ID of a pre-reserved IP address to assign to the Load Balancer on this Private Network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] static_configs: Define an IP address in the subnet of your private network that will be assigned to your load balancer instance
        :param pulumi.Input[_builtins.str] status: The status of the private network connection.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone of the Load Balancer.
        """
        pulumi.set(__self__, "private_network_id", private_network_id)
        if dhcp_config is not None:
            warnings.warn("""dhcp_config field is deprecated, please use `private_network_id` or `ipam_ids` instead""", DeprecationWarning)
            pulumi.log.warn("""dhcp_config is deprecated: dhcp_config field is deprecated, please use `private_network_id` or `ipam_ids` instead""")
        if dhcp_config is not None:
            pulumi.set(__self__, "dhcp_config", dhcp_config)
        if ipam_ids is not None:
            pulumi.set(__self__, "ipam_ids", ipam_ids)
        if static_configs is not None:
            warnings.warn("""static_config field is deprecated, please use `private_network_id` or `ipam_ids` instead""", DeprecationWarning)
            pulumi.log.warn("""static_configs is deprecated: static_config field is deprecated, please use `private_network_id` or `ipam_ids` instead""")
        if static_configs is not None:
            pulumi.set(__self__, "static_configs", static_configs)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Private Network to attach to.
        - > **Important:** Updates to `private_network` will recreate the attachment.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_network_id", value)

    @_builtins.property
    @pulumi.getter(name="dhcpConfig")
    @_utilities.deprecated("""dhcp_config field is deprecated, please use `private_network_id` or `ipam_ids` instead""")
    def dhcp_config(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true if you want to let DHCP assign IP addresses
        """
        return pulumi.get(self, "dhcp_config")

    @dhcp_config.setter
    def dhcp_config(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dhcp_config", value)

    @_builtins.property
    @pulumi.getter(name="ipamIds")
    def ipam_ids(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IPAM ID of a pre-reserved IP address to assign to the Load Balancer on this Private Network.
        """
        return pulumi.get(self, "ipam_ids")

    @ipam_ids.setter
    def ipam_ids(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipam_ids", value)

    @_builtins.property
    @pulumi.getter(name="staticConfigs")
    @_utilities.deprecated("""static_config field is deprecated, please use `private_network_id` or `ipam_ids` instead""")
    def static_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Define an IP address in the subnet of your private network that will be assigned to your load balancer instance
        """
        return pulumi.get(self, "static_configs")

    @static_configs.setter
    def static_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "static_configs", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the private network connection.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `zone`) The zone of the Load Balancer.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


