# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBackendResult',
    'AwaitableGetBackendResult',
    'get_backend',
    'get_backend_output',
]

@pulumi.output_type
class GetBackendResult:
    """
    A collection of values returned by getBackend.
    """
    def __init__(__self__, backend_id=None, failover_host=None, forward_port=None, forward_port_algorithm=None, forward_protocol=None, health_check_delay=None, health_check_http=None, health_check_https=None, health_check_max_retries=None, health_check_port=None, health_check_send_proxy=None, health_check_tcps=None, health_check_timeout=None, health_check_transient_delay=None, id=None, ignore_ssl_server_verify=None, lb_id=None, max_connections=None, max_retries=None, name=None, on_marked_down_action=None, proxy_protocol=None, redispatch_attempt_count=None, send_proxy_v2=None, server_ips=None, ssl_bridging=None, sticky_sessions=None, sticky_sessions_cookie_name=None, timeout_connect=None, timeout_queue=None, timeout_server=None, timeout_tunnel=None):
        if backend_id and not isinstance(backend_id, str):
            raise TypeError("Expected argument 'backend_id' to be a str")
        pulumi.set(__self__, "backend_id", backend_id)
        if failover_host and not isinstance(failover_host, str):
            raise TypeError("Expected argument 'failover_host' to be a str")
        pulumi.set(__self__, "failover_host", failover_host)
        if forward_port and not isinstance(forward_port, int):
            raise TypeError("Expected argument 'forward_port' to be a int")
        pulumi.set(__self__, "forward_port", forward_port)
        if forward_port_algorithm and not isinstance(forward_port_algorithm, str):
            raise TypeError("Expected argument 'forward_port_algorithm' to be a str")
        pulumi.set(__self__, "forward_port_algorithm", forward_port_algorithm)
        if forward_protocol and not isinstance(forward_protocol, str):
            raise TypeError("Expected argument 'forward_protocol' to be a str")
        pulumi.set(__self__, "forward_protocol", forward_protocol)
        if health_check_delay and not isinstance(health_check_delay, str):
            raise TypeError("Expected argument 'health_check_delay' to be a str")
        pulumi.set(__self__, "health_check_delay", health_check_delay)
        if health_check_http and not isinstance(health_check_http, list):
            raise TypeError("Expected argument 'health_check_http' to be a list")
        pulumi.set(__self__, "health_check_http", health_check_http)
        if health_check_https and not isinstance(health_check_https, list):
            raise TypeError("Expected argument 'health_check_https' to be a list")
        pulumi.set(__self__, "health_check_https", health_check_https)
        if health_check_max_retries and not isinstance(health_check_max_retries, int):
            raise TypeError("Expected argument 'health_check_max_retries' to be a int")
        pulumi.set(__self__, "health_check_max_retries", health_check_max_retries)
        if health_check_port and not isinstance(health_check_port, int):
            raise TypeError("Expected argument 'health_check_port' to be a int")
        pulumi.set(__self__, "health_check_port", health_check_port)
        if health_check_send_proxy and not isinstance(health_check_send_proxy, bool):
            raise TypeError("Expected argument 'health_check_send_proxy' to be a bool")
        pulumi.set(__self__, "health_check_send_proxy", health_check_send_proxy)
        if health_check_tcps and not isinstance(health_check_tcps, list):
            raise TypeError("Expected argument 'health_check_tcps' to be a list")
        pulumi.set(__self__, "health_check_tcps", health_check_tcps)
        if health_check_timeout and not isinstance(health_check_timeout, str):
            raise TypeError("Expected argument 'health_check_timeout' to be a str")
        pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        if health_check_transient_delay and not isinstance(health_check_transient_delay, str):
            raise TypeError("Expected argument 'health_check_transient_delay' to be a str")
        pulumi.set(__self__, "health_check_transient_delay", health_check_transient_delay)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ignore_ssl_server_verify and not isinstance(ignore_ssl_server_verify, bool):
            raise TypeError("Expected argument 'ignore_ssl_server_verify' to be a bool")
        pulumi.set(__self__, "ignore_ssl_server_verify", ignore_ssl_server_verify)
        if lb_id and not isinstance(lb_id, str):
            raise TypeError("Expected argument 'lb_id' to be a str")
        pulumi.set(__self__, "lb_id", lb_id)
        if max_connections and not isinstance(max_connections, int):
            raise TypeError("Expected argument 'max_connections' to be a int")
        pulumi.set(__self__, "max_connections", max_connections)
        if max_retries and not isinstance(max_retries, int):
            raise TypeError("Expected argument 'max_retries' to be a int")
        pulumi.set(__self__, "max_retries", max_retries)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if on_marked_down_action and not isinstance(on_marked_down_action, str):
            raise TypeError("Expected argument 'on_marked_down_action' to be a str")
        pulumi.set(__self__, "on_marked_down_action", on_marked_down_action)
        if proxy_protocol and not isinstance(proxy_protocol, str):
            raise TypeError("Expected argument 'proxy_protocol' to be a str")
        pulumi.set(__self__, "proxy_protocol", proxy_protocol)
        if redispatch_attempt_count and not isinstance(redispatch_attempt_count, int):
            raise TypeError("Expected argument 'redispatch_attempt_count' to be a int")
        pulumi.set(__self__, "redispatch_attempt_count", redispatch_attempt_count)
        if send_proxy_v2 and not isinstance(send_proxy_v2, bool):
            raise TypeError("Expected argument 'send_proxy_v2' to be a bool")
        pulumi.set(__self__, "send_proxy_v2", send_proxy_v2)
        if server_ips and not isinstance(server_ips, list):
            raise TypeError("Expected argument 'server_ips' to be a list")
        pulumi.set(__self__, "server_ips", server_ips)
        if ssl_bridging and not isinstance(ssl_bridging, bool):
            raise TypeError("Expected argument 'ssl_bridging' to be a bool")
        pulumi.set(__self__, "ssl_bridging", ssl_bridging)
        if sticky_sessions and not isinstance(sticky_sessions, str):
            raise TypeError("Expected argument 'sticky_sessions' to be a str")
        pulumi.set(__self__, "sticky_sessions", sticky_sessions)
        if sticky_sessions_cookie_name and not isinstance(sticky_sessions_cookie_name, str):
            raise TypeError("Expected argument 'sticky_sessions_cookie_name' to be a str")
        pulumi.set(__self__, "sticky_sessions_cookie_name", sticky_sessions_cookie_name)
        if timeout_connect and not isinstance(timeout_connect, str):
            raise TypeError("Expected argument 'timeout_connect' to be a str")
        pulumi.set(__self__, "timeout_connect", timeout_connect)
        if timeout_queue and not isinstance(timeout_queue, str):
            raise TypeError("Expected argument 'timeout_queue' to be a str")
        pulumi.set(__self__, "timeout_queue", timeout_queue)
        if timeout_server and not isinstance(timeout_server, str):
            raise TypeError("Expected argument 'timeout_server' to be a str")
        pulumi.set(__self__, "timeout_server", timeout_server)
        if timeout_tunnel and not isinstance(timeout_tunnel, str):
            raise TypeError("Expected argument 'timeout_tunnel' to be a str")
        pulumi.set(__self__, "timeout_tunnel", timeout_tunnel)

    @_builtins.property
    @pulumi.getter(name="backendId")
    def backend_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "backend_id")

    @_builtins.property
    @pulumi.getter(name="failoverHost")
    def failover_host(self) -> _builtins.str:
        return pulumi.get(self, "failover_host")

    @_builtins.property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> _builtins.int:
        return pulumi.get(self, "forward_port")

    @_builtins.property
    @pulumi.getter(name="forwardPortAlgorithm")
    def forward_port_algorithm(self) -> _builtins.str:
        return pulumi.get(self, "forward_port_algorithm")

    @_builtins.property
    @pulumi.getter(name="forwardProtocol")
    def forward_protocol(self) -> _builtins.str:
        return pulumi.get(self, "forward_protocol")

    @_builtins.property
    @pulumi.getter(name="healthCheckDelay")
    def health_check_delay(self) -> _builtins.str:
        return pulumi.get(self, "health_check_delay")

    @_builtins.property
    @pulumi.getter(name="healthCheckHttp")
    def health_check_http(self) -> Sequence['outputs.GetBackendHealthCheckHttpResult']:
        return pulumi.get(self, "health_check_http")

    @_builtins.property
    @pulumi.getter(name="healthCheckHttps")
    def health_check_https(self) -> Sequence['outputs.GetBackendHealthCheckHttpResult']:
        return pulumi.get(self, "health_check_https")

    @_builtins.property
    @pulumi.getter(name="healthCheckMaxRetries")
    def health_check_max_retries(self) -> _builtins.int:
        return pulumi.get(self, "health_check_max_retries")

    @_builtins.property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> _builtins.int:
        return pulumi.get(self, "health_check_port")

    @_builtins.property
    @pulumi.getter(name="healthCheckSendProxy")
    def health_check_send_proxy(self) -> _builtins.bool:
        return pulumi.get(self, "health_check_send_proxy")

    @_builtins.property
    @pulumi.getter(name="healthCheckTcps")
    def health_check_tcps(self) -> Sequence['outputs.GetBackendHealthCheckTcpResult']:
        return pulumi.get(self, "health_check_tcps")

    @_builtins.property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> _builtins.str:
        return pulumi.get(self, "health_check_timeout")

    @_builtins.property
    @pulumi.getter(name="healthCheckTransientDelay")
    def health_check_transient_delay(self) -> _builtins.str:
        return pulumi.get(self, "health_check_transient_delay")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ignoreSslServerVerify")
    def ignore_ssl_server_verify(self) -> _builtins.bool:
        return pulumi.get(self, "ignore_ssl_server_verify")

    @_builtins.property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "lb_id")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> _builtins.int:
        return pulumi.get(self, "max_connections")

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> _builtins.int:
        return pulumi.get(self, "max_retries")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="onMarkedDownAction")
    def on_marked_down_action(self) -> _builtins.str:
        return pulumi.get(self, "on_marked_down_action")

    @_builtins.property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> _builtins.str:
        return pulumi.get(self, "proxy_protocol")

    @_builtins.property
    @pulumi.getter(name="redispatchAttemptCount")
    def redispatch_attempt_count(self) -> _builtins.int:
        return pulumi.get(self, "redispatch_attempt_count")

    @_builtins.property
    @pulumi.getter(name="sendProxyV2")
    def send_proxy_v2(self) -> _builtins.bool:
        return pulumi.get(self, "send_proxy_v2")

    @_builtins.property
    @pulumi.getter(name="serverIps")
    def server_ips(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "server_ips")

    @_builtins.property
    @pulumi.getter(name="sslBridging")
    def ssl_bridging(self) -> _builtins.bool:
        return pulumi.get(self, "ssl_bridging")

    @_builtins.property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> _builtins.str:
        return pulumi.get(self, "sticky_sessions")

    @_builtins.property
    @pulumi.getter(name="stickySessionsCookieName")
    def sticky_sessions_cookie_name(self) -> _builtins.str:
        return pulumi.get(self, "sticky_sessions_cookie_name")

    @_builtins.property
    @pulumi.getter(name="timeoutConnect")
    def timeout_connect(self) -> _builtins.str:
        return pulumi.get(self, "timeout_connect")

    @_builtins.property
    @pulumi.getter(name="timeoutQueue")
    def timeout_queue(self) -> _builtins.str:
        return pulumi.get(self, "timeout_queue")

    @_builtins.property
    @pulumi.getter(name="timeoutServer")
    def timeout_server(self) -> _builtins.str:
        return pulumi.get(self, "timeout_server")

    @_builtins.property
    @pulumi.getter(name="timeoutTunnel")
    def timeout_tunnel(self) -> _builtins.str:
        return pulumi.get(self, "timeout_tunnel")


class AwaitableGetBackendResult(GetBackendResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackendResult(
            backend_id=self.backend_id,
            failover_host=self.failover_host,
            forward_port=self.forward_port,
            forward_port_algorithm=self.forward_port_algorithm,
            forward_protocol=self.forward_protocol,
            health_check_delay=self.health_check_delay,
            health_check_http=self.health_check_http,
            health_check_https=self.health_check_https,
            health_check_max_retries=self.health_check_max_retries,
            health_check_port=self.health_check_port,
            health_check_send_proxy=self.health_check_send_proxy,
            health_check_tcps=self.health_check_tcps,
            health_check_timeout=self.health_check_timeout,
            health_check_transient_delay=self.health_check_transient_delay,
            id=self.id,
            ignore_ssl_server_verify=self.ignore_ssl_server_verify,
            lb_id=self.lb_id,
            max_connections=self.max_connections,
            max_retries=self.max_retries,
            name=self.name,
            on_marked_down_action=self.on_marked_down_action,
            proxy_protocol=self.proxy_protocol,
            redispatch_attempt_count=self.redispatch_attempt_count,
            send_proxy_v2=self.send_proxy_v2,
            server_ips=self.server_ips,
            ssl_bridging=self.ssl_bridging,
            sticky_sessions=self.sticky_sessions,
            sticky_sessions_cookie_name=self.sticky_sessions_cookie_name,
            timeout_connect=self.timeout_connect,
            timeout_queue=self.timeout_queue,
            timeout_server=self.timeout_server,
            timeout_tunnel=self.timeout_tunnel)


def get_backend(backend_id: Optional[_builtins.str] = None,
                lb_id: Optional[_builtins.str] = None,
                name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackendResult:
    """
    Get information about Scaleway Load Balancer backends.

    For more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/reference-content/configuring-backends/) or [API documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-backends).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    main = scaleway.loadbalancers.Ip("main")
    main_load_balancer = scaleway.loadbalancers.LoadBalancer("main",
        ip_id=main.id,
        name="data-test-lb-backend",
        type="LB-S")
    main_backend = scaleway.loadbalancers.Backend("main",
        lb_id=main_load_balancer.id,
        name="backend01",
        forward_protocol="http",
        forward_port=80)
    by_id = scaleway.loadbalancers.get_backend_output(backend_id=main_backend.id)
    by_name = scaleway.loadbalancers.get_backend_output(name=main_backend.name,
        lb_id=main_load_balancer.id)
    ```


    :param _builtins.str backend_id: The backend ID.
           - Only one of `name` and `backend_id` should be specified.
    :param _builtins.str lb_id: Load Balancer ID this backend is attached to.
    :param _builtins.str name: The name of the backend.
           - When using `name` you should specify the `lb-id`
    """
    __args__ = dict()
    __args__['backendId'] = backend_id
    __args__['lbId'] = lb_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:loadbalancers/getBackend:getBackend', __args__, opts=opts, typ=GetBackendResult).value

    return AwaitableGetBackendResult(
        backend_id=pulumi.get(__ret__, 'backend_id'),
        failover_host=pulumi.get(__ret__, 'failover_host'),
        forward_port=pulumi.get(__ret__, 'forward_port'),
        forward_port_algorithm=pulumi.get(__ret__, 'forward_port_algorithm'),
        forward_protocol=pulumi.get(__ret__, 'forward_protocol'),
        health_check_delay=pulumi.get(__ret__, 'health_check_delay'),
        health_check_http=pulumi.get(__ret__, 'health_check_http'),
        health_check_https=pulumi.get(__ret__, 'health_check_https'),
        health_check_max_retries=pulumi.get(__ret__, 'health_check_max_retries'),
        health_check_port=pulumi.get(__ret__, 'health_check_port'),
        health_check_send_proxy=pulumi.get(__ret__, 'health_check_send_proxy'),
        health_check_tcps=pulumi.get(__ret__, 'health_check_tcps'),
        health_check_timeout=pulumi.get(__ret__, 'health_check_timeout'),
        health_check_transient_delay=pulumi.get(__ret__, 'health_check_transient_delay'),
        id=pulumi.get(__ret__, 'id'),
        ignore_ssl_server_verify=pulumi.get(__ret__, 'ignore_ssl_server_verify'),
        lb_id=pulumi.get(__ret__, 'lb_id'),
        max_connections=pulumi.get(__ret__, 'max_connections'),
        max_retries=pulumi.get(__ret__, 'max_retries'),
        name=pulumi.get(__ret__, 'name'),
        on_marked_down_action=pulumi.get(__ret__, 'on_marked_down_action'),
        proxy_protocol=pulumi.get(__ret__, 'proxy_protocol'),
        redispatch_attempt_count=pulumi.get(__ret__, 'redispatch_attempt_count'),
        send_proxy_v2=pulumi.get(__ret__, 'send_proxy_v2'),
        server_ips=pulumi.get(__ret__, 'server_ips'),
        ssl_bridging=pulumi.get(__ret__, 'ssl_bridging'),
        sticky_sessions=pulumi.get(__ret__, 'sticky_sessions'),
        sticky_sessions_cookie_name=pulumi.get(__ret__, 'sticky_sessions_cookie_name'),
        timeout_connect=pulumi.get(__ret__, 'timeout_connect'),
        timeout_queue=pulumi.get(__ret__, 'timeout_queue'),
        timeout_server=pulumi.get(__ret__, 'timeout_server'),
        timeout_tunnel=pulumi.get(__ret__, 'timeout_tunnel'))
def get_backend_output(backend_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       lb_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBackendResult]:
    """
    Get information about Scaleway Load Balancer backends.

    For more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/reference-content/configuring-backends/) or [API documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-backends).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    main = scaleway.loadbalancers.Ip("main")
    main_load_balancer = scaleway.loadbalancers.LoadBalancer("main",
        ip_id=main.id,
        name="data-test-lb-backend",
        type="LB-S")
    main_backend = scaleway.loadbalancers.Backend("main",
        lb_id=main_load_balancer.id,
        name="backend01",
        forward_protocol="http",
        forward_port=80)
    by_id = scaleway.loadbalancers.get_backend_output(backend_id=main_backend.id)
    by_name = scaleway.loadbalancers.get_backend_output(name=main_backend.name,
        lb_id=main_load_balancer.id)
    ```


    :param _builtins.str backend_id: The backend ID.
           - Only one of `name` and `backend_id` should be specified.
    :param _builtins.str lb_id: Load Balancer ID this backend is attached to.
    :param _builtins.str name: The name of the backend.
           - When using `name` you should specify the `lb-id`
    """
    __args__ = dict()
    __args__['backendId'] = backend_id
    __args__['lbId'] = lb_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:loadbalancers/getBackend:getBackend', __args__, opts=opts, typ=GetBackendResult)
    return __ret__.apply(lambda __response__: GetBackendResult(
        backend_id=pulumi.get(__response__, 'backend_id'),
        failover_host=pulumi.get(__response__, 'failover_host'),
        forward_port=pulumi.get(__response__, 'forward_port'),
        forward_port_algorithm=pulumi.get(__response__, 'forward_port_algorithm'),
        forward_protocol=pulumi.get(__response__, 'forward_protocol'),
        health_check_delay=pulumi.get(__response__, 'health_check_delay'),
        health_check_http=pulumi.get(__response__, 'health_check_http'),
        health_check_https=pulumi.get(__response__, 'health_check_https'),
        health_check_max_retries=pulumi.get(__response__, 'health_check_max_retries'),
        health_check_port=pulumi.get(__response__, 'health_check_port'),
        health_check_send_proxy=pulumi.get(__response__, 'health_check_send_proxy'),
        health_check_tcps=pulumi.get(__response__, 'health_check_tcps'),
        health_check_timeout=pulumi.get(__response__, 'health_check_timeout'),
        health_check_transient_delay=pulumi.get(__response__, 'health_check_transient_delay'),
        id=pulumi.get(__response__, 'id'),
        ignore_ssl_server_verify=pulumi.get(__response__, 'ignore_ssl_server_verify'),
        lb_id=pulumi.get(__response__, 'lb_id'),
        max_connections=pulumi.get(__response__, 'max_connections'),
        max_retries=pulumi.get(__response__, 'max_retries'),
        name=pulumi.get(__response__, 'name'),
        on_marked_down_action=pulumi.get(__response__, 'on_marked_down_action'),
        proxy_protocol=pulumi.get(__response__, 'proxy_protocol'),
        redispatch_attempt_count=pulumi.get(__response__, 'redispatch_attempt_count'),
        send_proxy_v2=pulumi.get(__response__, 'send_proxy_v2'),
        server_ips=pulumi.get(__response__, 'server_ips'),
        ssl_bridging=pulumi.get(__response__, 'ssl_bridging'),
        sticky_sessions=pulumi.get(__response__, 'sticky_sessions'),
        sticky_sessions_cookie_name=pulumi.get(__response__, 'sticky_sessions_cookie_name'),
        timeout_connect=pulumi.get(__response__, 'timeout_connect'),
        timeout_queue=pulumi.get(__response__, 'timeout_queue'),
        timeout_server=pulumi.get(__response__, 'timeout_server'),
        timeout_tunnel=pulumi.get(__response__, 'timeout_tunnel')))
