# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SnsTopicSubscriptionArgs', 'SnsTopicSubscription']

@pulumi.input_type
class SnsTopicSubscriptionArgs:
    def __init__(__self__, *,
                 access_key: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.str],
                 secret_key: pulumi.Input[_builtins.str],
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 redrive_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sns_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SnsTopicSubscription resource.
        :param pulumi.Input[_builtins.str] access_key: The access key of the SNS credentials.
        :param pulumi.Input[_builtins.str] protocol: Protocol of the SNS topic subscription.
        :param pulumi.Input[_builtins.str] secret_key: The secret key of the SNS credentials.
        :param pulumi.Input[_builtins.str] endpoint: Endpoint of the subscription
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project in which SNS is enabled.
        :param pulumi.Input[_builtins.bool] redrive_policy: Activate JSON redrive policy.
        :param pulumi.Input[_builtins.str] region: `region`). The region
               in which SNS is enabled.
        :param pulumi.Input[_builtins.str] sns_endpoint: The endpoint of the SNS service. Can contain a {region} placeholder. Defaults to `https://sns.mnq.{region}.scaleway.com`.
        :param pulumi.Input[_builtins.str] topic_arn: The ARN of the topic. Either `topic_id` or `topic_arn` is required.
        :param pulumi.Input[_builtins.str] topic_id: The ID of the topic. Either `topic_id` or `topic_arn` is required. Conflicts with `topic_arn`.
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "secret_key", secret_key)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if redrive_policy is not None:
            pulumi.set(__self__, "redrive_policy", redrive_policy)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sns_endpoint is not None:
            pulumi.set(__self__, "sns_endpoint", sns_endpoint)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)
        if topic_id is not None:
            pulumi.set(__self__, "topic_id", topic_id)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Input[_builtins.str]:
        """
        The access key of the SNS credentials.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        Protocol of the SNS topic subscription.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Input[_builtins.str]:
        """
        The secret key of the SNS credentials.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Endpoint of the subscription
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project in which SNS is enabled.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="redrivePolicy")
    def redrive_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Activate JSON redrive policy.
        """
        return pulumi.get(self, "redrive_policy")

    @redrive_policy.setter
    def redrive_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "redrive_policy", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`). The region
        in which SNS is enabled.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="snsEndpoint")
    def sns_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint of the SNS service. Can contain a {region} placeholder. Defaults to `https://sns.mnq.{region}.scaleway.com`.
        """
        return pulumi.get(self, "sns_endpoint")

    @sns_endpoint.setter
    def sns_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sns_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the topic. Either `topic_id` or `topic_arn` is required.
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic_arn", value)

    @_builtins.property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the topic. Either `topic_id` or `topic_arn` is required. Conflicts with `topic_arn`.
        """
        return pulumi.get(self, "topic_id")

    @topic_id.setter
    def topic_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic_id", value)


@pulumi.input_type
class _SnsTopicSubscriptionState:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 redrive_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sns_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SnsTopicSubscription resources.
        :param pulumi.Input[_builtins.str] access_key: The access key of the SNS credentials.
        :param pulumi.Input[_builtins.str] arn: The ARN of the topic subscription
        :param pulumi.Input[_builtins.str] endpoint: Endpoint of the subscription
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project in which SNS is enabled.
        :param pulumi.Input[_builtins.str] protocol: Protocol of the SNS topic subscription.
        :param pulumi.Input[_builtins.bool] redrive_policy: Activate JSON redrive policy.
        :param pulumi.Input[_builtins.str] region: `region`). The region
               in which SNS is enabled.
        :param pulumi.Input[_builtins.str] secret_key: The secret key of the SNS credentials.
        :param pulumi.Input[_builtins.str] sns_endpoint: The endpoint of the SNS service. Can contain a {region} placeholder. Defaults to `https://sns.mnq.{region}.scaleway.com`.
        :param pulumi.Input[_builtins.str] topic_arn: The ARN of the topic. Either `topic_id` or `topic_arn` is required.
        :param pulumi.Input[_builtins.str] topic_id: The ID of the topic. Either `topic_id` or `topic_arn` is required. Conflicts with `topic_arn`.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if redrive_policy is not None:
            pulumi.set(__self__, "redrive_policy", redrive_policy)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if sns_endpoint is not None:
            pulumi.set(__self__, "sns_endpoint", sns_endpoint)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)
        if topic_id is not None:
            pulumi.set(__self__, "topic_id", topic_id)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access key of the SNS credentials.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the topic subscription
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Endpoint of the subscription
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project in which SNS is enabled.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Protocol of the SNS topic subscription.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="redrivePolicy")
    def redrive_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Activate JSON redrive policy.
        """
        return pulumi.get(self, "redrive_policy")

    @redrive_policy.setter
    def redrive_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "redrive_policy", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`). The region
        in which SNS is enabled.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret key of the SNS credentials.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter(name="snsEndpoint")
    def sns_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint of the SNS service. Can contain a {region} placeholder. Defaults to `https://sns.mnq.{region}.scaleway.com`.
        """
        return pulumi.get(self, "sns_endpoint")

    @sns_endpoint.setter
    def sns_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sns_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the topic. Either `topic_id` or `topic_arn` is required.
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic_arn", value)

    @_builtins.property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the topic. Either `topic_id` or `topic_arn` is required. Conflicts with `topic_arn`.
        """
        return pulumi.get(self, "topic_id")

    @topic_id.setter
    def topic_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic_id", value)


@pulumi.type_token("scaleway:mnq/snsTopicSubscription:SnsTopicSubscription")
class SnsTopicSubscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 redrive_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sns_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages Scaleway Messaging and Queuing SNS topic subscriptions.
        For further information, see
        our [main documentation](https://www.scaleway.com/en/docs/messaging/reference-content/sns-overview/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        # For default project in default region
        main = scaleway.mnq.Sns("main")
        main_sns_credentials = scaleway.mnq.SnsCredentials("main",
            project_id=main.project_id,
            permissions={
                "can_manage": True,
                "can_publish": True,
                "can_receive": True,
            })
        topic = scaleway.mnq.SnsTopic("topic",
            project_id=main.project_id,
            name="my-topic",
            access_key=main_sns_credentials.access_key,
            secret_key=main_sns_credentials.secret_key)
        main_sns_topic_subscription = scaleway.mnq.SnsTopicSubscription("main",
            project_id=main.project_id,
            access_key=main_sns_credentials.access_key,
            secret_key=main_sns_credentials.secret_key,
            topic_id=topic.id,
            protocol="http",
            endpoint="http://example.com")
        ```

        ## Import

        SNS topic subscriptions can be imported using `{region}/{project-id}/{topic-name}/{subscription-id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:mnq/snsTopicSubscription:SnsTopicSubscription main fr-par/11111111111111111111111111111111/my-topic/11111111111111111111111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: The access key of the SNS credentials.
        :param pulumi.Input[_builtins.str] endpoint: Endpoint of the subscription
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project in which SNS is enabled.
        :param pulumi.Input[_builtins.str] protocol: Protocol of the SNS topic subscription.
        :param pulumi.Input[_builtins.bool] redrive_policy: Activate JSON redrive policy.
        :param pulumi.Input[_builtins.str] region: `region`). The region
               in which SNS is enabled.
        :param pulumi.Input[_builtins.str] secret_key: The secret key of the SNS credentials.
        :param pulumi.Input[_builtins.str] sns_endpoint: The endpoint of the SNS service. Can contain a {region} placeholder. Defaults to `https://sns.mnq.{region}.scaleway.com`.
        :param pulumi.Input[_builtins.str] topic_arn: The ARN of the topic. Either `topic_id` or `topic_arn` is required.
        :param pulumi.Input[_builtins.str] topic_id: The ID of the topic. Either `topic_id` or `topic_arn` is required. Conflicts with `topic_arn`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnsTopicSubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Scaleway Messaging and Queuing SNS topic subscriptions.
        For further information, see
        our [main documentation](https://www.scaleway.com/en/docs/messaging/reference-content/sns-overview/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        # For default project in default region
        main = scaleway.mnq.Sns("main")
        main_sns_credentials = scaleway.mnq.SnsCredentials("main",
            project_id=main.project_id,
            permissions={
                "can_manage": True,
                "can_publish": True,
                "can_receive": True,
            })
        topic = scaleway.mnq.SnsTopic("topic",
            project_id=main.project_id,
            name="my-topic",
            access_key=main_sns_credentials.access_key,
            secret_key=main_sns_credentials.secret_key)
        main_sns_topic_subscription = scaleway.mnq.SnsTopicSubscription("main",
            project_id=main.project_id,
            access_key=main_sns_credentials.access_key,
            secret_key=main_sns_credentials.secret_key,
            topic_id=topic.id,
            protocol="http",
            endpoint="http://example.com")
        ```

        ## Import

        SNS topic subscriptions can be imported using `{region}/{project-id}/{topic-name}/{subscription-id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:mnq/snsTopicSubscription:SnsTopicSubscription main fr-par/11111111111111111111111111111111/my-topic/11111111111111111111111111111111
        ```

        :param str resource_name: The name of the resource.
        :param SnsTopicSubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnsTopicSubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 redrive_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sns_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnsTopicSubscriptionArgs.__new__(SnsTopicSubscriptionArgs)

            if access_key is None and not opts.urn:
                raise TypeError("Missing required property 'access_key'")
            __props__.__dict__["access_key"] = None if access_key is None else pulumi.Output.secret(access_key)
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["project_id"] = project_id
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["redrive_policy"] = redrive_policy
            __props__.__dict__["region"] = region
            if secret_key is None and not opts.urn:
                raise TypeError("Missing required property 'secret_key'")
            __props__.__dict__["secret_key"] = None if secret_key is None else pulumi.Output.secret(secret_key)
            __props__.__dict__["sns_endpoint"] = sns_endpoint
            __props__.__dict__["topic_arn"] = topic_arn
            __props__.__dict__["topic_id"] = topic_id
            __props__.__dict__["arn"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/mnqSnsTopicSubscription:MnqSnsTopicSubscription")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accessKey", "secretKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SnsTopicSubscription, __self__).__init__(
            'scaleway:mnq/snsTopicSubscription:SnsTopicSubscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            redrive_policy: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            secret_key: Optional[pulumi.Input[_builtins.str]] = None,
            sns_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
            topic_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'SnsTopicSubscription':
        """
        Get an existing SnsTopicSubscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: The access key of the SNS credentials.
        :param pulumi.Input[_builtins.str] arn: The ARN of the topic subscription
        :param pulumi.Input[_builtins.str] endpoint: Endpoint of the subscription
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project in which SNS is enabled.
        :param pulumi.Input[_builtins.str] protocol: Protocol of the SNS topic subscription.
        :param pulumi.Input[_builtins.bool] redrive_policy: Activate JSON redrive policy.
        :param pulumi.Input[_builtins.str] region: `region`). The region
               in which SNS is enabled.
        :param pulumi.Input[_builtins.str] secret_key: The secret key of the SNS credentials.
        :param pulumi.Input[_builtins.str] sns_endpoint: The endpoint of the SNS service. Can contain a {region} placeholder. Defaults to `https://sns.mnq.{region}.scaleway.com`.
        :param pulumi.Input[_builtins.str] topic_arn: The ARN of the topic. Either `topic_id` or `topic_arn` is required.
        :param pulumi.Input[_builtins.str] topic_id: The ID of the topic. Either `topic_id` or `topic_arn` is required. Conflicts with `topic_arn`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnsTopicSubscriptionState.__new__(_SnsTopicSubscriptionState)

        __props__.__dict__["access_key"] = access_key
        __props__.__dict__["arn"] = arn
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["redrive_policy"] = redrive_policy
        __props__.__dict__["region"] = region
        __props__.__dict__["secret_key"] = secret_key
        __props__.__dict__["sns_endpoint"] = sns_endpoint
        __props__.__dict__["topic_arn"] = topic_arn
        __props__.__dict__["topic_id"] = topic_id
        return SnsTopicSubscription(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[_builtins.str]:
        """
        The access key of the SNS credentials.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the topic subscription
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Endpoint of the subscription
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the Project in which SNS is enabled.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        Protocol of the SNS topic subscription.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="redrivePolicy")
    def redrive_policy(self) -> pulumi.Output[_builtins.bool]:
        """
        Activate JSON redrive policy.
        """
        return pulumi.get(self, "redrive_policy")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `region`). The region
        in which SNS is enabled.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[_builtins.str]:
        """
        The secret key of the SNS credentials.
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter(name="snsEndpoint")
    def sns_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The endpoint of the SNS service. Can contain a {region} placeholder. Defaults to `https://sns.mnq.{region}.scaleway.com`.
        """
        return pulumi.get(self, "sns_endpoint")

    @_builtins.property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ARN of the topic. Either `topic_id` or `topic_arn` is required.
        """
        return pulumi.get(self, "topic_arn")

    @_builtins.property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the topic. Either `topic_id` or `topic_arn` is required. Conflicts with `topic_arn`.
        """
        return pulumi.get(self, "topic_id")

