# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MnqSqsArgs', 'MnqSqs']

@pulumi.input_type
class MnqSqsArgs:
    def __init__(__self__, *,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MnqSqs resource.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project in which SQS will be enabled.
        :param pulumi.Input[_builtins.str] region: `region`). The region
               in which SQS will be enabled.
        """
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project in which SQS will be enabled.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`). The region
        in which SQS will be enabled.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _MnqSqsState:
    def __init__(__self__, *,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MnqSqs resources.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint of the SQS service for this Project.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project in which SQS will be enabled.
        :param pulumi.Input[_builtins.str] region: `region`). The region
               in which SQS will be enabled.
        """
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint of the SQS service for this Project.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project in which SQS will be enabled.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`). The region
        in which SQS will be enabled.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


warnings.warn("""scaleway.index/mnqsqs.MnqSqs has been deprecated in favor of scaleway.mnq/sqs.Sqs""", DeprecationWarning)


@pulumi.type_token("scaleway:index/mnqSqs:MnqSqs")
class MnqSqs(pulumi.CustomResource):
    warnings.warn("""scaleway.index/mnqsqs.MnqSqs has been deprecated in favor of scaleway.mnq/sqs.Sqs""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Activate Scaleway Messaging and Queuing SQS in a Project.
        For further information, see
        our [main documentation](https://www.scaleway.com/en/docs/messaging/reference-content/sqs-overview/).

        ## Example Usage

        ### Basic

        Activate SQS in the default Project

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mnq.Sqs("main")
        ```

        Activate SQS for a specific project

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        project = scaleway.account.get_project(name="default")
        for_project = scaleway.mnq.Sqs("for_project", project_id=project.id)
        ```

        ## Import

        SQS status can be imported using the `{region}/{project_id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/mnqSqs:MnqSqs main fr-par/11111111111111111111111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project in which SQS will be enabled.
        :param pulumi.Input[_builtins.str] region: `region`). The region
               in which SQS will be enabled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[MnqSqsArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Activate Scaleway Messaging and Queuing SQS in a Project.
        For further information, see
        our [main documentation](https://www.scaleway.com/en/docs/messaging/reference-content/sqs-overview/).

        ## Example Usage

        ### Basic

        Activate SQS in the default Project

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mnq.Sqs("main")
        ```

        Activate SQS for a specific project

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        project = scaleway.account.get_project(name="default")
        for_project = scaleway.mnq.Sqs("for_project", project_id=project.id)
        ```

        ## Import

        SQS status can be imported using the `{region}/{project_id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/mnqSqs:MnqSqs main fr-par/11111111111111111111111111111111
        ```

        :param str resource_name: The name of the resource.
        :param MnqSqsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MnqSqsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""MnqSqs is deprecated: scaleway.index/mnqsqs.MnqSqs has been deprecated in favor of scaleway.mnq/sqs.Sqs""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MnqSqsArgs.__new__(MnqSqsArgs)

            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["endpoint"] = None
        super(MnqSqs, __self__).__init__(
            'scaleway:index/mnqSqs:MnqSqs',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'MnqSqs':
        """
        Get an existing MnqSqs resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint of the SQS service for this Project.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project in which SQS will be enabled.
        :param pulumi.Input[_builtins.str] region: `region`). The region
               in which SQS will be enabled.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MnqSqsState.__new__(_MnqSqsState)

        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        return MnqSqs(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The endpoint of the SQS service for this Project.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the Project in which SQS will be enabled.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `region`). The region
        in which SQS will be enabled.
        """
        return pulumi.get(self, "region")

