# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'InstancePrivateIpArgs',
    'InstancePrivateIpArgsDict',
    'InstancePrivateNetworkArgs',
    'InstancePrivateNetworkArgsDict',
    'InstancePublicNetworkArgs',
    'InstancePublicNetworkArgsDict',
    'UserRoleArgs',
    'UserRoleArgsDict',
]

MYPY = False

if not MYPY:
    class InstancePrivateIpArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The private IPv4 address.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the endpoint.
        """
elif False:
    InstancePrivateIpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstancePrivateIpArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] address: The private IPv4 address.
        :param pulumi.Input[_builtins.str] id: The ID of the endpoint.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IPv4 address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class InstancePrivateNetworkArgsDict(TypedDict):
        pn_id: pulumi.Input[_builtins.str]
        """
        The ID of the Private Network.
        """
        dns_records: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of DNS records for your endpoint.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the endpoint.
        """
        ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of IP addresses for your endpoint.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        TCP port of the endpoint.
        """
elif False:
    InstancePrivateNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstancePrivateNetworkArgs:
    def __init__(__self__, *,
                 pn_id: pulumi.Input[_builtins.str],
                 dns_records: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] pn_id: The ID of the Private Network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_records: List of DNS records for your endpoint.
        :param pulumi.Input[_builtins.str] id: The ID of the endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ips: List of IP addresses for your endpoint.
        :param pulumi.Input[_builtins.int] port: TCP port of the endpoint.
        """
        pulumi.set(__self__, "pn_id", pn_id)
        if dns_records is not None:
            pulumi.set(__self__, "dns_records", dns_records)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Private Network.
        """
        return pulumi.get(self, "pn_id")

    @pn_id.setter
    def pn_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pn_id", value)

    @_builtins.property
    @pulumi.getter(name="dnsRecords")
    def dns_records(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of DNS records for your endpoint.
        """
        return pulumi.get(self, "dns_records")

    @dns_records.setter
    def dns_records(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_records", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IP addresses for your endpoint.
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ips", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class InstancePublicNetworkArgsDict(TypedDict):
        dns_record: NotRequired[pulumi.Input[_builtins.str]]
        """
        The DNS record of your endpoint
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the endpoint.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        TCP port of the endpoint.
        """
elif False:
    InstancePublicNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstancePublicNetworkArgs:
    def __init__(__self__, *,
                 dns_record: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] dns_record: The DNS record of your endpoint
        :param pulumi.Input[_builtins.str] id: The ID of the endpoint.
        :param pulumi.Input[_builtins.int] port: TCP port of the endpoint.
        """
        if dns_record is not None:
            pulumi.set(__self__, "dns_record", dns_record)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="dnsRecord")
    def dns_record(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DNS record of your endpoint
        """
        return pulumi.get(self, "dns_record")

    @dns_record.setter
    def dns_record(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_record", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class UserRoleArgsDict(TypedDict):
        role: pulumi.Input[_builtins.str]
        """
        The role name. Valid values are `read`, `read_write`, `db_admin`, `sync`.
        """
        any_database: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Apply the role to all databases. Cannot be used with `database_name`.
        """
        database_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The database name for the role. Cannot be used with `any_database`.
        """
elif False:
    UserRoleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UserRoleArgs:
    def __init__(__self__, *,
                 role: pulumi.Input[_builtins.str],
                 any_database: Optional[pulumi.Input[_builtins.bool]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] role: The role name. Valid values are `read`, `read_write`, `db_admin`, `sync`.
        :param pulumi.Input[_builtins.bool] any_database: Apply the role to all databases. Cannot be used with `database_name`.
        :param pulumi.Input[_builtins.str] database_name: The database name for the role. Cannot be used with `any_database`.
        """
        pulumi.set(__self__, "role", role)
        if any_database is not None:
            pulumi.set(__self__, "any_database", any_database)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        The role name. Valid values are `read`, `read_write`, `db_admin`, `sync`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="anyDatabase")
    def any_database(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Apply the role to all databases. Cannot be used with `database_name`.
        """
        return pulumi.get(self, "any_database")

    @any_database.setter
    def any_database(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "any_database", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database name for the role. Cannot be used with `any_database`.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)


