# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'InstancePrivateIp',
    'InstancePrivateNetwork',
    'InstancePublicNetwork',
    'UserRole',
    'GetInstancePrivateIpResult',
    'GetInstancePrivateNetworkResult',
    'GetInstancePublicNetworkResult',
]

@pulumi.output_type
class InstancePrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The private IPv4 address.
        :param _builtins.str id: The ID of the endpoint.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The private IPv4 address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class InstancePrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pnId":
            suggest = "pn_id"
        elif key == "dnsRecords":
            suggest = "dns_records"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pn_id: _builtins.str,
                 dns_records: Optional[Sequence[_builtins.str]] = None,
                 id: Optional[_builtins.str] = None,
                 ips: Optional[Sequence[_builtins.str]] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str pn_id: The ID of the Private Network.
        :param Sequence[_builtins.str] dns_records: List of DNS records for your endpoint.
        :param _builtins.str id: The ID of the endpoint.
        :param Sequence[_builtins.str] ips: List of IP addresses for your endpoint.
        :param _builtins.int port: TCP port of the endpoint.
        """
        pulumi.set(__self__, "pn_id", pn_id)
        if dns_records is not None:
            pulumi.set(__self__, "dns_records", dns_records)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> _builtins.str:
        """
        The ID of the Private Network.
        """
        return pulumi.get(self, "pn_id")

    @_builtins.property
    @pulumi.getter(name="dnsRecords")
    def dns_records(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of DNS records for your endpoint.
        """
        return pulumi.get(self, "dns_records")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of IP addresses for your endpoint.
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class InstancePublicNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsRecord":
            suggest = "dns_record"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePublicNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePublicNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePublicNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_record: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str dns_record: The DNS record of your endpoint
        :param _builtins.str id: The ID of the endpoint.
        :param _builtins.int port: TCP port of the endpoint.
        """
        if dns_record is not None:
            pulumi.set(__self__, "dns_record", dns_record)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="dnsRecord")
    def dns_record(self) -> Optional[_builtins.str]:
        """
        The DNS record of your endpoint
        """
        return pulumi.get(self, "dns_record")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class UserRole(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "anyDatabase":
            suggest = "any_database"
        elif key == "databaseName":
            suggest = "database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserRole. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserRole.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserRole.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role: _builtins.str,
                 any_database: Optional[_builtins.bool] = None,
                 database_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str role: The role name. Valid values are `read`, `read_write`, `db_admin`, `sync`.
        :param _builtins.bool any_database: Apply the role to all databases. Cannot be used with `database_name`.
        :param _builtins.str database_name: The database name for the role. Cannot be used with `any_database`.
        """
        pulumi.set(__self__, "role", role)
        if any_database is not None:
            pulumi.set(__self__, "any_database", any_database)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        The role name. Valid values are `read`, `read_write`, `db_admin`, `sync`.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="anyDatabase")
    def any_database(self) -> Optional[_builtins.bool]:
        """
        Apply the role to all databases. Cannot be used with `database_name`.
        """
        return pulumi.get(self, "any_database")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[_builtins.str]:
        """
        The database name for the role. Cannot be used with `any_database`.
        """
        return pulumi.get(self, "database_name")


@pulumi.output_type
class GetInstancePrivateIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The private IPv4 address
        :param _builtins.str id: The ID of the MongoDB® Instance.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The private IPv4 address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the MongoDB® Instance.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetInstancePrivateNetworkResult(dict):
    def __init__(__self__, *,
                 dns_records: Sequence[_builtins.str],
                 id: _builtins.str,
                 ips: Sequence[_builtins.str],
                 pn_id: _builtins.str,
                 port: _builtins.int):
        """
        :param Sequence[_builtins.str] dns_records: List of DNS records for your endpoint
        :param _builtins.str id: The ID of the MongoDB® Instance.
        :param Sequence[_builtins.str] ips: List of IP addresses for your endpoint
        :param _builtins.str pn_id: The private network ID
        :param _builtins.int port: TCP port of the endpoint
        """
        pulumi.set(__self__, "dns_records", dns_records)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "pn_id", pn_id)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="dnsRecords")
    def dns_records(self) -> Sequence[_builtins.str]:
        """
        List of DNS records for your endpoint
        """
        return pulumi.get(self, "dns_records")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the MongoDB® Instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Sequence[_builtins.str]:
        """
        List of IP addresses for your endpoint
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> _builtins.str:
        """
        The private network ID
        """
        return pulumi.get(self, "pn_id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        TCP port of the endpoint
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetInstancePublicNetworkResult(dict):
    def __init__(__self__, *,
                 dns_record: _builtins.str,
                 id: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str dns_record: The DNS record of your endpoint
        :param _builtins.str id: The ID of the MongoDB® Instance.
        :param _builtins.int port: TCP port of the endpoint
        """
        pulumi.set(__self__, "dns_record", dns_record)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="dnsRecord")
    def dns_record(self) -> _builtins.str:
        """
        The DNS record of your endpoint
        """
        return pulumi.get(self, "dns_record")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the MongoDB® Instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        TCP port of the endpoint
        """
        return pulumi.get(self, "port")


