# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AclArgs', 'Acl']

@pulumi.input_type
class AclArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[_builtins.str],
                 default_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 is_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleArgs']]]] = None):
        """
        The set of arguments for constructing a Acl resource.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID the ACL belongs to.
        :param pulumi.Input[_builtins.str] default_policy: The action to take for packets which do not match any rules.
        :param pulumi.Input[_builtins.bool] is_ipv6: Defines whether this set of ACL rules is for IPv6 (false = IPv4). Each Network ACL can have rules for only one IP type.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the ACL.
        :param pulumi.Input[Sequence[pulumi.Input['AclRuleArgs']]] rules: The list of Network ACL rules.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if default_policy is not None:
            pulumi.set(__self__, "default_policy", default_policy)
        if is_ipv6 is not None:
            pulumi.set(__self__, "is_ipv6", is_ipv6)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The VPC ID the ACL belongs to.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultPolicy")
    def default_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action to take for packets which do not match any rules.
        """
        return pulumi.get(self, "default_policy")

    @default_policy.setter
    def default_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_policy", value)

    @_builtins.property
    @pulumi.getter(name="isIpv6")
    def is_ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether this set of ACL rules is for IPv6 (false = IPv4). Each Network ACL can have rules for only one IP type.
        """
        return pulumi.get(self, "is_ipv6")

    @is_ipv6.setter
    def is_ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_ipv6", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region of the ACL.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleArgs']]]]:
        """
        The list of Network ACL rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _AclState:
    def __init__(__self__, *,
                 default_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 is_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleArgs']]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Acl resources.
        :param pulumi.Input[_builtins.str] default_policy: The action to take for packets which do not match any rules.
        :param pulumi.Input[_builtins.bool] is_ipv6: Defines whether this set of ACL rules is for IPv6 (false = IPv4). Each Network ACL can have rules for only one IP type.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the ACL.
        :param pulumi.Input[Sequence[pulumi.Input['AclRuleArgs']]] rules: The list of Network ACL rules.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID the ACL belongs to.
        """
        if default_policy is not None:
            pulumi.set(__self__, "default_policy", default_policy)
        if is_ipv6 is not None:
            pulumi.set(__self__, "is_ipv6", is_ipv6)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="defaultPolicy")
    def default_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action to take for packets which do not match any rules.
        """
        return pulumi.get(self, "default_policy")

    @default_policy.setter
    def default_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_policy", value)

    @_builtins.property
    @pulumi.getter(name="isIpv6")
    def is_ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether this set of ACL rules is for IPv6 (false = IPv4). Each Network ACL can have rules for only one IP type.
        """
        return pulumi.get(self, "is_ipv6")

    @is_ipv6.setter
    def is_ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_ipv6", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region of the ACL.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleArgs']]]]:
        """
        The list of Network ACL rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID the ACL belongs to.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("scaleway:network/acl:Acl")
class Acl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 is_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclRuleArgs', 'AclRuleArgsDict']]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway VPC ACLs.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="tf-vpc-acl")
        acl01 = scaleway.network.Acl("acl01",
            vpc_id=vpc01.id,
            is_ipv6=False,
            rules=[{
                "protocol": "TCP",
                "src_port_low": 0,
                "src_port_high": 0,
                "dst_port_low": 80,
                "dst_port_high": 80,
                "source": "0.0.0.0/0",
                "destination": "0.0.0.0/0",
                "description": "Allow HTTP traffic from any source",
                "action": "accept",
            }],
            default_policy="drop")
        ```

        ## Import

        ACLs can be imported using `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:network/acl:Acl main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_policy: The action to take for packets which do not match any rules.
        :param pulumi.Input[_builtins.bool] is_ipv6: Defines whether this set of ACL rules is for IPv6 (false = IPv4). Each Network ACL can have rules for only one IP type.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the ACL.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AclRuleArgs', 'AclRuleArgsDict']]]] rules: The list of Network ACL rules.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID the ACL belongs to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway VPC ACLs.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="tf-vpc-acl")
        acl01 = scaleway.network.Acl("acl01",
            vpc_id=vpc01.id,
            is_ipv6=False,
            rules=[{
                "protocol": "TCP",
                "src_port_low": 0,
                "src_port_high": 0,
                "dst_port_low": 80,
                "dst_port_high": 80,
                "source": "0.0.0.0/0",
                "destination": "0.0.0.0/0",
                "description": "Allow HTTP traffic from any source",
                "action": "accept",
            }],
            default_policy="drop")
        ```

        ## Import

        ACLs can be imported using `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:network/acl:Acl main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param AclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 is_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclRuleArgs', 'AclRuleArgsDict']]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclArgs.__new__(AclArgs)

            __props__.__dict__["default_policy"] = default_policy
            __props__.__dict__["is_ipv6"] = is_ipv6
            __props__.__dict__["region"] = region
            __props__.__dict__["rules"] = rules
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
        super(Acl, __self__).__init__(
            'scaleway:network/acl:Acl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_policy: Optional[pulumi.Input[_builtins.str]] = None,
            is_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclRuleArgs', 'AclRuleArgsDict']]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Acl':
        """
        Get an existing Acl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_policy: The action to take for packets which do not match any rules.
        :param pulumi.Input[_builtins.bool] is_ipv6: Defines whether this set of ACL rules is for IPv6 (false = IPv4). Each Network ACL can have rules for only one IP type.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the ACL.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AclRuleArgs', 'AclRuleArgsDict']]]] rules: The list of Network ACL rules.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID the ACL belongs to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclState.__new__(_AclState)

        __props__.__dict__["default_policy"] = default_policy
        __props__.__dict__["is_ipv6"] = is_ipv6
        __props__.__dict__["region"] = region
        __props__.__dict__["rules"] = rules
        __props__.__dict__["vpc_id"] = vpc_id
        return Acl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultPolicy")
    def default_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The action to take for packets which do not match any rules.
        """
        return pulumi.get(self, "default_policy")

    @_builtins.property
    @pulumi.getter(name="isIpv6")
    def is_ipv6(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Defines whether this set of ACL rules is for IPv6 (false = IPv4). Each Network ACL can have rules for only one IP type.
        """
        return pulumi.get(self, "is_ipv6")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `region`) The region of the ACL.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.AclRule']]]:
        """
        The list of Network ACL rules.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC ID the ACL belongs to.
        """
        return pulumi.get(self, "vpc_id")

