# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AclRule',
    'GatewayNetworkIpamConfig',
    'GatewayNetworkPrivateIp',
    'PrivateNetworkIpv4Subnet',
    'PrivateNetworkIpv6Subnet',
    'GetGatewayNetworkIpamConfigResult',
    'GetGatewayNetworkPrivateIpResult',
    'GetPrivateNetworkIpv4SubnetResult',
    'GetPrivateNetworkIpv6SubnetResult',
    'GetRoutesRouteResult',
    'GetVpcsVpcResult',
]

@pulumi.output_type
class AclRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dstPortHigh":
            suggest = "dst_port_high"
        elif key == "dstPortLow":
            suggest = "dst_port_low"
        elif key == "srcPortHigh":
            suggest = "src_port_high"
        elif key == "srcPortLow":
            suggest = "src_port_low"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None,
                 destination: Optional[_builtins.str] = None,
                 dst_port_high: Optional[_builtins.int] = None,
                 dst_port_low: Optional[_builtins.int] = None,
                 protocol: Optional[_builtins.str] = None,
                 source: Optional[_builtins.str] = None,
                 src_port_high: Optional[_builtins.int] = None,
                 src_port_low: Optional[_builtins.int] = None):
        """
        :param _builtins.str action: The policy to apply to the packet.
        :param _builtins.str description: The rule description.
        :param _builtins.str destination: The destination IP range to which this rule applies (CIDR notation with subnet mask).
        :param _builtins.int dst_port_high: The ending port of the destination port range to which this rule applies (inclusive).
        :param _builtins.int dst_port_low: The starting port of the destination port range to which this rule applies (inclusive).
        :param _builtins.str protocol: The protocol to which this rule applies. Default value: ANY.
        :param _builtins.str source: The Source IP range to which this rule applies (CIDR notation with subnet mask).
        :param _builtins.int src_port_high: The ending port of the source port range to which this rule applies (inclusive).
        :param _builtins.int src_port_low: The starting port of the source port range to which this rule applies (inclusive).
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if dst_port_high is not None:
            pulumi.set(__self__, "dst_port_high", dst_port_high)
        if dst_port_low is not None:
            pulumi.set(__self__, "dst_port_low", dst_port_low)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if src_port_high is not None:
            pulumi.set(__self__, "src_port_high", src_port_high)
        if src_port_low is not None:
            pulumi.set(__self__, "src_port_low", src_port_low)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        The policy to apply to the packet.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The rule description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[_builtins.str]:
        """
        The destination IP range to which this rule applies (CIDR notation with subnet mask).
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter(name="dstPortHigh")
    def dst_port_high(self) -> Optional[_builtins.int]:
        """
        The ending port of the destination port range to which this rule applies (inclusive).
        """
        return pulumi.get(self, "dst_port_high")

    @_builtins.property
    @pulumi.getter(name="dstPortLow")
    def dst_port_low(self) -> Optional[_builtins.int]:
        """
        The starting port of the destination port range to which this rule applies (inclusive).
        """
        return pulumi.get(self, "dst_port_low")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        The protocol to which this rule applies. Default value: ANY.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[_builtins.str]:
        """
        The Source IP range to which this rule applies (CIDR notation with subnet mask).
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="srcPortHigh")
    def src_port_high(self) -> Optional[_builtins.int]:
        """
        The ending port of the source port range to which this rule applies (inclusive).
        """
        return pulumi.get(self, "src_port_high")

    @_builtins.property
    @pulumi.getter(name="srcPortLow")
    def src_port_low(self) -> Optional[_builtins.int]:
        """
        The starting port of the source port range to which this rule applies (inclusive).
        """
        return pulumi.get(self, "src_port_low")


@pulumi.output_type
class GatewayNetworkIpamConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipamIpId":
            suggest = "ipam_ip_id"
        elif key == "pushDefaultRoute":
            suggest = "push_default_route"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayNetworkIpamConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayNetworkIpamConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayNetworkIpamConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipam_ip_id: Optional[_builtins.str] = None,
                 push_default_route: Optional[_builtins.bool] = None):
        """
        :param _builtins.str ipam_ip_id: Use this IPAM-booked IP ID as the Gateway's IP in this Private Network.
        :param _builtins.bool push_default_route: Defines whether to enable the default route on the GatewayNetwork.
        """
        if ipam_ip_id is not None:
            pulumi.set(__self__, "ipam_ip_id", ipam_ip_id)
        if push_default_route is not None:
            pulumi.set(__self__, "push_default_route", push_default_route)

    @_builtins.property
    @pulumi.getter(name="ipamIpId")
    def ipam_ip_id(self) -> Optional[_builtins.str]:
        """
        Use this IPAM-booked IP ID as the Gateway's IP in this Private Network.
        """
        return pulumi.get(self, "ipam_ip_id")

    @_builtins.property
    @pulumi.getter(name="pushDefaultRoute")
    def push_default_route(self) -> Optional[_builtins.bool]:
        """
        Defines whether to enable the default route on the GatewayNetwork.
        """
        return pulumi.get(self, "push_default_route")


@pulumi.output_type
class GatewayNetworkPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The private IPv4 address.
        :param _builtins.str id: The ID of the IPv4 address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The private IPv4 address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IPv4 address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateNetworkIpv4Subnet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "prefixLength":
            suggest = "prefix_length"
        elif key == "subnetMask":
            suggest = "subnet_mask"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateNetworkIpv4Subnet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateNetworkIpv4Subnet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateNetworkIpv4Subnet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 created_at: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 prefix_length: Optional[_builtins.int] = None,
                 subnet: Optional[_builtins.str] = None,
                 subnet_mask: Optional[_builtins.str] = None,
                 updated_at: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The network address of the subnet in hexadecimal notation, e.g., '2001:db8::' for a '2001:db8::/64' subnet.
        :param _builtins.str created_at: The date and time of the creation of the subnet.
        :param _builtins.str id: The subnet ID.
        :param _builtins.int prefix_length: The length of the network prefix, e.g., 64 for a 'ffff:ffff:ffff:ffff::' mask.
        :param _builtins.str subnet: The subnet CIDR.
        :param _builtins.str subnet_mask: The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        :param _builtins.str updated_at: The date and time of the last update of the subnet.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if subnet_mask is not None:
            pulumi.set(__self__, "subnet_mask", subnet_mask)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The network address of the subnet in hexadecimal notation, e.g., '2001:db8::' for a '2001:db8::/64' subnet.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[_builtins.str]:
        """
        The date and time of the creation of the subnet.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The subnet ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[_builtins.int]:
        """
        The length of the network prefix, e.g., 64 for a 'ffff:ffff:ffff:ffff::' mask.
        """
        return pulumi.get(self, "prefix_length")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[_builtins.str]:
        """
        The subnet CIDR.
        """
        return pulumi.get(self, "subnet")

    @_builtins.property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> Optional[_builtins.str]:
        """
        The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        """
        return pulumi.get(self, "subnet_mask")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[_builtins.str]:
        """
        The date and time of the last update of the subnet.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class PrivateNetworkIpv6Subnet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "prefixLength":
            suggest = "prefix_length"
        elif key == "subnetMask":
            suggest = "subnet_mask"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateNetworkIpv6Subnet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateNetworkIpv6Subnet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateNetworkIpv6Subnet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 created_at: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 prefix_length: Optional[_builtins.int] = None,
                 subnet: Optional[_builtins.str] = None,
                 subnet_mask: Optional[_builtins.str] = None,
                 updated_at: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The network address of the subnet in hexadecimal notation, e.g., '2001:db8::' for a '2001:db8::/64' subnet.
        :param _builtins.str created_at: The date and time of the creation of the subnet.
        :param _builtins.str id: The subnet ID.
        :param _builtins.int prefix_length: The length of the network prefix, e.g., 64 for a 'ffff:ffff:ffff:ffff::' mask.
        :param _builtins.str subnet: The subnet CIDR.
        :param _builtins.str subnet_mask: The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        :param _builtins.str updated_at: The date and time of the last update of the subnet.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if subnet_mask is not None:
            pulumi.set(__self__, "subnet_mask", subnet_mask)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The network address of the subnet in hexadecimal notation, e.g., '2001:db8::' for a '2001:db8::/64' subnet.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[_builtins.str]:
        """
        The date and time of the creation of the subnet.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The subnet ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[_builtins.int]:
        """
        The length of the network prefix, e.g., 64 for a 'ffff:ffff:ffff:ffff::' mask.
        """
        return pulumi.get(self, "prefix_length")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[_builtins.str]:
        """
        The subnet CIDR.
        """
        return pulumi.get(self, "subnet")

    @_builtins.property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> Optional[_builtins.str]:
        """
        The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        """
        return pulumi.get(self, "subnet_mask")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[_builtins.str]:
        """
        The date and time of the last update of the subnet.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetGatewayNetworkIpamConfigResult(dict):
    def __init__(__self__, *,
                 ipam_ip_id: _builtins.str,
                 push_default_route: _builtins.bool):
        """
        :param _builtins.str ipam_ip_id: Use this IPAM-booked IP ID as the Gateway's IP in this Private Network
        :param _builtins.bool push_default_route: Defines whether the default route is enabled on that Gateway Network
        """
        pulumi.set(__self__, "ipam_ip_id", ipam_ip_id)
        pulumi.set(__self__, "push_default_route", push_default_route)

    @_builtins.property
    @pulumi.getter(name="ipamIpId")
    def ipam_ip_id(self) -> _builtins.str:
        """
        Use this IPAM-booked IP ID as the Gateway's IP in this Private Network
        """
        return pulumi.get(self, "ipam_ip_id")

    @_builtins.property
    @pulumi.getter(name="pushDefaultRoute")
    def push_default_route(self) -> _builtins.bool:
        """
        Defines whether the default route is enabled on that Gateway Network
        """
        return pulumi.get(self, "push_default_route")


@pulumi.output_type
class GetGatewayNetworkPrivateIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The private IPv4 address.
        :param _builtins.str id: The ID of the IPv4 address resource.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The private IPv4 address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the IPv4 address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetPrivateNetworkIpv4SubnetResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 created_at: _builtins.str,
                 id: _builtins.str,
                 prefix_length: _builtins.int,
                 subnet: _builtins.str,
                 subnet_mask: _builtins.str,
                 updated_at: _builtins.str):
        """
        :param _builtins.str address: The network address of the subnet in dotted decimal notation, e.g., '192.168.0.0' for a '192.168.0.0/24' subnet
        :param _builtins.str created_at: The date and time of the creation of the subnet
        :param _builtins.str id: The ID of the Private Network.
        :param _builtins.int prefix_length: The length of the network prefix, e.g., 24 for a 255.255.255.0 mask
        :param _builtins.str subnet: The subnet CIDR
        :param _builtins.str subnet_mask: The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        :param _builtins.str updated_at: The date and time of the last update of the subnet
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "prefix_length", prefix_length)
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "subnet_mask", subnet_mask)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The network address of the subnet in dotted decimal notation, e.g., '192.168.0.0' for a '192.168.0.0/24' subnet
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date and time of the creation of the subnet
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Private Network.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> _builtins.int:
        """
        The length of the network prefix, e.g., 24 for a 255.255.255.0 mask
        """
        return pulumi.get(self, "prefix_length")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> _builtins.str:
        """
        The subnet CIDR
        """
        return pulumi.get(self, "subnet")

    @_builtins.property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> _builtins.str:
        """
        The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        """
        return pulumi.get(self, "subnet_mask")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The date and time of the last update of the subnet
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetPrivateNetworkIpv6SubnetResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 created_at: _builtins.str,
                 id: _builtins.str,
                 prefix_length: _builtins.int,
                 subnet: _builtins.str,
                 subnet_mask: _builtins.str,
                 updated_at: _builtins.str):
        """
        :param _builtins.str address: The network address of the subnet in dotted decimal notation, e.g., '192.168.0.0' for a '192.168.0.0/24' subnet
        :param _builtins.str created_at: The date and time of the creation of the subnet
        :param _builtins.str id: The ID of the Private Network.
        :param _builtins.int prefix_length: The length of the network prefix, e.g., 24 for a 255.255.255.0 mask
        :param _builtins.str subnet: The subnet CIDR
        :param _builtins.str subnet_mask: The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        :param _builtins.str updated_at: The date and time of the last update of the subnet
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "prefix_length", prefix_length)
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "subnet_mask", subnet_mask)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The network address of the subnet in dotted decimal notation, e.g., '192.168.0.0' for a '192.168.0.0/24' subnet
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date and time of the creation of the subnet
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Private Network.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> _builtins.int:
        """
        The length of the network prefix, e.g., 24 for a 255.255.255.0 mask
        """
        return pulumi.get(self, "prefix_length")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> _builtins.str:
        """
        The subnet CIDR
        """
        return pulumi.get(self, "subnet")

    @_builtins.property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> _builtins.str:
        """
        The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        """
        return pulumi.get(self, "subnet_mask")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The date and time of the last update of the subnet
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetRoutesRouteResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 description: _builtins.str,
                 destination: _builtins.str,
                 id: _builtins.str,
                 nexthop_ip: _builtins.str,
                 nexthop_name: _builtins.str,
                 nexthop_private_network_id: _builtins.str,
                 nexthop_resource_id: _builtins.str,
                 nexthop_resource_type: _builtins.str,
                 tags: Sequence[_builtins.str],
                 vpc_id: _builtins.str,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str created_at: The date on which the route was created (RFC 3339 format).
        :param _builtins.str description: The description of the route.
        :param _builtins.str destination: The destination IP or IP range of the route.
        :param _builtins.str id: The ID of the route.
               > **Important:** route IDs are regional, which means they are of the form `{region}/{id}`, e.g. `fr-par/11111111-1111-1111-1111-111111111111
        :param _builtins.str nexthop_ip: The IP of the route's next hop.
        :param _builtins.str nexthop_name: The name of the route's next hop.
        :param _builtins.str nexthop_private_network_id: The next hop private network ID to filter for. routes with a similar next hop private network ID are listed.
        :param _builtins.str nexthop_resource_id: The next hop resource ID to filter for. routes with a similar next hop resource ID are listed.
        :param _builtins.str nexthop_resource_type: The next hop resource type to filter for. routes with a similar next hop resource type are listed.
        :param Sequence[_builtins.str] tags: List of tags to filter for. routes with these exact tags are listed.
        :param _builtins.str vpc_id: The VPC ID to filter for. routes with a similar VPC ID are listed.
        :param _builtins.str region: `region`). The region in which the routes exist.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "nexthop_ip", nexthop_ip)
        pulumi.set(__self__, "nexthop_name", nexthop_name)
        pulumi.set(__self__, "nexthop_private_network_id", nexthop_private_network_id)
        pulumi.set(__self__, "nexthop_resource_id", nexthop_resource_id)
        pulumi.set(__self__, "nexthop_resource_type", nexthop_resource_type)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date on which the route was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the route.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        """
        The destination IP or IP range of the route.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the route.
        > **Important:** route IDs are regional, which means they are of the form `{region}/{id}`, e.g. `fr-par/11111111-1111-1111-1111-111111111111
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="nexthopIp")
    def nexthop_ip(self) -> _builtins.str:
        """
        The IP of the route's next hop.
        """
        return pulumi.get(self, "nexthop_ip")

    @_builtins.property
    @pulumi.getter(name="nexthopName")
    def nexthop_name(self) -> _builtins.str:
        """
        The name of the route's next hop.
        """
        return pulumi.get(self, "nexthop_name")

    @_builtins.property
    @pulumi.getter(name="nexthopPrivateNetworkId")
    def nexthop_private_network_id(self) -> _builtins.str:
        """
        The next hop private network ID to filter for. routes with a similar next hop private network ID are listed.
        """
        return pulumi.get(self, "nexthop_private_network_id")

    @_builtins.property
    @pulumi.getter(name="nexthopResourceId")
    def nexthop_resource_id(self) -> _builtins.str:
        """
        The next hop resource ID to filter for. routes with a similar next hop resource ID are listed.
        """
        return pulumi.get(self, "nexthop_resource_id")

    @_builtins.property
    @pulumi.getter(name="nexthopResourceType")
    def nexthop_resource_type(self) -> _builtins.str:
        """
        The next hop resource type to filter for. routes with a similar next hop resource type are listed.
        """
        return pulumi.get(self, "nexthop_resource_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        List of tags to filter for. routes with these exact tags are listed.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The VPC ID to filter for. routes with a similar VPC ID are listed.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        `region`). The region in which the routes exist.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetVpcsVpcResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 id: _builtins.str,
                 is_default: _builtins.bool,
                 name: _builtins.str,
                 organization_id: _builtins.str,
                 project_id: _builtins.str,
                 tags: Sequence[_builtins.str],
                 update_at: _builtins.str,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str created_at: Date and time of VPC's creation (RFC 3339 format).
        :param _builtins.str id: The associated VPC ID.
               > **Important:** VPC IDs are regional, which means they are of the form `{region}/{id}`, e.g. `fr-par/11111111-1111-1111-1111-111111111111
        :param _builtins.bool is_default: Defines whether the VPC is the default one for its Project.
        :param _builtins.str name: The VPC name to filter for. VPCs with a similar name are listed.
        :param _builtins.str organization_id: The Organization ID the VPC is associated with.
        :param _builtins.str project_id: The ID of the Project the VPC is associated with.
        :param Sequence[_builtins.str] tags: List of tags to filter for. VPCs with these exact tags are listed.
        :param _builtins.str update_at: Date on which the VPC was last updated (RFC 3339 format)
        :param _builtins.str region: `region`). The region in which the VPCs exist.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "update_at", update_at)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Date and time of VPC's creation (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The associated VPC ID.
        > **Important:** VPC IDs are regional, which means they are of the form `{region}/{id}`, e.g. `fr-par/11111111-1111-1111-1111-111111111111
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Defines whether the VPC is the default one for its Project.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The VPC name to filter for. VPCs with a similar name are listed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        The Organization ID the VPC is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The ID of the Project the VPC is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        List of tags to filter for. VPCs with these exact tags are listed.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updateAt")
    def update_at(self) -> _builtins.str:
        """
        Date on which the VPC was last updated (RFC 3339 format)
        """
        return pulumi.get(self, "update_at")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        `region`). The region in which the VPCs exist.
        """
        return pulumi.get(self, "region")


