# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VpcArgs', 'Vpc']

@pulumi.input_type
class VpcArgs:
    def __init__(__self__, *,
                 enable_custom_routes_propagation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_routing: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Vpc resource.
        :param pulumi.Input[_builtins.bool] enable_custom_routes_propagation: Defines whether the VPC advertises custom routes between its Private Networks. Note that you will not be able to deactivate it afterwards.
        :param pulumi.Input[_builtins.bool] enable_routing: Enable routing between Private Networks in the VPC. Note that you will not be able to deactivate it afterwards.
        :param pulumi.Input[_builtins.str] name: The name for the VPC. If not provided it will be randomly generated.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the VPC is associated with.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the VPC.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags to associate with the VPC.
        """
        if enable_custom_routes_propagation is not None:
            pulumi.set(__self__, "enable_custom_routes_propagation", enable_custom_routes_propagation)
        if enable_routing is not None:
            pulumi.set(__self__, "enable_routing", enable_routing)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="enableCustomRoutesPropagation")
    def enable_custom_routes_propagation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether the VPC advertises custom routes between its Private Networks. Note that you will not be able to deactivate it afterwards.
        """
        return pulumi.get(self, "enable_custom_routes_propagation")

    @enable_custom_routes_propagation.setter
    def enable_custom_routes_propagation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_custom_routes_propagation", value)

    @_builtins.property
    @pulumi.getter(name="enableRouting")
    def enable_routing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable routing between Private Networks in the VPC. Note that you will not be able to deactivate it afterwards.
        """
        return pulumi.get(self, "enable_routing")

    @enable_routing.setter
    def enable_routing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_routing", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the VPC. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project the VPC is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region of the VPC.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags to associate with the VPC.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _VpcState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_custom_routes_propagation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_routing: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Vpc resources.
        :param pulumi.Input[_builtins.str] created_at: Date and time of VPC's creation (RFC 3339 format).
        :param pulumi.Input[_builtins.bool] enable_custom_routes_propagation: Defines whether the VPC advertises custom routes between its Private Networks. Note that you will not be able to deactivate it afterwards.
        :param pulumi.Input[_builtins.bool] enable_routing: Enable routing between Private Networks in the VPC. Note that you will not be able to deactivate it afterwards.
        :param pulumi.Input[_builtins.bool] is_default: Defines whether the VPC is the default one for its Project.
        :param pulumi.Input[_builtins.str] name: The name for the VPC. If not provided it will be randomly generated.
        :param pulumi.Input[_builtins.str] organization_id: The Organization ID the VPC is associated with.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the VPC is associated with.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the VPC.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags to associate with the VPC.
        :param pulumi.Input[_builtins.str] updated_at: Date and time of VPC's last update (RFC 3339 format).
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if enable_custom_routes_propagation is not None:
            pulumi.set(__self__, "enable_custom_routes_propagation", enable_custom_routes_propagation)
        if enable_routing is not None:
            pulumi.set(__self__, "enable_routing", enable_routing)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time of VPC's creation (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="enableCustomRoutesPropagation")
    def enable_custom_routes_propagation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether the VPC advertises custom routes between its Private Networks. Note that you will not be able to deactivate it afterwards.
        """
        return pulumi.get(self, "enable_custom_routes_propagation")

    @enable_custom_routes_propagation.setter
    def enable_custom_routes_propagation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_custom_routes_propagation", value)

    @_builtins.property
    @pulumi.getter(name="enableRouting")
    def enable_routing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable routing between Private Networks in the VPC. Note that you will not be able to deactivate it afterwards.
        """
        return pulumi.get(self, "enable_routing")

    @enable_routing.setter
    def enable_routing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_routing", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether the VPC is the default one for its Project.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the VPC. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Organization ID the VPC is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project the VPC is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region of the VPC.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags to associate with the VPC.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time of VPC's last update (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("scaleway:network/vpc:Vpc")
class Vpc(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_custom_routes_propagation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_routing: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Virtual Private Clouds.
        For more information, see [the main documentation](https://www.scaleway.com/en/docs/vpc/concepts/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01",
            name="my-vpc",
            tags=[
                "demo",
                "terraform",
            ])
        ```

        ### Enable routing

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01",
            name="my-vpc",
            tags=[
                "demo",
                "terraform",
                "routing",
            ],
            enable_routing=True)
        ```

        ## Import

        VPCs can be imported using `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:network/vpc:Vpc vpc_demo fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enable_custom_routes_propagation: Defines whether the VPC advertises custom routes between its Private Networks. Note that you will not be able to deactivate it afterwards.
        :param pulumi.Input[_builtins.bool] enable_routing: Enable routing between Private Networks in the VPC. Note that you will not be able to deactivate it afterwards.
        :param pulumi.Input[_builtins.str] name: The name for the VPC. If not provided it will be randomly generated.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the VPC is associated with.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the VPC.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags to associate with the VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[VpcArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Virtual Private Clouds.
        For more information, see [the main documentation](https://www.scaleway.com/en/docs/vpc/concepts/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01",
            name="my-vpc",
            tags=[
                "demo",
                "terraform",
            ])
        ```

        ### Enable routing

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01",
            name="my-vpc",
            tags=[
                "demo",
                "terraform",
                "routing",
            ],
            enable_routing=True)
        ```

        ## Import

        VPCs can be imported using `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:network/vpc:Vpc vpc_demo fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param VpcArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_custom_routes_propagation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_routing: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcArgs.__new__(VpcArgs)

            __props__.__dict__["enable_custom_routes_propagation"] = enable_custom_routes_propagation
            __props__.__dict__["enable_routing"] = enable_routing
            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["created_at"] = None
            __props__.__dict__["is_default"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/vpc:Vpc")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Vpc, __self__).__init__(
            'scaleway:network/vpc:Vpc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            enable_custom_routes_propagation: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_routing: Optional[pulumi.Input[_builtins.bool]] = None,
            is_default: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'Vpc':
        """
        Get an existing Vpc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: Date and time of VPC's creation (RFC 3339 format).
        :param pulumi.Input[_builtins.bool] enable_custom_routes_propagation: Defines whether the VPC advertises custom routes between its Private Networks. Note that you will not be able to deactivate it afterwards.
        :param pulumi.Input[_builtins.bool] enable_routing: Enable routing between Private Networks in the VPC. Note that you will not be able to deactivate it afterwards.
        :param pulumi.Input[_builtins.bool] is_default: Defines whether the VPC is the default one for its Project.
        :param pulumi.Input[_builtins.str] name: The name for the VPC. If not provided it will be randomly generated.
        :param pulumi.Input[_builtins.str] organization_id: The Organization ID the VPC is associated with.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the VPC is associated with.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the VPC.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags to associate with the VPC.
        :param pulumi.Input[_builtins.str] updated_at: Date and time of VPC's last update (RFC 3339 format).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcState.__new__(_VpcState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["enable_custom_routes_propagation"] = enable_custom_routes_propagation
        __props__.__dict__["enable_routing"] = enable_routing
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        return Vpc(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time of VPC's creation (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="enableCustomRoutesPropagation")
    def enable_custom_routes_propagation(self) -> pulumi.Output[_builtins.bool]:
        """
        Defines whether the VPC advertises custom routes between its Private Networks. Note that you will not be able to deactivate it afterwards.
        """
        return pulumi.get(self, "enable_custom_routes_propagation")

    @_builtins.property
    @pulumi.getter(name="enableRouting")
    def enable_routing(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable routing between Private Networks in the VPC. Note that you will not be able to deactivate it afterwards.
        """
        return pulumi.get(self, "enable_routing")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[_builtins.bool]:
        """
        Defines whether the VPC is the default one for its Project.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the VPC. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Organization ID the VPC is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the Project the VPC is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `region`) The region of the VPC.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The tags to associate with the VPC.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time of VPC's last update (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

