# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetResult',
    'AwaitableGetResult',
    'get',
    'get_output',
]

@pulumi.output_type
class GetResult:
    """
    A collection of values returned by get.
    """
    def __init__(__self__, bucket=None, content=None, content_base64=None, content_type=None, file=None, hash=None, id=None, key=None, metadata=None, project_id=None, region=None, sse_customer_key=None, storage_class=None, tags=None, visibility=None):
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if content_base64 and not isinstance(content_base64, str):
            raise TypeError("Expected argument 'content_base64' to be a str")
        pulumi.set(__self__, "content_base64", content_base64)
        if content_type and not isinstance(content_type, str):
            raise TypeError("Expected argument 'content_type' to be a str")
        pulumi.set(__self__, "content_type", content_type)
        if file and not isinstance(file, str):
            raise TypeError("Expected argument 'file' to be a str")
        pulumi.set(__self__, "file", file)
        if hash and not isinstance(hash, str):
            raise TypeError("Expected argument 'hash' to be a str")
        pulumi.set(__self__, "hash", hash)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if sse_customer_key and not isinstance(sse_customer_key, str):
            raise TypeError("Expected argument 'sse_customer_key' to be a str")
        pulumi.set(__self__, "sse_customer_key", sse_customer_key)
        if storage_class and not isinstance(storage_class, str):
            raise TypeError("Expected argument 'storage_class' to be a str")
        pulumi.set(__self__, "storage_class", storage_class)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if visibility and not isinstance(visibility, str):
            raise TypeError("Expected argument 'visibility' to be a str")
        pulumi.set(__self__, "visibility", visibility)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> _builtins.str:
        return pulumi.get(self, "content_base64")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def file(self) -> _builtins.str:
        return pulumi.get(self, "file")

    @_builtins.property
    @pulumi.getter
    def hash(self) -> _builtins.str:
        return pulumi.get(self, "hash")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sseCustomerKey")
    def sse_customer_key(self) -> _builtins.str:
        return pulumi.get(self, "sse_customer_key")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> _builtins.str:
        return pulumi.get(self, "visibility")


class AwaitableGetResult(GetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResult(
            bucket=self.bucket,
            content=self.content,
            content_base64=self.content_base64,
            content_type=self.content_type,
            file=self.file,
            hash=self.hash,
            id=self.id,
            key=self.key,
            metadata=self.metadata,
            project_id=self.project_id,
            region=self.region,
            sse_customer_key=self.sse_customer_key,
            storage_class=self.storage_class,
            tags=self.tags,
            visibility=self.visibility)


def get(bucket: Optional[_builtins.str] = None,
        key: Optional[_builtins.str] = None,
        project_id: Optional[_builtins.str] = None,
        region: Optional[_builtins.str] = None,
        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResult:
    """
    The `object.Item` data source is used to retrieve information about an Object Storage object.

    Refer to the Object Storage [documentation](https://www.scaleway.com/en/docs/object-storage/how-to/create-a-bucket/) for more information.

    ## Retrieve an Object Storage object

    The following example demonstrates how to retrieve metadata about an object stored in a bucket:

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    main = scaleway.object.Bucket("main", name="bucket.test.com")
    example = scaleway.object.Item("example",
        bucket=main.name,
        key="example.txt",
        content="Hello world!")
    selected = scaleway.object.get_output(bucket=example.bucket,
        key=example.key)
    ```


    :param _builtins.str key: The key (path or filename) of the object within the bucket.
    :param _builtins.str project_id: `project_id`) The ID of the project with which the bucket is associated.
    :param _builtins.str region: `region`) The region in which the bucket exists.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['key'] = key
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:object/get:get', __args__, opts=opts, typ=GetResult).value

    return AwaitableGetResult(
        bucket=pulumi.get(__ret__, 'bucket'),
        content=pulumi.get(__ret__, 'content'),
        content_base64=pulumi.get(__ret__, 'content_base64'),
        content_type=pulumi.get(__ret__, 'content_type'),
        file=pulumi.get(__ret__, 'file'),
        hash=pulumi.get(__ret__, 'hash'),
        id=pulumi.get(__ret__, 'id'),
        key=pulumi.get(__ret__, 'key'),
        metadata=pulumi.get(__ret__, 'metadata'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'),
        sse_customer_key=pulumi.get(__ret__, 'sse_customer_key'),
        storage_class=pulumi.get(__ret__, 'storage_class'),
        tags=pulumi.get(__ret__, 'tags'),
        visibility=pulumi.get(__ret__, 'visibility'))
def get_output(bucket: Optional[pulumi.Input[_builtins.str]] = None,
               key: Optional[pulumi.Input[_builtins.str]] = None,
               project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
               region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResult]:
    """
    The `object.Item` data source is used to retrieve information about an Object Storage object.

    Refer to the Object Storage [documentation](https://www.scaleway.com/en/docs/object-storage/how-to/create-a-bucket/) for more information.

    ## Retrieve an Object Storage object

    The following example demonstrates how to retrieve metadata about an object stored in a bucket:

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    main = scaleway.object.Bucket("main", name="bucket.test.com")
    example = scaleway.object.Item("example",
        bucket=main.name,
        key="example.txt",
        content="Hello world!")
    selected = scaleway.object.get_output(bucket=example.bucket,
        key=example.key)
    ```


    :param _builtins.str key: The key (path or filename) of the object within the bucket.
    :param _builtins.str project_id: `project_id`) The ID of the project with which the bucket is associated.
    :param _builtins.str region: `region`) The region in which the bucket exists.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['key'] = key
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:object/get:get', __args__, opts=opts, typ=GetResult)
    return __ret__.apply(lambda __response__: GetResult(
        bucket=pulumi.get(__response__, 'bucket'),
        content=pulumi.get(__response__, 'content'),
        content_base64=pulumi.get(__response__, 'content_base64'),
        content_type=pulumi.get(__response__, 'content_type'),
        file=pulumi.get(__response__, 'file'),
        hash=pulumi.get(__response__, 'hash'),
        id=pulumi.get(__response__, 'id'),
        key=pulumi.get(__response__, 'key'),
        metadata=pulumi.get(__response__, 'metadata'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region'),
        sse_customer_key=pulumi.get(__response__, 'sse_customer_key'),
        storage_class=pulumi.get(__response__, 'storage_class'),
        tags=pulumi.get(__response__, 'tags'),
        visibility=pulumi.get(__response__, 'visibility')))
