# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ObjectItemArgs', 'ObjectItem']

@pulumi.input_type
class ObjectItemArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 key: pulumi.Input[_builtins.str],
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 file: Optional[pulumi.Input[_builtins.str]] = None,
                 hash: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sse_customer_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ObjectItem resource.
        :param pulumi.Input[_builtins.str] bucket: The bucket's name or regional ID.
        :param pulumi.Input[_builtins.str] key: The path to the object.
        :param pulumi.Input[_builtins.str] content: The content of the file to upload. Only one of `file`, `content` or `content_base64` can be defined.
        :param pulumi.Input[_builtins.str] content_base64: The base64-encoded content of the file to upload. Only one of `file`, `content` or `content_base64` can be defined.
               
               > **Note:** Only one of `file`, `content` or `content_base64` can be defined.
        :param pulumi.Input[_builtins.str] content_type: The standard MIME type of the object's content (e.g., 'application/json', 'text/plain'). This specifies how the object should be interpreted by clients. See RFC 9110: https://www.rfc-editor.org/rfc/rfc9110.html#name-content-type
        :param pulumi.Input[_builtins.str] file: The name of the file to upload, defaults to an empty file.
        :param pulumi.Input[_builtins.str] hash: Hash of the file, used to trigger the upload on file change.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Map of metadata used for the object (keys must be lowercase).
        :param pulumi.Input[_builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[_builtins.str] region: The Scaleway region the bucket resides in.
        :param pulumi.Input[_builtins.str] sse_customer_key: Customer's encryption keys to encrypt data (SSE-C)
        :param pulumi.Input[_builtins.str] storage_class: Specifies the Scaleway [storage class](https://www.scaleway.com/en/docs/object-storage/concepts/#storage-class) (`STANDARD`, `GLACIER`, or `ONEZONE_IA`) used to store the object.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags.
        :param pulumi.Input[_builtins.str] visibility: Visibility of the object, `public-read` or `private`.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_base64 is not None:
            pulumi.set(__self__, "content_base64", content_base64)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if hash is not None:
            pulumi.set(__self__, "hash", hash)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sse_customer_key is not None:
            pulumi.set(__self__, "sse_customer_key", sse_customer_key)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        The bucket's name or regional ID.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The path to the object.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the file to upload. Only one of `file`, `content` or `content_base64` can be defined.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded content of the file to upload. Only one of `file`, `content` or `content_base64` can be defined.

        > **Note:** Only one of `file`, `content` or `content_base64` can be defined.
        """
        return pulumi.get(self, "content_base64")

    @content_base64.setter
    def content_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_base64", value)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The standard MIME type of the object's content (e.g., 'application/json', 'text/plain'). This specifies how the object should be interpreted by clients. See RFC 9110: https://www.rfc-editor.org/rfc/rfc9110.html#name-content-type
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_type", value)

    @_builtins.property
    @pulumi.getter
    def file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the file to upload, defaults to an empty file.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file", value)

    @_builtins.property
    @pulumi.getter
    def hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Hash of the file, used to trigger the upload on file change.
        """
        return pulumi.get(self, "hash")

    @hash.setter
    def hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hash", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of metadata used for the object (keys must be lowercase).
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Scaleway region the bucket resides in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sseCustomerKey")
    def sse_customer_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Customer's encryption keys to encrypt data (SSE-C)
        """
        return pulumi.get(self, "sse_customer_key")

    @sse_customer_key.setter
    def sse_customer_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sse_customer_key", value)

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Scaleway [storage class](https://www.scaleway.com/en/docs/object-storage/concepts/#storage-class) (`STANDARD`, `GLACIER`, or `ONEZONE_IA`) used to store the object.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_class", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Visibility of the object, `public-read` or `private`.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "visibility", value)


@pulumi.input_type
class _ObjectItemState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 file: Optional[pulumi.Input[_builtins.str]] = None,
                 hash: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sse_customer_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ObjectItem resources.
        :param pulumi.Input[_builtins.str] bucket: The bucket's name or regional ID.
        :param pulumi.Input[_builtins.str] content: The content of the file to upload. Only one of `file`, `content` or `content_base64` can be defined.
        :param pulumi.Input[_builtins.str] content_base64: The base64-encoded content of the file to upload. Only one of `file`, `content` or `content_base64` can be defined.
               
               > **Note:** Only one of `file`, `content` or `content_base64` can be defined.
        :param pulumi.Input[_builtins.str] content_type: The standard MIME type of the object's content (e.g., 'application/json', 'text/plain'). This specifies how the object should be interpreted by clients. See RFC 9110: https://www.rfc-editor.org/rfc/rfc9110.html#name-content-type
        :param pulumi.Input[_builtins.str] file: The name of the file to upload, defaults to an empty file.
        :param pulumi.Input[_builtins.str] hash: Hash of the file, used to trigger the upload on file change.
        :param pulumi.Input[_builtins.str] key: The path to the object.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Map of metadata used for the object (keys must be lowercase).
        :param pulumi.Input[_builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[_builtins.str] region: The Scaleway region the bucket resides in.
        :param pulumi.Input[_builtins.str] sse_customer_key: Customer's encryption keys to encrypt data (SSE-C)
        :param pulumi.Input[_builtins.str] storage_class: Specifies the Scaleway [storage class](https://www.scaleway.com/en/docs/object-storage/concepts/#storage-class) (`STANDARD`, `GLACIER`, or `ONEZONE_IA`) used to store the object.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags.
        :param pulumi.Input[_builtins.str] visibility: Visibility of the object, `public-read` or `private`.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_base64 is not None:
            pulumi.set(__self__, "content_base64", content_base64)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if hash is not None:
            pulumi.set(__self__, "hash", hash)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sse_customer_key is not None:
            pulumi.set(__self__, "sse_customer_key", sse_customer_key)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bucket's name or regional ID.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the file to upload. Only one of `file`, `content` or `content_base64` can be defined.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded content of the file to upload. Only one of `file`, `content` or `content_base64` can be defined.

        > **Note:** Only one of `file`, `content` or `content_base64` can be defined.
        """
        return pulumi.get(self, "content_base64")

    @content_base64.setter
    def content_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_base64", value)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The standard MIME type of the object's content (e.g., 'application/json', 'text/plain'). This specifies how the object should be interpreted by clients. See RFC 9110: https://www.rfc-editor.org/rfc/rfc9110.html#name-content-type
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_type", value)

    @_builtins.property
    @pulumi.getter
    def file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the file to upload, defaults to an empty file.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file", value)

    @_builtins.property
    @pulumi.getter
    def hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Hash of the file, used to trigger the upload on file change.
        """
        return pulumi.get(self, "hash")

    @hash.setter
    def hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hash", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the object.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of metadata used for the object (keys must be lowercase).
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Scaleway region the bucket resides in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sseCustomerKey")
    def sse_customer_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Customer's encryption keys to encrypt data (SSE-C)
        """
        return pulumi.get(self, "sse_customer_key")

    @sse_customer_key.setter
    def sse_customer_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sse_customer_key", value)

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Scaleway [storage class](https://www.scaleway.com/en/docs/object-storage/concepts/#storage-class) (`STANDARD`, `GLACIER`, or `ONEZONE_IA`) used to store the object.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_class", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Visibility of the object, `public-read` or `private`.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "visibility", value)


warnings.warn("""scaleway.index/objectitem.ObjectItem has been deprecated in favor of scaleway.object/item.Item""", DeprecationWarning)


@pulumi.type_token("scaleway:index/objectItem:ObjectItem")
class ObjectItem(pulumi.CustomResource):
    warnings.warn("""scaleway.index/objectitem.ObjectItem has been deprecated in favor of scaleway.object/item.Item""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 file: Optional[pulumi.Input[_builtins.str]] = None,
                 hash: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sse_customer_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `object.Item` resource allows you to create and manage objects for [Scaleway Object storage](https://www.scaleway.com/en/docs/object-storage/).

        Refer to the [dedicated documentation](https://www.scaleway.com/en/docs/object-storage/how-to/upload-files-into-a-bucket/) for more information on Object Storage objects.

        ## Import

        Objects can be imported using the `{region}/{bucketName}/{objectKey}` identifier, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:index/objectItem:ObjectItem some_object fr-par/some-bucket/some-file
        ```

        ~> **Important:** The `project_id` attribute has a particular behavior with s3 products because the s3 API is scoped by project.

        If you are using a project different from the default one, you have to specify the project ID at the end of the import command.

        bash

        ```sh
        $ pulumi import scaleway:index/objectItem:ObjectItem some_object fr-par/some-bucket/some-file@xxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: The bucket's name or regional ID.
        :param pulumi.Input[_builtins.str] content: The content of the file to upload. Only one of `file`, `content` or `content_base64` can be defined.
        :param pulumi.Input[_builtins.str] content_base64: The base64-encoded content of the file to upload. Only one of `file`, `content` or `content_base64` can be defined.
               
               > **Note:** Only one of `file`, `content` or `content_base64` can be defined.
        :param pulumi.Input[_builtins.str] content_type: The standard MIME type of the object's content (e.g., 'application/json', 'text/plain'). This specifies how the object should be interpreted by clients. See RFC 9110: https://www.rfc-editor.org/rfc/rfc9110.html#name-content-type
        :param pulumi.Input[_builtins.str] file: The name of the file to upload, defaults to an empty file.
        :param pulumi.Input[_builtins.str] hash: Hash of the file, used to trigger the upload on file change.
        :param pulumi.Input[_builtins.str] key: The path to the object.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Map of metadata used for the object (keys must be lowercase).
        :param pulumi.Input[_builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[_builtins.str] region: The Scaleway region the bucket resides in.
        :param pulumi.Input[_builtins.str] sse_customer_key: Customer's encryption keys to encrypt data (SSE-C)
        :param pulumi.Input[_builtins.str] storage_class: Specifies the Scaleway [storage class](https://www.scaleway.com/en/docs/object-storage/concepts/#storage-class) (`STANDARD`, `GLACIER`, or `ONEZONE_IA`) used to store the object.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags.
        :param pulumi.Input[_builtins.str] visibility: Visibility of the object, `public-read` or `private`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ObjectItemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `object.Item` resource allows you to create and manage objects for [Scaleway Object storage](https://www.scaleway.com/en/docs/object-storage/).

        Refer to the [dedicated documentation](https://www.scaleway.com/en/docs/object-storage/how-to/upload-files-into-a-bucket/) for more information on Object Storage objects.

        ## Import

        Objects can be imported using the `{region}/{bucketName}/{objectKey}` identifier, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:index/objectItem:ObjectItem some_object fr-par/some-bucket/some-file
        ```

        ~> **Important:** The `project_id` attribute has a particular behavior with s3 products because the s3 API is scoped by project.

        If you are using a project different from the default one, you have to specify the project ID at the end of the import command.

        bash

        ```sh
        $ pulumi import scaleway:index/objectItem:ObjectItem some_object fr-par/some-bucket/some-file@xxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param ObjectItemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ObjectItemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 file: Optional[pulumi.Input[_builtins.str]] = None,
                 hash: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sse_customer_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""ObjectItem is deprecated: scaleway.index/objectitem.ObjectItem has been deprecated in favor of scaleway.object/item.Item""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ObjectItemArgs.__new__(ObjectItemArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["content"] = content
            __props__.__dict__["content_base64"] = content_base64
            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["file"] = file
            __props__.__dict__["hash"] = hash
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["sse_customer_key"] = None if sse_customer_key is None else pulumi.Output.secret(sse_customer_key)
            __props__.__dict__["storage_class"] = storage_class
            __props__.__dict__["tags"] = tags
            __props__.__dict__["visibility"] = visibility
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["sseCustomerKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ObjectItem, __self__).__init__(
            'scaleway:index/objectItem:ObjectItem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            content_base64: Optional[pulumi.Input[_builtins.str]] = None,
            content_type: Optional[pulumi.Input[_builtins.str]] = None,
            file: Optional[pulumi.Input[_builtins.str]] = None,
            hash: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            sse_customer_key: Optional[pulumi.Input[_builtins.str]] = None,
            storage_class: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            visibility: Optional[pulumi.Input[_builtins.str]] = None) -> 'ObjectItem':
        """
        Get an existing ObjectItem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: The bucket's name or regional ID.
        :param pulumi.Input[_builtins.str] content: The content of the file to upload. Only one of `file`, `content` or `content_base64` can be defined.
        :param pulumi.Input[_builtins.str] content_base64: The base64-encoded content of the file to upload. Only one of `file`, `content` or `content_base64` can be defined.
               
               > **Note:** Only one of `file`, `content` or `content_base64` can be defined.
        :param pulumi.Input[_builtins.str] content_type: The standard MIME type of the object's content (e.g., 'application/json', 'text/plain'). This specifies how the object should be interpreted by clients. See RFC 9110: https://www.rfc-editor.org/rfc/rfc9110.html#name-content-type
        :param pulumi.Input[_builtins.str] file: The name of the file to upload, defaults to an empty file.
        :param pulumi.Input[_builtins.str] hash: Hash of the file, used to trigger the upload on file change.
        :param pulumi.Input[_builtins.str] key: The path to the object.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Map of metadata used for the object (keys must be lowercase).
        :param pulumi.Input[_builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[_builtins.str] region: The Scaleway region the bucket resides in.
        :param pulumi.Input[_builtins.str] sse_customer_key: Customer's encryption keys to encrypt data (SSE-C)
        :param pulumi.Input[_builtins.str] storage_class: Specifies the Scaleway [storage class](https://www.scaleway.com/en/docs/object-storage/concepts/#storage-class) (`STANDARD`, `GLACIER`, or `ONEZONE_IA`) used to store the object.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags.
        :param pulumi.Input[_builtins.str] visibility: Visibility of the object, `public-read` or `private`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ObjectItemState.__new__(_ObjectItemState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["content"] = content
        __props__.__dict__["content_base64"] = content_base64
        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["file"] = file
        __props__.__dict__["hash"] = hash
        __props__.__dict__["key"] = key
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["sse_customer_key"] = sse_customer_key
        __props__.__dict__["storage_class"] = storage_class
        __props__.__dict__["tags"] = tags
        __props__.__dict__["visibility"] = visibility
        return ObjectItem(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        The bucket's name or regional ID.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The content of the file to upload. Only one of `file`, `content` or `content_base64` can be defined.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The base64-encoded content of the file to upload. Only one of `file`, `content` or `content_base64` can be defined.

        > **Note:** Only one of `file`, `content` or `content_base64` can be defined.
        """
        return pulumi.get(self, "content_base64")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[_builtins.str]:
        """
        The standard MIME type of the object's content (e.g., 'application/json', 'text/plain'). This specifies how the object should be interpreted by clients. See RFC 9110: https://www.rfc-editor.org/rfc/rfc9110.html#name-content-type
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def file(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the file to upload, defaults to an empty file.
        """
        return pulumi.get(self, "file")

    @_builtins.property
    @pulumi.getter
    def hash(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Hash of the file, used to trigger the upload on file change.
        """
        return pulumi.get(self, "hash")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        The path to the object.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of metadata used for the object (keys must be lowercase).
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Scaleway region the bucket resides in.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sseCustomerKey")
    def sse_customer_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Customer's encryption keys to encrypt data (SSE-C)
        """
        return pulumi.get(self, "sse_customer_key")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Scaleway [storage class](https://www.scaleway.com/en/docs/object-storage/concepts/#storage-class) (`STANDARD`, `GLACIER`, or `ONEZONE_IA`) used to store the object.
        """
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[_builtins.str]:
        """
        Visibility of the object, `public-read` or `private`.
        """
        return pulumi.get(self, "visibility")

