# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSourcesResult',
    'AwaitableGetSourcesResult',
    'get_sources',
    'get_sources_output',
]

@pulumi.output_type
class GetSourcesResult:
    """
    A collection of values returned by getSources.
    """
    def __init__(__self__, created_at=None, id=None, name=None, origin=None, project_id=None, push_url=None, region=None, retention_days=None, sources=None, synchronized_with_grafana=None, type=None, updated_at=None, url=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if origin and not isinstance(origin, str):
            raise TypeError("Expected argument 'origin' to be a str")
        pulumi.set(__self__, "origin", origin)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if push_url and not isinstance(push_url, str):
            raise TypeError("Expected argument 'push_url' to be a str")
        pulumi.set(__self__, "push_url", push_url)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if retention_days and not isinstance(retention_days, int):
            raise TypeError("Expected argument 'retention_days' to be a int")
        pulumi.set(__self__, "retention_days", retention_days)
        if sources and not isinstance(sources, list):
            raise TypeError("Expected argument 'sources' to be a list")
        pulumi.set(__self__, "sources", sources)
        if synchronized_with_grafana and not isinstance(synchronized_with_grafana, bool):
            raise TypeError("Expected argument 'synchronized_with_grafana' to be a bool")
        pulumi.set(__self__, "synchronized_with_grafana", synchronized_with_grafana)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date and time of the creation of the cockpit datasource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the datasource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def origin(self) -> Optional[_builtins.str]:
        """
        The origin of the datasource.
        """
        return pulumi.get(self, "origin")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        The project ID of the data source.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="pushUrl")
    def push_url(self) -> _builtins.str:
        """
        The URL endpoint used for pushing data to the cockpit data source.
        """
        return pulumi.get(self, "push_url")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region of the data source.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> _builtins.int:
        """
        The number of days to retain data.
        """
        return pulumi.get(self, "retention_days")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetSourcesSourceResult']:
        """
        List of cockpit sources.
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter(name="synchronizedWithGrafana")
    def synchronized_with_grafana(self) -> _builtins.bool:
        """
        Indicates whether the data source is synchronized with Grafana.
        """
        return pulumi.get(self, "synchronized_with_grafana")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of the datasource.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The date and time of the last update of the cockpit datasource.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL of the datasource.
        """
        return pulumi.get(self, "url")


class AwaitableGetSourcesResult(GetSourcesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSourcesResult(
            created_at=self.created_at,
            id=self.id,
            name=self.name,
            origin=self.origin,
            project_id=self.project_id,
            push_url=self.push_url,
            region=self.region,
            retention_days=self.retention_days,
            sources=self.sources,
            synchronized_with_grafana=self.synchronized_with_grafana,
            type=self.type,
            updated_at=self.updated_at,
            url=self.url)


def get_sources(name: Optional[_builtins.str] = None,
                origin: Optional[_builtins.str] = None,
                project_id: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                type: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSourcesResult:
    """
    Gets information about multiple Cockpit data sources.

    ## Example Usage

    ### List all sources in a project

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    all = scaleway.observability.get_sources(project_id="11111111-1111-1111-1111-111111111111")
    ```

    ### Filter sources by type

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    metrics = scaleway.observability.get_sources(project_id="11111111-1111-1111-1111-111111111111",
        type="metrics")
    ```

    ### Filter sources by name

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    my_sources = scaleway.observability.get_sources(project_id="11111111-1111-1111-1111-111111111111",
        name="my-data-source")
    ```

    ### Filter sources by origin

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    external = scaleway.observability.get_sources(project_id="11111111-1111-1111-1111-111111111111",
        origin="external")
    ```

    ### List default Scaleway sources

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    default = scaleway.observability.get_sources(project_id="11111111-1111-1111-1111-111111111111",
        origin="scaleway")
    ```


    :param _builtins.str name: Filter sources by name.
    :param _builtins.str origin: Filter sources by origin. Possible values are: `scaleway`, `external`, `custom`.
    :param _builtins.str project_id: The project ID the cockpit sources are associated with.
    :param _builtins.str region: The region in which the cockpit sources are located.
    :param _builtins.str type: Filter sources by type. Possible values are: `metrics`, `logs`, `traces`.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['origin'] = origin
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:observability/getSources:getSources', __args__, opts=opts, typ=GetSourcesResult).value

    return AwaitableGetSourcesResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        origin=pulumi.get(__ret__, 'origin'),
        project_id=pulumi.get(__ret__, 'project_id'),
        push_url=pulumi.get(__ret__, 'push_url'),
        region=pulumi.get(__ret__, 'region'),
        retention_days=pulumi.get(__ret__, 'retention_days'),
        sources=pulumi.get(__ret__, 'sources'),
        synchronized_with_grafana=pulumi.get(__ret__, 'synchronized_with_grafana'),
        type=pulumi.get(__ret__, 'type'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        url=pulumi.get(__ret__, 'url'))
def get_sources_output(name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       origin: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSourcesResult]:
    """
    Gets information about multiple Cockpit data sources.

    ## Example Usage

    ### List all sources in a project

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    all = scaleway.observability.get_sources(project_id="11111111-1111-1111-1111-111111111111")
    ```

    ### Filter sources by type

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    metrics = scaleway.observability.get_sources(project_id="11111111-1111-1111-1111-111111111111",
        type="metrics")
    ```

    ### Filter sources by name

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    my_sources = scaleway.observability.get_sources(project_id="11111111-1111-1111-1111-111111111111",
        name="my-data-source")
    ```

    ### Filter sources by origin

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    external = scaleway.observability.get_sources(project_id="11111111-1111-1111-1111-111111111111",
        origin="external")
    ```

    ### List default Scaleway sources

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    default = scaleway.observability.get_sources(project_id="11111111-1111-1111-1111-111111111111",
        origin="scaleway")
    ```


    :param _builtins.str name: Filter sources by name.
    :param _builtins.str origin: Filter sources by origin. Possible values are: `scaleway`, `external`, `custom`.
    :param _builtins.str project_id: The project ID the cockpit sources are associated with.
    :param _builtins.str region: The region in which the cockpit sources are located.
    :param _builtins.str type: Filter sources by type. Possible values are: `metrics`, `logs`, `traces`.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['origin'] = origin
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:observability/getSources:getSources', __args__, opts=opts, typ=GetSourcesResult)
    return __ret__.apply(lambda __response__: GetSourcesResult(
        created_at=pulumi.get(__response__, 'created_at'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        origin=pulumi.get(__response__, 'origin'),
        project_id=pulumi.get(__response__, 'project_id'),
        push_url=pulumi.get(__response__, 'push_url'),
        region=pulumi.get(__response__, 'region'),
        retention_days=pulumi.get(__response__, 'retention_days'),
        sources=pulumi.get(__response__, 'sources'),
        synchronized_with_grafana=pulumi.get(__response__, 'synchronized_with_grafana'),
        type=pulumi.get(__response__, 'type'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        url=pulumi.get(__response__, 'url')))
