# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TokenArgs', 'Token']

@pulumi.input_type
class TokenArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input['TokenScopesArgs']] = None):
        """
        The set of arguments for constructing a Token resource.
        :param pulumi.Input[_builtins.str] name: The name of the token.
        :param pulumi.Input[_builtins.str] project_id: ) The ID of the Project the Cockpit is associated with.
        :param pulumi.Input[_builtins.str] region: ) The region where the Cockpit token is located.
        :param pulumi.Input['TokenScopesArgs'] scopes: Scopes allowed, each with default values:
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the token.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ) The ID of the Project the Cockpit is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ) The region where the Cockpit token is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input['TokenScopesArgs']]:
        """
        Scopes allowed, each with default values:
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input['TokenScopesArgs']]):
        pulumi.set(self, "scopes", value)


@pulumi.input_type
class _TokenState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input['TokenScopesArgs']] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Token resources.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the Cockpit Token (Format ISO 8601)
        :param pulumi.Input[_builtins.str] name: The name of the token.
        :param pulumi.Input[_builtins.str] project_id: ) The ID of the Project the Cockpit is associated with.
        :param pulumi.Input[_builtins.str] region: ) The region where the Cockpit token is located.
        :param pulumi.Input['TokenScopesArgs'] scopes: Scopes allowed, each with default values:
        :param pulumi.Input[_builtins.str] secret_key: The secret key of the token.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the Cockpit Token (Format ISO 8601)
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the creation of the Cockpit Token (Format ISO 8601)
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the token.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ) The ID of the Project the Cockpit is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ) The region where the Cockpit token is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input['TokenScopesArgs']]:
        """
        Scopes allowed, each with default values:
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input['TokenScopesArgs']]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret key of the token.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the last update of the Cockpit Token (Format ISO 8601)
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("scaleway:observability/token:Token")
class Token(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Union['TokenScopesArgs', 'TokenScopesArgsDict']]] = None,
                 __props__=None):
        """
        The `observability.Token` resource allows you to create and manage your Cockpit [tokens](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#tokens).

        Refer to Cockpit's [product documentation](https://www.scaleway.com/en/docs/observability/cockpit/concepts/) and [API documentation](https://www.scaleway.com/en/developers/api/cockpit/regional-api) for more information.

        ## Example Usage

        ### Use a Cockpit token

        The following commands allow you to:

        - create a Scaleway Project named `my-project`
        - create a Cockpit token named `my-awesome-token` inside the Project
        - assign `read` permissions to the token for metrics and logs
        - disable `write` permissions for metrics and logs

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        project = scaleway.account.Project("project", name="my-project")
        main = scaleway.observability.Token("main",
            project_id=project.id,
            name="my-awesome-token")
        ```

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        project = scaleway.account.Project("project", name="my-project")
        # Create a token that can read metrics and logs but not write
        main = scaleway.observability.Token("main",
            project_id=project.id,
            name="my-awesome-token",
            scopes={
                "query_metrics": True,
                "write_metrics": False,
                "query_logs": True,
                "write_logs": False,
            })
        ```

        ## Import

        This section explains how to import a Cockpit token using the `{region}/{id}` format.

        bash

        ```sh
        $ pulumi import scaleway:observability/token:Token main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the token.
        :param pulumi.Input[_builtins.str] project_id: ) The ID of the Project the Cockpit is associated with.
        :param pulumi.Input[_builtins.str] region: ) The region where the Cockpit token is located.
        :param pulumi.Input[Union['TokenScopesArgs', 'TokenScopesArgsDict']] scopes: Scopes allowed, each with default values:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TokenArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `observability.Token` resource allows you to create and manage your Cockpit [tokens](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#tokens).

        Refer to Cockpit's [product documentation](https://www.scaleway.com/en/docs/observability/cockpit/concepts/) and [API documentation](https://www.scaleway.com/en/developers/api/cockpit/regional-api) for more information.

        ## Example Usage

        ### Use a Cockpit token

        The following commands allow you to:

        - create a Scaleway Project named `my-project`
        - create a Cockpit token named `my-awesome-token` inside the Project
        - assign `read` permissions to the token for metrics and logs
        - disable `write` permissions for metrics and logs

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        project = scaleway.account.Project("project", name="my-project")
        main = scaleway.observability.Token("main",
            project_id=project.id,
            name="my-awesome-token")
        ```

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        project = scaleway.account.Project("project", name="my-project")
        # Create a token that can read metrics and logs but not write
        main = scaleway.observability.Token("main",
            project_id=project.id,
            name="my-awesome-token",
            scopes={
                "query_metrics": True,
                "write_metrics": False,
                "query_logs": True,
                "write_logs": False,
            })
        ```

        ## Import

        This section explains how to import a Cockpit token using the `{region}/{id}` format.

        bash

        ```sh
        $ pulumi import scaleway:observability/token:Token main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param TokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Union['TokenScopesArgs', 'TokenScopesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TokenArgs.__new__(TokenArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["scopes"] = scopes
            __props__.__dict__["created_at"] = None
            __props__.__dict__["secret_key"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/cockpitToken:CockpitToken")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Token, __self__).__init__(
            'scaleway:observability/token:Token',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            scopes: Optional[pulumi.Input[Union['TokenScopesArgs', 'TokenScopesArgsDict']]] = None,
            secret_key: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'Token':
        """
        Get an existing Token resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the Cockpit Token (Format ISO 8601)
        :param pulumi.Input[_builtins.str] name: The name of the token.
        :param pulumi.Input[_builtins.str] project_id: ) The ID of the Project the Cockpit is associated with.
        :param pulumi.Input[_builtins.str] region: ) The region where the Cockpit token is located.
        :param pulumi.Input[Union['TokenScopesArgs', 'TokenScopesArgsDict']] scopes: Scopes allowed, each with default values:
        :param pulumi.Input[_builtins.str] secret_key: The secret key of the token.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the Cockpit Token (Format ISO 8601)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TokenState.__new__(_TokenState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["secret_key"] = secret_key
        __props__.__dict__["updated_at"] = updated_at
        return Token(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the creation of the Cockpit Token (Format ISO 8601)
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the token.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        ) The ID of the Project the Cockpit is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ) The region where the Cockpit token is located.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> pulumi.Output['outputs.TokenScopes']:
        """
        Scopes allowed, each with default values:
        """
        return pulumi.get(self, "scopes")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[_builtins.str]:
        """
        The secret key of the token.
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the last update of the Cockpit Token (Format ISO 8601)
        """
        return pulumi.get(self, "updated_at")

