# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'AppleSiliconServerPrivateIp',
    'AppleSiliconServerPrivateNetwork',
    'BaremetalServerIp',
    'BaremetalServerIpv4',
    'BaremetalServerIpv6',
    'BaremetalServerOption',
    'BaremetalServerPrivateIp',
    'BaremetalServerPrivateNetwork',
    'BlockSnapshotExport',
    'BlockSnapshotImport',
    'CockpitAlertManagerContactPoint',
    'CockpitEndpoint',
    'CockpitPushUrl',
    'CockpitTokenScopes',
    'ContainerHealthCheck',
    'ContainerHealthCheckHttp',
    'ContainerScalingOption',
    'ContainerTriggerNats',
    'ContainerTriggerSqs',
    'DatabaseAclAclRule',
    'DatabaseInstanceLoadBalancer',
    'DatabaseInstanceLogsPolicy',
    'DatabaseInstancePrivateIp',
    'DatabaseInstancePrivateNetwork',
    'DatabaseInstanceReadReplica',
    'DatabaseInstanceUpgradableVersion',
    'DatabaseReadReplicaDirectAccess',
    'DatabaseReadReplicaPrivateNetwork',
    'DomainRecordGeoIp',
    'DomainRecordGeoIpMatch',
    'DomainRecordHttpService',
    'DomainRecordView',
    'DomainRecordWeighted',
    'EdgeServicesBackendStageLbBackendConfig',
    'EdgeServicesBackendStageLbBackendConfigLbConfig',
    'EdgeServicesBackendStageS3BackendConfig',
    'EdgeServicesCacheStagePurgeRequest',
    'EdgeServicesRouteStageRule',
    'EdgeServicesRouteStageRuleRuleHttpMatch',
    'EdgeServicesRouteStageRuleRuleHttpMatchPathFilter',
    'EdgeServicesTlsStageSecret',
    'FunctionTriggerNats',
    'FunctionTriggerSqs',
    'IamPolicyRule',
    'InferenceDeploymentPrivateEndpoint',
    'InferenceDeploymentPrivateIp',
    'InferenceDeploymentPublicEndpoint',
    'InstanceImageAdditionalVolume',
    'InstanceImageRootVolume',
    'InstancePrivateNicPrivateIp',
    'InstanceSecurityGroupInboundRule',
    'InstanceSecurityGroupOutboundRule',
    'InstanceSecurityGroupRulesInboundRule',
    'InstanceSecurityGroupRulesOutboundRule',
    'InstanceServerFilesystem',
    'InstanceServerPrivateIp',
    'InstanceServerPrivateNetwork',
    'InstanceServerPublicIp',
    'InstanceServerRootVolume',
    'InstanceSnapshotImport',
    'IotDeviceCertificate',
    'IotDeviceMessageFilters',
    'IotDeviceMessageFiltersPublish',
    'IotDeviceMessageFiltersSubscribe',
    'IotRouteDatabase',
    'IotRouteRest',
    'IotRouteS3',
    'IpamIpCustomResource',
    'IpamIpResource',
    'IpamIpReverse',
    'IpamIpSource',
    'JobDefinitionCron',
    'JobDefinitionSecretReference',
    'KeyManagerKeyRotationPolicy',
    'KubernetesClusterAutoUpgrade',
    'KubernetesClusterAutoscalerConfig',
    'KubernetesClusterKubeconfig',
    'KubernetesClusterOpenIdConnectConfig',
    'KubernetesNodePoolNode',
    'KubernetesNodePoolNodePrivateIp',
    'KubernetesNodePoolUpgradePolicy',
    'LoadbalancerAclAction',
    'LoadbalancerAclActionRedirect',
    'LoadbalancerAclMatch',
    'LoadbalancerBackendHealthCheckHttp',
    'LoadbalancerBackendHealthCheckHttps',
    'LoadbalancerBackendHealthCheckTcp',
    'LoadbalancerCertificateCustomCertificate',
    'LoadbalancerCertificateLetsencrypt',
    'LoadbalancerFrontendAcl',
    'LoadbalancerFrontendAclAction',
    'LoadbalancerFrontendAclActionRedirect',
    'LoadbalancerFrontendAclMatch',
    'LoadbalancerPrivateIp',
    'LoadbalancerPrivateNetwork',
    'MnqSnsCredentialsPermissions',
    'MnqSqsCredentialsPermissions',
    'MnqSqsQueueDeadLetterQueue',
    'MongoDbInstancePrivateIp',
    'MongoDbInstancePrivateNetwork',
    'MongoDbInstancePublicNetwork',
    'ObjectBucketAclAccessControlPolicy',
    'ObjectBucketAclAccessControlPolicyGrant',
    'ObjectBucketAclAccessControlPolicyGrantGrantee',
    'ObjectBucketAclAccessControlPolicyOwner',
    'ObjectBucketCorsRule',
    'ObjectBucketLifecycleRule',
    'ObjectBucketLifecycleRuleExpiration',
    'ObjectBucketLifecycleRuleTransition',
    'ObjectBucketLockConfigurationRule',
    'ObjectBucketLockConfigurationRuleDefaultRetention',
    'ObjectBucketVersioning',
    'ObjectBucketWebsiteConfigurationErrorDocument',
    'ObjectBucketWebsiteConfigurationIndexDocument',
    'RedisClusterAcl',
    'RedisClusterPrivateIp',
    'RedisClusterPrivateNetwork',
    'RedisClusterPublicNetwork',
    'SecretEphemeralPolicy',
    'SecretVersion',
    'TemDomainReputation',
    'VpcGatewayNetworkIpamConfig',
    'VpcGatewayNetworkPrivateIp',
    'VpcPrivateNetworkIpv4Subnet',
    'VpcPrivateNetworkIpv6Subnet',
    'WebhostingCpanelUrl',
    'WebhostingNameServer',
    'WebhostingOption',
    'WebhostingRecord',
    'GetBaremetalOfferCpuResult',
    'GetBaremetalOfferDiskResult',
    'GetBaremetalOfferMemoryResult',
    'GetBaremetalServerIpResult',
    'GetBaremetalServerIpv4Result',
    'GetBaremetalServerIpv6Result',
    'GetBaremetalServerOptionResult',
    'GetBaremetalServerPrivateIpResult',
    'GetBaremetalServerPrivateNetworkResult',
    'GetBillingConsumptionsConsumptionResult',
    'GetBillingInvoicesInvoiceResult',
    'GetBlockSnapshotExportResult',
    'GetBlockSnapshotImportResult',
    'GetCockpitEndpointResult',
    'GetCockpitPushUrlResult',
    'GetContainerHealthCheckResult',
    'GetContainerHealthCheckHttpResult',
    'GetContainerScalingOptionResult',
    'GetDatabaseAclAclRuleResult',
    'GetDatabaseInstanceLoadBalancerResult',
    'GetDatabaseInstanceLogsPolicyResult',
    'GetDatabaseInstancePrivateIpResult',
    'GetDatabaseInstancePrivateNetworkResult',
    'GetDatabaseInstanceReadReplicaResult',
    'GetDatabaseInstanceUpgradableVersionResult',
    'GetDomainRecordGeoIpResult',
    'GetDomainRecordGeoIpMatchResult',
    'GetDomainRecordHttpServiceResult',
    'GetDomainRecordViewResult',
    'GetDomainRecordWeightedResult',
    'GetFlexibleIpsIpResult',
    'GetFlexibleIpsIpMacAddressResult',
    'GetInstancePrivateNicPrivateIpResult',
    'GetInstanceSecurityGroupInboundRuleResult',
    'GetInstanceSecurityGroupOutboundRuleResult',
    'GetInstanceServerFilesystemResult',
    'GetInstanceServerPrivateIpResult',
    'GetInstanceServerPrivateNetworkResult',
    'GetInstanceServerPublicIpResult',
    'GetInstanceServerRootVolumeResult',
    'GetInstanceServersServerResult',
    'GetInstanceServersServerPrivateIpResult',
    'GetInstanceServersServerPublicIpResult',
    'GetInstanceSnapshotImportResult',
    'GetIotDeviceCertificateResult',
    'GetIotDeviceMessageFilterResult',
    'GetIotDeviceMessageFilterPublishResult',
    'GetIotDeviceMessageFilterSubscribeResult',
    'GetIpamIpResourceResult',
    'GetIpamIpsIpResult',
    'GetIpamIpsIpResourceResult',
    'GetIpamIpsResourceResult',
    'GetKubernetesClusterAutoUpgradeResult',
    'GetKubernetesClusterAutoscalerConfigResult',
    'GetKubernetesClusterKubeconfigResult',
    'GetKubernetesClusterOpenIdConnectConfigResult',
    'GetKubernetesNodePoolNodeResult',
    'GetKubernetesNodePoolNodePrivateIpResult',
    'GetKubernetesNodePoolUpgradePolicyResult',
    'GetLbAclsAclResult',
    'GetLbAclsAclActionResult',
    'GetLbAclsAclActionRedirectResult',
    'GetLbAclsAclMatchResult',
    'GetLbBackendHealthCheckHttpResult',
    'GetLbBackendHealthCheckTcpResult',
    'GetLbBackendsBackendResult',
    'GetLbBackendsBackendHealthCheckHttpResult',
    'GetLbBackendsBackendHealthCheckTcpResult',
    'GetLbFrontendAclResult',
    'GetLbFrontendAclActionResult',
    'GetLbFrontendAclActionRedirectResult',
    'GetLbFrontendAclMatchResult',
    'GetLbFrontendsFrontendResult',
    'GetLbIpsIpResult',
    'GetLbRoutesRouteResult',
    'GetLbsLbResult',
    'GetLbsLbInstanceResult',
    'GetLbsLbIpResult',
    'GetLoadbalancerCertificateCustomCertificateResult',
    'GetLoadbalancerCertificateLetsencryptResult',
    'GetLoadbalancerPrivateIpResult',
    'GetLoadbalancerPrivateNetworkResult',
    'GetMongoDbInstancePrivateIpResult',
    'GetMongoDbInstancePrivateNetworkResult',
    'GetMongoDbInstancePublicNetworkResult',
    'GetObjectBucketCorsRuleResult',
    'GetObjectBucketLifecycleRuleResult',
    'GetObjectBucketLifecycleRuleExpirationResult',
    'GetObjectBucketLifecycleRuleTransitionResult',
    'GetObjectBucketVersioningResult',
    'GetRedisClusterAclResult',
    'GetRedisClusterPrivateIpResult',
    'GetRedisClusterPrivateNetworkResult',
    'GetRedisClusterPublicNetworkResult',
    'GetSecretEphemeralPolicyResult',
    'GetSecretVersionResult',
    'GetTemDomainReputationResult',
    'GetVpcGatewayNetworkIpamConfigResult',
    'GetVpcGatewayNetworkPrivateIpResult',
    'GetVpcPrivateNetworkIpv4SubnetResult',
    'GetVpcPrivateNetworkIpv6SubnetResult',
    'GetVpcRoutesRouteResult',
    'GetVpcsVpcResult',
    'GetWebHostOfferOfferResult',
    'GetWebHostOfferOfferOptionResult',
    'GetWebHostOfferProductResult',
    'GetWebhostingCpanelUrlResult',
    'GetWebhostingNameServerResult',
    'GetWebhostingOptionResult',
    'GetWebhostingRecordResult',
]

@pulumi.output_type
class AppleSiliconServerPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The private IP address.
        :param _builtins.str id: The ID of the IP address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class AppleSiliconServerPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "ipamIpIds":
            suggest = "ipam_ip_ids"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppleSiliconServerPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppleSiliconServerPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppleSiliconServerPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 created_at: Optional[_builtins.str] = None,
                 ipam_ip_ids: Optional[Sequence[_builtins.str]] = None,
                 status: Optional[_builtins.str] = None,
                 updated_at: Optional[_builtins.str] = None,
                 vlan: Optional[_builtins.int] = None):
        """
        :param _builtins.str id: The private network ID
        :param _builtins.str created_at: The date and time the private network was created.
        :param Sequence[_builtins.str] ipam_ip_ids: A list of IPAM IP IDs to attach to the server.
        :param _builtins.str status: The current status of the private network.
        :param _builtins.str updated_at: The date and time the private network was last updated.
        :param _builtins.int vlan: The VLAN ID associated with the private network.
        """
        pulumi.set(__self__, "id", id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if ipam_ip_ids is not None:
            pulumi.set(__self__, "ipam_ip_ids", ipam_ip_ids)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The private network ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[_builtins.str]:
        """
        The date and time the private network was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="ipamIpIds")
    def ipam_ip_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of IPAM IP IDs to attach to the server.
        """
        return pulumi.get(self, "ipam_ip_ids")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The current status of the private network.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[_builtins.str]:
        """
        The date and time the private network was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def vlan(self) -> Optional[_builtins.int]:
        """
        The VLAN ID associated with the private network.
        """
        return pulumi.get(self, "vlan")


@pulumi.output_type
class BaremetalServerIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 reverse: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The address of the IPv6.
        :param _builtins.str id: The ID of the IPv6.
        :param _builtins.str reverse: The reverse of the IPv6.
        :param _builtins.str version: The type of the IPv6.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The address of the IPv6.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IPv6.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> Optional[_builtins.str]:
        """
        The reverse of the IPv6.
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The type of the IPv6.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class BaremetalServerIpv4(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 reverse: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The address of the IPv6.
        :param _builtins.str id: The ID of the IPv6.
        :param _builtins.str reverse: The reverse of the IPv6.
        :param _builtins.str version: The type of the IPv6.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The address of the IPv6.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IPv6.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> Optional[_builtins.str]:
        """
        The reverse of the IPv6.
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The type of the IPv6.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class BaremetalServerIpv6(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 reverse: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The address of the IPv6.
        :param _builtins.str id: The ID of the IPv6.
        :param _builtins.str reverse: The reverse of the IPv6.
        :param _builtins.str version: The type of the IPv6.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The address of the IPv6.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IPv6.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> Optional[_builtins.str]:
        """
        The reverse of the IPv6.
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The type of the IPv6.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class BaremetalServerOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiresAt":
            suggest = "expires_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BaremetalServerOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BaremetalServerOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BaremetalServerOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 expires_at: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The id of the option to enable. Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-options-list-options) to find the available options IDs.
        :param _builtins.str expires_at: The auto expiration date for compatible options
        :param _builtins.str name: The name of the server.
        """
        pulumi.set(__self__, "id", id)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the option to enable. Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-options-list-options) to find the available options IDs.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[_builtins.str]:
        """
        The auto expiration date for compatible options
        """
        return pulumi.get(self, "expires_at")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class BaremetalServerPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The address of the IPv6.
        :param _builtins.str id: The ID of the IPv6.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The address of the IPv6.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IPv6.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class BaremetalServerPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "ipamIpIds":
            suggest = "ipam_ip_ids"
        elif key == "mappingId":
            suggest = "mapping_id"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BaremetalServerPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BaremetalServerPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BaremetalServerPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 created_at: Optional[_builtins.str] = None,
                 ipam_ip_ids: Optional[Sequence[_builtins.str]] = None,
                 mapping_id: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 updated_at: Optional[_builtins.str] = None,
                 vlan: Optional[_builtins.int] = None):
        """
        :param _builtins.str id: The id of the private network to attach.
        :param _builtins.str created_at: The date and time of the creation of the private network.
        :param Sequence[_builtins.str] ipam_ip_ids: List of IPAM IP IDs to assign to the server in the requested private network.
        :param _builtins.str mapping_id: The ID of the Server-to-Private Network mapping.
        :param _builtins.str status: The private network status.
        :param _builtins.str updated_at: The date and time of the last update of the private network.
        :param _builtins.int vlan: The VLAN ID associated to the private network.
        """
        pulumi.set(__self__, "id", id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if ipam_ip_ids is not None:
            pulumi.set(__self__, "ipam_ip_ids", ipam_ip_ids)
        if mapping_id is not None:
            pulumi.set(__self__, "mapping_id", mapping_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the private network to attach.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[_builtins.str]:
        """
        The date and time of the creation of the private network.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="ipamIpIds")
    def ipam_ip_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of IPAM IP IDs to assign to the server in the requested private network.
        """
        return pulumi.get(self, "ipam_ip_ids")

    @_builtins.property
    @pulumi.getter(name="mappingId")
    def mapping_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Server-to-Private Network mapping.
        """
        return pulumi.get(self, "mapping_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The private network status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[_builtins.str]:
        """
        The date and time of the last update of the private network.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def vlan(self) -> Optional[_builtins.int]:
        """
        The VLAN ID associated to the private network.
        """
        return pulumi.get(self, "vlan")


@pulumi.output_type
class BlockSnapshotExport(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 key: _builtins.str):
        """
        :param _builtins.str bucket: The name of the bucket where the QCOW file will be saved.
        :param _builtins.str key: The desired key (path) for the QCOW file within the bucket.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of the bucket where the QCOW file will be saved.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The desired key (path) for the QCOW file within the bucket.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class BlockSnapshotImport(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 key: _builtins.str):
        """
        :param _builtins.str bucket: The name of the bucket containing the QCOW file.
        :param _builtins.str key: The key of the QCOW file within the bucket.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of the bucket containing the QCOW file.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key of the QCOW file within the bucket.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class CockpitAlertManagerContactPoint(dict):
    def __init__(__self__, *,
                 email: Optional[_builtins.str] = None):
        """
        :param _builtins.str email: Email addresses for the alert receivers
        """
        if email is not None:
            pulumi.set(__self__, "email", email)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[_builtins.str]:
        """
        Email addresses for the alert receivers
        """
        return pulumi.get(self, "email")


@pulumi.output_type
class CockpitEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertmanagerUrl":
            suggest = "alertmanager_url"
        elif key == "grafanaUrl":
            suggest = "grafana_url"
        elif key == "logsUrl":
            suggest = "logs_url"
        elif key == "metricsUrl":
            suggest = "metrics_url"
        elif key == "tracesUrl":
            suggest = "traces_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CockpitEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CockpitEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CockpitEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alertmanager_url: Optional[_builtins.str] = None,
                 grafana_url: Optional[_builtins.str] = None,
                 logs_url: Optional[_builtins.str] = None,
                 metrics_url: Optional[_builtins.str] = None,
                 traces_url: Optional[_builtins.str] = None):
        """
        :param _builtins.str alertmanager_url: (Deprecated) URL for the [Alert manager](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#alert-manager).
        :param _builtins.str grafana_url: (Deprecated) URL for Grafana.
        :param _builtins.str logs_url: (Deprecated) URL for [logs](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#logs) to retrieve in the [Data sources tab](https://console.scaleway.com/cockpit/dataSource) of the Scaleway console.
        :param _builtins.str metrics_url: (Deprecated) URL for [metrics](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#metric) to retrieve in the [Data sources tab](https://console.scaleway.com/cockpit/dataSource) of the Scaleway console.
        :param _builtins.str traces_url: (Deprecated) URL for [traces](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#traces) to retrieve in the [Data sources tab](https://console.scaleway.com/cockpit/dataSource) of the Scaleway console.
        """
        if alertmanager_url is not None:
            pulumi.set(__self__, "alertmanager_url", alertmanager_url)
        if grafana_url is not None:
            pulumi.set(__self__, "grafana_url", grafana_url)
        if logs_url is not None:
            pulumi.set(__self__, "logs_url", logs_url)
        if metrics_url is not None:
            pulumi.set(__self__, "metrics_url", metrics_url)
        if traces_url is not None:
            pulumi.set(__self__, "traces_url", traces_url)

    @_builtins.property
    @pulumi.getter(name="alertmanagerUrl")
    def alertmanager_url(self) -> Optional[_builtins.str]:
        """
        (Deprecated) URL for the [Alert manager](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#alert-manager).
        """
        return pulumi.get(self, "alertmanager_url")

    @_builtins.property
    @pulumi.getter(name="grafanaUrl")
    def grafana_url(self) -> Optional[_builtins.str]:
        """
        (Deprecated) URL for Grafana.
        """
        return pulumi.get(self, "grafana_url")

    @_builtins.property
    @pulumi.getter(name="logsUrl")
    def logs_url(self) -> Optional[_builtins.str]:
        """
        (Deprecated) URL for [logs](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#logs) to retrieve in the [Data sources tab](https://console.scaleway.com/cockpit/dataSource) of the Scaleway console.
        """
        return pulumi.get(self, "logs_url")

    @_builtins.property
    @pulumi.getter(name="metricsUrl")
    def metrics_url(self) -> Optional[_builtins.str]:
        """
        (Deprecated) URL for [metrics](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#metric) to retrieve in the [Data sources tab](https://console.scaleway.com/cockpit/dataSource) of the Scaleway console.
        """
        return pulumi.get(self, "metrics_url")

    @_builtins.property
    @pulumi.getter(name="tracesUrl")
    def traces_url(self) -> Optional[_builtins.str]:
        """
        (Deprecated) URL for [traces](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#traces) to retrieve in the [Data sources tab](https://console.scaleway.com/cockpit/dataSource) of the Scaleway console.
        """
        return pulumi.get(self, "traces_url")


@pulumi.output_type
class CockpitPushUrl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pushLogsUrl":
            suggest = "push_logs_url"
        elif key == "pushMetricsUrl":
            suggest = "push_metrics_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CockpitPushUrl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CockpitPushUrl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CockpitPushUrl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 push_logs_url: Optional[_builtins.str] = None,
                 push_metrics_url: Optional[_builtins.str] = None):
        """
        :param _builtins.str push_logs_url: Push URL for logs (Grafana Loki)
        :param _builtins.str push_metrics_url: Push URL for metrics (Grafana Mimir)
        """
        if push_logs_url is not None:
            pulumi.set(__self__, "push_logs_url", push_logs_url)
        if push_metrics_url is not None:
            pulumi.set(__self__, "push_metrics_url", push_metrics_url)

    @_builtins.property
    @pulumi.getter(name="pushLogsUrl")
    def push_logs_url(self) -> Optional[_builtins.str]:
        """
        Push URL for logs (Grafana Loki)
        """
        return pulumi.get(self, "push_logs_url")

    @_builtins.property
    @pulumi.getter(name="pushMetricsUrl")
    def push_metrics_url(self) -> Optional[_builtins.str]:
        """
        Push URL for metrics (Grafana Mimir)
        """
        return pulumi.get(self, "push_metrics_url")


@pulumi.output_type
class CockpitTokenScopes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryLogs":
            suggest = "query_logs"
        elif key == "queryMetrics":
            suggest = "query_metrics"
        elif key == "queryTraces":
            suggest = "query_traces"
        elif key == "setupAlerts":
            suggest = "setup_alerts"
        elif key == "setupLogsRules":
            suggest = "setup_logs_rules"
        elif key == "setupMetricsRules":
            suggest = "setup_metrics_rules"
        elif key == "writeLogs":
            suggest = "write_logs"
        elif key == "writeMetrics":
            suggest = "write_metrics"
        elif key == "writeTraces":
            suggest = "write_traces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CockpitTokenScopes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CockpitTokenScopes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CockpitTokenScopes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_logs: Optional[_builtins.bool] = None,
                 query_metrics: Optional[_builtins.bool] = None,
                 query_traces: Optional[_builtins.bool] = None,
                 setup_alerts: Optional[_builtins.bool] = None,
                 setup_logs_rules: Optional[_builtins.bool] = None,
                 setup_metrics_rules: Optional[_builtins.bool] = None,
                 write_logs: Optional[_builtins.bool] = None,
                 write_metrics: Optional[_builtins.bool] = None,
                 write_traces: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool query_logs: Permission to query logs.
        :param _builtins.bool query_metrics: Permission to query metrics.
        :param _builtins.bool query_traces: Permission to query traces.
        :param _builtins.bool setup_alerts: Permission to set up alerts.
        :param _builtins.bool setup_logs_rules: Permission to set up logs rules.
        :param _builtins.bool setup_metrics_rules: Permission to set up metrics rules.
        :param _builtins.bool write_logs: Permission to write logs.
        :param _builtins.bool write_metrics: Permission to write metrics.
        :param _builtins.bool write_traces: Permission to write traces.
        """
        if query_logs is not None:
            pulumi.set(__self__, "query_logs", query_logs)
        if query_metrics is not None:
            pulumi.set(__self__, "query_metrics", query_metrics)
        if query_traces is not None:
            pulumi.set(__self__, "query_traces", query_traces)
        if setup_alerts is not None:
            pulumi.set(__self__, "setup_alerts", setup_alerts)
        if setup_logs_rules is not None:
            pulumi.set(__self__, "setup_logs_rules", setup_logs_rules)
        if setup_metrics_rules is not None:
            pulumi.set(__self__, "setup_metrics_rules", setup_metrics_rules)
        if write_logs is not None:
            pulumi.set(__self__, "write_logs", write_logs)
        if write_metrics is not None:
            pulumi.set(__self__, "write_metrics", write_metrics)
        if write_traces is not None:
            pulumi.set(__self__, "write_traces", write_traces)

    @_builtins.property
    @pulumi.getter(name="queryLogs")
    def query_logs(self) -> Optional[_builtins.bool]:
        """
        Permission to query logs.
        """
        return pulumi.get(self, "query_logs")

    @_builtins.property
    @pulumi.getter(name="queryMetrics")
    def query_metrics(self) -> Optional[_builtins.bool]:
        """
        Permission to query metrics.
        """
        return pulumi.get(self, "query_metrics")

    @_builtins.property
    @pulumi.getter(name="queryTraces")
    def query_traces(self) -> Optional[_builtins.bool]:
        """
        Permission to query traces.
        """
        return pulumi.get(self, "query_traces")

    @_builtins.property
    @pulumi.getter(name="setupAlerts")
    def setup_alerts(self) -> Optional[_builtins.bool]:
        """
        Permission to set up alerts.
        """
        return pulumi.get(self, "setup_alerts")

    @_builtins.property
    @pulumi.getter(name="setupLogsRules")
    def setup_logs_rules(self) -> Optional[_builtins.bool]:
        """
        Permission to set up logs rules.
        """
        return pulumi.get(self, "setup_logs_rules")

    @_builtins.property
    @pulumi.getter(name="setupMetricsRules")
    def setup_metrics_rules(self) -> Optional[_builtins.bool]:
        """
        Permission to set up metrics rules.
        """
        return pulumi.get(self, "setup_metrics_rules")

    @_builtins.property
    @pulumi.getter(name="writeLogs")
    def write_logs(self) -> Optional[_builtins.bool]:
        """
        Permission to write logs.
        """
        return pulumi.get(self, "write_logs")

    @_builtins.property
    @pulumi.getter(name="writeMetrics")
    def write_metrics(self) -> Optional[_builtins.bool]:
        """
        Permission to write metrics.
        """
        return pulumi.get(self, "write_metrics")

    @_builtins.property
    @pulumi.getter(name="writeTraces")
    def write_traces(self) -> Optional[_builtins.bool]:
        """
        Permission to write traces.
        """
        return pulumi.get(self, "write_traces")


@pulumi.output_type
class ContainerHealthCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: _builtins.int,
                 https: Sequence['outputs.ContainerHealthCheckHttp'],
                 interval: _builtins.str):
        """
        :param _builtins.int failure_threshold: Number of consecutive health check failures before considering the container unhealthy.
        :param Sequence['ContainerHealthCheckHttpArgs'] https: HTTP health check configuration.
        :param _builtins.str interval: Period between health checks (in seconds).
        """
        pulumi.set(__self__, "failure_threshold", failure_threshold)
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "interval", interval)

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> _builtins.int:
        """
        Number of consecutive health check failures before considering the container unhealthy.
        """
        return pulumi.get(self, "failure_threshold")

    @_builtins.property
    @pulumi.getter
    def https(self) -> Sequence['outputs.ContainerHealthCheckHttp']:
        """
        HTTP health check configuration.
        """
        return pulumi.get(self, "https")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.str:
        """
        Period between health checks (in seconds).
        """
        return pulumi.get(self, "interval")


@pulumi.output_type
class ContainerHealthCheckHttp(dict):
    def __init__(__self__, *,
                 path: _builtins.str):
        """
        :param _builtins.str path: Path to use for the HTTP health check.
        """
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path to use for the HTTP health check.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class ContainerScalingOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "concurrentRequestsThreshold":
            suggest = "concurrent_requests_threshold"
        elif key == "cpuUsageThreshold":
            suggest = "cpu_usage_threshold"
        elif key == "memoryUsageThreshold":
            suggest = "memory_usage_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerScalingOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerScalingOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerScalingOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 concurrent_requests_threshold: Optional[_builtins.int] = None,
                 cpu_usage_threshold: Optional[_builtins.int] = None,
                 memory_usage_threshold: Optional[_builtins.int] = None):
        """
        :param _builtins.int concurrent_requests_threshold: Scale depending on the number of concurrent requests being processed per container instance.
        :param _builtins.int cpu_usage_threshold: Scale depending on the CPU usage of a container instance.
        :param _builtins.int memory_usage_threshold: Scale depending on the memory usage of a container instance.
        """
        if concurrent_requests_threshold is not None:
            pulumi.set(__self__, "concurrent_requests_threshold", concurrent_requests_threshold)
        if cpu_usage_threshold is not None:
            pulumi.set(__self__, "cpu_usage_threshold", cpu_usage_threshold)
        if memory_usage_threshold is not None:
            pulumi.set(__self__, "memory_usage_threshold", memory_usage_threshold)

    @_builtins.property
    @pulumi.getter(name="concurrentRequestsThreshold")
    def concurrent_requests_threshold(self) -> Optional[_builtins.int]:
        """
        Scale depending on the number of concurrent requests being processed per container instance.
        """
        return pulumi.get(self, "concurrent_requests_threshold")

    @_builtins.property
    @pulumi.getter(name="cpuUsageThreshold")
    def cpu_usage_threshold(self) -> Optional[_builtins.int]:
        """
        Scale depending on the CPU usage of a container instance.
        """
        return pulumi.get(self, "cpu_usage_threshold")

    @_builtins.property
    @pulumi.getter(name="memoryUsageThreshold")
    def memory_usage_threshold(self) -> Optional[_builtins.int]:
        """
        Scale depending on the memory usage of a container instance.
        """
        return pulumi.get(self, "memory_usage_threshold")


@pulumi.output_type
class ContainerTriggerNats(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerTriggerNats. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerTriggerNats.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerTriggerNats.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subject: _builtins.str,
                 account_id: Optional[_builtins.str] = None,
                 project_id: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str subject: The subject to listen to.
        :param _builtins.str account_id: unique identifier of the Messaging and Queuing NATS account.
        :param _builtins.str project_id: THe ID of the project that contains the Messaging and Queuing NATS account (defaults to provider `project_id`)
        :param _builtins.str region: Region where the Messaging and Queuing NATS account is enabled (defaults to provider `region`)
        """
        pulumi.set(__self__, "subject", subject)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> _builtins.str:
        """
        The subject to listen to.
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[_builtins.str]:
        """
        unique identifier of the Messaging and Queuing NATS account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        THe ID of the project that contains the Messaging and Queuing NATS account (defaults to provider `project_id`)
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        Region where the Messaging and Queuing NATS account is enabled (defaults to provider `region`)
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class ContainerTriggerSqs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namespaceId":
            suggest = "namespace_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerTriggerSqs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerTriggerSqs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerTriggerSqs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 queue: _builtins.str,
                 namespace_id: Optional[_builtins.str] = None,
                 project_id: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str queue: The name of the SQS queue.
        :param _builtins.str namespace_id: ID of the Messaging and Queuing namespace. This argument is deprecated.
        :param _builtins.str project_id: The ID of the project in which SQS is enabled, (defaults to provider `project_id`)
        :param _builtins.str region: Region where SQS is enabled (defaults to provider `region`)
        """
        pulumi.set(__self__, "queue", queue)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def queue(self) -> _builtins.str:
        """
        The name of the SQS queue.
        """
        return pulumi.get(self, "queue")

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    @_utilities.deprecated("""The 'namespace_id' field is deprecated and will be removed in the next major version. It is no longer necessary to specify it""")
    def namespace_id(self) -> Optional[_builtins.str]:
        """
        ID of the Messaging and Queuing namespace. This argument is deprecated.
        """
        return pulumi.get(self, "namespace_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        The ID of the project in which SQS is enabled, (defaults to provider `project_id`)
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        Region where SQS is enabled (defaults to provider `region`)
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class DatabaseAclAclRule(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str ip: The IP range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        :param _builtins.str description: A text describing this rule. Default description: `IP allowed`
        """
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The IP range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        A text describing this rule. Default description: `IP allowed`
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class DatabaseInstanceLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointId":
            suggest = "endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_id: Optional[_builtins.str] = None,
                 hostname: Optional[_builtins.str] = None,
                 ip: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str endpoint_id: The ID of the endpoint.
        :param _builtins.str hostname: Hostname of the endpoint.
        :param _builtins.str ip: IPv4 address on the network.
        :param _builtins.str name: The name of the Database Instance.
        :param _builtins.int port: Port in the Private Network.
        """
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[_builtins.str]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        Hostname of the endpoint.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IPv4 address on the network.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port in the Private Network.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class DatabaseInstanceLogsPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAgeRetention":
            suggest = "max_age_retention"
        elif key == "totalDiskRetention":
            suggest = "total_disk_retention"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceLogsPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceLogsPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceLogsPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_age_retention: Optional[_builtins.int] = None,
                 total_disk_retention: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_age_retention: The max age (in days) of remote logs to keep on the Database Instance
        :param _builtins.int total_disk_retention: The max disk size of remote logs to keep on the Database Instance.
        """
        if max_age_retention is not None:
            pulumi.set(__self__, "max_age_retention", max_age_retention)
        if total_disk_retention is not None:
            pulumi.set(__self__, "total_disk_retention", total_disk_retention)

    @_builtins.property
    @pulumi.getter(name="maxAgeRetention")
    def max_age_retention(self) -> Optional[_builtins.int]:
        """
        The max age (in days) of remote logs to keep on the Database Instance
        """
        return pulumi.get(self, "max_age_retention")

    @_builtins.property
    @pulumi.getter(name="totalDiskRetention")
    def total_disk_retention(self) -> Optional[_builtins.int]:
        """
        The max disk size of remote logs to keep on the Database Instance.
        """
        return pulumi.get(self, "total_disk_retention")


@pulumi.output_type
class DatabaseInstancePrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The private IPv4 address.
        :param _builtins.str id: Version ID to use in upgrade requests.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The private IPv4 address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Version ID to use in upgrade requests.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class DatabaseInstancePrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pnId":
            suggest = "pn_id"
        elif key == "enableIpam":
            suggest = "enable_ipam"
        elif key == "endpointId":
            suggest = "endpoint_id"
        elif key == "ipNet":
            suggest = "ip_net"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstancePrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstancePrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstancePrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pn_id: _builtins.str,
                 enable_ipam: Optional[_builtins.bool] = None,
                 endpoint_id: Optional[_builtins.str] = None,
                 hostname: Optional[_builtins.str] = None,
                 ip: Optional[_builtins.str] = None,
                 ip_net: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str pn_id: The private network ID
        :param _builtins.bool enable_ipam: Whether or not the private network endpoint should be configured with IPAM
        :param _builtins.str endpoint_id: The ID of the endpoint.
        :param _builtins.str hostname: Hostname of the endpoint.
        :param _builtins.str ip: IPv4 address on the network.
        :param _builtins.str ip_net: The IP with the given mask within the private subnet
        :param _builtins.str name: The name of the Database Instance.
        :param _builtins.int port: Port in the Private Network.
        :param _builtins.str zone: The zone you want to attach the resource to
        """
        pulumi.set(__self__, "pn_id", pn_id)
        if enable_ipam is not None:
            pulumi.set(__self__, "enable_ipam", enable_ipam)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_net is not None:
            pulumi.set(__self__, "ip_net", ip_net)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> _builtins.str:
        """
        The private network ID
        """
        return pulumi.get(self, "pn_id")

    @_builtins.property
    @pulumi.getter(name="enableIpam")
    def enable_ipam(self) -> Optional[_builtins.bool]:
        """
        Whether or not the private network endpoint should be configured with IPAM
        """
        return pulumi.get(self, "enable_ipam")

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[_builtins.str]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        Hostname of the endpoint.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IPv4 address on the network.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipNet")
    def ip_net(self) -> Optional[_builtins.str]:
        """
        The IP with the given mask within the private subnet
        """
        return pulumi.get(self, "ip_net")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port in the Private Network.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        The zone you want to attach the resource to
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class DatabaseInstanceReadReplica(dict):
    def __init__(__self__, *,
                 ip: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str ip: IPv4 address on the network.
        :param _builtins.str name: The name of the Database Instance.
        :param _builtins.int port: Port in the Private Network.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IPv4 address on the network.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port in the Private Network.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class DatabaseInstanceUpgradableVersion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minorVersion":
            suggest = "minor_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceUpgradableVersion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceUpgradableVersion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceUpgradableVersion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 minor_version: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: Version ID to use in upgrade requests.
        :param _builtins.str minor_version: Minor version string (e.g., `15.5.0`).
        :param _builtins.str name: The name of the Database Instance.
        :param _builtins.str version: Version string (e.g., `15.5`).
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if minor_version is not None:
            pulumi.set(__self__, "minor_version", minor_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Version ID to use in upgrade requests.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="minorVersion")
    def minor_version(self) -> Optional[_builtins.str]:
        """
        Minor version string (e.g., `15.5.0`).
        """
        return pulumi.get(self, "minor_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Version string (e.g., `15.5`).
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class DatabaseReadReplicaDirectAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointId":
            suggest = "endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseReadReplicaDirectAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseReadReplicaDirectAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseReadReplicaDirectAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_id: Optional[_builtins.str] = None,
                 hostname: Optional[_builtins.str] = None,
                 ip: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str endpoint_id: The ID of the endpoint of the Read Replica.
        :param _builtins.str hostname: Hostname of the endpoint. Only one of IP and hostname may be set.
        :param _builtins.str ip: IPv4 address of the endpoint (IP address). Only one of IP and hostname may be set.
        :param _builtins.str name: Name of the endpoint.
        :param _builtins.int port: TCP port of the endpoint.
        """
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[_builtins.str]:
        """
        The ID of the endpoint of the Read Replica.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        Hostname of the endpoint. Only one of IP and hostname may be set.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IPv4 address of the endpoint (IP address). Only one of IP and hostname may be set.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class DatabaseReadReplicaPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateNetworkId":
            suggest = "private_network_id"
        elif key == "enableIpam":
            suggest = "enable_ipam"
        elif key == "endpointId":
            suggest = "endpoint_id"
        elif key == "serviceIp":
            suggest = "service_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseReadReplicaPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseReadReplicaPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseReadReplicaPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_network_id: _builtins.str,
                 enable_ipam: Optional[_builtins.bool] = None,
                 endpoint_id: Optional[_builtins.str] = None,
                 hostname: Optional[_builtins.str] = None,
                 ip: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 service_ip: Optional[_builtins.str] = None,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str private_network_id: UUID of the Private Netork to be connected to the Read Replica.
        :param _builtins.bool enable_ipam: If true, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
               
               > **Important:** One of `service_ip` or `enable_ipam=true` must be set.
        :param _builtins.str endpoint_id: The ID of the endpoint of the Read Replica.
        :param _builtins.str hostname: Hostname of the endpoint. Only one of IP and hostname may be set.
        :param _builtins.str ip: IPv4 address of the endpoint (IP address). Only one of IP and hostname may be set.
        :param _builtins.str name: Name of the endpoint.
        :param _builtins.int port: TCP port of the endpoint.
        :param _builtins.str service_ip: The IP network address within the private subnet. This must be an IPv4 address with a CIDR notation. If not set, The IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
        :param _builtins.str zone: Private network zone
        """
        pulumi.set(__self__, "private_network_id", private_network_id)
        if enable_ipam is not None:
            pulumi.set(__self__, "enable_ipam", enable_ipam)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service_ip is not None:
            pulumi.set(__self__, "service_ip", service_ip)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> _builtins.str:
        """
        UUID of the Private Netork to be connected to the Read Replica.
        """
        return pulumi.get(self, "private_network_id")

    @_builtins.property
    @pulumi.getter(name="enableIpam")
    def enable_ipam(self) -> Optional[_builtins.bool]:
        """
        If true, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.

        > **Important:** One of `service_ip` or `enable_ipam=true` must be set.
        """
        return pulumi.get(self, "enable_ipam")

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[_builtins.str]:
        """
        The ID of the endpoint of the Read Replica.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        Hostname of the endpoint. Only one of IP and hostname may be set.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IPv4 address of the endpoint (IP address). Only one of IP and hostname may be set.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="serviceIp")
    def service_ip(self) -> Optional[_builtins.str]:
        """
        The IP network address within the private subnet. This must be an IPv4 address with a CIDR notation. If not set, The IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
        """
        return pulumi.get(self, "service_ip")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        Private network zone
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class DomainRecordGeoIp(dict):
    def __init__(__self__, *,
                 matches: Sequence['outputs.DomainRecordGeoIpMatch']):
        """
        :param Sequence['DomainRecordGeoIpMatchArgs'] matches: The list of matches
        """
        pulumi.set(__self__, "matches", matches)

    @_builtins.property
    @pulumi.getter
    def matches(self) -> Sequence['outputs.DomainRecordGeoIpMatch']:
        """
        The list of matches
        """
        return pulumi.get(self, "matches")


@pulumi.output_type
class DomainRecordGeoIpMatch(dict):
    def __init__(__self__, *,
                 data: _builtins.str,
                 continents: Optional[Sequence[_builtins.str]] = None,
                 countries: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str data: The content of the record (an IPv4 for an `A` record, a string for a `TXT` record, etc.).
        :param Sequence[_builtins.str] continents: List of continents (eg: EU for Europe, NA for North America, AS for Asia...). List of all continents code: https://api.scaleway.com/domain-private/v2beta1/continents
        :param Sequence[_builtins.str] countries: List of countries (eg: FR for France, US for the United States, GB for Great Britain...). List of all countries code: https://api.scaleway.com/domain-private/v2beta1/countries
        """
        pulumi.set(__self__, "data", data)
        if continents is not None:
            pulumi.set(__self__, "continents", continents)
        if countries is not None:
            pulumi.set(__self__, "countries", countries)

    @_builtins.property
    @pulumi.getter
    def data(self) -> _builtins.str:
        """
        The content of the record (an IPv4 for an `A` record, a string for a `TXT` record, etc.).
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter
    def continents(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of continents (eg: EU for Europe, NA for North America, AS for Asia...). List of all continents code: https://api.scaleway.com/domain-private/v2beta1/continents
        """
        return pulumi.get(self, "continents")

    @_builtins.property
    @pulumi.getter
    def countries(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of countries (eg: FR for France, US for the United States, GB for Great Britain...). List of all countries code: https://api.scaleway.com/domain-private/v2beta1/countries
        """
        return pulumi.get(self, "countries")


@pulumi.output_type
class DomainRecordHttpService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mustContain":
            suggest = "must_contain"
        elif key == "userAgent":
            suggest = "user_agent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainRecordHttpService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainRecordHttpService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainRecordHttpService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ips: Sequence[_builtins.str],
                 must_contain: _builtins.str,
                 strategy: _builtins.str,
                 url: _builtins.str,
                 user_agent: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] ips: IPs to check
        :param _builtins.str must_contain: Text to search
        :param _builtins.str strategy: Strategy to return an IP from the IPs list
        :param _builtins.str url: URL to match the must_contain text to validate an IP
        :param _builtins.str user_agent: User-agent used when checking the URL
        """
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "must_contain", must_contain)
        pulumi.set(__self__, "strategy", strategy)
        pulumi.set(__self__, "url", url)
        if user_agent is not None:
            pulumi.set(__self__, "user_agent", user_agent)

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Sequence[_builtins.str]:
        """
        IPs to check
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter(name="mustContain")
    def must_contain(self) -> _builtins.str:
        """
        Text to search
        """
        return pulumi.get(self, "must_contain")

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> _builtins.str:
        """
        Strategy to return an IP from the IPs list
        """
        return pulumi.get(self, "strategy")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        URL to match the must_contain text to validate an IP
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="userAgent")
    def user_agent(self) -> Optional[_builtins.str]:
        """
        User-agent used when checking the URL
        """
        return pulumi.get(self, "user_agent")


@pulumi.output_type
class DomainRecordView(dict):
    def __init__(__self__, *,
                 data: _builtins.str,
                 subnet: _builtins.str):
        """
        :param _builtins.str data: The content of the record (an IPv4 for an `A` record, a string for a `TXT` record, etc.).
        :param _builtins.str subnet: The subnet of the view
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "subnet", subnet)

    @_builtins.property
    @pulumi.getter
    def data(self) -> _builtins.str:
        """
        The content of the record (an IPv4 for an `A` record, a string for a `TXT` record, etc.).
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> _builtins.str:
        """
        The subnet of the view
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class DomainRecordWeighted(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.str ip: The weighted IP
        :param _builtins.int weight: The weight of the IP
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The weighted IP
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        The weight of the IP
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class EdgeServicesBackendStageLbBackendConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lbConfig":
            suggest = "lb_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeServicesBackendStageLbBackendConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeServicesBackendStageLbBackendConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeServicesBackendStageLbBackendConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lb_config: Optional['outputs.EdgeServicesBackendStageLbBackendConfigLbConfig'] = None):
        """
        :param 'EdgeServicesBackendStageLbBackendConfigLbConfigArgs' lb_config: The Load Balancer config.
        """
        if lb_config is not None:
            pulumi.set(__self__, "lb_config", lb_config)

    @_builtins.property
    @pulumi.getter(name="lbConfig")
    def lb_config(self) -> Optional['outputs.EdgeServicesBackendStageLbBackendConfigLbConfig']:
        """
        The Load Balancer config.
        """
        return pulumi.get(self, "lb_config")


@pulumi.output_type
class EdgeServicesBackendStageLbBackendConfigLbConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "frontendId":
            suggest = "frontend_id"
        elif key == "isSsl":
            suggest = "is_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeServicesBackendStageLbBackendConfigLbConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeServicesBackendStageLbBackendConfigLbConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeServicesBackendStageLbBackendConfigLbConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[_builtins.str] = None,
                 frontend_id: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 is_ssl: Optional[_builtins.bool] = None,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str domain_name: The Fully Qualified Domain Name (in the format subdomain.example.com) to use in HTTP requests sent towards your Load Balancer.
        :param _builtins.str frontend_id: The ID of the frontend.
        :param _builtins.str id: The ID of the Load Balancer.
        :param _builtins.bool is_ssl: Defines whether the Load Balancer's frontend handles SSL connections.
        :param _builtins.str zone: `zone`) The zone of the Load Balancer.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if frontend_id is not None:
            pulumi.set(__self__, "frontend_id", frontend_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_ssl is not None:
            pulumi.set(__self__, "is_ssl", is_ssl)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        The Fully Qualified Domain Name (in the format subdomain.example.com) to use in HTTP requests sent towards your Load Balancer.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> Optional[_builtins.str]:
        """
        The ID of the frontend.
        """
        return pulumi.get(self, "frontend_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the Load Balancer.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isSsl")
    def is_ssl(self) -> Optional[_builtins.bool]:
        """
        Defines whether the Load Balancer's frontend handles SSL connections.
        """
        return pulumi.get(self, "is_ssl")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        `zone`) The zone of the Load Balancer.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class EdgeServicesBackendStageS3BackendConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "bucketRegion":
            suggest = "bucket_region"
        elif key == "isWebsite":
            suggest = "is_website"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeServicesBackendStageS3BackendConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeServicesBackendStageS3BackendConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeServicesBackendStageS3BackendConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: Optional[_builtins.str] = None,
                 bucket_region: Optional[_builtins.str] = None,
                 is_website: Optional[_builtins.bool] = None):
        """
        :param _builtins.str bucket_name: The name of the Bucket.
        :param _builtins.str bucket_region: The region of the Bucket.
        :param _builtins.bool is_website: Defines whether the bucket website feature is enabled.
        """
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if bucket_region is not None:
            pulumi.set(__self__, "bucket_region", bucket_region)
        if is_website is not None:
            pulumi.set(__self__, "is_website", is_website)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[_builtins.str]:
        """
        The name of the Bucket.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> Optional[_builtins.str]:
        """
        The region of the Bucket.
        """
        return pulumi.get(self, "bucket_region")

    @_builtins.property
    @pulumi.getter(name="isWebsite")
    def is_website(self) -> Optional[_builtins.bool]:
        """
        Defines whether the bucket website feature is enabled.
        """
        return pulumi.get(self, "is_website")


@pulumi.output_type
class EdgeServicesCacheStagePurgeRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pipelineId":
            suggest = "pipeline_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeServicesCacheStagePurgeRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeServicesCacheStagePurgeRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeServicesCacheStagePurgeRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all: Optional[_builtins.bool] = None,
                 assets: Optional[Sequence[_builtins.str]] = None,
                 pipeline_id: Optional[_builtins.str] = None):
        """
        :param _builtins.bool all: Defines whether to purge all content.
        :param Sequence[_builtins.str] assets: The list of asserts to purge.
        :param _builtins.str pipeline_id: The pipeline ID in which the purge request will be created.
        """
        if all is not None:
            pulumi.set(__self__, "all", all)
        if assets is not None:
            pulumi.set(__self__, "assets", assets)
        if pipeline_id is not None:
            pulumi.set(__self__, "pipeline_id", pipeline_id)

    @_builtins.property
    @pulumi.getter
    def all(self) -> Optional[_builtins.bool]:
        """
        Defines whether to purge all content.
        """
        return pulumi.get(self, "all")

    @_builtins.property
    @pulumi.getter
    def assets(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of asserts to purge.
        """
        return pulumi.get(self, "assets")

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> Optional[_builtins.str]:
        """
        The pipeline ID in which the purge request will be created.
        """
        return pulumi.get(self, "pipeline_id")


@pulumi.output_type
class EdgeServicesRouteStageRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendStageId":
            suggest = "backend_stage_id"
        elif key == "ruleHttpMatch":
            suggest = "rule_http_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeServicesRouteStageRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeServicesRouteStageRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeServicesRouteStageRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_stage_id: _builtins.str,
                 rule_http_match: Optional['outputs.EdgeServicesRouteStageRuleRuleHttpMatch'] = None):
        """
        :param _builtins.str backend_stage_id: The ID of the backend stage that requests matching the rule should be forwarded to.
        :param 'EdgeServicesRouteStageRuleRuleHttpMatchArgs' rule_http_match: The rule condition to be matched. Requests matching the condition defined here will be directly forwarded to the backend specified by the `backend_stage_id` field. Requests that do not match will be checked by the next rule's condition.
        """
        pulumi.set(__self__, "backend_stage_id", backend_stage_id)
        if rule_http_match is not None:
            pulumi.set(__self__, "rule_http_match", rule_http_match)

    @_builtins.property
    @pulumi.getter(name="backendStageId")
    def backend_stage_id(self) -> _builtins.str:
        """
        The ID of the backend stage that requests matching the rule should be forwarded to.
        """
        return pulumi.get(self, "backend_stage_id")

    @_builtins.property
    @pulumi.getter(name="ruleHttpMatch")
    def rule_http_match(self) -> Optional['outputs.EdgeServicesRouteStageRuleRuleHttpMatch']:
        """
        The rule condition to be matched. Requests matching the condition defined here will be directly forwarded to the backend specified by the `backend_stage_id` field. Requests that do not match will be checked by the next rule's condition.
        """
        return pulumi.get(self, "rule_http_match")


@pulumi.output_type
class EdgeServicesRouteStageRuleRuleHttpMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "methodFilters":
            suggest = "method_filters"
        elif key == "pathFilter":
            suggest = "path_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeServicesRouteStageRuleRuleHttpMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeServicesRouteStageRuleRuleHttpMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeServicesRouteStageRuleRuleHttpMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method_filters: Optional[Sequence[_builtins.str]] = None,
                 path_filter: Optional['outputs.EdgeServicesRouteStageRuleRuleHttpMatchPathFilter'] = None):
        """
        :param Sequence[_builtins.str] method_filters: HTTP methods to filter for. A request using any of these methods will be considered to match the rule. Possible values are `get`, `post`, `put`, `patch`, `delete`, `head`, `options`. All methods will match if none is provided.
        :param 'EdgeServicesRouteStageRuleRuleHttpMatchPathFilterArgs' path_filter: HTTP URL path to filter for. A request whose path matches the given filter will be considered to match the rule. All paths will match if none is provided.
        """
        if method_filters is not None:
            pulumi.set(__self__, "method_filters", method_filters)
        if path_filter is not None:
            pulumi.set(__self__, "path_filter", path_filter)

    @_builtins.property
    @pulumi.getter(name="methodFilters")
    def method_filters(self) -> Optional[Sequence[_builtins.str]]:
        """
        HTTP methods to filter for. A request using any of these methods will be considered to match the rule. Possible values are `get`, `post`, `put`, `patch`, `delete`, `head`, `options`. All methods will match if none is provided.
        """
        return pulumi.get(self, "method_filters")

    @_builtins.property
    @pulumi.getter(name="pathFilter")
    def path_filter(self) -> Optional['outputs.EdgeServicesRouteStageRuleRuleHttpMatchPathFilter']:
        """
        HTTP URL path to filter for. A request whose path matches the given filter will be considered to match the rule. All paths will match if none is provided.
        """
        return pulumi.get(self, "path_filter")


@pulumi.output_type
class EdgeServicesRouteStageRuleRuleHttpMatchPathFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pathFilterType":
            suggest = "path_filter_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeServicesRouteStageRuleRuleHttpMatchPathFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeServicesRouteStageRuleRuleHttpMatchPathFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeServicesRouteStageRuleRuleHttpMatchPathFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path_filter_type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str path_filter_type: The type of filter to match for the HTTP URL path. For now, all path filters must be written in regex and use the `regex` type.
        :param _builtins.str value: The value to be matched for the HTTP URL path.
        """
        pulumi.set(__self__, "path_filter_type", path_filter_type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="pathFilterType")
    def path_filter_type(self) -> _builtins.str:
        """
        The type of filter to match for the HTTP URL path. For now, all path filters must be written in regex and use the `regex` type.
        """
        return pulumi.get(self, "path_filter_type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value to be matched for the HTTP URL path.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EdgeServicesTlsStageSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretId":
            suggest = "secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeServicesTlsStageSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeServicesTlsStageSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeServicesTlsStageSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: Optional[_builtins.str] = None,
                 secret_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str region: The region of the secret.
        :param _builtins.str secret_id: The ID of the Secret
        """
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region of the secret.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Secret
        """
        return pulumi.get(self, "secret_id")


@pulumi.output_type
class FunctionTriggerNats(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionTriggerNats. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionTriggerNats.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionTriggerNats.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subject: _builtins.str,
                 account_id: Optional[_builtins.str] = None,
                 project_id: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str subject: The subject to listen to.
        :param _builtins.str account_id: unique identifier of the Messaging and Queuing NATS account.
        :param _builtins.str project_id: THe ID of the project that contains the Messaging and Queuing NATS account (defaults to provider `project_id`)
        :param _builtins.str region: Region where the Messaging and Queuing NATS account is enabled (defaults to provider `region`)
        """
        pulumi.set(__self__, "subject", subject)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> _builtins.str:
        """
        The subject to listen to.
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[_builtins.str]:
        """
        unique identifier of the Messaging and Queuing NATS account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        THe ID of the project that contains the Messaging and Queuing NATS account (defaults to provider `project_id`)
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        Region where the Messaging and Queuing NATS account is enabled (defaults to provider `region`)
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class FunctionTriggerSqs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namespaceId":
            suggest = "namespace_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionTriggerSqs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionTriggerSqs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionTriggerSqs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 queue: _builtins.str,
                 namespace_id: Optional[_builtins.str] = None,
                 project_id: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str queue: The name of the SQS queue.
        :param _builtins.str namespace_id: ID of the Messaging and Queuing namespace. This argument is deprecated.
        :param _builtins.str project_id: The ID of the project in which SQS is enabled, (defaults to provider `project_id`)
        :param _builtins.str region: Region where SQS is enabled (defaults to provider `region`)
        """
        pulumi.set(__self__, "queue", queue)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def queue(self) -> _builtins.str:
        """
        The name of the SQS queue.
        """
        return pulumi.get(self, "queue")

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    @_utilities.deprecated("""The 'namespace_id' field is deprecated and will be removed in the next major version. It is no longer necessary to specify it""")
    def namespace_id(self) -> Optional[_builtins.str]:
        """
        ID of the Messaging and Queuing namespace. This argument is deprecated.
        """
        return pulumi.get(self, "namespace_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        The ID of the project in which SQS is enabled, (defaults to provider `project_id`)
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        Region where SQS is enabled (defaults to provider `region`)
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class IamPolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "permissionSetNames":
            suggest = "permission_set_names"
        elif key == "organizationId":
            suggest = "organization_id"
        elif key == "projectIds":
            suggest = "project_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IamPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IamPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IamPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permission_set_names: Sequence[_builtins.str],
                 condition: Optional[_builtins.str] = None,
                 organization_id: Optional[_builtins.str] = None,
                 project_ids: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] permission_set_names: Names of permission sets bind to the rule.
        :param _builtins.str condition: The condition of the rule.
               
               **_TIP:_** You can use the Scaleway CLI to list the permissions details. e.g:
               
               ```shell
               scw iam permission-set list
               ```
        :param _builtins.str organization_id: ID of organization scoped to the rule, this can be used to create a rule for all projects in an organization.
        :param Sequence[_builtins.str] project_ids: List of project IDs scoped to the rule.
               
               > **Important** One `organization_id` or `project_ids` must be set per rule.
        """
        pulumi.set(__self__, "permission_set_names", permission_set_names)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if project_ids is not None:
            pulumi.set(__self__, "project_ids", project_ids)

    @_builtins.property
    @pulumi.getter(name="permissionSetNames")
    def permission_set_names(self) -> Sequence[_builtins.str]:
        """
        Names of permission sets bind to the rule.
        """
        return pulumi.get(self, "permission_set_names")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[_builtins.str]:
        """
        The condition of the rule.

        **_TIP:_** You can use the Scaleway CLI to list the permissions details. e.g:

        ```shell
        scw iam permission-set list
        ```
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[_builtins.str]:
        """
        ID of organization scoped to the rule, this can be used to create a rule for all projects in an organization.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="projectIds")
    def project_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of project IDs scoped to the rule.

        > **Important** One `organization_id` or `project_ids` must be set per rule.
        """
        return pulumi.get(self, "project_ids")


@pulumi.output_type
class InferenceDeploymentPrivateEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableAuth":
            suggest = "disable_auth"
        elif key == "privateNetworkId":
            suggest = "private_network_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceDeploymentPrivateEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceDeploymentPrivateEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceDeploymentPrivateEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_auth: Optional[_builtins.bool] = None,
                 id: Optional[_builtins.str] = None,
                 private_network_id: Optional[_builtins.str] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.bool disable_auth: Disable the authentication on the endpoint.
        :param _builtins.str id: (Optional) The id of the public endpoint.
        :param _builtins.str private_network_id: The ID of the private network to use.
        :param _builtins.str url: (Optional) The URL of the endpoint.
        """
        if disable_auth is not None:
            pulumi.set(__self__, "disable_auth", disable_auth)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if private_network_id is not None:
            pulumi.set(__self__, "private_network_id", private_network_id)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="disableAuth")
    def disable_auth(self) -> Optional[_builtins.bool]:
        """
        Disable the authentication on the endpoint.
        """
        return pulumi.get(self, "disable_auth")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        (Optional) The id of the public endpoint.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[_builtins.str]:
        """
        The ID of the private network to use.
        """
        return pulumi.get(self, "private_network_id")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        (Optional) The URL of the endpoint.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class InferenceDeploymentPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The private IPv4 address.
        :param _builtins.str id: (Optional) The id of the public endpoint.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The private IPv4 address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        (Optional) The id of the public endpoint.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class InferenceDeploymentPublicEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableAuth":
            suggest = "disable_auth"
        elif key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceDeploymentPublicEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceDeploymentPublicEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceDeploymentPublicEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_auth: Optional[_builtins.bool] = None,
                 id: Optional[_builtins.str] = None,
                 is_enabled: Optional[_builtins.bool] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.bool disable_auth: Disable the authentication on the endpoint.
        :param _builtins.str id: (Optional) The id of the public endpoint.
        :param _builtins.bool is_enabled: Enable or disable public endpoint.
        :param _builtins.str url: (Optional) The URL of the endpoint.
        """
        if disable_auth is not None:
            pulumi.set(__self__, "disable_auth", disable_auth)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="disableAuth")
    def disable_auth(self) -> Optional[_builtins.bool]:
        """
        Disable the authentication on the endpoint.
        """
        return pulumi.get(self, "disable_auth")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        (Optional) The id of the public endpoint.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[_builtins.bool]:
        """
        Enable or disable public endpoint.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        (Optional) The URL of the endpoint.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class InstanceImageAdditionalVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceImageAdditionalVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceImageAdditionalVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceImageAdditionalVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 server: Optional[Mapping[str, _builtins.str]] = None,
                 size: Optional[_builtins.int] = None,
                 tags: Optional[Sequence[_builtins.str]] = None,
                 volume_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: ID of the server containing the volume.
        :param _builtins.str name: The name of the image. If not provided it will be randomly generated.
        :param Mapping[str, _builtins.str] server: Description of the server containing the volume (in case the image is a backup from a server).
        :param _builtins.int size: The size of the volume.
        :param Sequence[_builtins.str] tags: A list of tags to apply to the image.
        :param _builtins.str volume_type: The type of volume, possible values are `l_ssd` and `sbs_snapshot`.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of the server containing the volume.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the image. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def server(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Description of the server containing the volume (in case the image is a backup from a server).
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        The size of the volume.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of tags to apply to the image.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[_builtins.str]:
        """
        The type of volume, possible values are `l_ssd` and `sbs_snapshot`.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class InstanceImageRootVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceImageRootVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceImageRootVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceImageRootVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 size: Optional[_builtins.int] = None,
                 volume_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: ID of the server containing the volume.
        :param _builtins.str name: The name of the image. If not provided it will be randomly generated.
        :param _builtins.int size: The size of the volume.
        :param _builtins.str volume_type: The type of volume, possible values are `l_ssd` and `sbs_snapshot`.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of the server containing the volume.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the image. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        The size of the volume.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[_builtins.str]:
        """
        The type of volume, possible values are `l_ssd` and `sbs_snapshot`.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class InstancePrivateNicPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The private IP address.
        :param _builtins.str id: The ID of the IP address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class InstanceSecurityGroupInboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSecurityGroupInboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSecurityGroupInboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSecurityGroupInboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 ip: Optional[_builtins.str] = None,
                 ip_range: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 port_range: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param _builtins.str ip: The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param _builtins.str ip_range: The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param _builtins.int port: The port this rule applies to. If no `port` nor `port_range` are specified, the rule will apply to all port. Only one of `port` and `port_range` should be specified.
        :param _builtins.str port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param _builtins.str protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Ip address is deprecated. Please use ip_range instead""")
    def ip(self) -> Optional[_builtins.str]:
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[_builtins.str]:
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port this rule applies to. If no `port` nor `port_range` are specified, the rule will apply to all port. Only one of `port` and `port_range` should be specified.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[_builtins.str]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class InstanceSecurityGroupOutboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSecurityGroupOutboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSecurityGroupOutboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSecurityGroupOutboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 ip: Optional[_builtins.str] = None,
                 ip_range: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 port_range: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: Action when rule match request (drop or accept)
        :param _builtins.str ip: Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        :param _builtins.str ip_range: Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        :param _builtins.int port: Network port for this rule
        :param _builtins.str port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param _builtins.str protocol: Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        Action when rule match request (drop or accept)
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Ip address is deprecated. Please use ip_range instead""")
    def ip(self) -> Optional[_builtins.str]:
        """
        Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[_builtins.str]:
        """
        Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Network port for this rule
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[_builtins.str]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class InstanceSecurityGroupRulesInboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSecurityGroupRulesInboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSecurityGroupRulesInboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSecurityGroupRulesInboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 ip: Optional[_builtins.str] = None,
                 ip_range: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 port_range: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param _builtins.str ip: The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param _builtins.str ip_range: The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param _builtins.int port: The port this rule apply to. If no port is specified, rule will apply to all port.
        :param _builtins.str port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param _builtins.str protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Ip address is deprecated. Please use ip_range instead""")
    def ip(self) -> Optional[_builtins.str]:
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[_builtins.str]:
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port this rule apply to. If no port is specified, rule will apply to all port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[_builtins.str]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class InstanceSecurityGroupRulesOutboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSecurityGroupRulesOutboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSecurityGroupRulesOutboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSecurityGroupRulesOutboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 ip: Optional[_builtins.str] = None,
                 ip_range: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 port_range: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: Action when rule match request (drop or accept)
        :param _builtins.str ip: Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        :param _builtins.str ip_range: Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        :param _builtins.int port: Network port for this rule
        :param _builtins.str port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param _builtins.str protocol: Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        Action when rule match request (drop or accept)
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Ip address is deprecated. Please use ip_range instead""")
    def ip(self) -> Optional[_builtins.str]:
        """
        Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[_builtins.str]:
        """
        Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Network port for this rule
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[_builtins.str]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class InstanceServerFilesystem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filesystemId":
            suggest = "filesystem_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceServerFilesystem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceServerFilesystem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceServerFilesystem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filesystem_id: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str filesystem_id: The unique ID of the filesystem attached to the server.
        :param _builtins.str status: The state of the filesystem
        """
        if filesystem_id is not None:
            pulumi.set(__self__, "filesystem_id", filesystem_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="filesystemId")
    def filesystem_id(self) -> Optional[_builtins.str]:
        """
        The unique ID of the filesystem attached to the server.
        """
        return pulumi.get(self, "filesystem_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The state of the filesystem
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class InstanceServerPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The private IP address.
        :param _builtins.str id: The ID of the IP address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class InstanceServerPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pnId":
            suggest = "pn_id"
        elif key == "macAddress":
            suggest = "mac_address"
        elif key == "pnicId":
            suggest = "pnic_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceServerPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceServerPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceServerPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pn_id: _builtins.str,
                 mac_address: Optional[_builtins.str] = None,
                 pnic_id: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str pn_id: The Private Network ID
        :param _builtins.str mac_address: MAC address of the NIC
        :param _builtins.str pnic_id: The ID of the NIC
        :param _builtins.str status: The private NIC state
        :param _builtins.str zone: `zone`) The zone in which the server should be created.
        """
        pulumi.set(__self__, "pn_id", pn_id)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if pnic_id is not None:
            pulumi.set(__self__, "pnic_id", pnic_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> _builtins.str:
        """
        The Private Network ID
        """
        return pulumi.get(self, "pn_id")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[_builtins.str]:
        """
        MAC address of the NIC
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="pnicId")
    def pnic_id(self) -> Optional[_builtins.str]:
        """
        The ID of the NIC
        """
        return pulumi.get(self, "pnic_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The private NIC state
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class InstanceServerPublicIp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningMode":
            suggest = "provisioning_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceServerPublicIp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceServerPublicIp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceServerPublicIp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 dynamic: Optional[_builtins.bool] = None,
                 family: Optional[_builtins.str] = None,
                 gateway: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 netmask: Optional[_builtins.str] = None,
                 provisioning_mode: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The address of the IP.
        :param _builtins.bool dynamic: Whether the IP is dynamic.
        :param _builtins.str family: The IP address' family.
        :param _builtins.str gateway: The IP of the Gateway associated with the IP.
        :param _builtins.str id: The ID of the IP.
        :param _builtins.str netmask: The CIDR netmask of the IP.
        :param _builtins.str provisioning_mode: The provisioning mode of the IP
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if dynamic is not None:
            pulumi.set(__self__, "dynamic", dynamic)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if netmask is not None:
            pulumi.set(__self__, "netmask", netmask)
        if provisioning_mode is not None:
            pulumi.set(__self__, "provisioning_mode", provisioning_mode)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The address of the IP.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def dynamic(self) -> Optional[_builtins.bool]:
        """
        Whether the IP is dynamic.
        """
        return pulumi.get(self, "dynamic")

    @_builtins.property
    @pulumi.getter
    def family(self) -> Optional[_builtins.str]:
        """
        The IP address' family.
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> Optional[_builtins.str]:
        """
        The IP of the Gateway associated with the IP.
        """
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IP.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def netmask(self) -> Optional[_builtins.str]:
        """
        The CIDR netmask of the IP.
        """
        return pulumi.get(self, "netmask")

    @_builtins.property
    @pulumi.getter(name="provisioningMode")
    def provisioning_mode(self) -> Optional[_builtins.str]:
        """
        The provisioning mode of the IP
        """
        return pulumi.get(self, "provisioning_mode")


@pulumi.output_type
class InstanceServerRootVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "sbsIops":
            suggest = "sbs_iops"
        elif key == "sizeInGb":
            suggest = "size_in_gb"
        elif key == "volumeId":
            suggest = "volume_id"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceServerRootVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceServerRootVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceServerRootVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot: Optional[_builtins.bool] = None,
                 delete_on_termination: Optional[_builtins.bool] = None,
                 name: Optional[_builtins.str] = None,
                 sbs_iops: Optional[_builtins.int] = None,
                 size_in_gb: Optional[_builtins.int] = None,
                 volume_id: Optional[_builtins.str] = None,
                 volume_type: Optional[_builtins.str] = None):
        """
        :param _builtins.bool boot: Set the volume where the boot the server
        :param _builtins.bool delete_on_termination: Forces deletion of the root volume on instance termination.
        :param _builtins.str name: The name of the server.
        :param _builtins.int sbs_iops: Choose IOPS of your sbs volume, has to be used with `sbs_volume` for root volume type.
               
               > **Important:** Updates to `root_volume.size_in_gb` will be ignored after the creation of the server.
        :param _builtins.int size_in_gb: Size of the root volume in gigabytes.
               To find the right size use [this endpoint](https://www.scaleway.com/en/developers/api/instance/#path-instances-list-all-instances) and
               check the `volumes_constraint.{min|max}_size` (in bytes) for your `commercial_type`.
               Depending on `volume_type`, updates to this field may recreate a new resource.
        :param _builtins.str volume_id: The volume ID of the root volume of the server, allows you to create server with an existing volume. If empty, will be computed to a created volume ID.
        :param _builtins.str volume_type: Volume type of root volume, can be `l_ssd` or `sbs_volume`, default value depends on server type
        """
        if boot is not None:
            pulumi.set(__self__, "boot", boot)
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sbs_iops is not None:
            pulumi.set(__self__, "sbs_iops", sbs_iops)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter
    def boot(self) -> Optional[_builtins.bool]:
        """
        Set the volume where the boot the server
        """
        return pulumi.get(self, "boot")

    @_builtins.property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[_builtins.bool]:
        """
        Forces deletion of the root volume on instance termination.
        """
        return pulumi.get(self, "delete_on_termination")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sbsIops")
    def sbs_iops(self) -> Optional[_builtins.int]:
        """
        Choose IOPS of your sbs volume, has to be used with `sbs_volume` for root volume type.

        > **Important:** Updates to `root_volume.size_in_gb` will be ignored after the creation of the server.
        """
        return pulumi.get(self, "sbs_iops")

    @_builtins.property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> Optional[_builtins.int]:
        """
        Size of the root volume in gigabytes.
        To find the right size use [this endpoint](https://www.scaleway.com/en/developers/api/instance/#path-instances-list-all-instances) and
        check the `volumes_constraint.{min|max}_size` (in bytes) for your `commercial_type`.
        Depending on `volume_type`, updates to this field may recreate a new resource.
        """
        return pulumi.get(self, "size_in_gb")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[_builtins.str]:
        """
        The volume ID of the root volume of the server, allows you to create server with an existing volume. If empty, will be computed to a created volume ID.
        """
        return pulumi.get(self, "volume_id")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[_builtins.str]:
        """
        Volume type of root volume, can be `l_ssd` or `sbs_volume`, default value depends on server type
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class InstanceSnapshotImport(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 key: _builtins.str):
        """
        :param _builtins.str bucket: Bucket name containing [qcow2](https://en.wikipedia.org/wiki/Qcow) to import
        :param _builtins.str key: Key of the object to import
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Bucket name containing [qcow2](https://en.wikipedia.org/wiki/Qcow) to import
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Key of the object to import
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class IotDeviceCertificate(dict):
    def __init__(__self__, *,
                 crt: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None):
        """
        :param _builtins.str crt: X509 PEM encoded certificate of the device
        :param _builtins.str key: The private key of the device, in case it is generated by Scaleway.
        """
        if crt is not None:
            pulumi.set(__self__, "crt", crt)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def crt(self) -> Optional[_builtins.str]:
        """
        X509 PEM encoded certificate of the device
        """
        return pulumi.get(self, "crt")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The private key of the device, in case it is generated by Scaleway.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class IotDeviceMessageFilters(dict):
    def __init__(__self__, *,
                 publish: Optional['outputs.IotDeviceMessageFiltersPublish'] = None,
                 subscribe: Optional['outputs.IotDeviceMessageFiltersSubscribe'] = None):
        """
        :param 'IotDeviceMessageFiltersPublishArgs' publish: Rules used to restrict topics the device can publish to.
        :param 'IotDeviceMessageFiltersSubscribeArgs' subscribe: Rules used to restrict topics the device can subscribe to.
        """
        if publish is not None:
            pulumi.set(__self__, "publish", publish)
        if subscribe is not None:
            pulumi.set(__self__, "subscribe", subscribe)

    @_builtins.property
    @pulumi.getter
    def publish(self) -> Optional['outputs.IotDeviceMessageFiltersPublish']:
        """
        Rules used to restrict topics the device can publish to.
        """
        return pulumi.get(self, "publish")

    @_builtins.property
    @pulumi.getter
    def subscribe(self) -> Optional['outputs.IotDeviceMessageFiltersSubscribe']:
        """
        Rules used to restrict topics the device can subscribe to.
        """
        return pulumi.get(self, "subscribe")


@pulumi.output_type
class IotDeviceMessageFiltersPublish(dict):
    def __init__(__self__, *,
                 policy: Optional[_builtins.str] = None,
                 topics: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str policy: Filtering policy (eg `accept` or `reject`)
        :param Sequence[_builtins.str] topics: List of topics to match (eg `foo/bar/+/baz/#`)
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[_builtins.str]:
        """
        Filtering policy (eg `accept` or `reject`)
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def topics(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of topics to match (eg `foo/bar/+/baz/#`)
        """
        return pulumi.get(self, "topics")


@pulumi.output_type
class IotDeviceMessageFiltersSubscribe(dict):
    def __init__(__self__, *,
                 policy: Optional[_builtins.str] = None,
                 topics: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str policy: Same as publish rules.
        :param Sequence[_builtins.str] topics: Same as publish rules.
               
               - `certificate.crt` - (Optional) The certificate of the device, either generated by Scaleway or provided.
               
               > **Important:** Updates to `certificate.crt` will disconnect connected devices and the previous certificate will be deleted and won't be recoverable.
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[_builtins.str]:
        """
        Same as publish rules.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def topics(self) -> Optional[Sequence[_builtins.str]]:
        """
        Same as publish rules.

        - `certificate.crt` - (Optional) The certificate of the device, either generated by Scaleway or provided.

        > **Important:** Updates to `certificate.crt` will disconnect connected devices and the previous certificate will be deleted and won't be recoverable.
        """
        return pulumi.get(self, "topics")


@pulumi.output_type
class IotRouteDatabase(dict):
    def __init__(__self__, *,
                 dbname: _builtins.str,
                 host: _builtins.str,
                 password: _builtins.str,
                 port: _builtins.int,
                 query: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str dbname: The database name (e.g. `measurements`).
        :param _builtins.str host: The database hostname. Can be an IP or a FQDN.
        :param _builtins.str password: The database password.
        :param _builtins.int port: The database port (e.g. `5432`)
        :param _builtins.str query: The SQL query that will be executed when receiving a message ($TOPIC and $PAYLOAD variables are available, see documentation, e.g. `INSERT INTO mytable(date, topic, value) VALUES (NOW(), $TOPIC, $PAYLOAD)`).
        :param _builtins.str username: The database username.
        """
        pulumi.set(__self__, "dbname", dbname)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def dbname(self) -> _builtins.str:
        """
        The database name (e.g. `measurements`).
        """
        return pulumi.get(self, "dbname")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The database hostname. Can be an IP or a FQDN.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The database password.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The database port (e.g. `5432`)
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        The SQL query that will be executed when receiving a message ($TOPIC and $PAYLOAD variables are available, see documentation, e.g. `INSERT INTO mytable(date, topic, value) VALUES (NOW(), $TOPIC, $PAYLOAD)`).
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The database username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class IotRouteRest(dict):
    def __init__(__self__, *,
                 headers: Mapping[str, _builtins.str],
                 uri: _builtins.str,
                 verb: _builtins.str):
        """
        :param Mapping[str, _builtins.str] headers: a map of the extra headers to send with the HTTP call (e.g. `X-Header = Value`).
        :param _builtins.str uri: The URI of the Rest endpoint (e.g. `https://internal.mycompany.com/ingest/mqttdata`).
        :param _builtins.str verb: The HTTP Verb used to call Rest URI (e.g. `post`).
        """
        pulumi.set(__self__, "headers", headers)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "verb", verb)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Mapping[str, _builtins.str]:
        """
        a map of the extra headers to send with the HTTP call (e.g. `X-Header = Value`).
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        The URI of the Rest endpoint (e.g. `https://internal.mycompany.com/ingest/mqttdata`).
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter
    def verb(self) -> _builtins.str:
        """
        The HTTP Verb used to call Rest URI (e.g. `post`).
        """
        return pulumi.get(self, "verb")


@pulumi.output_type
class IotRouteS3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "bucketRegion":
            suggest = "bucket_region"
        elif key == "objectPrefix":
            suggest = "object_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IotRouteS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IotRouteS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IotRouteS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: _builtins.str,
                 bucket_region: _builtins.str,
                 strategy: _builtins.str,
                 object_prefix: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket_name: The name of the S3 route's destination bucket (e.g. `my-object-storage`).
        :param _builtins.str bucket_region: The region of the S3 route's destination bucket (e.g. `fr-par`).
        :param _builtins.str strategy: How the S3 route's objects will be created (e.g. `per_topic`). See [documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for behaviour details.
        :param _builtins.str object_prefix: The string to prefix object names with (e.g. `mykeyprefix-`).
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "bucket_region", bucket_region)
        pulumi.set(__self__, "strategy", strategy)
        if object_prefix is not None:
            pulumi.set(__self__, "object_prefix", object_prefix)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        The name of the S3 route's destination bucket (e.g. `my-object-storage`).
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> _builtins.str:
        """
        The region of the S3 route's destination bucket (e.g. `fr-par`).
        """
        return pulumi.get(self, "bucket_region")

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> _builtins.str:
        """
        How the S3 route's objects will be created (e.g. `per_topic`). See [documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for behaviour details.
        """
        return pulumi.get(self, "strategy")

    @_builtins.property
    @pulumi.getter(name="objectPrefix")
    def object_prefix(self) -> Optional[_builtins.str]:
        """
        The string to prefix object names with (e.g. `mykeyprefix-`).
        """
        return pulumi.get(self, "object_prefix")


@pulumi.output_type
class IpamIpCustomResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "macAddress":
            suggest = "mac_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpamIpCustomResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpamIpCustomResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpamIpCustomResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mac_address: _builtins.str,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str mac_address: The MAC address of the custom resource.
        :param _builtins.str name: When the resource is in a Private Network, a DNS record is available to resolve the resource name.
        """
        pulumi.set(__self__, "mac_address", mac_address)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> _builtins.str:
        """
        The MAC address of the custom resource.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        When the resource is in a Private Network, a DNS record is available to resolve the resource name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class IpamIpResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "macAddress":
            suggest = "mac_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpamIpResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpamIpResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpamIpResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 mac_address: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The ID of the resource that the IP is attached to.
        :param _builtins.str mac_address: The MAC address of the resource the IP is attached to.
        :param _builtins.str name: The name of the resource the IP is attached to.
        :param _builtins.str type: The type of resource the IP is attached to.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the resource that the IP is attached to.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[_builtins.str]:
        """
        The MAC address of the resource the IP is attached to.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the resource the IP is attached to.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of resource the IP is attached to.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class IpamIpReverse(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 hostname: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The IP corresponding to the hostname
        :param _builtins.str hostname: The reverse domain name.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The IP corresponding to the hostname
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        The reverse domain name.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class IpamIpSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateNetworkId":
            suggest = "private_network_id"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpamIpSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpamIpSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpamIpSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_network_id: Optional[_builtins.str] = None,
                 subnet_id: Optional[_builtins.str] = None,
                 zonal: Optional[_builtins.str] = None):
        """
        :param _builtins.str private_network_id: The Private Network of the IP (if the IP is a private IP).
        :param _builtins.str subnet_id: The Private Network subnet of the IP (if the IP is a private IP).
        :param _builtins.str zonal: The zone of the IP (if the IP is public and zoned, rather than private and/or regional)
        """
        if private_network_id is not None:
            pulumi.set(__self__, "private_network_id", private_network_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if zonal is not None:
            pulumi.set(__self__, "zonal", zonal)

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[_builtins.str]:
        """
        The Private Network of the IP (if the IP is a private IP).
        """
        return pulumi.get(self, "private_network_id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        The Private Network subnet of the IP (if the IP is a private IP).
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def zonal(self) -> Optional[_builtins.str]:
        """
        The zone of the IP (if the IP is public and zoned, rather than private and/or regional)
        """
        return pulumi.get(self, "zonal")


@pulumi.output_type
class JobDefinitionCron(dict):
    def __init__(__self__, *,
                 schedule: _builtins.str,
                 timezone: _builtins.str):
        """
        :param _builtins.str schedule: Cron format string.
        :param _builtins.str timezone: The timezone, must be a canonical TZ identifier as found in this [list](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
        """
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "timezone", timezone)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> _builtins.str:
        """
        Cron format string.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> _builtins.str:
        """
        The timezone, must be a canonical TZ identifier as found in this [list](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
        """
        return pulumi.get(self, "timezone")


@pulumi.output_type
class JobDefinitionSecretReference(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretId":
            suggest = "secret_id"
        elif key == "secretReferenceId":
            suggest = "secret_reference_id"
        elif key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionSecretReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionSecretReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionSecretReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_id: _builtins.str,
                 environment: Optional[_builtins.str] = None,
                 file: Optional[_builtins.str] = None,
                 secret_reference_id: Optional[_builtins.str] = None,
                 secret_version: Optional[_builtins.str] = None):
        """
        :param _builtins.str secret_id: The secret unique identifier, it could be formatted as region/UUID or UUID. In case the region is passed, it must be the same as the job definition. You could reference the same secret multiple times in the same job definition.
        :param _builtins.str environment: An environment variable containing the secret value. Must be specified if `file` is not specified.
        :param _builtins.str file: The absolute file path where the secret will be mounted. Must be specified if `environment` is not specified.
        :param _builtins.str secret_reference_id: The secret reference UUID that is automatically generated by the provider.
        :param _builtins.str secret_version: The secret version.
        """
        pulumi.set(__self__, "secret_id", secret_id)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if secret_reference_id is not None:
            pulumi.set(__self__, "secret_reference_id", secret_reference_id)
        if secret_version is not None:
            pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        The secret unique identifier, it could be formatted as region/UUID or UUID. In case the region is passed, it must be the same as the job definition. You could reference the same secret multiple times in the same job definition.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[_builtins.str]:
        """
        An environment variable containing the secret value. Must be specified if `file` is not specified.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def file(self) -> Optional[_builtins.str]:
        """
        The absolute file path where the secret will be mounted. Must be specified if `environment` is not specified.
        """
        return pulumi.get(self, "file")

    @_builtins.property
    @pulumi.getter(name="secretReferenceId")
    def secret_reference_id(self) -> Optional[_builtins.str]:
        """
        The secret reference UUID that is automatically generated by the provider.
        """
        return pulumi.get(self, "secret_reference_id")

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> Optional[_builtins.str]:
        """
        The secret version.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class KeyManagerKeyRotationPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rotationPeriod":
            suggest = "rotation_period"
        elif key == "nextRotationAt":
            suggest = "next_rotation_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyManagerKeyRotationPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyManagerKeyRotationPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyManagerKeyRotationPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rotation_period: _builtins.str,
                 next_rotation_at: Optional[_builtins.str] = None):
        """
        :param _builtins.str rotation_period: – The period between key rotations (e.g., `"720h"` for 30 days).
        :param _builtins.str next_rotation_at: The date and time of the next scheduled rotation.
        """
        pulumi.set(__self__, "rotation_period", rotation_period)
        if next_rotation_at is not None:
            pulumi.set(__self__, "next_rotation_at", next_rotation_at)

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> _builtins.str:
        """
        – The period between key rotations (e.g., `"720h"` for 30 days).
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="nextRotationAt")
    def next_rotation_at(self) -> Optional[_builtins.str]:
        """
        The date and time of the next scheduled rotation.
        """
        return pulumi.get(self, "next_rotation_at")


@pulumi.output_type
class KubernetesClusterAutoUpgrade(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maintenanceWindowDay":
            suggest = "maintenance_window_day"
        elif key == "maintenanceWindowStartHour":
            suggest = "maintenance_window_start_hour"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesClusterAutoUpgrade. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesClusterAutoUpgrade.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesClusterAutoUpgrade.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: _builtins.bool,
                 maintenance_window_day: _builtins.str,
                 maintenance_window_start_hour: _builtins.int):
        """
        :param _builtins.bool enable: Set to `true` to enable Kubernetes patch version auto upgrades.
               > **Important:** When enabling auto upgrades, the `version` field take a minor version like x.y (ie 1.18).
        :param _builtins.str maintenance_window_day: The day of the auto upgrade maintenance window (`monday` to `sunday`, or `any`).
        :param _builtins.int maintenance_window_start_hour: The start hour (UTC) of the 2-hour auto upgrade maintenance window (0 to 23).
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "maintenance_window_day", maintenance_window_day)
        pulumi.set(__self__, "maintenance_window_start_hour", maintenance_window_start_hour)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> _builtins.bool:
        """
        Set to `true` to enable Kubernetes patch version auto upgrades.
        > **Important:** When enabling auto upgrades, the `version` field take a minor version like x.y (ie 1.18).
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowDay")
    def maintenance_window_day(self) -> _builtins.str:
        """
        The day of the auto upgrade maintenance window (`monday` to `sunday`, or `any`).
        """
        return pulumi.get(self, "maintenance_window_day")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowStartHour")
    def maintenance_window_start_hour(self) -> _builtins.int:
        """
        The start hour (UTC) of the 2-hour auto upgrade maintenance window (0 to 23).
        """
        return pulumi.get(self, "maintenance_window_start_hour")


@pulumi.output_type
class KubernetesClusterAutoscalerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "balanceSimilarNodeGroups":
            suggest = "balance_similar_node_groups"
        elif key == "disableScaleDown":
            suggest = "disable_scale_down"
        elif key == "expendablePodsPriorityCutoff":
            suggest = "expendable_pods_priority_cutoff"
        elif key == "ignoreDaemonsetsUtilization":
            suggest = "ignore_daemonsets_utilization"
        elif key == "maxGracefulTerminationSec":
            suggest = "max_graceful_termination_sec"
        elif key == "scaleDownDelayAfterAdd":
            suggest = "scale_down_delay_after_add"
        elif key == "scaleDownUnneededTime":
            suggest = "scale_down_unneeded_time"
        elif key == "scaleDownUtilizationThreshold":
            suggest = "scale_down_utilization_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesClusterAutoscalerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesClusterAutoscalerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesClusterAutoscalerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 balance_similar_node_groups: Optional[_builtins.bool] = None,
                 disable_scale_down: Optional[_builtins.bool] = None,
                 estimator: Optional[_builtins.str] = None,
                 expander: Optional[_builtins.str] = None,
                 expendable_pods_priority_cutoff: Optional[_builtins.int] = None,
                 ignore_daemonsets_utilization: Optional[_builtins.bool] = None,
                 max_graceful_termination_sec: Optional[_builtins.int] = None,
                 scale_down_delay_after_add: Optional[_builtins.str] = None,
                 scale_down_unneeded_time: Optional[_builtins.str] = None,
                 scale_down_utilization_threshold: Optional[_builtins.float] = None):
        """
        :param _builtins.bool balance_similar_node_groups: Detect similar node groups and balance the number of nodes between them.
        :param _builtins.bool disable_scale_down: Disables the scale down feature of the autoscaler.
        :param _builtins.str estimator: Type of resource estimator to be used in scale up.
        :param _builtins.str expander: Type of node group expander to be used in scale up.
        :param _builtins.int expendable_pods_priority_cutoff: Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
        :param _builtins.bool ignore_daemonsets_utilization: Ignore DaemonSet pods when calculating resource utilization for scaling down.
        :param _builtins.int max_graceful_termination_sec: Maximum number of seconds the cluster autoscaler waits for pod termination when trying to scale down a node
        :param _builtins.str scale_down_delay_after_add: How long after scale up that scale down evaluation resumes.
        :param _builtins.str scale_down_unneeded_time: How long a node should be unneeded before it is eligible for scale down.
        :param _builtins.float scale_down_utilization_threshold: Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        """
        if balance_similar_node_groups is not None:
            pulumi.set(__self__, "balance_similar_node_groups", balance_similar_node_groups)
        if disable_scale_down is not None:
            pulumi.set(__self__, "disable_scale_down", disable_scale_down)
        if estimator is not None:
            pulumi.set(__self__, "estimator", estimator)
        if expander is not None:
            pulumi.set(__self__, "expander", expander)
        if expendable_pods_priority_cutoff is not None:
            pulumi.set(__self__, "expendable_pods_priority_cutoff", expendable_pods_priority_cutoff)
        if ignore_daemonsets_utilization is not None:
            pulumi.set(__self__, "ignore_daemonsets_utilization", ignore_daemonsets_utilization)
        if max_graceful_termination_sec is not None:
            pulumi.set(__self__, "max_graceful_termination_sec", max_graceful_termination_sec)
        if scale_down_delay_after_add is not None:
            pulumi.set(__self__, "scale_down_delay_after_add", scale_down_delay_after_add)
        if scale_down_unneeded_time is not None:
            pulumi.set(__self__, "scale_down_unneeded_time", scale_down_unneeded_time)
        if scale_down_utilization_threshold is not None:
            pulumi.set(__self__, "scale_down_utilization_threshold", scale_down_utilization_threshold)

    @_builtins.property
    @pulumi.getter(name="balanceSimilarNodeGroups")
    def balance_similar_node_groups(self) -> Optional[_builtins.bool]:
        """
        Detect similar node groups and balance the number of nodes between them.
        """
        return pulumi.get(self, "balance_similar_node_groups")

    @_builtins.property
    @pulumi.getter(name="disableScaleDown")
    def disable_scale_down(self) -> Optional[_builtins.bool]:
        """
        Disables the scale down feature of the autoscaler.
        """
        return pulumi.get(self, "disable_scale_down")

    @_builtins.property
    @pulumi.getter
    def estimator(self) -> Optional[_builtins.str]:
        """
        Type of resource estimator to be used in scale up.
        """
        return pulumi.get(self, "estimator")

    @_builtins.property
    @pulumi.getter
    def expander(self) -> Optional[_builtins.str]:
        """
        Type of node group expander to be used in scale up.
        """
        return pulumi.get(self, "expander")

    @_builtins.property
    @pulumi.getter(name="expendablePodsPriorityCutoff")
    def expendable_pods_priority_cutoff(self) -> Optional[_builtins.int]:
        """
        Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
        """
        return pulumi.get(self, "expendable_pods_priority_cutoff")

    @_builtins.property
    @pulumi.getter(name="ignoreDaemonsetsUtilization")
    def ignore_daemonsets_utilization(self) -> Optional[_builtins.bool]:
        """
        Ignore DaemonSet pods when calculating resource utilization for scaling down.
        """
        return pulumi.get(self, "ignore_daemonsets_utilization")

    @_builtins.property
    @pulumi.getter(name="maxGracefulTerminationSec")
    def max_graceful_termination_sec(self) -> Optional[_builtins.int]:
        """
        Maximum number of seconds the cluster autoscaler waits for pod termination when trying to scale down a node
        """
        return pulumi.get(self, "max_graceful_termination_sec")

    @_builtins.property
    @pulumi.getter(name="scaleDownDelayAfterAdd")
    def scale_down_delay_after_add(self) -> Optional[_builtins.str]:
        """
        How long after scale up that scale down evaluation resumes.
        """
        return pulumi.get(self, "scale_down_delay_after_add")

    @_builtins.property
    @pulumi.getter(name="scaleDownUnneededTime")
    def scale_down_unneeded_time(self) -> Optional[_builtins.str]:
        """
        How long a node should be unneeded before it is eligible for scale down.
        """
        return pulumi.get(self, "scale_down_unneeded_time")

    @_builtins.property
    @pulumi.getter(name="scaleDownUtilizationThreshold")
    def scale_down_utilization_threshold(self) -> Optional[_builtins.float]:
        """
        Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        """
        return pulumi.get(self, "scale_down_utilization_threshold")


@pulumi.output_type
class KubernetesClusterKubeconfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterCaCertificate":
            suggest = "cluster_ca_certificate"
        elif key == "configFile":
            suggest = "config_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesClusterKubeconfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesClusterKubeconfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesClusterKubeconfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_ca_certificate: Optional[_builtins.str] = None,
                 config_file: Optional[_builtins.str] = None,
                 host: Optional[_builtins.str] = None,
                 token: Optional[_builtins.str] = None):
        """
        :param _builtins.str cluster_ca_certificate: The CA certificate of the Kubernetes API server.
        :param _builtins.str config_file: The raw kubeconfig file.
        :param _builtins.str host: The URL of the Kubernetes API server.
        :param _builtins.str token: The token to connect to the Kubernetes API server.
        """
        if cluster_ca_certificate is not None:
            pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        if config_file is not None:
            pulumi.set(__self__, "config_file", config_file)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @_builtins.property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> Optional[_builtins.str]:
        """
        The CA certificate of the Kubernetes API server.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @_builtins.property
    @pulumi.getter(name="configFile")
    def config_file(self) -> Optional[_builtins.str]:
        """
        The raw kubeconfig file.
        """
        return pulumi.get(self, "config_file")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        The URL of the Kubernetes API server.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[_builtins.str]:
        """
        The token to connect to the Kubernetes API server.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class KubernetesClusterOpenIdConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "issuerUrl":
            suggest = "issuer_url"
        elif key == "groupsClaims":
            suggest = "groups_claims"
        elif key == "groupsPrefix":
            suggest = "groups_prefix"
        elif key == "requiredClaims":
            suggest = "required_claims"
        elif key == "usernameClaim":
            suggest = "username_claim"
        elif key == "usernamePrefix":
            suggest = "username_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesClusterOpenIdConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesClusterOpenIdConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesClusterOpenIdConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: _builtins.str,
                 issuer_url: _builtins.str,
                 groups_claims: Optional[Sequence[_builtins.str]] = None,
                 groups_prefix: Optional[_builtins.str] = None,
                 required_claims: Optional[Sequence[_builtins.str]] = None,
                 username_claim: Optional[_builtins.str] = None,
                 username_prefix: Optional[_builtins.str] = None):
        """
        :param _builtins.str client_id: A client id that all tokens must be issued for
        :param _builtins.str issuer_url: URL of the provider which allows the API server to discover public signing keys
        :param Sequence[_builtins.str] groups_claims: JWT claim to use as the user's group
        :param _builtins.str groups_prefix: Prefix prepended to group claims
        :param Sequence[_builtins.str] required_claims: Multiple key=value pairs that describes a required claim in the ID Token
        :param _builtins.str username_claim: JWT claim to use as the user name
        :param _builtins.str username_prefix: Prefix prepended to username
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "issuer_url", issuer_url)
        if groups_claims is not None:
            pulumi.set(__self__, "groups_claims", groups_claims)
        if groups_prefix is not None:
            pulumi.set(__self__, "groups_prefix", groups_prefix)
        if required_claims is not None:
            pulumi.set(__self__, "required_claims", required_claims)
        if username_claim is not None:
            pulumi.set(__self__, "username_claim", username_claim)
        if username_prefix is not None:
            pulumi.set(__self__, "username_prefix", username_prefix)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        A client id that all tokens must be issued for
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> _builtins.str:
        """
        URL of the provider which allows the API server to discover public signing keys
        """
        return pulumi.get(self, "issuer_url")

    @_builtins.property
    @pulumi.getter(name="groupsClaims")
    def groups_claims(self) -> Optional[Sequence[_builtins.str]]:
        """
        JWT claim to use as the user's group
        """
        return pulumi.get(self, "groups_claims")

    @_builtins.property
    @pulumi.getter(name="groupsPrefix")
    def groups_prefix(self) -> Optional[_builtins.str]:
        """
        Prefix prepended to group claims
        """
        return pulumi.get(self, "groups_prefix")

    @_builtins.property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Optional[Sequence[_builtins.str]]:
        """
        Multiple key=value pairs that describes a required claim in the ID Token
        """
        return pulumi.get(self, "required_claims")

    @_builtins.property
    @pulumi.getter(name="usernameClaim")
    def username_claim(self) -> Optional[_builtins.str]:
        """
        JWT claim to use as the user name
        """
        return pulumi.get(self, "username_claim")

    @_builtins.property
    @pulumi.getter(name="usernamePrefix")
    def username_prefix(self) -> Optional[_builtins.str]:
        """
        Prefix prepended to username
        """
        return pulumi.get(self, "username_prefix")


@pulumi.output_type
class KubernetesNodePoolNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIps":
            suggest = "private_ips"
        elif key == "publicIp":
            suggest = "public_ip"
        elif key == "publicIpV6":
            suggest = "public_ip_v6"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesNodePoolNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesNodePoolNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesNodePoolNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 private_ips: Optional[Sequence['outputs.KubernetesNodePoolNodePrivateIp']] = None,
                 public_ip: Optional[_builtins.str] = None,
                 public_ip_v6: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The ID of the IP address resource.
        :param _builtins.str name: The name for the pool.
               
               > **Important:** Updates to this field will recreate a new resource.
        :param Sequence['KubernetesNodePoolNodePrivateIpArgs'] private_ips: The list of private IPv4 and IPv6 addresses associated with the node.
        :param _builtins.str public_ip: The public IPv4. (Deprecated, Please use the official Kubernetes provider and the kubernetes_nodes data source)
        :param _builtins.str public_ip_v6: The public IPv6. (Deprecated, Please use the official Kubernetes provider and the kubernetes_nodes data source)
        :param _builtins.str status: The status of the node.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if public_ip_v6 is not None:
            pulumi.set(__self__, "public_ip_v6", public_ip_v6)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name for the pool.

        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[Sequence['outputs.KubernetesNodePoolNodePrivateIp']]:
        """
        The list of private IPv4 and IPv6 addresses associated with the node.
        """
        return pulumi.get(self, "private_ips")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    @_utilities.deprecated("""Please use the official Kubernetes provider and the kubernetes_nodes data source""")
    def public_ip(self) -> Optional[_builtins.str]:
        """
        The public IPv4. (Deprecated, Please use the official Kubernetes provider and the kubernetes_nodes data source)
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter(name="publicIpV6")
    @_utilities.deprecated("""Please use the official Kubernetes provider and the kubernetes_nodes data source""")
    def public_ip_v6(self) -> Optional[_builtins.str]:
        """
        The public IPv6. (Deprecated, Please use the official Kubernetes provider and the kubernetes_nodes data source)
        """
        return pulumi.get(self, "public_ip_v6")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the node.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class KubernetesNodePoolNodePrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The private IP address.
        :param _builtins.str id: The ID of the IP address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class KubernetesNodePoolUpgradePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSurge":
            suggest = "max_surge"
        elif key == "maxUnavailable":
            suggest = "max_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesNodePoolUpgradePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesNodePoolUpgradePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesNodePoolUpgradePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_surge: Optional[_builtins.int] = None,
                 max_unavailable: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_surge: The maximum number of nodes to be created during the upgrade
        :param _builtins.int max_unavailable: The maximum number of nodes that can be not ready at the same time
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @_builtins.property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[_builtins.int]:
        """
        The maximum number of nodes to be created during the upgrade
        """
        return pulumi.get(self, "max_surge")

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[_builtins.int]:
        """
        The maximum number of nodes that can be not ready at the same time
        """
        return pulumi.get(self, "max_unavailable")


@pulumi.output_type
class LoadbalancerAclAction(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 redirects: Optional[Sequence['outputs.LoadbalancerAclActionRedirect']] = None):
        """
        :param _builtins.str type: The action type. Possible values are: `allow` or `deny` or `redirect`.
        :param Sequence['LoadbalancerAclActionRedirectArgs'] redirects: Redirect parameters when using an ACL with `redirect` action.
        """
        pulumi.set(__self__, "type", type)
        if redirects is not None:
            pulumi.set(__self__, "redirects", redirects)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The action type. Possible values are: `allow` or `deny` or `redirect`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def redirects(self) -> Optional[Sequence['outputs.LoadbalancerAclActionRedirect']]:
        """
        Redirect parameters when using an ACL with `redirect` action.
        """
        return pulumi.get(self, "redirects")


@pulumi.output_type
class LoadbalancerAclActionRedirect(dict):
    def __init__(__self__, *,
                 code: Optional[_builtins.int] = None,
                 target: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.int code: The HTTP redirect code to use. Valid values are `301`, `302`, `303`, `307` and `308`.
        :param _builtins.str target: An URL can be used in case of a location redirect (e.g. `https://scaleway.com` will redirect to this same URL). A scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme.
        :param _builtins.str type: The redirect type. Possible values are: `location` or `scheme`.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        """
        The HTTP redirect code to use. Valid values are `301`, `302`, `303`, `307` and `308`.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[_builtins.str]:
        """
        An URL can be used in case of a location redirect (e.g. `https://scaleway.com` will redirect to this same URL). A scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The redirect type. Possible values are: `location` or `scheme`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LoadbalancerAclMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpFilter":
            suggest = "http_filter"
        elif key == "httpFilterOption":
            suggest = "http_filter_option"
        elif key == "httpFilterValues":
            suggest = "http_filter_values"
        elif key == "ipSubnets":
            suggest = "ip_subnets"
        elif key == "ipsEdgeServices":
            suggest = "ips_edge_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerAclMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerAclMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerAclMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_filter: Optional[_builtins.str] = None,
                 http_filter_option: Optional[_builtins.str] = None,
                 http_filter_values: Optional[Sequence[_builtins.str]] = None,
                 invert: Optional[_builtins.bool] = None,
                 ip_subnets: Optional[Sequence[_builtins.str]] = None,
                 ips_edge_services: Optional[_builtins.bool] = None):
        """
        :param _builtins.str http_filter: The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
               It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
               Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        :param _builtins.str http_filter_option: If you have `http_filter` at `http_header_match`, you can use this field to filter on the HTTP header's value.
        :param Sequence[_builtins.str] http_filter_values: A list of possible values to match for the given HTTP filter.
               Keep in mind that in the case of `http_header_match` the HTTP header field name is case insensitive.
        :param _builtins.bool invert: If set to `true`, the condition will be of type "unless".
        :param Sequence[_builtins.str] ip_subnets: A list of IPs, or CIDR v4/v6 addresses of the session client, to match. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        :param _builtins.bool ips_edge_services: Defines whether Edge Services IPs should be matched. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        if http_filter is not None:
            pulumi.set(__self__, "http_filter", http_filter)
        if http_filter_option is not None:
            pulumi.set(__self__, "http_filter_option", http_filter_option)
        if http_filter_values is not None:
            pulumi.set(__self__, "http_filter_values", http_filter_values)
        if invert is not None:
            pulumi.set(__self__, "invert", invert)
        if ip_subnets is not None:
            pulumi.set(__self__, "ip_subnets", ip_subnets)
        if ips_edge_services is not None:
            pulumi.set(__self__, "ips_edge_services", ips_edge_services)

    @_builtins.property
    @pulumi.getter(name="httpFilter")
    def http_filter(self) -> Optional[_builtins.str]:
        """
        The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
        It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
        Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        """
        return pulumi.get(self, "http_filter")

    @_builtins.property
    @pulumi.getter(name="httpFilterOption")
    def http_filter_option(self) -> Optional[_builtins.str]:
        """
        If you have `http_filter` at `http_header_match`, you can use this field to filter on the HTTP header's value.
        """
        return pulumi.get(self, "http_filter_option")

    @_builtins.property
    @pulumi.getter(name="httpFilterValues")
    def http_filter_values(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of possible values to match for the given HTTP filter.
        Keep in mind that in the case of `http_header_match` the HTTP header field name is case insensitive.
        """
        return pulumi.get(self, "http_filter_values")

    @_builtins.property
    @pulumi.getter
    def invert(self) -> Optional[_builtins.bool]:
        """
        If set to `true`, the condition will be of type "unless".
        """
        return pulumi.get(self, "invert")

    @_builtins.property
    @pulumi.getter(name="ipSubnets")
    def ip_subnets(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of IPs, or CIDR v4/v6 addresses of the session client, to match. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        return pulumi.get(self, "ip_subnets")

    @_builtins.property
    @pulumi.getter(name="ipsEdgeServices")
    def ips_edge_services(self) -> Optional[_builtins.bool]:
        """
        Defines whether Edge Services IPs should be matched. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        return pulumi.get(self, "ips_edge_services")


@pulumi.output_type
class LoadbalancerBackendHealthCheckHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostHeader":
            suggest = "host_header"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerBackendHealthCheckHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerBackendHealthCheckHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerBackendHealthCheckHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 uri: _builtins.str,
                 code: Optional[_builtins.int] = None,
                 host_header: Optional[_builtins.str] = None,
                 method: Optional[_builtins.str] = None):
        """
        :param _builtins.str uri: The HTTP endpoint URL to call for HC requests
        :param _builtins.int code: The expected HTTP status code
        :param _builtins.str host_header: The HTTP host header to use for HC requests
        :param _builtins.str method: The HTTP method to use for HC requests
        """
        pulumi.set(__self__, "uri", uri)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if method is not None:
            pulumi.set(__self__, "method", method)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        The HTTP endpoint URL to call for HC requests
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        """
        The expected HTTP status code
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[_builtins.str]:
        """
        The HTTP host header to use for HC requests
        """
        return pulumi.get(self, "host_header")

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[_builtins.str]:
        """
        The HTTP method to use for HC requests
        """
        return pulumi.get(self, "method")


@pulumi.output_type
class LoadbalancerBackendHealthCheckHttps(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostHeader":
            suggest = "host_header"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerBackendHealthCheckHttps. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerBackendHealthCheckHttps.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerBackendHealthCheckHttps.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 uri: _builtins.str,
                 code: Optional[_builtins.int] = None,
                 host_header: Optional[_builtins.str] = None,
                 method: Optional[_builtins.str] = None,
                 sni: Optional[_builtins.str] = None):
        """
        :param _builtins.str uri: The HTTPS endpoint URL to call for HC requests
        :param _builtins.int code: The expected HTTP status code
        :param _builtins.str host_header: The HTTP host header to use for HC requests
        :param _builtins.str method: The HTTP method to use for HC requests
        :param _builtins.str sni: The SNI to use for HC requests over SSL
        """
        pulumi.set(__self__, "uri", uri)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if sni is not None:
            pulumi.set(__self__, "sni", sni)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        The HTTPS endpoint URL to call for HC requests
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        """
        The expected HTTP status code
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[_builtins.str]:
        """
        The HTTP host header to use for HC requests
        """
        return pulumi.get(self, "host_header")

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[_builtins.str]:
        """
        The HTTP method to use for HC requests
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def sni(self) -> Optional[_builtins.str]:
        """
        The SNI to use for HC requests over SSL
        """
        return pulumi.get(self, "sni")


@pulumi.output_type
class LoadbalancerBackendHealthCheckTcp(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class LoadbalancerCertificateCustomCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateChain":
            suggest = "certificate_chain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerCertificateCustomCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerCertificateCustomCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerCertificateCustomCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_chain: _builtins.str):
        """
        :param _builtins.str certificate_chain: The full PEM-formatted certificate chain
        """
        pulumi.set(__self__, "certificate_chain", certificate_chain)

    @_builtins.property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> _builtins.str:
        """
        The full PEM-formatted certificate chain
        """
        return pulumi.get(self, "certificate_chain")


@pulumi.output_type
class LoadbalancerCertificateLetsencrypt(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "subjectAlternativeNames":
            suggest = "subject_alternative_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerCertificateLetsencrypt. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerCertificateLetsencrypt.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerCertificateLetsencrypt.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_name: _builtins.str,
                 subject_alternative_names: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str common_name: Main domain of the certificate
        :param Sequence[_builtins.str] subject_alternative_names: The alternative domain names of the certificate
        """
        pulumi.set(__self__, "common_name", common_name)
        if subject_alternative_names is not None:
            pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> _builtins.str:
        """
        Main domain of the certificate
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        The alternative domain names of the certificate
        """
        return pulumi.get(self, "subject_alternative_names")


@pulumi.output_type
class LoadbalancerFrontendAcl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendAcl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendAcl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendAcl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: 'outputs.LoadbalancerFrontendAclAction',
                 match: 'outputs.LoadbalancerFrontendAclMatch',
                 created_at: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 updated_at: Optional[_builtins.str] = None):
        """
        :param 'LoadbalancerFrontendAclActionArgs' action: Action to undertake when an ACL filter matches.
        :param 'LoadbalancerFrontendAclMatchArgs' match: The ACL match rule. At least `ip_subnet` or `ips_edge_services` or `http_filter` and `http_filter_value` are required.
        :param _builtins.str created_at: The date and time the frontend was created.
        :param _builtins.str description: Description of the ACL
        :param _builtins.str name: The ACL name. If not provided it will be randomly generated.
        :param _builtins.str updated_at: The date and time the frontend resource was updated.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "match", match)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def action(self) -> 'outputs.LoadbalancerFrontendAclAction':
        """
        Action to undertake when an ACL filter matches.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def match(self) -> 'outputs.LoadbalancerFrontendAclMatch':
        """
        The ACL match rule. At least `ip_subnet` or `ips_edge_services` or `http_filter` and `http_filter_value` are required.
        """
        return pulumi.get(self, "match")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[_builtins.str]:
        """
        The date and time the frontend was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the ACL
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The ACL name. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[_builtins.str]:
        """
        The date and time the frontend resource was updated.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class LoadbalancerFrontendAclAction(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 redirects: Optional[Sequence['outputs.LoadbalancerFrontendAclActionRedirect']] = None):
        """
        :param _builtins.str type: The action type. Possible values are: `allow` or `deny` or `redirect`.
        :param Sequence['LoadbalancerFrontendAclActionRedirectArgs'] redirects: Redirect parameters when using an ACL with `redirect` action.
        """
        pulumi.set(__self__, "type", type)
        if redirects is not None:
            pulumi.set(__self__, "redirects", redirects)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The action type. Possible values are: `allow` or `deny` or `redirect`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def redirects(self) -> Optional[Sequence['outputs.LoadbalancerFrontendAclActionRedirect']]:
        """
        Redirect parameters when using an ACL with `redirect` action.
        """
        return pulumi.get(self, "redirects")


@pulumi.output_type
class LoadbalancerFrontendAclActionRedirect(dict):
    def __init__(__self__, *,
                 code: Optional[_builtins.int] = None,
                 target: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.int code: The HTTP redirect code to use. Valid values are `301`, `302`, `303`, `307` and `308`.
        :param _builtins.str target: A URL can be used in case of a location redirect (e.g. `https://scaleway.com` will redirect to this same URL). A scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme.
        :param _builtins.str type: The redirect type. Possible values are: `location` or `scheme`.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        """
        The HTTP redirect code to use. Valid values are `301`, `302`, `303`, `307` and `308`.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[_builtins.str]:
        """
        A URL can be used in case of a location redirect (e.g. `https://scaleway.com` will redirect to this same URL). A scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The redirect type. Possible values are: `location` or `scheme`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LoadbalancerFrontendAclMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpFilter":
            suggest = "http_filter"
        elif key == "httpFilterOption":
            suggest = "http_filter_option"
        elif key == "httpFilterValues":
            suggest = "http_filter_values"
        elif key == "ipSubnets":
            suggest = "ip_subnets"
        elif key == "ipsEdgeServices":
            suggest = "ips_edge_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendAclMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendAclMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendAclMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_filter: Optional[_builtins.str] = None,
                 http_filter_option: Optional[_builtins.str] = None,
                 http_filter_values: Optional[Sequence[_builtins.str]] = None,
                 invert: Optional[_builtins.bool] = None,
                 ip_subnets: Optional[Sequence[_builtins.str]] = None,
                 ips_edge_services: Optional[_builtins.bool] = None):
        """
        :param _builtins.str http_filter: The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
               It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
               Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        :param _builtins.str http_filter_option: If you have `http_filter` at `http_header_match`, you can use this field to filter on the HTTP header's value.
        :param Sequence[_builtins.str] http_filter_values: A list of possible values to match for the given HTTP filter.
               Keep in mind that in the case of `http_header_match` the HTTP header field name is case insensitive.
        :param _builtins.bool invert: If set to `true`, the condition will be of type "unless".
        :param Sequence[_builtins.str] ip_subnets: A list of IPs, or CIDR v4/v6 addresses of the session client, to match. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        :param _builtins.bool ips_edge_services: Defines whether Edge Services IPs should be matched. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        if http_filter is not None:
            pulumi.set(__self__, "http_filter", http_filter)
        if http_filter_option is not None:
            pulumi.set(__self__, "http_filter_option", http_filter_option)
        if http_filter_values is not None:
            pulumi.set(__self__, "http_filter_values", http_filter_values)
        if invert is not None:
            pulumi.set(__self__, "invert", invert)
        if ip_subnets is not None:
            pulumi.set(__self__, "ip_subnets", ip_subnets)
        if ips_edge_services is not None:
            pulumi.set(__self__, "ips_edge_services", ips_edge_services)

    @_builtins.property
    @pulumi.getter(name="httpFilter")
    def http_filter(self) -> Optional[_builtins.str]:
        """
        The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
        It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
        Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        """
        return pulumi.get(self, "http_filter")

    @_builtins.property
    @pulumi.getter(name="httpFilterOption")
    def http_filter_option(self) -> Optional[_builtins.str]:
        """
        If you have `http_filter` at `http_header_match`, you can use this field to filter on the HTTP header's value.
        """
        return pulumi.get(self, "http_filter_option")

    @_builtins.property
    @pulumi.getter(name="httpFilterValues")
    def http_filter_values(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of possible values to match for the given HTTP filter.
        Keep in mind that in the case of `http_header_match` the HTTP header field name is case insensitive.
        """
        return pulumi.get(self, "http_filter_values")

    @_builtins.property
    @pulumi.getter
    def invert(self) -> Optional[_builtins.bool]:
        """
        If set to `true`, the condition will be of type "unless".
        """
        return pulumi.get(self, "invert")

    @_builtins.property
    @pulumi.getter(name="ipSubnets")
    def ip_subnets(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of IPs, or CIDR v4/v6 addresses of the session client, to match. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        return pulumi.get(self, "ip_subnets")

    @_builtins.property
    @pulumi.getter(name="ipsEdgeServices")
    def ips_edge_services(self) -> Optional[_builtins.bool]:
        """
        Defines whether Edge Services IPs should be matched. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        return pulumi.get(self, "ips_edge_services")


@pulumi.output_type
class LoadbalancerPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The private IP address.
        :param _builtins.str id: The ID of the IP address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class LoadbalancerPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateNetworkId":
            suggest = "private_network_id"
        elif key == "dhcpConfig":
            suggest = "dhcp_config"
        elif key == "ipamIds":
            suggest = "ipam_ids"
        elif key == "staticConfigs":
            suggest = "static_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_network_id: _builtins.str,
                 dhcp_config: Optional[_builtins.bool] = None,
                 ipam_ids: Optional[_builtins.str] = None,
                 static_configs: Optional[Sequence[_builtins.str]] = None,
                 status: Optional[_builtins.str] = None,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str private_network_id: The ID of the Private Network to attach to.
               - > **Important:** Updates to `private_network` will recreate the attachment.
        :param _builtins.bool dhcp_config: Set to true if you want to let DHCP assign IP addresses
        :param _builtins.str ipam_ids: IPAM ID of a pre-reserved IP address to assign to the Load Balancer on this Private Network.
        :param Sequence[_builtins.str] static_configs: Define an IP address in the subnet of your private network that will be assigned to your load balancer instance
        :param _builtins.str status: The status of the private network connection.
        :param _builtins.str zone: `zone`) The zone of the Load Balancer.
        """
        pulumi.set(__self__, "private_network_id", private_network_id)
        if dhcp_config is not None:
            pulumi.set(__self__, "dhcp_config", dhcp_config)
        if ipam_ids is not None:
            pulumi.set(__self__, "ipam_ids", ipam_ids)
        if static_configs is not None:
            pulumi.set(__self__, "static_configs", static_configs)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> _builtins.str:
        """
        The ID of the Private Network to attach to.
        - > **Important:** Updates to `private_network` will recreate the attachment.
        """
        return pulumi.get(self, "private_network_id")

    @_builtins.property
    @pulumi.getter(name="dhcpConfig")
    @_utilities.deprecated("""dhcp_config field is deprecated, please use `private_network_id` or `ipam_ids` instead""")
    def dhcp_config(self) -> Optional[_builtins.bool]:
        """
        Set to true if you want to let DHCP assign IP addresses
        """
        return pulumi.get(self, "dhcp_config")

    @_builtins.property
    @pulumi.getter(name="ipamIds")
    def ipam_ids(self) -> Optional[_builtins.str]:
        """
        IPAM ID of a pre-reserved IP address to assign to the Load Balancer on this Private Network.
        """
        return pulumi.get(self, "ipam_ids")

    @_builtins.property
    @pulumi.getter(name="staticConfigs")
    @_utilities.deprecated("""static_config field is deprecated, please use `private_network_id` or `ipam_ids` instead""")
    def static_configs(self) -> Optional[Sequence[_builtins.str]]:
        """
        Define an IP address in the subnet of your private network that will be assigned to your load balancer instance
        """
        return pulumi.get(self, "static_configs")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the private network connection.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        `zone`) The zone of the Load Balancer.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class MnqSnsCredentialsPermissions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canManage":
            suggest = "can_manage"
        elif key == "canPublish":
            suggest = "can_publish"
        elif key == "canReceive":
            suggest = "can_receive"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MnqSnsCredentialsPermissions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MnqSnsCredentialsPermissions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MnqSnsCredentialsPermissions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 can_manage: Optional[_builtins.bool] = None,
                 can_publish: Optional[_builtins.bool] = None,
                 can_receive: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool can_manage: . Defines whether the user can manage the associated resource(s).
        :param _builtins.bool can_publish: . Defines whether the user can publish messages to the service.
        :param _builtins.bool can_receive: . Defines whether the user can receive messages from the service.
        """
        if can_manage is not None:
            pulumi.set(__self__, "can_manage", can_manage)
        if can_publish is not None:
            pulumi.set(__self__, "can_publish", can_publish)
        if can_receive is not None:
            pulumi.set(__self__, "can_receive", can_receive)

    @_builtins.property
    @pulumi.getter(name="canManage")
    def can_manage(self) -> Optional[_builtins.bool]:
        """
        . Defines whether the user can manage the associated resource(s).
        """
        return pulumi.get(self, "can_manage")

    @_builtins.property
    @pulumi.getter(name="canPublish")
    def can_publish(self) -> Optional[_builtins.bool]:
        """
        . Defines whether the user can publish messages to the service.
        """
        return pulumi.get(self, "can_publish")

    @_builtins.property
    @pulumi.getter(name="canReceive")
    def can_receive(self) -> Optional[_builtins.bool]:
        """
        . Defines whether the user can receive messages from the service.
        """
        return pulumi.get(self, "can_receive")


@pulumi.output_type
class MnqSqsCredentialsPermissions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canManage":
            suggest = "can_manage"
        elif key == "canPublish":
            suggest = "can_publish"
        elif key == "canReceive":
            suggest = "can_receive"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MnqSqsCredentialsPermissions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MnqSqsCredentialsPermissions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MnqSqsCredentialsPermissions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 can_manage: Optional[_builtins.bool] = None,
                 can_publish: Optional[_builtins.bool] = None,
                 can_receive: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool can_manage: . Defines whether the user can manage the associated resource(s).
        :param _builtins.bool can_publish: . Defines whether the user can publish messages to the service.
        :param _builtins.bool can_receive: . Defines whether the user can receive messages from the service.
        """
        if can_manage is not None:
            pulumi.set(__self__, "can_manage", can_manage)
        if can_publish is not None:
            pulumi.set(__self__, "can_publish", can_publish)
        if can_receive is not None:
            pulumi.set(__self__, "can_receive", can_receive)

    @_builtins.property
    @pulumi.getter(name="canManage")
    def can_manage(self) -> Optional[_builtins.bool]:
        """
        . Defines whether the user can manage the associated resource(s).
        """
        return pulumi.get(self, "can_manage")

    @_builtins.property
    @pulumi.getter(name="canPublish")
    def can_publish(self) -> Optional[_builtins.bool]:
        """
        . Defines whether the user can publish messages to the service.
        """
        return pulumi.get(self, "can_publish")

    @_builtins.property
    @pulumi.getter(name="canReceive")
    def can_receive(self) -> Optional[_builtins.bool]:
        """
        . Defines whether the user can receive messages from the service.
        """
        return pulumi.get(self, "can_receive")


@pulumi.output_type
class MnqSqsQueueDeadLetterQueue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReceiveCount":
            suggest = "max_receive_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MnqSqsQueueDeadLetterQueue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MnqSqsQueueDeadLetterQueue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MnqSqsQueueDeadLetterQueue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 max_receive_count: _builtins.int):
        """
        :param _builtins.str id: The ID of the queue with format `{region/{project-id}/{queue-name}`
        :param _builtins.int max_receive_count: The number of times a message is delivered to the source queue before being sent to the dead-letter queue. Must be between 1 and 1,000.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "max_receive_count", max_receive_count)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the queue with format `{region/{project-id}/{queue-name}`
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxReceiveCount")
    def max_receive_count(self) -> _builtins.int:
        """
        The number of times a message is delivered to the source queue before being sent to the dead-letter queue. Must be between 1 and 1,000.
        """
        return pulumi.get(self, "max_receive_count")


@pulumi.output_type
class MongoDbInstancePrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The private IPv4 address.
        :param _builtins.str id: The ID of the endpoint.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The private IPv4 address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class MongoDbInstancePrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pnId":
            suggest = "pn_id"
        elif key == "dnsRecords":
            suggest = "dns_records"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MongoDbInstancePrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MongoDbInstancePrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MongoDbInstancePrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pn_id: _builtins.str,
                 dns_records: Optional[Sequence[_builtins.str]] = None,
                 id: Optional[_builtins.str] = None,
                 ips: Optional[Sequence[_builtins.str]] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str pn_id: The ID of the Private Network.
        :param Sequence[_builtins.str] dns_records: List of DNS records for your endpoint.
        :param _builtins.str id: The ID of the endpoint.
        :param Sequence[_builtins.str] ips: List of IP addresses for your endpoint.
        :param _builtins.int port: TCP port of the endpoint.
        """
        pulumi.set(__self__, "pn_id", pn_id)
        if dns_records is not None:
            pulumi.set(__self__, "dns_records", dns_records)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> _builtins.str:
        """
        The ID of the Private Network.
        """
        return pulumi.get(self, "pn_id")

    @_builtins.property
    @pulumi.getter(name="dnsRecords")
    def dns_records(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of DNS records for your endpoint.
        """
        return pulumi.get(self, "dns_records")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of IP addresses for your endpoint.
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class MongoDbInstancePublicNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsRecord":
            suggest = "dns_record"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MongoDbInstancePublicNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MongoDbInstancePublicNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MongoDbInstancePublicNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_record: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str dns_record: The DNS record of your endpoint
        :param _builtins.str id: The ID of the endpoint.
        :param _builtins.int port: TCP port of the endpoint.
        """
        if dns_record is not None:
            pulumi.set(__self__, "dns_record", dns_record)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="dnsRecord")
    def dns_record(self) -> Optional[_builtins.str]:
        """
        The DNS record of your endpoint
        """
        return pulumi.get(self, "dns_record")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ObjectBucketAclAccessControlPolicy(dict):
    def __init__(__self__, *,
                 owner: 'outputs.ObjectBucketAclAccessControlPolicyOwner',
                 grants: Optional[Sequence['outputs.ObjectBucketAclAccessControlPolicyGrant']] = None):
        """
        :param 'ObjectBucketAclAccessControlPolicyOwnerArgs' owner: Configuration block of the bucket project owner's display organization ID.
        :param Sequence['ObjectBucketAclAccessControlPolicyGrantArgs'] grants: Grant
        """
        pulumi.set(__self__, "owner", owner)
        if grants is not None:
            pulumi.set(__self__, "grants", grants)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> 'outputs.ObjectBucketAclAccessControlPolicyOwner':
        """
        Configuration block of the bucket project owner's display organization ID.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def grants(self) -> Optional[Sequence['outputs.ObjectBucketAclAccessControlPolicyGrant']]:
        """
        Grant
        """
        return pulumi.get(self, "grants")


@pulumi.output_type
class ObjectBucketAclAccessControlPolicyGrant(dict):
    def __init__(__self__, *,
                 permission: _builtins.str,
                 grantee: Optional['outputs.ObjectBucketAclAccessControlPolicyGrantGrantee'] = None):
        """
        :param _builtins.str permission: Logging permissions assigned to the grantee for the bucket.
        :param 'ObjectBucketAclAccessControlPolicyGrantGranteeArgs' grantee: Configuration block for the project being granted permissions.
        """
        pulumi.set(__self__, "permission", permission)
        if grantee is not None:
            pulumi.set(__self__, "grantee", grantee)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> _builtins.str:
        """
        Logging permissions assigned to the grantee for the bucket.
        """
        return pulumi.get(self, "permission")

    @_builtins.property
    @pulumi.getter
    def grantee(self) -> Optional['outputs.ObjectBucketAclAccessControlPolicyGrantGrantee']:
        """
        Configuration block for the project being granted permissions.
        """
        return pulumi.get(self, "grantee")


@pulumi.output_type
class ObjectBucketAclAccessControlPolicyGrantGrantee(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectBucketAclAccessControlPolicyGrantGrantee. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectBucketAclAccessControlPolicyGrantGrantee.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectBucketAclAccessControlPolicyGrantGrantee.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None,
                 uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str display_name: Display name of the grantee to grant access to.
        :param _builtins.str id: The `region`, `bucket` and `acl` separated by (`/`).
        :param _builtins.str type: Type of grantee. Valid values: `CanonicalUser`, `Group`
        :param _builtins.str uri: The uri of the grantee if you are granting permissions to a predefined group.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Display name of the grantee to grant access to.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The `region`, `bucket` and `acl` separated by (`/`).
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of grantee. Valid values: `CanonicalUser`, `Group`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[_builtins.str]:
        """
        The uri of the grantee if you are granting permissions to a predefined group.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class ObjectBucketAclAccessControlPolicyOwner(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectBucketAclAccessControlPolicyOwner. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectBucketAclAccessControlPolicyOwner.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectBucketAclAccessControlPolicyOwner.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 display_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The `region`, `bucket` and `acl` separated by (`/`).
        :param _builtins.str display_name: The project ID of the grantee.
        """
        pulumi.set(__self__, "id", id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The `region`, `bucket` and `acl` separated by (`/`).
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The project ID of the grantee.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class ObjectBucketCorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAgeSeconds":
            suggest = "max_age_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectBucketCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectBucketCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectBucketCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_methods: Sequence[_builtins.str],
                 allowed_origins: Sequence[_builtins.str],
                 allowed_headers: Optional[Sequence[_builtins.str]] = None,
                 expose_headers: Optional[Sequence[_builtins.str]] = None,
                 max_age_seconds: Optional[_builtins.int] = None):
        """
        :param Sequence[_builtins.str] allowed_methods: Specifies which methods are allowed (`GET`, `PUT`, `POST`, `DELETE` or `HEAD`).
        :param Sequence[_builtins.str] allowed_origins: Specifies which origins are allowed.
        :param Sequence[_builtins.str] allowed_headers: Specifies which headers are allowed.
        :param Sequence[_builtins.str] expose_headers: Specifies header exposure in the response.
        :param _builtins.int max_age_seconds: Specifies time in seconds that the browser can cache the response for a preflight request.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[_builtins.str]:
        """
        Specifies which methods are allowed (`GET`, `PUT`, `POST`, `DELETE` or `HEAD`).
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[_builtins.str]:
        """
        Specifies which origins are allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies which headers are allowed.
        """
        return pulumi.get(self, "allowed_headers")

    @_builtins.property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies header exposure in the response.
        """
        return pulumi.get(self, "expose_headers")

    @_builtins.property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[_builtins.int]:
        """
        Specifies time in seconds that the browser can cache the response for a preflight request.
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class ObjectBucketLifecycleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortIncompleteMultipartUploadDays":
            suggest = "abort_incomplete_multipart_upload_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectBucketLifecycleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectBucketLifecycleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectBucketLifecycleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 abort_incomplete_multipart_upload_days: Optional[_builtins.int] = None,
                 expiration: Optional['outputs.ObjectBucketLifecycleRuleExpiration'] = None,
                 id: Optional[_builtins.str] = None,
                 prefix: Optional[_builtins.str] = None,
                 tags: Optional[Mapping[str, _builtins.str]] = None,
                 transitions: Optional[Sequence['outputs.ObjectBucketLifecycleRuleTransition']] = None):
        """
        :param _builtins.bool enabled: The element value can be either Enabled or Disabled. If a rule is disabled, Scaleway Object Storage does not perform any of the actions defined in the rule.
        :param _builtins.int abort_incomplete_multipart_upload_days: Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
               
               > **Important:** Avoid using `prefix` for `AbortIncompleteMultipartUpload`, as any incomplete multipart upload will be billed
        :param 'ObjectBucketLifecycleRuleExpirationArgs' expiration: Specifies a period in the object's expire
        :param _builtins.str id: Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        :param _builtins.str prefix: Object key prefix identifying one or more objects to which the rule applies.
        :param Mapping[str, _builtins.str] tags: Specifies object tags key and value.
        :param Sequence['ObjectBucketLifecycleRuleTransitionArgs'] transitions: Define when objects transition to another storage class
        """
        pulumi.set(__self__, "enabled", enabled)
        if abort_incomplete_multipart_upload_days is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload_days", abort_incomplete_multipart_upload_days)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        The element value can be either Enabled or Disabled. If a rule is disabled, Scaleway Object Storage does not perform any of the actions defined in the rule.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="abortIncompleteMultipartUploadDays")
    def abort_incomplete_multipart_upload_days(self) -> Optional[_builtins.int]:
        """
        Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.

        > **Important:** Avoid using `prefix` for `AbortIncompleteMultipartUpload`, as any incomplete multipart upload will be billed
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload_days")

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> Optional['outputs.ObjectBucketLifecycleRuleExpiration']:
        """
        Specifies a period in the object's expire
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[_builtins.str]:
        """
        Object key prefix identifying one or more objects to which the rule applies.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Specifies object tags key and value.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def transitions(self) -> Optional[Sequence['outputs.ObjectBucketLifecycleRuleTransition']]:
        """
        Define when objects transition to another storage class
        """
        return pulumi.get(self, "transitions")


@pulumi.output_type
class ObjectBucketLifecycleRuleExpiration(dict):
    def __init__(__self__, *,
                 days: _builtins.int):
        """
        :param _builtins.int days: Specifies the number of days after object creation when the specific rule action takes effect.
        """
        pulumi.set(__self__, "days", days)

    @_builtins.property
    @pulumi.getter
    def days(self) -> _builtins.int:
        """
        Specifies the number of days after object creation when the specific rule action takes effect.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class ObjectBucketLifecycleRuleTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectBucketLifecycleRuleTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectBucketLifecycleRuleTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectBucketLifecycleRuleTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class: _builtins.str,
                 days: Optional[_builtins.int] = None):
        """
        :param _builtins.str storage_class: Specifies the Scaleway [storage class](https://www.scaleway.com/en/docs/object-storage/concepts/#storage-class) `STANDARD`, `GLACIER`, `ONEZONE_IA`  to which you want the object to transition.
               
               
               > **Important:**  If versioning is enabled, this rule only deletes the current version of an object.
               > **Important:**  If versioning is enabled, this rule only deletes the current version of an object.
               
               
               > **Important:**  `ONEZONE_IA` is only available in `fr-par` region. The storage class `GLACIER` is not available in `pl-waw` region.
               > **Important:**  `ONEZONE_IA` is only available in `fr-par` region. The storage class `GLACIER` is not available in `pl-waw` region.
        :param _builtins.int days: Specifies the number of days after object creation when the specific rule action takes effect.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        Specifies the Scaleway [storage class](https://www.scaleway.com/en/docs/object-storage/concepts/#storage-class) `STANDARD`, `GLACIER`, `ONEZONE_IA`  to which you want the object to transition.


        > **Important:**  If versioning is enabled, this rule only deletes the current version of an object.
        > **Important:**  If versioning is enabled, this rule only deletes the current version of an object.


        > **Important:**  `ONEZONE_IA` is only available in `fr-par` region. The storage class `GLACIER` is not available in `pl-waw` region.
        > **Important:**  `ONEZONE_IA` is only available in `fr-par` region. The storage class `GLACIER` is not available in `pl-waw` region.
        """
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter
    def days(self) -> Optional[_builtins.int]:
        """
        Specifies the number of days after object creation when the specific rule action takes effect.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class ObjectBucketLockConfigurationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRetention":
            suggest = "default_retention"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectBucketLockConfigurationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectBucketLockConfigurationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectBucketLockConfigurationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_retention: 'outputs.ObjectBucketLockConfigurationRuleDefaultRetention'):
        """
        :param 'ObjectBucketLockConfigurationRuleDefaultRetentionArgs' default_retention: The default retention for the lock.
        """
        pulumi.set(__self__, "default_retention", default_retention)

    @_builtins.property
    @pulumi.getter(name="defaultRetention")
    def default_retention(self) -> 'outputs.ObjectBucketLockConfigurationRuleDefaultRetention':
        """
        The default retention for the lock.
        """
        return pulumi.get(self, "default_retention")


@pulumi.output_type
class ObjectBucketLockConfigurationRuleDefaultRetention(dict):
    def __init__(__self__, *,
                 mode: _builtins.str,
                 days: Optional[_builtins.int] = None,
                 years: Optional[_builtins.int] = None):
        """
        :param _builtins.str mode: The default object lock retention mode you want to apply to new objects placed in the specified bucket. Valid values are `GOVERNANCE` or `COMPLIANCE`. Refer to the [dedicated documentation](https://www.scaleway.com/en/docs/object-storage/api-cli/object-lock/#retention-modes) for more information on retention modes.
        :param _builtins.int days: The number of days you want to specify for the default retention period.
        :param _builtins.int years: The number of years you want to specify for the default retention period.
        """
        pulumi.set(__self__, "mode", mode)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if years is not None:
            pulumi.set(__self__, "years", years)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        The default object lock retention mode you want to apply to new objects placed in the specified bucket. Valid values are `GOVERNANCE` or `COMPLIANCE`. Refer to the [dedicated documentation](https://www.scaleway.com/en/docs/object-storage/api-cli/object-lock/#retention-modes) for more information on retention modes.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def days(self) -> Optional[_builtins.int]:
        """
        The number of days you want to specify for the default retention period.
        """
        return pulumi.get(self, "days")

    @_builtins.property
    @pulumi.getter
    def years(self) -> Optional[_builtins.int]:
        """
        The number of years you want to specify for the default retention period.
        """
        return pulumi.get(self, "years")


@pulumi.output_type
class ObjectBucketVersioning(dict):
    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enabled: Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ObjectBucketWebsiteConfigurationErrorDocument(dict):
    def __init__(__self__, *,
                 key: _builtins.str):
        """
        :param _builtins.str key: The object key name to use when a 4XX class error occurs.
        """
        pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The object key name to use when a 4XX class error occurs.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class ObjectBucketWebsiteConfigurationIndexDocument(dict):
    def __init__(__self__, *,
                 suffix: _builtins.str):
        """
        :param _builtins.str suffix: A suffix that is appended to a request targeting a specific directory on the website endpoint.
               
               > **Important:** The suffix must not be empty and must not include a slash character. The routing is not supported.
        """
        pulumi.set(__self__, "suffix", suffix)

    @_builtins.property
    @pulumi.getter
    def suffix(self) -> _builtins.str:
        """
        A suffix that is appended to a request targeting a specific directory on the website endpoint.

        > **Important:** The suffix must not be empty and must not include a slash character. The routing is not supported.
        """
        return pulumi.get(self, "suffix")


@pulumi.output_type
class RedisClusterAcl(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str ip: The IP range to whitelist
               in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        :param _builtins.str description: A text describing this rule. Default description: `Allow IP`
               
               > The `acl` conflict with `private_network`. Only one should be specified.
        :param _builtins.str id: The ID of the IPv4 address resource.
        """
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The IP range to whitelist
        in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        A text describing this rule. Default description: `Allow IP`

        > The `acl` conflict with `private_network`. Only one should be specified.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IPv4 address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class RedisClusterPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The private IPv4 address.
        :param _builtins.str id: The ID of the IPv4 address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The private IPv4 address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IPv4 address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class RedisClusterPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointId":
            suggest = "endpoint_id"
        elif key == "serviceIps":
            suggest = "service_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RedisClusterPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RedisClusterPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RedisClusterPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 endpoint_id: Optional[_builtins.str] = None,
                 ips: Optional[Sequence[_builtins.str]] = None,
                 port: Optional[_builtins.int] = None,
                 service_ips: Optional[Sequence[_builtins.str]] = None,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The UUID of the Private Network resource.
        :param _builtins.str endpoint_id: The ID of the endpoint.
        :param Sequence[_builtins.str] ips: List of IPv4 addresses of the endpoint.
        :param _builtins.int port: TCP port of the endpoint.
        :param Sequence[_builtins.str] service_ips: Endpoint IPv4 addresses in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation). You must provide at least one IP per node.
               Keep in mind that in cluster mode you cannot edit your Private Network after its creation so if you want to be able to
               scale your cluster horizontally (adding nodes) later, you should provide more IPs than nodes.
               If not set, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
               > **Important:** When IPAM is enabled, the IPs specified here will be ignored and should not be provided.
               
               > The `private_network` conflicts with `acl`. Only one should be specified.
               
               > **Important:** The way to use Private Networks differs whether you are using Redis™ in Standalone or cluster mode.
               
               - Standalone mode (`cluster_size` = 1) : you can attach as many Private Networks as you want (each must be a separate
               block). If you detach your only Private Network, your cluster won't be reachable until you define a new Private or
               Public Network. You can modify your `private_network` and its specs, you can have both a Private and Public Network side
               by side.
               
               - Cluster mode (`cluster_size` > 2) : you can define a single Private Network as you create your cluster, you won't be
               able to edit or detach it afterward, unless you create another cluster. This also means that, if you are using a static
               configuration (`service_ips`), you won't be able to scale your cluster horizontally (add more nodes) since it would
               require updating the Private Network to add IPs.
               Your `service_ips` must be listed as follows:
        :param _builtins.str zone: `zone`) The zone in which the
               Redis™ cluster should be created.
        """
        pulumi.set(__self__, "id", id)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service_ips is not None:
            pulumi.set(__self__, "service_ips", service_ips)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The UUID of the Private Network resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[_builtins.str]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of IPv4 addresses of the endpoint.
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="serviceIps")
    def service_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        Endpoint IPv4 addresses in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation). You must provide at least one IP per node.
        Keep in mind that in cluster mode you cannot edit your Private Network after its creation so if you want to be able to
        scale your cluster horizontally (adding nodes) later, you should provide more IPs than nodes.
        If not set, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
        > **Important:** When IPAM is enabled, the IPs specified here will be ignored and should not be provided.

        > The `private_network` conflicts with `acl`. Only one should be specified.

        > **Important:** The way to use Private Networks differs whether you are using Redis™ in Standalone or cluster mode.

        - Standalone mode (`cluster_size` = 1) : you can attach as many Private Networks as you want (each must be a separate
        block). If you detach your only Private Network, your cluster won't be reachable until you define a new Private or
        Public Network. You can modify your `private_network` and its specs, you can have both a Private and Public Network side
        by side.

        - Cluster mode (`cluster_size` > 2) : you can define a single Private Network as you create your cluster, you won't be
        able to edit or detach it afterward, unless you create another cluster. This also means that, if you are using a static
        configuration (`service_ips`), you won't be able to scale your cluster horizontally (add more nodes) since it would
        require updating the Private Network to add IPs.
        Your `service_ips` must be listed as follows:
        """
        return pulumi.get(self, "service_ips")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        `zone`) The zone in which the
        Redis™ cluster should be created.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class RedisClusterPublicNetwork(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 ips: Optional[Sequence[_builtins.str]] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str id: The ID of the IPv4 address resource.
        :param Sequence[_builtins.str] ips: List of IPv4 addresses of the endpoint.
        :param _builtins.int port: TCP port of the endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IPv4 address resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of IPv4 addresses of the endpoint.
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class SecretEphemeralPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiresOnceAccessed":
            suggest = "expires_once_accessed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretEphemeralPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretEphemeralPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretEphemeralPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 expires_once_accessed: Optional[_builtins.bool] = None,
                 ttl: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: Action to perform when the version of a secret expires. Available values can be found in [SDK constants](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/secret/v1beta1#pkg-constants).
        :param _builtins.bool expires_once_accessed: True if the secret version expires after a single user access.
        :param _builtins.str ttl: Time frame, from one second and up to one year, during which the secret's versions are valid. Has to be specified in [Go Duration format](https://pkg.go.dev/time#ParseDuration) (ex: "30m", "24h").
        """
        pulumi.set(__self__, "action", action)
        if expires_once_accessed is not None:
            pulumi.set(__self__, "expires_once_accessed", expires_once_accessed)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        Action to perform when the version of a secret expires. Available values can be found in [SDK constants](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/secret/v1beta1#pkg-constants).
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="expiresOnceAccessed")
    def expires_once_accessed(self) -> Optional[_builtins.bool]:
        """
        True if the secret version expires after a single user access.
        """
        return pulumi.get(self, "expires_once_accessed")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[_builtins.str]:
        """
        Time frame, from one second and up to one year, during which the secret's versions are valid. Has to be specified in [Go Duration format](https://pkg.go.dev/time#ParseDuration) (ex: "30m", "24h").
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class SecretVersion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "secretId":
            suggest = "secret_id"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretVersion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretVersion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretVersion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None,
                 latest: Optional[_builtins.bool] = None,
                 revision: Optional[_builtins.str] = None,
                 secret_id: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 updated_at: Optional[_builtins.str] = None):
        """
        :param _builtins.str created_at: Date and time of the secret's creation (in RFC 3339 format).
        :param _builtins.str description: Description of the secret (e.g. `my-new-description`).
        :param _builtins.bool latest: Returns true if the version is the latest.
        :param _builtins.str revision: The revision of secret version
        :param _builtins.str secret_id: The secret ID associated with this version
        :param _builtins.str status: The status of the secret.
        :param _builtins.str updated_at: Date and time of the secret's last update (in RFC 3339 format).
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if latest is not None:
            pulumi.set(__self__, "latest", latest)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[_builtins.str]:
        """
        Date and time of the secret's creation (in RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the secret (e.g. `my-new-description`).
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def latest(self) -> Optional[_builtins.bool]:
        """
        Returns true if the version is the latest.
        """
        return pulumi.get(self, "latest")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> Optional[_builtins.str]:
        """
        The revision of secret version
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[_builtins.str]:
        """
        The secret ID associated with this version
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the secret.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[_builtins.str]:
        """
        Date and time of the secret's last update (in RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class TemDomainReputation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "previousScore":
            suggest = "previous_score"
        elif key == "previousScoredAt":
            suggest = "previous_scored_at"
        elif key == "scoredAt":
            suggest = "scored_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TemDomainReputation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TemDomainReputation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TemDomainReputation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 previous_score: Optional[_builtins.int] = None,
                 previous_scored_at: Optional[_builtins.str] = None,
                 score: Optional[_builtins.int] = None,
                 scored_at: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.int previous_score: The previously-calculated domain's reputation score.
        :param _builtins.str previous_scored_at: The time and date the previous reputation score was calculated.
        :param _builtins.int score: A range from 0 to 100 that determines your domain's reputation score.
        :param _builtins.str scored_at: The time and date the score was calculated.
        :param _builtins.str status: The status of the domain's reputation.
        """
        if previous_score is not None:
            pulumi.set(__self__, "previous_score", previous_score)
        if previous_scored_at is not None:
            pulumi.set(__self__, "previous_scored_at", previous_scored_at)
        if score is not None:
            pulumi.set(__self__, "score", score)
        if scored_at is not None:
            pulumi.set(__self__, "scored_at", scored_at)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="previousScore")
    def previous_score(self) -> Optional[_builtins.int]:
        """
        The previously-calculated domain's reputation score.
        """
        return pulumi.get(self, "previous_score")

    @_builtins.property
    @pulumi.getter(name="previousScoredAt")
    def previous_scored_at(self) -> Optional[_builtins.str]:
        """
        The time and date the previous reputation score was calculated.
        """
        return pulumi.get(self, "previous_scored_at")

    @_builtins.property
    @pulumi.getter
    def score(self) -> Optional[_builtins.int]:
        """
        A range from 0 to 100 that determines your domain's reputation score.
        """
        return pulumi.get(self, "score")

    @_builtins.property
    @pulumi.getter(name="scoredAt")
    def scored_at(self) -> Optional[_builtins.str]:
        """
        The time and date the score was calculated.
        """
        return pulumi.get(self, "scored_at")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the domain's reputation.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class VpcGatewayNetworkIpamConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipamIpId":
            suggest = "ipam_ip_id"
        elif key == "pushDefaultRoute":
            suggest = "push_default_route"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpcGatewayNetworkIpamConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpcGatewayNetworkIpamConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpcGatewayNetworkIpamConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipam_ip_id: Optional[_builtins.str] = None,
                 push_default_route: Optional[_builtins.bool] = None):
        """
        :param _builtins.str ipam_ip_id: Use this IPAM-booked IP ID as the Gateway's IP in this Private Network.
        :param _builtins.bool push_default_route: Defines whether to enable the default route on the GatewayNetwork.
        """
        if ipam_ip_id is not None:
            pulumi.set(__self__, "ipam_ip_id", ipam_ip_id)
        if push_default_route is not None:
            pulumi.set(__self__, "push_default_route", push_default_route)

    @_builtins.property
    @pulumi.getter(name="ipamIpId")
    def ipam_ip_id(self) -> Optional[_builtins.str]:
        """
        Use this IPAM-booked IP ID as the Gateway's IP in this Private Network.
        """
        return pulumi.get(self, "ipam_ip_id")

    @_builtins.property
    @pulumi.getter(name="pushDefaultRoute")
    def push_default_route(self) -> Optional[_builtins.bool]:
        """
        Defines whether to enable the default route on the GatewayNetwork.
        """
        return pulumi.get(self, "push_default_route")


@pulumi.output_type
class VpcGatewayNetworkPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The private IPv4 address.
        :param _builtins.str id: The ID of the IPv4 address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The private IPv4 address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IPv4 address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class VpcPrivateNetworkIpv4Subnet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "prefixLength":
            suggest = "prefix_length"
        elif key == "subnetMask":
            suggest = "subnet_mask"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpcPrivateNetworkIpv4Subnet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpcPrivateNetworkIpv4Subnet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpcPrivateNetworkIpv4Subnet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 created_at: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 prefix_length: Optional[_builtins.int] = None,
                 subnet: Optional[_builtins.str] = None,
                 subnet_mask: Optional[_builtins.str] = None,
                 updated_at: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The network address of the subnet in hexadecimal notation, e.g., '2001:db8::' for a '2001:db8::/64' subnet.
        :param _builtins.str created_at: The date and time of the creation of the subnet.
        :param _builtins.str id: The subnet ID.
        :param _builtins.int prefix_length: The length of the network prefix, e.g., 64 for a 'ffff:ffff:ffff:ffff::' mask.
        :param _builtins.str subnet: The subnet CIDR.
        :param _builtins.str subnet_mask: The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        :param _builtins.str updated_at: The date and time of the last update of the subnet.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if subnet_mask is not None:
            pulumi.set(__self__, "subnet_mask", subnet_mask)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The network address of the subnet in hexadecimal notation, e.g., '2001:db8::' for a '2001:db8::/64' subnet.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[_builtins.str]:
        """
        The date and time of the creation of the subnet.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The subnet ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[_builtins.int]:
        """
        The length of the network prefix, e.g., 64 for a 'ffff:ffff:ffff:ffff::' mask.
        """
        return pulumi.get(self, "prefix_length")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[_builtins.str]:
        """
        The subnet CIDR.
        """
        return pulumi.get(self, "subnet")

    @_builtins.property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> Optional[_builtins.str]:
        """
        The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        """
        return pulumi.get(self, "subnet_mask")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[_builtins.str]:
        """
        The date and time of the last update of the subnet.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class VpcPrivateNetworkIpv6Subnet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "prefixLength":
            suggest = "prefix_length"
        elif key == "subnetMask":
            suggest = "subnet_mask"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpcPrivateNetworkIpv6Subnet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpcPrivateNetworkIpv6Subnet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpcPrivateNetworkIpv6Subnet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 created_at: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 prefix_length: Optional[_builtins.int] = None,
                 subnet: Optional[_builtins.str] = None,
                 subnet_mask: Optional[_builtins.str] = None,
                 updated_at: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The network address of the subnet in hexadecimal notation, e.g., '2001:db8::' for a '2001:db8::/64' subnet.
        :param _builtins.str created_at: The date and time of the creation of the subnet.
        :param _builtins.str id: The subnet ID.
        :param _builtins.int prefix_length: The length of the network prefix, e.g., 64 for a 'ffff:ffff:ffff:ffff::' mask.
        :param _builtins.str subnet: The subnet CIDR.
        :param _builtins.str subnet_mask: The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        :param _builtins.str updated_at: The date and time of the last update of the subnet.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if subnet_mask is not None:
            pulumi.set(__self__, "subnet_mask", subnet_mask)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The network address of the subnet in hexadecimal notation, e.g., '2001:db8::' for a '2001:db8::/64' subnet.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[_builtins.str]:
        """
        The date and time of the creation of the subnet.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The subnet ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[_builtins.int]:
        """
        The length of the network prefix, e.g., 64 for a 'ffff:ffff:ffff:ffff::' mask.
        """
        return pulumi.get(self, "prefix_length")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[_builtins.str]:
        """
        The subnet CIDR.
        """
        return pulumi.get(self, "subnet")

    @_builtins.property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> Optional[_builtins.str]:
        """
        The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        """
        return pulumi.get(self, "subnet_mask")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[_builtins.str]:
        """
        The date and time of the last update of the subnet.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class WebhostingCpanelUrl(dict):
    def __init__(__self__, *,
                 dashboard: Optional[_builtins.str] = None,
                 webmail: Optional[_builtins.str] = None):
        """
        :param _builtins.str dashboard: The URL of the Dashboard.
        :param _builtins.str webmail: The URL of the Webmail interface.
        """
        if dashboard is not None:
            pulumi.set(__self__, "dashboard", dashboard)
        if webmail is not None:
            pulumi.set(__self__, "webmail", webmail)

    @_builtins.property
    @pulumi.getter
    def dashboard(self) -> Optional[_builtins.str]:
        """
        The URL of the Dashboard.
        """
        return pulumi.get(self, "dashboard")

    @_builtins.property
    @pulumi.getter
    def webmail(self) -> Optional[_builtins.str]:
        """
        The URL of the Webmail interface.
        """
        return pulumi.get(self, "webmail")


@pulumi.output_type
class WebhostingNameServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isDefault":
            suggest = "is_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhostingNameServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhostingNameServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhostingNameServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: Optional[_builtins.str] = None,
                 is_default: Optional[_builtins.bool] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str hostname: Hostname of the server
        :param _builtins.bool is_default: Whether or not the webhosting is the default one
        :param _builtins.str status: The hosting status.
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        Hostname of the server
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[_builtins.bool]:
        """
        Whether or not the webhosting is the default one
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The hosting status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class WebhostingOption(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The option ID.
        :param _builtins.str name: The option name.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The option ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The option name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class WebhostingRecord(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 priority: Optional[_builtins.int] = None,
                 status: Optional[_builtins.str] = None,
                 ttl: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The option name.
        :param _builtins.int priority: Priority of DNS records associated with the webhosting.
        :param _builtins.str status: The hosting status.
        :param _builtins.int ttl: Time to live in seconds of the record
        :param _builtins.str type: Type of the DNS record
        :param _builtins.str value: Value of the DNS record
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The option name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        Priority of DNS records associated with the webhosting.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The hosting status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[_builtins.int]:
        """
        Time to live in seconds of the record
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of the DNS record
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Value of the DNS record
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetBaremetalOfferCpuResult(dict):
    def __init__(__self__, *,
                 core_count: _builtins.int,
                 frequency: _builtins.int,
                 name: _builtins.str,
                 thread_count: _builtins.int):
        """
        :param _builtins.int core_count: Number of core on this CPU.
        :param _builtins.int frequency: Frequency of the memory in MHz.
        :param _builtins.str name: The offer name. Only one of `name` and `offer_id` should be specified.
        :param _builtins.int thread_count: Number of thread on this CPU.
        """
        pulumi.set(__self__, "core_count", core_count)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "thread_count", thread_count)

    @_builtins.property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> _builtins.int:
        """
        Number of core on this CPU.
        """
        return pulumi.get(self, "core_count")

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> _builtins.int:
        """
        Frequency of the memory in MHz.
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The offer name. Only one of `name` and `offer_id` should be specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="threadCount")
    def thread_count(self) -> _builtins.int:
        """
        Number of thread on this CPU.
        """
        return pulumi.get(self, "thread_count")


@pulumi.output_type
class GetBaremetalOfferDiskResult(dict):
    def __init__(__self__, *,
                 capacity: _builtins.int,
                 type: _builtins.str):
        """
        :param _builtins.int capacity: Capacity of the memory in GB.
        :param _builtins.str type: Type of memory.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> _builtins.int:
        """
        Capacity of the memory in GB.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of memory.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetBaremetalOfferMemoryResult(dict):
    def __init__(__self__, *,
                 capacity: _builtins.int,
                 frequency: _builtins.int,
                 is_ecc: _builtins.bool,
                 type: _builtins.str):
        """
        :param _builtins.int capacity: Capacity of the memory in GB.
        :param _builtins.int frequency: Frequency of the memory in MHz.
        :param _builtins.bool is_ecc: True if error-correcting code is available on this memory.
        :param _builtins.str type: Type of memory.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "is_ecc", is_ecc)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> _builtins.int:
        """
        Capacity of the memory in GB.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> _builtins.int:
        """
        Frequency of the memory in MHz.
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter(name="isEcc")
    def is_ecc(self) -> _builtins.bool:
        """
        True if error-correcting code is available on this memory.
        """
        return pulumi.get(self, "is_ecc")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of memory.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetBaremetalServerIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str,
                 reverse: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str address: The IPv6 address
        :param _builtins.str id: The ID of the server.
        :param _builtins.str reverse: The Reverse of the IPv6
        :param _builtins.str version: The version of the IPv6
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "reverse", reverse)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The IPv6 address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> _builtins.str:
        """
        The Reverse of the IPv6
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the IPv6
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetBaremetalServerIpv4Result(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str,
                 reverse: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str address: The IPv6 address
        :param _builtins.str id: The ID of the server.
        :param _builtins.str reverse: The Reverse of the IPv6
        :param _builtins.str version: The version of the IPv6
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "reverse", reverse)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The IPv6 address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> _builtins.str:
        """
        The Reverse of the IPv6
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the IPv6
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetBaremetalServerIpv6Result(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str,
                 reverse: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str address: The IPv6 address
        :param _builtins.str id: The ID of the server.
        :param _builtins.str reverse: The Reverse of the IPv6
        :param _builtins.str version: The version of the IPv6
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "reverse", reverse)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The IPv6 address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> _builtins.str:
        """
        The Reverse of the IPv6
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the IPv6
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetBaremetalServerOptionResult(dict):
    def __init__(__self__, *,
                 expires_at: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str expires_at: Auto expire the option after this date
        :param _builtins.str id: The ID of the server.
        :param _builtins.str name: The server name. Only one of `name` and `server_id` should be specified.
        """
        pulumi.set(__self__, "expires_at", expires_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> _builtins.str:
        """
        Auto expire the option after this date
        """
        return pulumi.get(self, "expires_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The server name. Only one of `name` and `server_id` should be specified.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetBaremetalServerPrivateIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The private IP address
        :param _builtins.str id: The ID of the server.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The private IP address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetBaremetalServerPrivateNetworkResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 id: _builtins.str,
                 ipam_ip_ids: Sequence[_builtins.str],
                 mapping_id: _builtins.str,
                 status: _builtins.str,
                 updated_at: _builtins.str,
                 vlan: _builtins.int):
        """
        :param _builtins.str created_at: The date and time of the creation of the private network
        :param _builtins.str id: The ID of the server.
        :param Sequence[_builtins.str] ipam_ip_ids: List of IPAM IP IDs to attach to the server
        :param _builtins.str mapping_id: The ID of the Server-to-Private Network mapping
        :param _builtins.str status: The private network status
        :param _builtins.str updated_at: The date and time of the last update of the private network
        :param _builtins.int vlan: The VLAN ID associated to the private network
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipam_ip_ids", ipam_ip_ids)
        pulumi.set(__self__, "mapping_id", mapping_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "vlan", vlan)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date and time of the creation of the private network
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipamIpIds")
    def ipam_ip_ids(self) -> Sequence[_builtins.str]:
        """
        List of IPAM IP IDs to attach to the server
        """
        return pulumi.get(self, "ipam_ip_ids")

    @_builtins.property
    @pulumi.getter(name="mappingId")
    def mapping_id(self) -> _builtins.str:
        """
        The ID of the Server-to-Private Network mapping
        """
        return pulumi.get(self, "mapping_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The private network status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The date and time of the last update of the private network
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def vlan(self) -> _builtins.int:
        """
        The VLAN ID associated to the private network
        """
        return pulumi.get(self, "vlan")


@pulumi.output_type
class GetBillingConsumptionsConsumptionResult(dict):
    def __init__(__self__, *,
                 billed_quantity: _builtins.str,
                 category_name: _builtins.str,
                 product_name: _builtins.str,
                 project_id: _builtins.str,
                 sku: _builtins.str,
                 unit: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str billed_quantity: The consumed quantity.
        :param _builtins.str category_name: The name of the consumption category.
        :param _builtins.str product_name: The product name.
        :param _builtins.str project_id: `project_id`) The ID of the project the consumption list is associated with.
        :param _builtins.str sku: The unique identifier of the product.
        :param _builtins.str unit: The unit of consumed quantity.
        :param _builtins.str value: The monetary value of the consumption.
        """
        pulumi.set(__self__, "billed_quantity", billed_quantity)
        pulumi.set(__self__, "category_name", category_name)
        pulumi.set(__self__, "product_name", product_name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="billedQuantity")
    def billed_quantity(self) -> _builtins.str:
        """
        The consumed quantity.
        """
        return pulumi.get(self, "billed_quantity")

    @_builtins.property
    @pulumi.getter(name="categoryName")
    def category_name(self) -> _builtins.str:
        """
        The name of the consumption category.
        """
        return pulumi.get(self, "category_name")

    @_builtins.property
    @pulumi.getter(name="productName")
    def product_name(self) -> _builtins.str:
        """
        The product name.
        """
        return pulumi.get(self, "product_name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        `project_id`) The ID of the project the consumption list is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> _builtins.str:
        """
        The unique identifier of the product.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        """
        The unit of consumed quantity.
        """
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The monetary value of the consumption.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetBillingInvoicesInvoiceResult(dict):
    def __init__(__self__, *,
                 billing_period: _builtins.str,
                 due_date: _builtins.str,
                 id: _builtins.str,
                 invoice_type: _builtins.str,
                 issued_date: _builtins.str,
                 number: _builtins.int,
                 organization_name: _builtins.str,
                 seller_name: _builtins.str,
                 start_date: _builtins.str,
                 state: _builtins.str,
                 stop_date: _builtins.str,
                 total_discount: _builtins.str,
                 total_tax: _builtins.str,
                 total_taxed: _builtins.str,
                 total_undiscount: _builtins.str,
                 total_untaxed: _builtins.str):
        """
        :param _builtins.str billing_period: The billing period of the invoice in the YYYY-MM format.
        :param _builtins.str due_date: The payment time limit, set according to the Organization's payment conditions (RFC 3339 format).
        :param _builtins.str id: The associated invoice ID.
        :param _builtins.str invoice_type: Invoices with the given type are listed. Valid values are `periodic` and `purchase`.
        :param _builtins.str issued_date: The date when the invoice was sent to the customer (RFC 3339 format).
        :param _builtins.int number: The invoice number.
        :param _builtins.str organization_name: The organization name.
        :param _builtins.str seller_name: The name of the seller (Scaleway).
        :param _builtins.str start_date: The start date of the billing period (RFC 3339 format).
        :param _builtins.str state: The state of the invoice.
        :param _builtins.str stop_date: The end date of the billing period (RFC 3339 format).
        :param _builtins.str total_discount: The total discount amount of the invoice.
        :param _builtins.str total_tax: The total tax amount of the invoice.
        :param _builtins.str total_taxed: The total amount, taxed.
        :param _builtins.str total_undiscount: The total amount of the invoice before applying the discount.
        :param _builtins.str total_untaxed: The total amount, untaxed.
        """
        pulumi.set(__self__, "billing_period", billing_period)
        pulumi.set(__self__, "due_date", due_date)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "invoice_type", invoice_type)
        pulumi.set(__self__, "issued_date", issued_date)
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "organization_name", organization_name)
        pulumi.set(__self__, "seller_name", seller_name)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "stop_date", stop_date)
        pulumi.set(__self__, "total_discount", total_discount)
        pulumi.set(__self__, "total_tax", total_tax)
        pulumi.set(__self__, "total_taxed", total_taxed)
        pulumi.set(__self__, "total_undiscount", total_undiscount)
        pulumi.set(__self__, "total_untaxed", total_untaxed)

    @_builtins.property
    @pulumi.getter(name="billingPeriod")
    def billing_period(self) -> _builtins.str:
        """
        The billing period of the invoice in the YYYY-MM format.
        """
        return pulumi.get(self, "billing_period")

    @_builtins.property
    @pulumi.getter(name="dueDate")
    def due_date(self) -> _builtins.str:
        """
        The payment time limit, set according to the Organization's payment conditions (RFC 3339 format).
        """
        return pulumi.get(self, "due_date")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The associated invoice ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="invoiceType")
    def invoice_type(self) -> _builtins.str:
        """
        Invoices with the given type are listed. Valid values are `periodic` and `purchase`.
        """
        return pulumi.get(self, "invoice_type")

    @_builtins.property
    @pulumi.getter(name="issuedDate")
    def issued_date(self) -> _builtins.str:
        """
        The date when the invoice was sent to the customer (RFC 3339 format).
        """
        return pulumi.get(self, "issued_date")

    @_builtins.property
    @pulumi.getter
    def number(self) -> _builtins.int:
        """
        The invoice number.
        """
        return pulumi.get(self, "number")

    @_builtins.property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> _builtins.str:
        """
        The organization name.
        """
        return pulumi.get(self, "organization_name")

    @_builtins.property
    @pulumi.getter(name="sellerName")
    def seller_name(self) -> _builtins.str:
        """
        The name of the seller (Scaleway).
        """
        return pulumi.get(self, "seller_name")

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> _builtins.str:
        """
        The start date of the billing period (RFC 3339 format).
        """
        return pulumi.get(self, "start_date")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The state of the invoice.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stopDate")
    def stop_date(self) -> _builtins.str:
        """
        The end date of the billing period (RFC 3339 format).
        """
        return pulumi.get(self, "stop_date")

    @_builtins.property
    @pulumi.getter(name="totalDiscount")
    def total_discount(self) -> _builtins.str:
        """
        The total discount amount of the invoice.
        """
        return pulumi.get(self, "total_discount")

    @_builtins.property
    @pulumi.getter(name="totalTax")
    def total_tax(self) -> _builtins.str:
        """
        The total tax amount of the invoice.
        """
        return pulumi.get(self, "total_tax")

    @_builtins.property
    @pulumi.getter(name="totalTaxed")
    def total_taxed(self) -> _builtins.str:
        """
        The total amount, taxed.
        """
        return pulumi.get(self, "total_taxed")

    @_builtins.property
    @pulumi.getter(name="totalUndiscount")
    def total_undiscount(self) -> _builtins.str:
        """
        The total amount of the invoice before applying the discount.
        """
        return pulumi.get(self, "total_undiscount")

    @_builtins.property
    @pulumi.getter(name="totalUntaxed")
    def total_untaxed(self) -> _builtins.str:
        """
        The total amount, untaxed.
        """
        return pulumi.get(self, "total_untaxed")


@pulumi.output_type
class GetBlockSnapshotExportResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 key: _builtins.str):
        """
        :param _builtins.str bucket: Bucket containing qcow
        :param _builtins.str key: Key of the qcow file in the specified bucket
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Bucket containing qcow
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Key of the qcow file in the specified bucket
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class GetBlockSnapshotImportResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 key: _builtins.str):
        """
        :param _builtins.str bucket: Bucket containing qcow
        :param _builtins.str key: Key of the qcow file in the specified bucket
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Bucket containing qcow
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Key of the qcow file in the specified bucket
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class GetCockpitEndpointResult(dict):
    def __init__(__self__, *,
                 alertmanager_url: _builtins.str,
                 grafana_url: _builtins.str,
                 logs_url: _builtins.str,
                 metrics_url: _builtins.str,
                 traces_url: _builtins.str):
        """
        :param _builtins.str alertmanager_url: (Deprecated) URL for the [Alert manager](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#alert-manager).
        :param _builtins.str grafana_url: (Deprecated) URL for Grafana.
        :param _builtins.str logs_url: (Deprecated) URL for [logs](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#logs) to retrieve in the [Data sources tab](https://console.scaleway.com/cockpit/dataSource) of the Scaleway console.
        :param _builtins.str metrics_url: (Deprecated) URL for [metrics](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#metric) to retrieve in the [Data sources tab](https://console.scaleway.com/cockpit/dataSource) of the Scaleway console.
        :param _builtins.str traces_url: The traces URL.
        """
        pulumi.set(__self__, "alertmanager_url", alertmanager_url)
        pulumi.set(__self__, "grafana_url", grafana_url)
        pulumi.set(__self__, "logs_url", logs_url)
        pulumi.set(__self__, "metrics_url", metrics_url)
        pulumi.set(__self__, "traces_url", traces_url)

    @_builtins.property
    @pulumi.getter(name="alertmanagerUrl")
    def alertmanager_url(self) -> _builtins.str:
        """
        (Deprecated) URL for the [Alert manager](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#alert-manager).
        """
        return pulumi.get(self, "alertmanager_url")

    @_builtins.property
    @pulumi.getter(name="grafanaUrl")
    def grafana_url(self) -> _builtins.str:
        """
        (Deprecated) URL for Grafana.
        """
        return pulumi.get(self, "grafana_url")

    @_builtins.property
    @pulumi.getter(name="logsUrl")
    def logs_url(self) -> _builtins.str:
        """
        (Deprecated) URL for [logs](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#logs) to retrieve in the [Data sources tab](https://console.scaleway.com/cockpit/dataSource) of the Scaleway console.
        """
        return pulumi.get(self, "logs_url")

    @_builtins.property
    @pulumi.getter(name="metricsUrl")
    def metrics_url(self) -> _builtins.str:
        """
        (Deprecated) URL for [metrics](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#metric) to retrieve in the [Data sources tab](https://console.scaleway.com/cockpit/dataSource) of the Scaleway console.
        """
        return pulumi.get(self, "metrics_url")

    @_builtins.property
    @pulumi.getter(name="tracesUrl")
    def traces_url(self) -> _builtins.str:
        """
        The traces URL.
        """
        return pulumi.get(self, "traces_url")


@pulumi.output_type
class GetCockpitPushUrlResult(dict):
    def __init__(__self__, *,
                 push_logs_url: _builtins.str,
                 push_metrics_url: _builtins.str):
        """
        :param _builtins.str push_logs_url: Push URL for logs (Grafana Loki)
        :param _builtins.str push_metrics_url: Push URL for metrics (Grafana Mimir)
        """
        pulumi.set(__self__, "push_logs_url", push_logs_url)
        pulumi.set(__self__, "push_metrics_url", push_metrics_url)

    @_builtins.property
    @pulumi.getter(name="pushLogsUrl")
    def push_logs_url(self) -> _builtins.str:
        """
        Push URL for logs (Grafana Loki)
        """
        return pulumi.get(self, "push_logs_url")

    @_builtins.property
    @pulumi.getter(name="pushMetricsUrl")
    def push_metrics_url(self) -> _builtins.str:
        """
        Push URL for metrics (Grafana Mimir)
        """
        return pulumi.get(self, "push_metrics_url")


@pulumi.output_type
class GetContainerHealthCheckResult(dict):
    def __init__(__self__, *,
                 failure_threshold: _builtins.int,
                 https: Sequence['outputs.GetContainerHealthCheckHttpResult'],
                 interval: _builtins.str):
        """
        :param _builtins.int failure_threshold: Number of consecutive health check failures before considering the container unhealthy.
        :param Sequence['GetContainerHealthCheckHttpArgs'] https: HTTP health check configuration.
        :param _builtins.str interval: Period between health checks (in seconds).
        """
        pulumi.set(__self__, "failure_threshold", failure_threshold)
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "interval", interval)

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> _builtins.int:
        """
        Number of consecutive health check failures before considering the container unhealthy.
        """
        return pulumi.get(self, "failure_threshold")

    @_builtins.property
    @pulumi.getter
    def https(self) -> Sequence['outputs.GetContainerHealthCheckHttpResult']:
        """
        HTTP health check configuration.
        """
        return pulumi.get(self, "https")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.str:
        """
        Period between health checks (in seconds).
        """
        return pulumi.get(self, "interval")


@pulumi.output_type
class GetContainerHealthCheckHttpResult(dict):
    def __init__(__self__, *,
                 path: _builtins.str):
        """
        :param _builtins.str path: Path to use for the HTTP health check.
        """
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path to use for the HTTP health check.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetContainerScalingOptionResult(dict):
    def __init__(__self__, *,
                 concurrent_requests_threshold: _builtins.int,
                 cpu_usage_threshold: _builtins.int,
                 memory_usage_threshold: _builtins.int):
        """
        :param _builtins.int concurrent_requests_threshold: Scale depending on the number of concurrent requests being processed per container instance.
        :param _builtins.int cpu_usage_threshold: Scale depending on the CPU usage of a container instance.
        :param _builtins.int memory_usage_threshold: Scale depending on the memory usage of a container instance.
        """
        pulumi.set(__self__, "concurrent_requests_threshold", concurrent_requests_threshold)
        pulumi.set(__self__, "cpu_usage_threshold", cpu_usage_threshold)
        pulumi.set(__self__, "memory_usage_threshold", memory_usage_threshold)

    @_builtins.property
    @pulumi.getter(name="concurrentRequestsThreshold")
    def concurrent_requests_threshold(self) -> _builtins.int:
        """
        Scale depending on the number of concurrent requests being processed per container instance.
        """
        return pulumi.get(self, "concurrent_requests_threshold")

    @_builtins.property
    @pulumi.getter(name="cpuUsageThreshold")
    def cpu_usage_threshold(self) -> _builtins.int:
        """
        Scale depending on the CPU usage of a container instance.
        """
        return pulumi.get(self, "cpu_usage_threshold")

    @_builtins.property
    @pulumi.getter(name="memoryUsageThreshold")
    def memory_usage_threshold(self) -> _builtins.int:
        """
        Scale depending on the memory usage of a container instance.
        """
        return pulumi.get(self, "memory_usage_threshold")


@pulumi.output_type
class GetDatabaseAclAclRuleResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 ip: _builtins.str):
        """
        :param _builtins.str description: A simple text describing this rule
        :param _builtins.str ip: The ip range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A simple text describing this rule
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The ip range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class GetDatabaseInstanceLoadBalancerResult(dict):
    def __init__(__self__, *,
                 endpoint_id: _builtins.str,
                 hostname: _builtins.str,
                 ip: _builtins.str,
                 name: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str endpoint_id: The endpoint ID
        :param _builtins.str hostname: The hostname of your endpoint
        :param _builtins.str ip: The IP of your load balancer service
        :param _builtins.str name: The name of the RDB instance.
        :param _builtins.int port: The port of your load balancer service
        """
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> _builtins.str:
        """
        The endpoint ID
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The hostname of your endpoint
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The IP of your load balancer service
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the RDB instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port of your load balancer service
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetDatabaseInstanceLogsPolicyResult(dict):
    def __init__(__self__, *,
                 max_age_retention: _builtins.int,
                 total_disk_retention: _builtins.int):
        """
        :param _builtins.int max_age_retention: The max age (in days) of remote logs to keep on the Database Instance
        :param _builtins.int total_disk_retention: The max disk size of remote logs to keep on the Database Instance.
        """
        pulumi.set(__self__, "max_age_retention", max_age_retention)
        pulumi.set(__self__, "total_disk_retention", total_disk_retention)

    @_builtins.property
    @pulumi.getter(name="maxAgeRetention")
    def max_age_retention(self) -> _builtins.int:
        """
        The max age (in days) of remote logs to keep on the Database Instance
        """
        return pulumi.get(self, "max_age_retention")

    @_builtins.property
    @pulumi.getter(name="totalDiskRetention")
    def total_disk_retention(self) -> _builtins.int:
        """
        The max disk size of remote logs to keep on the Database Instance.
        """
        return pulumi.get(self, "total_disk_retention")


@pulumi.output_type
class GetDatabaseInstancePrivateIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The private IPv4 address
        :param _builtins.str id: The ID of the Database Instance.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The private IPv4 address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Database Instance.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetDatabaseInstancePrivateNetworkResult(dict):
    def __init__(__self__, *,
                 enable_ipam: _builtins.bool,
                 endpoint_id: _builtins.str,
                 hostname: _builtins.str,
                 ip: _builtins.str,
                 ip_net: _builtins.str,
                 name: _builtins.str,
                 pn_id: _builtins.str,
                 port: _builtins.int,
                 zone: _builtins.str):
        """
        :param _builtins.bool enable_ipam: Whether or not the private network endpoint should be configured with IPAM
        :param _builtins.str endpoint_id: The endpoint ID
        :param _builtins.str hostname: The hostname of your endpoint
        :param _builtins.str ip: The IP of your Instance within the private service
        :param _builtins.str ip_net: The IP with the given mask within the private subnet
        :param _builtins.str name: The name of the RDB instance.
        :param _builtins.str pn_id: The private network ID
        :param _builtins.int port: The port of your private service
        :param _builtins.str zone: The zone you want to attach the resource to
        """
        pulumi.set(__self__, "enable_ipam", enable_ipam)
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "ip_net", ip_net)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pn_id", pn_id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="enableIpam")
    def enable_ipam(self) -> _builtins.bool:
        """
        Whether or not the private network endpoint should be configured with IPAM
        """
        return pulumi.get(self, "enable_ipam")

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> _builtins.str:
        """
        The endpoint ID
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The hostname of your endpoint
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The IP of your Instance within the private service
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipNet")
    def ip_net(self) -> _builtins.str:
        """
        The IP with the given mask within the private subnet
        """
        return pulumi.get(self, "ip_net")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the RDB instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> _builtins.str:
        """
        The private network ID
        """
        return pulumi.get(self, "pn_id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port of your private service
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        The zone you want to attach the resource to
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetDatabaseInstanceReadReplicaResult(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 name: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str ip: IP of the replica
        :param _builtins.str name: The name of the RDB instance.
        :param _builtins.int port: Port of the replica
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        IP of the replica
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the RDB instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port of the replica
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetDatabaseInstanceUpgradableVersionResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 minor_version: _builtins.str,
                 name: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str id: The ID of the Database Instance.
        :param _builtins.str minor_version: Minor version string
        :param _builtins.str name: The name of the RDB instance.
        :param _builtins.str version: Version string
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "minor_version", minor_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Database Instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="minorVersion")
    def minor_version(self) -> _builtins.str:
        """
        Minor version string
        """
        return pulumi.get(self, "minor_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the RDB instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Version string
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDomainRecordGeoIpResult(dict):
    def __init__(__self__, *,
                 matches: Sequence['outputs.GetDomainRecordGeoIpMatchResult']):
        """
        :param Sequence['GetDomainRecordGeoIpMatchArgs'] matches: The list of matches
        """
        pulumi.set(__self__, "matches", matches)

    @_builtins.property
    @pulumi.getter
    def matches(self) -> Sequence['outputs.GetDomainRecordGeoIpMatchResult']:
        """
        The list of matches
        """
        return pulumi.get(self, "matches")


@pulumi.output_type
class GetDomainRecordGeoIpMatchResult(dict):
    def __init__(__self__, *,
                 continents: Sequence[_builtins.str],
                 countries: Sequence[_builtins.str],
                 data: _builtins.str):
        """
        :param Sequence[_builtins.str] continents: List of continents (eg: EU for Europe, NA for North America, AS for Asia...). List of all continents code: https://api.scaleway.com/domain-private/v2beta1/continents
        :param Sequence[_builtins.str] countries: List of countries (eg: FR for France, US for the United States, GB for Great Britain...). List of all countries code: https://api.scaleway.com/domain-private/v2beta1/countries
        :param _builtins.str data: The content of the record (e.g., an IPv4 address for an `A` record or a string for a `TXT` record). Cannot be used with `record_id`.
        """
        pulumi.set(__self__, "continents", continents)
        pulumi.set(__self__, "countries", countries)
        pulumi.set(__self__, "data", data)

    @_builtins.property
    @pulumi.getter
    def continents(self) -> Sequence[_builtins.str]:
        """
        List of continents (eg: EU for Europe, NA for North America, AS for Asia...). List of all continents code: https://api.scaleway.com/domain-private/v2beta1/continents
        """
        return pulumi.get(self, "continents")

    @_builtins.property
    @pulumi.getter
    def countries(self) -> Sequence[_builtins.str]:
        """
        List of countries (eg: FR for France, US for the United States, GB for Great Britain...). List of all countries code: https://api.scaleway.com/domain-private/v2beta1/countries
        """
        return pulumi.get(self, "countries")

    @_builtins.property
    @pulumi.getter
    def data(self) -> _builtins.str:
        """
        The content of the record (e.g., an IPv4 address for an `A` record or a string for a `TXT` record). Cannot be used with `record_id`.
        """
        return pulumi.get(self, "data")


@pulumi.output_type
class GetDomainRecordHttpServiceResult(dict):
    def __init__(__self__, *,
                 ips: Sequence[_builtins.str],
                 must_contain: _builtins.str,
                 strategy: _builtins.str,
                 url: _builtins.str,
                 user_agent: _builtins.str):
        """
        :param Sequence[_builtins.str] ips: IPs to check
        :param _builtins.str must_contain: Text to search
        :param _builtins.str strategy: Strategy to return an IP from the IPs list
        :param _builtins.str url: URL to match the must_contain text to validate an IP
        :param _builtins.str user_agent: User-agent used when checking the URL
        """
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "must_contain", must_contain)
        pulumi.set(__self__, "strategy", strategy)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user_agent", user_agent)

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Sequence[_builtins.str]:
        """
        IPs to check
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter(name="mustContain")
    def must_contain(self) -> _builtins.str:
        """
        Text to search
        """
        return pulumi.get(self, "must_contain")

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> _builtins.str:
        """
        Strategy to return an IP from the IPs list
        """
        return pulumi.get(self, "strategy")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        URL to match the must_contain text to validate an IP
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="userAgent")
    def user_agent(self) -> _builtins.str:
        """
        User-agent used when checking the URL
        """
        return pulumi.get(self, "user_agent")


@pulumi.output_type
class GetDomainRecordViewResult(dict):
    def __init__(__self__, *,
                 data: _builtins.str,
                 subnet: _builtins.str):
        """
        :param _builtins.str data: The content of the record (e.g., an IPv4 address for an `A` record or a string for a `TXT` record). Cannot be used with `record_id`.
        :param _builtins.str subnet: The subnet of the view
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "subnet", subnet)

    @_builtins.property
    @pulumi.getter
    def data(self) -> _builtins.str:
        """
        The content of the record (e.g., an IPv4 address for an `A` record or a string for a `TXT` record). Cannot be used with `record_id`.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> _builtins.str:
        """
        The subnet of the view
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class GetDomainRecordWeightedResult(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.str ip: The weighted IP
        :param _builtins.int weight: The weight of the IP
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The weighted IP
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        The weight of the IP
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetFlexibleIpsIpResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 ip_address: _builtins.str,
                 mac_addresses: Sequence['outputs.GetFlexibleIpsIpMacAddressResult'],
                 organization_id: _builtins.str,
                 project_id: _builtins.str,
                 reverse: _builtins.str,
                 status: _builtins.str,
                 tags: Sequence[_builtins.str],
                 updated_at: _builtins.str,
                 zone: _builtins.str):
        """
        :param _builtins.str created_at: The date on which the flexible IP was created (RFC 3339 format).
        :param _builtins.str description: The description of the flexible IP.
        :param _builtins.str id: The MAC address ID.
        :param _builtins.str ip_address: IP address of the flexible IP
        :param Sequence['GetFlexibleIpsIpMacAddressArgs'] mac_addresses: The MAC address of the Virtual MAC.
        :param _builtins.str organization_id: (Defaults to provider `organization_id`) The ID of the organization the IP is in.
        :param _builtins.str project_id: (Defaults to provider `project_id`) The ID of the project the IP is in.
        :param _builtins.str reverse: The reverse domain associated with this IP.
        :param _builtins.str status: The status of virtual MAC.
        :param Sequence[_builtins.str] tags: List of tags used as filter. IPs with these exact tags are listed.
        :param _builtins.str updated_at: The date on which the flexible IP was last updated (RFC 3339 format).
        :param _builtins.str zone: `zone`) The zone in which IPs exist.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "mac_addresses", mac_addresses)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "reverse", reverse)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date on which the flexible IP was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the flexible IP.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The MAC address ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        IP address of the flexible IP
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="macAddresses")
    def mac_addresses(self) -> Sequence['outputs.GetFlexibleIpsIpMacAddressResult']:
        """
        The MAC address of the Virtual MAC.
        """
        return pulumi.get(self, "mac_addresses")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        (Defaults to provider `organization_id`) The ID of the organization the IP is in.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        (Defaults to provider `project_id`) The ID of the project the IP is in.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> _builtins.str:
        """
        The reverse domain associated with this IP.
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of virtual MAC.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        List of tags used as filter. IPs with these exact tags are listed.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The date on which the flexible IP was last updated (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        `zone`) The zone in which IPs exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetFlexibleIpsIpMacAddressResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 id: _builtins.str,
                 mac_address: _builtins.str,
                 mac_type: _builtins.str,
                 status: _builtins.str,
                 updated_at: _builtins.str,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str created_at: The date on which the flexible IP was created (RFC 3339 format).
        :param _builtins.str id: The MAC address ID.
        :param _builtins.str mac_address: The MAC address of the Virtual MAC.
        :param _builtins.str mac_type: The type of virtual MAC.
        :param _builtins.str status: The status of virtual MAC.
        :param _builtins.str updated_at: The date on which the flexible IP was last updated (RFC 3339 format).
        :param _builtins.str zone: `zone`) The zone in which IPs exist.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "mac_type", mac_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date on which the flexible IP was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The MAC address ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> _builtins.str:
        """
        The MAC address of the Virtual MAC.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="macType")
    def mac_type(self) -> _builtins.str:
        """
        The type of virtual MAC.
        """
        return pulumi.get(self, "mac_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of virtual MAC.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The date on which the flexible IP was last updated (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        `zone`) The zone in which IPs exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetInstancePrivateNicPrivateIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The private IP address
        :param _builtins.str id: The ID of the IP address resource
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The private IP address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the IP address resource
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetInstanceSecurityGroupInboundRuleResult(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 ip: _builtins.str,
                 ip_range: _builtins.str,
                 port: _builtins.int,
                 port_range: _builtins.str,
                 protocol: _builtins.str):
        """
        :param _builtins.str action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param _builtins.str ip: The ip this rule apply to.
        :param _builtins.str ip_range: The ip range (e.g `192.168.1.0/24`) this rule apply to.
        :param _builtins.int port: The port this rule apply to. If no port is specified, rule will apply to all port.
        :param _builtins.str port_range: The port range (e.g `22-23`) this rule applies to.
               If no `port` nor `port_range` are specified, rule will apply to all port.
               Only one of `port` and `port_range` should be specified.
        :param _builtins.str protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_range", port_range)
        pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The ip this rule apply to.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> _builtins.str:
        """
        The ip range (e.g `192.168.1.0/24`) this rule apply to.
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port this rule apply to. If no port is specified, rule will apply to all port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> _builtins.str:
        """
        The port range (e.g `22-23`) this rule applies to.
        If no `port` nor `port_range` are specified, rule will apply to all port.
        Only one of `port` and `port_range` should be specified.
        """
        return pulumi.get(self, "port_range")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetInstanceSecurityGroupOutboundRuleResult(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 ip: _builtins.str,
                 ip_range: _builtins.str,
                 port: _builtins.int,
                 port_range: _builtins.str,
                 protocol: _builtins.str):
        """
        :param _builtins.str action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param _builtins.str ip: The ip this rule apply to.
        :param _builtins.str ip_range: The ip range (e.g `192.168.1.0/24`) this rule apply to.
        :param _builtins.int port: The port this rule apply to. If no port is specified, rule will apply to all port.
        :param _builtins.str port_range: The port range (e.g `22-23`) this rule applies to.
               If no `port` nor `port_range` are specified, rule will apply to all port.
               Only one of `port` and `port_range` should be specified.
        :param _builtins.str protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_range", port_range)
        pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The ip this rule apply to.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> _builtins.str:
        """
        The ip range (e.g `192.168.1.0/24`) this rule apply to.
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port this rule apply to. If no port is specified, rule will apply to all port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> _builtins.str:
        """
        The port range (e.g `22-23`) this rule applies to.
        If no `port` nor `port_range` are specified, rule will apply to all port.
        Only one of `port` and `port_range` should be specified.
        """
        return pulumi.get(self, "port_range")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetInstanceServerFilesystemResult(dict):
    def __init__(__self__, *,
                 filesystem_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str filesystem_id: The filesystem ID attached to the server
        :param _builtins.str status: The state of the filesystem
        """
        pulumi.set(__self__, "filesystem_id", filesystem_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="filesystemId")
    def filesystem_id(self) -> _builtins.str:
        """
        The filesystem ID attached to the server
        """
        return pulumi.get(self, "filesystem_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The state of the filesystem
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetInstanceServerPrivateIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The private IP address.
        :param _builtins.str id: The ID of the IP address resource.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetInstanceServerPrivateNetworkResult(dict):
    def __init__(__self__, *,
                 mac_address: _builtins.str,
                 pn_id: _builtins.str,
                 pnic_id: _builtins.str,
                 status: _builtins.str,
                 zone: _builtins.str):
        """
        :param _builtins.str mac_address: MAC address of the NIC
        :param _builtins.str pn_id: The Private Network ID
        :param _builtins.str pnic_id: The ID of the NIC
        :param _builtins.str status: The private NIC state
        :param _builtins.str zone: `zone`) The zone in which the server exists.
        """
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "pn_id", pn_id)
        pulumi.set(__self__, "pnic_id", pnic_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> _builtins.str:
        """
        MAC address of the NIC
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> _builtins.str:
        """
        The Private Network ID
        """
        return pulumi.get(self, "pn_id")

    @_builtins.property
    @pulumi.getter(name="pnicId")
    def pnic_id(self) -> _builtins.str:
        """
        The ID of the NIC
        """
        return pulumi.get(self, "pnic_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The private NIC state
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        `zone`) The zone in which the server exists.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetInstanceServerPublicIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 dynamic: _builtins.bool,
                 family: _builtins.str,
                 gateway: _builtins.str,
                 id: _builtins.str,
                 netmask: _builtins.str,
                 provisioning_mode: _builtins.str):
        """
        :param _builtins.str address: The private IP address.
        :param _builtins.bool dynamic: Whether the IP is dynamic
        :param _builtins.str family: IP address family (inet or inet6)
        :param _builtins.str gateway: Gateway's IP address
        :param _builtins.str id: The ID of the IP address resource.
        :param _builtins.str netmask: CIDR netmask
        :param _builtins.str provisioning_mode: Provisioning mode of the IP address
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "dynamic", dynamic)
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "provisioning_mode", provisioning_mode)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def dynamic(self) -> _builtins.bool:
        """
        Whether the IP is dynamic
        """
        return pulumi.get(self, "dynamic")

    @_builtins.property
    @pulumi.getter
    def family(self) -> _builtins.str:
        """
        IP address family (inet or inet6)
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> _builtins.str:
        """
        Gateway's IP address
        """
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def netmask(self) -> _builtins.str:
        """
        CIDR netmask
        """
        return pulumi.get(self, "netmask")

    @_builtins.property
    @pulumi.getter(name="provisioningMode")
    def provisioning_mode(self) -> _builtins.str:
        """
        Provisioning mode of the IP address
        """
        return pulumi.get(self, "provisioning_mode")


@pulumi.output_type
class GetInstanceServerRootVolumeResult(dict):
    def __init__(__self__, *,
                 boot: _builtins.bool,
                 delete_on_termination: _builtins.bool,
                 name: _builtins.str,
                 sbs_iops: _builtins.int,
                 size_in_gb: _builtins.int,
                 volume_id: _builtins.str,
                 volume_type: _builtins.str):
        """
        :param _builtins.bool boot: Set the volume where the boot the server
        :param _builtins.bool delete_on_termination: Forces deletion of the root volume on instance termination.
        :param _builtins.str name: The server name. Only one of `name` and `server_id` should be specified.
        :param _builtins.int sbs_iops: SBS Volume IOPS, only with volume_type as sbs_volume
        :param _builtins.int size_in_gb: Size of the root volume in gigabytes.
        :param _builtins.str volume_id: The volume ID of the root volume of the server.
        :param _builtins.str volume_type: Volume type of the root volume
        """
        pulumi.set(__self__, "boot", boot)
        pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sbs_iops", sbs_iops)
        pulumi.set(__self__, "size_in_gb", size_in_gb)
        pulumi.set(__self__, "volume_id", volume_id)
        pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter
    def boot(self) -> _builtins.bool:
        """
        Set the volume where the boot the server
        """
        return pulumi.get(self, "boot")

    @_builtins.property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> _builtins.bool:
        """
        Forces deletion of the root volume on instance termination.
        """
        return pulumi.get(self, "delete_on_termination")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The server name. Only one of `name` and `server_id` should be specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sbsIops")
    def sbs_iops(self) -> _builtins.int:
        """
        SBS Volume IOPS, only with volume_type as sbs_volume
        """
        return pulumi.get(self, "sbs_iops")

    @_builtins.property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> _builtins.int:
        """
        Size of the root volume in gigabytes.
        """
        return pulumi.get(self, "size_in_gb")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> _builtins.str:
        """
        The volume ID of the root volume of the server.
        """
        return pulumi.get(self, "volume_id")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> _builtins.str:
        """
        Volume type of the root volume
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class GetInstanceServersServerResult(dict):
    def __init__(__self__, *,
                 boot_type: _builtins.str,
                 bootscript_id: _builtins.str,
                 enable_dynamic_ip: _builtins.bool,
                 id: _builtins.str,
                 image: _builtins.str,
                 name: _builtins.str,
                 organization_id: _builtins.str,
                 placement_group_id: _builtins.str,
                 placement_group_policy_respected: _builtins.bool,
                 private_ips: Sequence['outputs.GetInstanceServersServerPrivateIpResult'],
                 project_id: _builtins.str,
                 public_ips: Sequence['outputs.GetInstanceServersServerPublicIpResult'],
                 security_group_id: _builtins.str,
                 state: _builtins.str,
                 tags: Sequence[_builtins.str],
                 type: _builtins.str,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str boot_type: The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        :param _builtins.str bootscript_id: UUID of the bootscript
        :param _builtins.bool enable_dynamic_ip: If true a dynamic IP will be attached to the server.
        :param _builtins.str id: The ID of the IP
        :param _builtins.str image: The UUID or the label of the base image used by the server.
        :param _builtins.str name: The server name used as filter. Servers with a name like it are listed.
        :param _builtins.str organization_id: The organization ID the server is associated with.
        :param _builtins.str placement_group_id: The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the server is attached to.
        :param _builtins.bool placement_group_policy_respected: Whether the placement group policy respected or not
        :param Sequence['GetInstanceServersServerPrivateIpArgs'] private_ips: The list of private IPv4 and IPv6 addresses associated with the server.
        :param _builtins.str project_id: The ID of the project the server is associated with.
        :param Sequence['GetInstanceServersServerPublicIpArgs'] public_ips: The list of public IPs of the server
        :param _builtins.str security_group_id: The [security group](https://developers.scaleway.com/en/products/instance/api/#security-groups-8d7f89) the server is attached to.
        :param _builtins.str state: The state of the server. Possible values are: `started`, `stopped` or `standby`.
        :param Sequence[_builtins.str] tags: List of tags used as filter. Servers with these exact tags are listed.
        :param _builtins.str type: The commercial type of the server.
        :param _builtins.str zone: `zone`) The zone in which servers exist.
        """
        pulumi.set(__self__, "boot_type", boot_type)
        pulumi.set(__self__, "bootscript_id", bootscript_id)
        pulumi.set(__self__, "enable_dynamic_ip", enable_dynamic_ip)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "placement_group_id", placement_group_id)
        pulumi.set(__self__, "placement_group_policy_respected", placement_group_policy_respected)
        pulumi.set(__self__, "private_ips", private_ips)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "public_ips", public_ips)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="bootType")
    def boot_type(self) -> _builtins.str:
        """
        The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        """
        return pulumi.get(self, "boot_type")

    @_builtins.property
    @pulumi.getter(name="bootscriptId")
    @_utilities.deprecated("""bootscript are not supported""")
    def bootscript_id(self) -> _builtins.str:
        """
        UUID of the bootscript
        """
        return pulumi.get(self, "bootscript_id")

    @_builtins.property
    @pulumi.getter(name="enableDynamicIp")
    def enable_dynamic_ip(self) -> _builtins.bool:
        """
        If true a dynamic IP will be attached to the server.
        """
        return pulumi.get(self, "enable_dynamic_ip")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the IP
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        The UUID or the label of the base image used by the server.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The server name used as filter. Servers with a name like it are listed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        The organization ID the server is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> _builtins.str:
        """
        The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the server is attached to.
        """
        return pulumi.get(self, "placement_group_id")

    @_builtins.property
    @pulumi.getter(name="placementGroupPolicyRespected")
    def placement_group_policy_respected(self) -> _builtins.bool:
        """
        Whether the placement group policy respected or not
        """
        return pulumi.get(self, "placement_group_policy_respected")

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Sequence['outputs.GetInstanceServersServerPrivateIpResult']:
        """
        The list of private IPv4 and IPv6 addresses associated with the server.
        """
        return pulumi.get(self, "private_ips")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Sequence['outputs.GetInstanceServersServerPublicIpResult']:
        """
        The list of public IPs of the server
        """
        return pulumi.get(self, "public_ips")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        The [security group](https://developers.scaleway.com/en/products/instance/api/#security-groups-8d7f89) the server is attached to.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The state of the server. Possible values are: `started`, `stopped` or `standby`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        List of tags used as filter. Servers with these exact tags are listed.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The commercial type of the server.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        `zone`) The zone in which servers exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetInstanceServersServerPrivateIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The address of the IP
        :param _builtins.str id: The ID of the IP
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The address of the IP
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the IP
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetInstanceServersServerPublicIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The address of the IP
        :param _builtins.str id: The ID of the IP
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The address of the IP
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the IP
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetInstanceSnapshotImportResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 key: _builtins.str):
        """
        :param _builtins.str bucket: Bucket containing qcow
        :param _builtins.str key: Key of the qcow file in the specified bucket
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Bucket containing qcow
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Key of the qcow file in the specified bucket
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class GetIotDeviceCertificateResult(dict):
    def __init__(__self__, *,
                 crt: _builtins.str,
                 key: _builtins.str):
        """
        :param _builtins.str crt: X509 PEM encoded certificate of the device
        :param _builtins.str key: X509 PEM encoded key of the device
        """
        pulumi.set(__self__, "crt", crt)
        pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def crt(self) -> _builtins.str:
        """
        X509 PEM encoded certificate of the device
        """
        return pulumi.get(self, "crt")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        X509 PEM encoded key of the device
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class GetIotDeviceMessageFilterResult(dict):
    def __init__(__self__, *,
                 publishes: Sequence['outputs.GetIotDeviceMessageFilterPublishResult'],
                 subscribes: Sequence['outputs.GetIotDeviceMessageFilterSubscribeResult']):
        """
        :param Sequence['GetIotDeviceMessageFilterPublishArgs'] publishes: Rule to restrict topics the device can publish to
        :param Sequence['GetIotDeviceMessageFilterSubscribeArgs'] subscribes: Rule to restrict topics the device can subscribe to
        """
        pulumi.set(__self__, "publishes", publishes)
        pulumi.set(__self__, "subscribes", subscribes)

    @_builtins.property
    @pulumi.getter
    def publishes(self) -> Sequence['outputs.GetIotDeviceMessageFilterPublishResult']:
        """
        Rule to restrict topics the device can publish to
        """
        return pulumi.get(self, "publishes")

    @_builtins.property
    @pulumi.getter
    def subscribes(self) -> Sequence['outputs.GetIotDeviceMessageFilterSubscribeResult']:
        """
        Rule to restrict topics the device can subscribe to
        """
        return pulumi.get(self, "subscribes")


@pulumi.output_type
class GetIotDeviceMessageFilterPublishResult(dict):
    def __init__(__self__, *,
                 policy: _builtins.str,
                 topics: Sequence[_builtins.str]):
        """
        :param _builtins.str policy: Publish message filter policy
        :param Sequence[_builtins.str] topics: List of topics in the set
        """
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "topics", topics)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        Publish message filter policy
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def topics(self) -> Sequence[_builtins.str]:
        """
        List of topics in the set
        """
        return pulumi.get(self, "topics")


@pulumi.output_type
class GetIotDeviceMessageFilterSubscribeResult(dict):
    def __init__(__self__, *,
                 policy: _builtins.str,
                 topics: Sequence[_builtins.str]):
        """
        :param _builtins.str policy: Subscribe message filter policy
        :param Sequence[_builtins.str] topics: List of topics in the set
        """
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "topics", topics)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        Subscribe message filter policy
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def topics(self) -> Sequence[_builtins.str]:
        """
        List of topics in the set
        """
        return pulumi.get(self, "topics")


@pulumi.output_type
class GetIpamIpResourceResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of the resource the IP is attached to. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        :param _builtins.str id: The ID of the resource that the IP is attached to.
        :param _builtins.str name: The name of the resource the IP is attached to.
        """
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the resource the IP is attached to. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the resource that the IP is attached to.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the resource the IP is attached to.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetIpamIpsIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 created_at: _builtins.str,
                 id: _builtins.str,
                 project_id: _builtins.str,
                 region: _builtins.str,
                 resources: Sequence['outputs.GetIpamIpsIpResourceResult'],
                 tags: Sequence[_builtins.str],
                 updated_at: _builtins.str,
                 zone: _builtins.str):
        """
        :param _builtins.str address: The Scaleway internal IP address of the resource.
        :param _builtins.str created_at: The date and time of the creation of the IP.
        :param _builtins.str id: The ID of the resource.
        :param _builtins.str project_id: The ID of the Project to filter for.
        :param _builtins.str region: The region to filter for.
        :param Sequence['GetIpamIpsIpResourceArgs'] resources: Filter for a resource attached to the IP, using resource ID, type or name.
        :param Sequence[_builtins.str] tags: The IP tags to filter for.
        :param _builtins.str updated_at: The date and time of the last update of the IP.
        :param _builtins.str zone: The zone of the IP.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The Scaleway internal IP address of the resource.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date and time of the creation of the IP.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The ID of the Project to filter for.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region to filter for.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetIpamIpsIpResourceResult']:
        """
        Filter for a resource attached to the IP, using resource ID, type or name.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        The IP tags to filter for.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The date and time of the last update of the IP.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        The zone of the IP.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetIpamIpsIpResourceResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 mac_address: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str id: The ID of the attached resource.
        :param _builtins.str mac_address: The linked MAC address to filter for.
        :param _builtins.str name: The name of the attached resource.
        :param _builtins.str type: The type of the attached resource. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the attached resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> _builtins.str:
        """
        The linked MAC address to filter for.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the attached resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the attached resource. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetIpamIpsResourceResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of the attached resource. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        :param _builtins.str id: The ID of the attached resource.
        :param _builtins.str name: The name of the attached resource.
        """
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the attached resource. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the attached resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the attached resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetKubernetesClusterAutoUpgradeResult(dict):
    def __init__(__self__, *,
                 enable: _builtins.bool,
                 maintenance_window_day: _builtins.str,
                 maintenance_window_start_hour: _builtins.int):
        """
        :param _builtins.bool enable: True if Kubernetes patch version auto upgrades is enabled.
        :param _builtins.str maintenance_window_day: The day of the auto upgrade maintenance window (`monday` to `sunday`, or `any`).
        :param _builtins.int maintenance_window_start_hour: The start hour (UTC) of the 2-hour auto upgrade maintenance window (0 to 23).
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "maintenance_window_day", maintenance_window_day)
        pulumi.set(__self__, "maintenance_window_start_hour", maintenance_window_start_hour)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> _builtins.bool:
        """
        True if Kubernetes patch version auto upgrades is enabled.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowDay")
    def maintenance_window_day(self) -> _builtins.str:
        """
        The day of the auto upgrade maintenance window (`monday` to `sunday`, or `any`).
        """
        return pulumi.get(self, "maintenance_window_day")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowStartHour")
    def maintenance_window_start_hour(self) -> _builtins.int:
        """
        The start hour (UTC) of the 2-hour auto upgrade maintenance window (0 to 23).
        """
        return pulumi.get(self, "maintenance_window_start_hour")


@pulumi.output_type
class GetKubernetesClusterAutoscalerConfigResult(dict):
    def __init__(__self__, *,
                 balance_similar_node_groups: _builtins.bool,
                 disable_scale_down: _builtins.bool,
                 estimator: _builtins.str,
                 expander: _builtins.str,
                 expendable_pods_priority_cutoff: _builtins.int,
                 ignore_daemonsets_utilization: _builtins.bool,
                 max_graceful_termination_sec: _builtins.int,
                 scale_down_delay_after_add: _builtins.str,
                 scale_down_unneeded_time: _builtins.str,
                 scale_down_utilization_threshold: _builtins.float):
        """
        :param _builtins.bool balance_similar_node_groups: True if detecting similar node groups and balance the number of nodes between them is enabled.
        :param _builtins.bool disable_scale_down: True if the scale down feature of the autoscaler is disabled.
        :param _builtins.str estimator: The type of resource estimator used in scale up.
        :param _builtins.str expander: The type of node group expander be used in scale up.
        :param _builtins.int expendable_pods_priority_cutoff: Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
        :param _builtins.bool ignore_daemonsets_utilization: True if ignoring DaemonSet pods when calculating resource utilization for scaling down is enabled.
        :param _builtins.int max_graceful_termination_sec: Maximum number of seconds the cluster autoscaler waits for pod termination when trying to scale down a node
        :param _builtins.str scale_down_delay_after_add: The duration after scale up that scale down evaluation resumes.
        :param _builtins.str scale_down_unneeded_time: The duration a node should be unneeded before it is eligible for scale down.
        :param _builtins.float scale_down_utilization_threshold: Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        """
        pulumi.set(__self__, "balance_similar_node_groups", balance_similar_node_groups)
        pulumi.set(__self__, "disable_scale_down", disable_scale_down)
        pulumi.set(__self__, "estimator", estimator)
        pulumi.set(__self__, "expander", expander)
        pulumi.set(__self__, "expendable_pods_priority_cutoff", expendable_pods_priority_cutoff)
        pulumi.set(__self__, "ignore_daemonsets_utilization", ignore_daemonsets_utilization)
        pulumi.set(__self__, "max_graceful_termination_sec", max_graceful_termination_sec)
        pulumi.set(__self__, "scale_down_delay_after_add", scale_down_delay_after_add)
        pulumi.set(__self__, "scale_down_unneeded_time", scale_down_unneeded_time)
        pulumi.set(__self__, "scale_down_utilization_threshold", scale_down_utilization_threshold)

    @_builtins.property
    @pulumi.getter(name="balanceSimilarNodeGroups")
    def balance_similar_node_groups(self) -> _builtins.bool:
        """
        True if detecting similar node groups and balance the number of nodes between them is enabled.
        """
        return pulumi.get(self, "balance_similar_node_groups")

    @_builtins.property
    @pulumi.getter(name="disableScaleDown")
    def disable_scale_down(self) -> _builtins.bool:
        """
        True if the scale down feature of the autoscaler is disabled.
        """
        return pulumi.get(self, "disable_scale_down")

    @_builtins.property
    @pulumi.getter
    def estimator(self) -> _builtins.str:
        """
        The type of resource estimator used in scale up.
        """
        return pulumi.get(self, "estimator")

    @_builtins.property
    @pulumi.getter
    def expander(self) -> _builtins.str:
        """
        The type of node group expander be used in scale up.
        """
        return pulumi.get(self, "expander")

    @_builtins.property
    @pulumi.getter(name="expendablePodsPriorityCutoff")
    def expendable_pods_priority_cutoff(self) -> _builtins.int:
        """
        Pods with priority below cutoff will be expendable. They can be killed without any consideration during scale down and they don't cause scale up. Pods with null priority (PodPriority disabled) are non expendable.
        """
        return pulumi.get(self, "expendable_pods_priority_cutoff")

    @_builtins.property
    @pulumi.getter(name="ignoreDaemonsetsUtilization")
    def ignore_daemonsets_utilization(self) -> _builtins.bool:
        """
        True if ignoring DaemonSet pods when calculating resource utilization for scaling down is enabled.
        """
        return pulumi.get(self, "ignore_daemonsets_utilization")

    @_builtins.property
    @pulumi.getter(name="maxGracefulTerminationSec")
    def max_graceful_termination_sec(self) -> _builtins.int:
        """
        Maximum number of seconds the cluster autoscaler waits for pod termination when trying to scale down a node
        """
        return pulumi.get(self, "max_graceful_termination_sec")

    @_builtins.property
    @pulumi.getter(name="scaleDownDelayAfterAdd")
    def scale_down_delay_after_add(self) -> _builtins.str:
        """
        The duration after scale up that scale down evaluation resumes.
        """
        return pulumi.get(self, "scale_down_delay_after_add")

    @_builtins.property
    @pulumi.getter(name="scaleDownUnneededTime")
    def scale_down_unneeded_time(self) -> _builtins.str:
        """
        The duration a node should be unneeded before it is eligible for scale down.
        """
        return pulumi.get(self, "scale_down_unneeded_time")

    @_builtins.property
    @pulumi.getter(name="scaleDownUtilizationThreshold")
    def scale_down_utilization_threshold(self) -> _builtins.float:
        """
        Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        """
        return pulumi.get(self, "scale_down_utilization_threshold")


@pulumi.output_type
class GetKubernetesClusterKubeconfigResult(dict):
    def __init__(__self__, *,
                 cluster_ca_certificate: _builtins.str,
                 config_file: _builtins.str,
                 host: _builtins.str,
                 token: _builtins.str):
        """
        :param _builtins.str cluster_ca_certificate: The CA certificate of the Kubernetes API server.
        :param _builtins.str config_file: The raw kubeconfig file.
        :param _builtins.str host: The URL of the Kubernetes API server.
        :param _builtins.str token: The token to connect to the Kubernetes API server.
        """
        pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        pulumi.set(__self__, "config_file", config_file)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "token", token)

    @_builtins.property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> _builtins.str:
        """
        The CA certificate of the Kubernetes API server.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @_builtins.property
    @pulumi.getter(name="configFile")
    def config_file(self) -> _builtins.str:
        """
        The raw kubeconfig file.
        """
        return pulumi.get(self, "config_file")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The URL of the Kubernetes API server.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The token to connect to the Kubernetes API server.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class GetKubernetesClusterOpenIdConnectConfigResult(dict):
    def __init__(__self__, *,
                 client_id: _builtins.str,
                 groups_claims: Sequence[_builtins.str],
                 groups_prefix: _builtins.str,
                 issuer_url: _builtins.str,
                 required_claims: Sequence[_builtins.str],
                 username_claim: _builtins.str,
                 username_prefix: _builtins.str):
        """
        :param _builtins.str client_id: A client id that all tokens must be issued for
        :param Sequence[_builtins.str] groups_claims: JWT claim to use as the user's group
        :param _builtins.str groups_prefix: Prefix prepended to group claims
        :param _builtins.str issuer_url: URL of the provider which allows the API server to discover public signing keys
        :param Sequence[_builtins.str] required_claims: Multiple key=value pairs that describes a required claim in the ID Token
        :param _builtins.str username_claim: JWT claim to use as the user name
        :param _builtins.str username_prefix: Prefix prepended to username
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "groups_claims", groups_claims)
        pulumi.set(__self__, "groups_prefix", groups_prefix)
        pulumi.set(__self__, "issuer_url", issuer_url)
        pulumi.set(__self__, "required_claims", required_claims)
        pulumi.set(__self__, "username_claim", username_claim)
        pulumi.set(__self__, "username_prefix", username_prefix)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        A client id that all tokens must be issued for
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="groupsClaims")
    def groups_claims(self) -> Sequence[_builtins.str]:
        """
        JWT claim to use as the user's group
        """
        return pulumi.get(self, "groups_claims")

    @_builtins.property
    @pulumi.getter(name="groupsPrefix")
    def groups_prefix(self) -> _builtins.str:
        """
        Prefix prepended to group claims
        """
        return pulumi.get(self, "groups_prefix")

    @_builtins.property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> _builtins.str:
        """
        URL of the provider which allows the API server to discover public signing keys
        """
        return pulumi.get(self, "issuer_url")

    @_builtins.property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Sequence[_builtins.str]:
        """
        Multiple key=value pairs that describes a required claim in the ID Token
        """
        return pulumi.get(self, "required_claims")

    @_builtins.property
    @pulumi.getter(name="usernameClaim")
    def username_claim(self) -> _builtins.str:
        """
        JWT claim to use as the user name
        """
        return pulumi.get(self, "username_claim")

    @_builtins.property
    @pulumi.getter(name="usernamePrefix")
    def username_prefix(self) -> _builtins.str:
        """
        Prefix prepended to username
        """
        return pulumi.get(self, "username_prefix")


@pulumi.output_type
class GetKubernetesNodePoolNodeResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str,
                 private_ips: Sequence['outputs.GetKubernetesNodePoolNodePrivateIpResult'],
                 public_ip: _builtins.str,
                 public_ip_v6: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str id: The ID of the pool.
        :param _builtins.str name: The pool name. Only one of `name` and `pool_id` should be specified. `cluster_id` should be specified with `name`.
        :param Sequence['GetKubernetesNodePoolNodePrivateIpArgs'] private_ips: List of private IPv4 and IPv6 addresses associated with the node
        :param _builtins.str public_ip: The public IPv4.
        :param _builtins.str public_ip_v6: The public IPv6.
        :param _builtins.str status: The status of the node.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ips", private_ips)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "public_ip_v6", public_ip_v6)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the pool.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The pool name. Only one of `name` and `pool_id` should be specified. `cluster_id` should be specified with `name`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Sequence['outputs.GetKubernetesNodePoolNodePrivateIpResult']:
        """
        List of private IPv4 and IPv6 addresses associated with the node
        """
        return pulumi.get(self, "private_ips")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> _builtins.str:
        """
        The public IPv4.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter(name="publicIpV6")
    def public_ip_v6(self) -> _builtins.str:
        """
        The public IPv6.
        """
        return pulumi.get(self, "public_ip_v6")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the node.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetKubernetesNodePoolNodePrivateIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The private IP address
        :param _builtins.str id: The ID of the pool.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The private IP address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the pool.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetKubernetesNodePoolUpgradePolicyResult(dict):
    def __init__(__self__, *,
                 max_surge: _builtins.int,
                 max_unavailable: _builtins.int):
        """
        :param _builtins.int max_surge: The maximum number of nodes to be created during the upgrade
        :param _builtins.int max_unavailable: The maximum number of nodes that can be not ready at the same time
        """
        pulumi.set(__self__, "max_surge", max_surge)
        pulumi.set(__self__, "max_unavailable", max_unavailable)

    @_builtins.property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> _builtins.int:
        """
        The maximum number of nodes to be created during the upgrade
        """
        return pulumi.get(self, "max_surge")

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> _builtins.int:
        """
        The maximum number of nodes that can be not ready at the same time
        """
        return pulumi.get(self, "max_unavailable")


@pulumi.output_type
class GetLbAclsAclResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetLbAclsAclActionResult'],
                 created_at: _builtins.str,
                 description: _builtins.str,
                 frontend_id: _builtins.str,
                 id: _builtins.str,
                 index: _builtins.int,
                 matches: Sequence['outputs.GetLbAclsAclMatchResult'],
                 name: _builtins.str,
                 update_at: _builtins.str):
        """
        :param Sequence['GetLbAclsAclActionArgs'] actions: The action to be undertaken when an ACL filter matches.
        :param _builtins.str created_at: The date on which the ACL was created (RFC 3339 format).
        :param _builtins.str description: The description of the ACL resource.
        :param _builtins.str frontend_id: The frontend ID this ACL is attached to. ACLs with a matching frontend ID are listed.
               > **Important:** LB frontend IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        :param _builtins.str id: The associated ACL ID.
               > **Important:** LB ACLs' IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        :param _builtins.int index: The priority of this ACL in the ordered list.
        :param Sequence['GetLbAclsAclMatchArgs'] matches: The ACL match rule.
        :param _builtins.str name: The ACL name to filter for. ACLs with a matching name are listed.
        :param _builtins.str update_at: The date on which the ACL was last updated (RFC 3339 format).
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "frontend_id", frontend_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "matches", matches)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "update_at", update_at)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetLbAclsAclActionResult']:
        """
        The action to be undertaken when an ACL filter matches.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date on which the ACL was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the ACL resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> _builtins.str:
        """
        The frontend ID this ACL is attached to. ACLs with a matching frontend ID are listed.
        > **Important:** LB frontend IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        """
        return pulumi.get(self, "frontend_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The associated ACL ID.
        > **Important:** LB ACLs' IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def index(self) -> _builtins.int:
        """
        The priority of this ACL in the ordered list.
        """
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter
    def matches(self) -> Sequence['outputs.GetLbAclsAclMatchResult']:
        """
        The ACL match rule.
        """
        return pulumi.get(self, "matches")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The ACL name to filter for. ACLs with a matching name are listed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="updateAt")
    def update_at(self) -> _builtins.str:
        """
        The date on which the ACL was last updated (RFC 3339 format).
        """
        return pulumi.get(self, "update_at")


@pulumi.output_type
class GetLbAclsAclActionResult(dict):
    def __init__(__self__, *,
                 redirects: Sequence['outputs.GetLbAclsAclActionRedirectResult'],
                 type: _builtins.str):
        """
        :param Sequence['GetLbAclsAclActionRedirectArgs'] redirects: Redirect parameters when using an ACL with `redirect` action.
        :param _builtins.str type: The redirect type.
        """
        pulumi.set(__self__, "redirects", redirects)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def redirects(self) -> Sequence['outputs.GetLbAclsAclActionRedirectResult']:
        """
        Redirect parameters when using an ACL with `redirect` action.
        """
        return pulumi.get(self, "redirects")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The redirect type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetLbAclsAclActionRedirectResult(dict):
    def __init__(__self__, *,
                 code: _builtins.int,
                 target: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.int code: The HTTP redirect code to use.
        :param _builtins.str target: The URL used in case of a location redirect, or the scheme name that replaces the request's original scheme.
        :param _builtins.str type: The redirect type.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.int:
        """
        The HTTP redirect code to use.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def target(self) -> _builtins.str:
        """
        The URL used in case of a location redirect, or the scheme name that replaces the request's original scheme.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The redirect type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetLbAclsAclMatchResult(dict):
    def __init__(__self__, *,
                 http_filter: _builtins.str,
                 http_filter_option: _builtins.str,
                 http_filter_values: Sequence[_builtins.str],
                 invert: _builtins.bool,
                 ip_subnets: Sequence[_builtins.str],
                 ips_edge_services: _builtins.bool):
        """
        :param _builtins.str http_filter: The HTTP filter to match.
        :param _builtins.str http_filter_option: A list of possible values for the HTTP filter based on the HTTP header.
        :param Sequence[_builtins.str] http_filter_values: The possible values to match for a given HTTP filter.
        :param _builtins.bool invert: The condition will be of type "unless" if invert is set to `true`
        :param Sequence[_builtins.str] ip_subnets: A list of IPs, or CIDR v4/v6 addresses of the session client, to match.
        :param _builtins.bool ips_edge_services: Defines whether Edge Services IPs should be matched.
        """
        pulumi.set(__self__, "http_filter", http_filter)
        pulumi.set(__self__, "http_filter_option", http_filter_option)
        pulumi.set(__self__, "http_filter_values", http_filter_values)
        pulumi.set(__self__, "invert", invert)
        pulumi.set(__self__, "ip_subnets", ip_subnets)
        pulumi.set(__self__, "ips_edge_services", ips_edge_services)

    @_builtins.property
    @pulumi.getter(name="httpFilter")
    def http_filter(self) -> _builtins.str:
        """
        The HTTP filter to match.
        """
        return pulumi.get(self, "http_filter")

    @_builtins.property
    @pulumi.getter(name="httpFilterOption")
    def http_filter_option(self) -> _builtins.str:
        """
        A list of possible values for the HTTP filter based on the HTTP header.
        """
        return pulumi.get(self, "http_filter_option")

    @_builtins.property
    @pulumi.getter(name="httpFilterValues")
    def http_filter_values(self) -> Sequence[_builtins.str]:
        """
        The possible values to match for a given HTTP filter.
        """
        return pulumi.get(self, "http_filter_values")

    @_builtins.property
    @pulumi.getter
    def invert(self) -> _builtins.bool:
        """
        The condition will be of type "unless" if invert is set to `true`
        """
        return pulumi.get(self, "invert")

    @_builtins.property
    @pulumi.getter(name="ipSubnets")
    def ip_subnets(self) -> Sequence[_builtins.str]:
        """
        A list of IPs, or CIDR v4/v6 addresses of the session client, to match.
        """
        return pulumi.get(self, "ip_subnets")

    @_builtins.property
    @pulumi.getter(name="ipsEdgeServices")
    def ips_edge_services(self) -> _builtins.bool:
        """
        Defines whether Edge Services IPs should be matched.
        """
        return pulumi.get(self, "ips_edge_services")


@pulumi.output_type
class GetLbBackendHealthCheckHttpResult(dict):
    def __init__(__self__, *,
                 code: _builtins.int,
                 host_header: _builtins.str,
                 method: _builtins.str,
                 sni: _builtins.str,
                 uri: _builtins.str):
        """
        :param _builtins.int code: The expected HTTP status code
        :param _builtins.str host_header: The HTTP host header to use for HC requests
        :param _builtins.str method: The HTTP method to use for HC requests
        :param _builtins.str sni: The SNI to use for HC requests over SSL
        :param _builtins.str uri: The HTTPS endpoint URL to call for HC requests
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "host_header", host_header)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "sni", sni)
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.int:
        """
        The expected HTTP status code
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> _builtins.str:
        """
        The HTTP host header to use for HC requests
        """
        return pulumi.get(self, "host_header")

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        The HTTP method to use for HC requests
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def sni(self) -> _builtins.str:
        """
        The SNI to use for HC requests over SSL
        """
        return pulumi.get(self, "sni")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        The HTTPS endpoint URL to call for HC requests
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetLbBackendHealthCheckTcpResult(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class GetLbBackendsBackendResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 failover_host: _builtins.str,
                 forward_port: _builtins.int,
                 forward_port_algorithm: _builtins.str,
                 forward_protocol: _builtins.str,
                 health_check_delay: _builtins.str,
                 health_check_http: Sequence['outputs.GetLbBackendsBackendHealthCheckHttpResult'],
                 health_check_https: Sequence['outputs.GetLbBackendsBackendHealthCheckHttpResult'],
                 health_check_max_retries: _builtins.int,
                 health_check_port: _builtins.int,
                 health_check_tcps: Sequence['outputs.GetLbBackendsBackendHealthCheckTcpResult'],
                 health_check_timeout: _builtins.str,
                 id: _builtins.str,
                 ignore_ssl_server_verify: _builtins.bool,
                 lb_id: _builtins.str,
                 name: _builtins.str,
                 on_marked_down_action: _builtins.str,
                 proxy_protocol: _builtins.str,
                 server_ips: Sequence[_builtins.str],
                 ssl_bridging: _builtins.bool,
                 sticky_sessions: _builtins.str,
                 sticky_sessions_cookie_name: _builtins.str,
                 timeout_connect: _builtins.str,
                 timeout_server: _builtins.str,
                 timeout_tunnel: _builtins.str,
                 update_at: _builtins.str):
        """
        :param _builtins.str created_at: The date on which the backend was created (RFC 3339 format).
        :param _builtins.str failover_host: Scaleway S3 bucket website to be served if all backend servers are down.
        :param _builtins.int forward_port: User sessions will be forwarded to this backend server port.
        :param _builtins.str forward_port_algorithm: Load balancing algorithm.
        :param _builtins.str forward_protocol: Backend protocol.
        :param _builtins.str health_check_delay: Interval between two health check requests.
        :param Sequence['GetLbBackendsBackendHealthCheckHttpArgs'] health_check_http: This block enables HTTP health checks.
        :param Sequence['GetLbBackendsBackendHealthCheckHttpArgs'] health_check_https: This block enables HTTPS health checks.
        :param _builtins.int health_check_max_retries: Number of allowed failed health check requests before the backend server is marked as down.
        :param _builtins.int health_check_port: Port the health check requests will be sent to.
        :param Sequence['GetLbBackendsBackendHealthCheckTcpArgs'] health_check_tcps: This block enables TCP health checks.
        :param _builtins.str health_check_timeout: Timeout before a health check request is considered failed.
        :param _builtins.str id: The associated backend ID.
        :param _builtins.bool ignore_ssl_server_verify: Specifies whether the Load Balancer should check the backend server’s certificate before initiating a connection.
        :param _builtins.str lb_id: The Load Balancer ID this backend is attached to. Backends with a matching ID are listed.
        :param _builtins.str name: The backend name to filter for. Backends with a matching name are listed.
        :param _builtins.str on_marked_down_action: Modify what occurs when a backend server is marked down.
        :param _builtins.str proxy_protocol: The type of PROXY protocol.
        :param Sequence[_builtins.str] server_ips: List of backend server IP addresses.
        :param _builtins.bool ssl_bridging: Enables SSL between Load Balancer and backend servers.
        :param _builtins.str sticky_sessions: Enables cookie-based session persistence.
        :param _builtins.str sticky_sessions_cookie_name: Cookie name for sticky sessions.
        :param _builtins.str timeout_connect: Maximum initial server connection establishment time.
        :param _builtins.str timeout_server: Maximum server connection inactivity time.
        :param _builtins.str timeout_tunnel: Maximum tunnel inactivity time.
        :param _builtins.str update_at: The date on which the backend was last updated (RFC 3339 format).
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "failover_host", failover_host)
        pulumi.set(__self__, "forward_port", forward_port)
        pulumi.set(__self__, "forward_port_algorithm", forward_port_algorithm)
        pulumi.set(__self__, "forward_protocol", forward_protocol)
        pulumi.set(__self__, "health_check_delay", health_check_delay)
        pulumi.set(__self__, "health_check_http", health_check_http)
        pulumi.set(__self__, "health_check_https", health_check_https)
        pulumi.set(__self__, "health_check_max_retries", health_check_max_retries)
        pulumi.set(__self__, "health_check_port", health_check_port)
        pulumi.set(__self__, "health_check_tcps", health_check_tcps)
        pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ignore_ssl_server_verify", ignore_ssl_server_verify)
        pulumi.set(__self__, "lb_id", lb_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "on_marked_down_action", on_marked_down_action)
        pulumi.set(__self__, "proxy_protocol", proxy_protocol)
        pulumi.set(__self__, "server_ips", server_ips)
        pulumi.set(__self__, "ssl_bridging", ssl_bridging)
        pulumi.set(__self__, "sticky_sessions", sticky_sessions)
        pulumi.set(__self__, "sticky_sessions_cookie_name", sticky_sessions_cookie_name)
        pulumi.set(__self__, "timeout_connect", timeout_connect)
        pulumi.set(__self__, "timeout_server", timeout_server)
        pulumi.set(__self__, "timeout_tunnel", timeout_tunnel)
        pulumi.set(__self__, "update_at", update_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date on which the backend was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="failoverHost")
    def failover_host(self) -> _builtins.str:
        """
        Scaleway S3 bucket website to be served if all backend servers are down.
        """
        return pulumi.get(self, "failover_host")

    @_builtins.property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> _builtins.int:
        """
        User sessions will be forwarded to this backend server port.
        """
        return pulumi.get(self, "forward_port")

    @_builtins.property
    @pulumi.getter(name="forwardPortAlgorithm")
    def forward_port_algorithm(self) -> _builtins.str:
        """
        Load balancing algorithm.
        """
        return pulumi.get(self, "forward_port_algorithm")

    @_builtins.property
    @pulumi.getter(name="forwardProtocol")
    def forward_protocol(self) -> _builtins.str:
        """
        Backend protocol.
        """
        return pulumi.get(self, "forward_protocol")

    @_builtins.property
    @pulumi.getter(name="healthCheckDelay")
    def health_check_delay(self) -> _builtins.str:
        """
        Interval between two health check requests.
        """
        return pulumi.get(self, "health_check_delay")

    @_builtins.property
    @pulumi.getter(name="healthCheckHttp")
    def health_check_http(self) -> Sequence['outputs.GetLbBackendsBackendHealthCheckHttpResult']:
        """
        This block enables HTTP health checks.
        """
        return pulumi.get(self, "health_check_http")

    @_builtins.property
    @pulumi.getter(name="healthCheckHttps")
    def health_check_https(self) -> Sequence['outputs.GetLbBackendsBackendHealthCheckHttpResult']:
        """
        This block enables HTTPS health checks.
        """
        return pulumi.get(self, "health_check_https")

    @_builtins.property
    @pulumi.getter(name="healthCheckMaxRetries")
    def health_check_max_retries(self) -> _builtins.int:
        """
        Number of allowed failed health check requests before the backend server is marked as down.
        """
        return pulumi.get(self, "health_check_max_retries")

    @_builtins.property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> _builtins.int:
        """
        Port the health check requests will be sent to.
        """
        return pulumi.get(self, "health_check_port")

    @_builtins.property
    @pulumi.getter(name="healthCheckTcps")
    def health_check_tcps(self) -> Sequence['outputs.GetLbBackendsBackendHealthCheckTcpResult']:
        """
        This block enables TCP health checks.
        """
        return pulumi.get(self, "health_check_tcps")

    @_builtins.property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> _builtins.str:
        """
        Timeout before a health check request is considered failed.
        """
        return pulumi.get(self, "health_check_timeout")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The associated backend ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ignoreSslServerVerify")
    def ignore_ssl_server_verify(self) -> _builtins.bool:
        """
        Specifies whether the Load Balancer should check the backend server’s certificate before initiating a connection.
        """
        return pulumi.get(self, "ignore_ssl_server_verify")

    @_builtins.property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> _builtins.str:
        """
        The Load Balancer ID this backend is attached to. Backends with a matching ID are listed.
        """
        return pulumi.get(self, "lb_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The backend name to filter for. Backends with a matching name are listed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="onMarkedDownAction")
    def on_marked_down_action(self) -> _builtins.str:
        """
        Modify what occurs when a backend server is marked down.
        """
        return pulumi.get(self, "on_marked_down_action")

    @_builtins.property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> _builtins.str:
        """
        The type of PROXY protocol.
        """
        return pulumi.get(self, "proxy_protocol")

    @_builtins.property
    @pulumi.getter(name="serverIps")
    def server_ips(self) -> Sequence[_builtins.str]:
        """
        List of backend server IP addresses.
        """
        return pulumi.get(self, "server_ips")

    @_builtins.property
    @pulumi.getter(name="sslBridging")
    def ssl_bridging(self) -> _builtins.bool:
        """
        Enables SSL between Load Balancer and backend servers.
        """
        return pulumi.get(self, "ssl_bridging")

    @_builtins.property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> _builtins.str:
        """
        Enables cookie-based session persistence.
        """
        return pulumi.get(self, "sticky_sessions")

    @_builtins.property
    @pulumi.getter(name="stickySessionsCookieName")
    def sticky_sessions_cookie_name(self) -> _builtins.str:
        """
        Cookie name for sticky sessions.
        """
        return pulumi.get(self, "sticky_sessions_cookie_name")

    @_builtins.property
    @pulumi.getter(name="timeoutConnect")
    def timeout_connect(self) -> _builtins.str:
        """
        Maximum initial server connection establishment time.
        """
        return pulumi.get(self, "timeout_connect")

    @_builtins.property
    @pulumi.getter(name="timeoutServer")
    def timeout_server(self) -> _builtins.str:
        """
        Maximum server connection inactivity time.
        """
        return pulumi.get(self, "timeout_server")

    @_builtins.property
    @pulumi.getter(name="timeoutTunnel")
    def timeout_tunnel(self) -> _builtins.str:
        """
        Maximum tunnel inactivity time.
        """
        return pulumi.get(self, "timeout_tunnel")

    @_builtins.property
    @pulumi.getter(name="updateAt")
    def update_at(self) -> _builtins.str:
        """
        The date on which the backend was last updated (RFC 3339 format).
        """
        return pulumi.get(self, "update_at")


@pulumi.output_type
class GetLbBackendsBackendHealthCheckHttpResult(dict):
    def __init__(__self__, *,
                 code: _builtins.int,
                 host_header: _builtins.str,
                 method: _builtins.str,
                 sni: _builtins.str,
                 uri: _builtins.str):
        """
        :param _builtins.int code: The expected HTTP status code.
        :param _builtins.str host_header: The HTTP host header to use for health check requests.
        :param _builtins.str method: The HTTP method to use for health check requests.
        :param _builtins.str sni: The SNI to use for HC requests over SSL.
        :param _builtins.str uri: The path of health check requests.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "host_header", host_header)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "sni", sni)
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.int:
        """
        The expected HTTP status code.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> _builtins.str:
        """
        The HTTP host header to use for health check requests.
        """
        return pulumi.get(self, "host_header")

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        The HTTP method to use for health check requests.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def sni(self) -> _builtins.str:
        """
        The SNI to use for HC requests over SSL.
        """
        return pulumi.get(self, "sni")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        The path of health check requests.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetLbBackendsBackendHealthCheckTcpResult(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class GetLbFrontendAclResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetLbFrontendAclActionResult'],
                 created_at: _builtins.str,
                 description: _builtins.str,
                 matches: Sequence['outputs.GetLbFrontendAclMatchResult'],
                 name: _builtins.str,
                 updated_at: _builtins.str):
        """
        :param Sequence['GetLbFrontendAclActionArgs'] actions: Action to undertake when an ACL filter matches
        :param _builtins.str created_at: IsDate and time of ACL's creation (RFC 3339 format)
        :param _builtins.str description: Description of the ACL
        :param Sequence['GetLbFrontendAclMatchArgs'] matches: The ACL match rule
        :param _builtins.str name: The name of the frontend.
               - When using the `name` you should specify the `lb-id`
        :param _builtins.str updated_at: IsDate and time of ACL's update (RFC 3339 format)
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "matches", matches)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetLbFrontendAclActionResult']:
        """
        Action to undertake when an ACL filter matches
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        IsDate and time of ACL's creation (RFC 3339 format)
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the ACL
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def matches(self) -> Sequence['outputs.GetLbFrontendAclMatchResult']:
        """
        The ACL match rule
        """
        return pulumi.get(self, "matches")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the frontend.
        - When using the `name` you should specify the `lb-id`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        IsDate and time of ACL's update (RFC 3339 format)
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetLbFrontendAclActionResult(dict):
    def __init__(__self__, *,
                 redirects: Sequence['outputs.GetLbFrontendAclActionRedirectResult'],
                 type: _builtins.str):
        """
        :param Sequence['GetLbFrontendAclActionRedirectArgs'] redirects: Redirect parameters when using an ACL with `redirect` action
        :param _builtins.str type: The action type
        """
        pulumi.set(__self__, "redirects", redirects)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def redirects(self) -> Sequence['outputs.GetLbFrontendAclActionRedirectResult']:
        """
        Redirect parameters when using an ACL with `redirect` action
        """
        return pulumi.get(self, "redirects")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The action type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetLbFrontendAclActionRedirectResult(dict):
    def __init__(__self__, *,
                 code: _builtins.int,
                 target: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.int code: The HTTP redirect code to use
        :param _builtins.str target: An URL can be used in case of a location redirect
        :param _builtins.str type: The redirect type
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.int:
        """
        The HTTP redirect code to use
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def target(self) -> _builtins.str:
        """
        An URL can be used in case of a location redirect
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The redirect type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetLbFrontendAclMatchResult(dict):
    def __init__(__self__, *,
                 http_filter: _builtins.str,
                 http_filter_option: _builtins.str,
                 http_filter_values: Sequence[_builtins.str],
                 invert: _builtins.bool,
                 ip_subnets: Sequence[_builtins.str],
                 ips_edge_services: _builtins.bool):
        """
        :param _builtins.str http_filter: The HTTP filter to match
        :param _builtins.str http_filter_option: You can use this field with http_header_match acl type to set the header name to filter
        :param Sequence[_builtins.str] http_filter_values: A list of possible values to match for the given HTTP filter
        :param _builtins.bool invert: If set to true, the condition will be of type "unless"
        :param Sequence[_builtins.str] ip_subnets: A list of IPs or CIDR v4/v6 addresses of the client of the session to match
        :param _builtins.bool ips_edge_services: Defines whether Edge Services IPs should be matched
        """
        pulumi.set(__self__, "http_filter", http_filter)
        pulumi.set(__self__, "http_filter_option", http_filter_option)
        pulumi.set(__self__, "http_filter_values", http_filter_values)
        pulumi.set(__self__, "invert", invert)
        pulumi.set(__self__, "ip_subnets", ip_subnets)
        pulumi.set(__self__, "ips_edge_services", ips_edge_services)

    @_builtins.property
    @pulumi.getter(name="httpFilter")
    def http_filter(self) -> _builtins.str:
        """
        The HTTP filter to match
        """
        return pulumi.get(self, "http_filter")

    @_builtins.property
    @pulumi.getter(name="httpFilterOption")
    def http_filter_option(self) -> _builtins.str:
        """
        You can use this field with http_header_match acl type to set the header name to filter
        """
        return pulumi.get(self, "http_filter_option")

    @_builtins.property
    @pulumi.getter(name="httpFilterValues")
    def http_filter_values(self) -> Sequence[_builtins.str]:
        """
        A list of possible values to match for the given HTTP filter
        """
        return pulumi.get(self, "http_filter_values")

    @_builtins.property
    @pulumi.getter
    def invert(self) -> _builtins.bool:
        """
        If set to true, the condition will be of type "unless"
        """
        return pulumi.get(self, "invert")

    @_builtins.property
    @pulumi.getter(name="ipSubnets")
    def ip_subnets(self) -> Sequence[_builtins.str]:
        """
        A list of IPs or CIDR v4/v6 addresses of the client of the session to match
        """
        return pulumi.get(self, "ip_subnets")

    @_builtins.property
    @pulumi.getter(name="ipsEdgeServices")
    def ips_edge_services(self) -> _builtins.bool:
        """
        Defines whether Edge Services IPs should be matched
        """
        return pulumi.get(self, "ips_edge_services")


@pulumi.output_type
class GetLbFrontendsFrontendResult(dict):
    def __init__(__self__, *,
                 backend_id: _builtins.str,
                 certificate_ids: Sequence[_builtins.str],
                 connection_rate_limit: _builtins.int,
                 created_at: _builtins.str,
                 enable_access_logs: _builtins.bool,
                 enable_http3: _builtins.bool,
                 id: _builtins.str,
                 inbound_port: _builtins.int,
                 lb_id: _builtins.str,
                 name: _builtins.str,
                 timeout_client: _builtins.str,
                 update_at: _builtins.str):
        """
        :param _builtins.str backend_id: The Load Balancer backend ID this frontend is attached to.
               > **Important:** Load Balancer backend IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        :param Sequence[_builtins.str] certificate_ids: List of certificate IDs that are used by the frontend.
        :param _builtins.int connection_rate_limit: The rate limit for new connections established on this frontend. Use 0 value to disable, else value is connections per second.
        :param _builtins.str created_at: The date on which the frontend was created (RFC 3339 format).
        :param _builtins.bool enable_access_logs: Defines whether to enable access logs on the frontend.
        :param _builtins.bool enable_http3: Whether HTTP/3 protocol is activated.
        :param _builtins.str id: The ID of the associated frontend.
               > **Important:** LB frontend IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        :param _builtins.int inbound_port: TCP port the frontend listens to.
        :param _builtins.str lb_id: The Load Balancer ID this frontend is attached to. Frontends with a matching ID are listed.
        :param _builtins.str name: The frontend name to filter for. Frontends with a matching name are listed.
        :param _builtins.str timeout_client: Maximum inactivity time on the client side.
        :param _builtins.str update_at: The date on which the frontend was last updated (RFC 3339 format).
        """
        pulumi.set(__self__, "backend_id", backend_id)
        pulumi.set(__self__, "certificate_ids", certificate_ids)
        pulumi.set(__self__, "connection_rate_limit", connection_rate_limit)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "enable_access_logs", enable_access_logs)
        pulumi.set(__self__, "enable_http3", enable_http3)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "inbound_port", inbound_port)
        pulumi.set(__self__, "lb_id", lb_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "timeout_client", timeout_client)
        pulumi.set(__self__, "update_at", update_at)

    @_builtins.property
    @pulumi.getter(name="backendId")
    def backend_id(self) -> _builtins.str:
        """
        The Load Balancer backend ID this frontend is attached to.
        > **Important:** Load Balancer backend IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        """
        return pulumi.get(self, "backend_id")

    @_builtins.property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> Sequence[_builtins.str]:
        """
        List of certificate IDs that are used by the frontend.
        """
        return pulumi.get(self, "certificate_ids")

    @_builtins.property
    @pulumi.getter(name="connectionRateLimit")
    def connection_rate_limit(self) -> _builtins.int:
        """
        The rate limit for new connections established on this frontend. Use 0 value to disable, else value is connections per second.
        """
        return pulumi.get(self, "connection_rate_limit")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date on which the frontend was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="enableAccessLogs")
    def enable_access_logs(self) -> _builtins.bool:
        """
        Defines whether to enable access logs on the frontend.
        """
        return pulumi.get(self, "enable_access_logs")

    @_builtins.property
    @pulumi.getter(name="enableHttp3")
    def enable_http3(self) -> _builtins.bool:
        """
        Whether HTTP/3 protocol is activated.
        """
        return pulumi.get(self, "enable_http3")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the associated frontend.
        > **Important:** LB frontend IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inboundPort")
    def inbound_port(self) -> _builtins.int:
        """
        TCP port the frontend listens to.
        """
        return pulumi.get(self, "inbound_port")

    @_builtins.property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> _builtins.str:
        """
        The Load Balancer ID this frontend is attached to. Frontends with a matching ID are listed.
        """
        return pulumi.get(self, "lb_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The frontend name to filter for. Frontends with a matching name are listed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="timeoutClient")
    def timeout_client(self) -> _builtins.str:
        """
        Maximum inactivity time on the client side.
        """
        return pulumi.get(self, "timeout_client")

    @_builtins.property
    @pulumi.getter(name="updateAt")
    def update_at(self) -> _builtins.str:
        """
        The date on which the frontend was last updated (RFC 3339 format).
        """
        return pulumi.get(self, "update_at")


@pulumi.output_type
class GetLbIpsIpResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 ip_address: _builtins.str,
                 lb_id: _builtins.str,
                 organization_id: _builtins.str,
                 project_id: _builtins.str,
                 reverse: _builtins.str,
                 tags: Sequence[_builtins.str],
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The ID of the associated IP.
        :param _builtins.str ip_address: The IP address
        :param _builtins.str lb_id: The ID of the associated Load BalancerD, if any
        :param _builtins.str organization_id: The ID of the Organization the Load Balancer is associated with.
        :param _builtins.str project_id: The ID of the Project the Load Balancer is associated with.
        :param _builtins.str reverse: The reverse domain associated with this IP.
        :param Sequence[_builtins.str] tags: List of tags used as filter. IPs with these exact tags are listed.
        :param _builtins.str zone: `zone`) The zone in which the IPs exist.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "lb_id", lb_id)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "reverse", reverse)
        pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the associated IP.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> _builtins.str:
        """
        The ID of the associated Load BalancerD, if any
        """
        return pulumi.get(self, "lb_id")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        The ID of the Organization the Load Balancer is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The ID of the Project the Load Balancer is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> _builtins.str:
        """
        The reverse domain associated with this IP.
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        List of tags used as filter. IPs with these exact tags are listed.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        `zone`) The zone in which the IPs exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetLbRoutesRouteResult(dict):
    def __init__(__self__, *,
                 backend_id: _builtins.str,
                 created_at: _builtins.str,
                 frontend_id: _builtins.str,
                 id: _builtins.str,
                 match_host_header: _builtins.str,
                 match_sni: _builtins.str,
                 match_subdomains: _builtins.bool,
                 update_at: _builtins.str):
        """
        :param _builtins.str backend_id: The backend ID to redirect to
        :param _builtins.str created_at: The date on which the route was created (RFC 3339 format).
        :param _builtins.str frontend_id: The frontend ID (the origin of the redirection), to filter for. Routes with a matching frontend ID are listed.
        :param _builtins.str id: The associated route ID.
        :param _builtins.str match_host_header: Specifies the host of the server to which the request is being sent.
        :param _builtins.str match_sni: Server Name Indication TLS extension field from an incoming connection made via an SSL/TLS transport layer.
        :param _builtins.bool match_subdomains: If true, all subdomains will match.
        :param _builtins.str update_at: The date on which the route was last updated (RFC 3339 format).
        """
        pulumi.set(__self__, "backend_id", backend_id)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "frontend_id", frontend_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "match_host_header", match_host_header)
        pulumi.set(__self__, "match_sni", match_sni)
        pulumi.set(__self__, "match_subdomains", match_subdomains)
        pulumi.set(__self__, "update_at", update_at)

    @_builtins.property
    @pulumi.getter(name="backendId")
    def backend_id(self) -> _builtins.str:
        """
        The backend ID to redirect to
        """
        return pulumi.get(self, "backend_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date on which the route was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> _builtins.str:
        """
        The frontend ID (the origin of the redirection), to filter for. Routes with a matching frontend ID are listed.
        """
        return pulumi.get(self, "frontend_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The associated route ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="matchHostHeader")
    def match_host_header(self) -> _builtins.str:
        """
        Specifies the host of the server to which the request is being sent.
        """
        return pulumi.get(self, "match_host_header")

    @_builtins.property
    @pulumi.getter(name="matchSni")
    def match_sni(self) -> _builtins.str:
        """
        Server Name Indication TLS extension field from an incoming connection made via an SSL/TLS transport layer.
        """
        return pulumi.get(self, "match_sni")

    @_builtins.property
    @pulumi.getter(name="matchSubdomains")
    def match_subdomains(self) -> _builtins.bool:
        """
        If true, all subdomains will match.
        """
        return pulumi.get(self, "match_subdomains")

    @_builtins.property
    @pulumi.getter(name="updateAt")
    def update_at(self) -> _builtins.str:
        """
        The date on which the route was last updated (RFC 3339 format).
        """
        return pulumi.get(self, "update_at")


@pulumi.output_type
class GetLbsLbResult(dict):
    def __init__(__self__, *,
                 backend_count: _builtins.int,
                 created_at: _builtins.str,
                 description: _builtins.str,
                 frontend_count: _builtins.int,
                 id: _builtins.str,
                 instances: Sequence['outputs.GetLbsLbInstanceResult'],
                 ips: Sequence['outputs.GetLbsLbIpResult'],
                 name: _builtins.str,
                 organization_id: _builtins.str,
                 private_network_count: _builtins.int,
                 project_id: _builtins.str,
                 route_count: _builtins.int,
                 ssl_compatibility_level: _builtins.str,
                 status: _builtins.str,
                 subscriber: _builtins.str,
                 tags: Sequence[_builtins.str],
                 type: _builtins.str,
                 updated_at: _builtins.str,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.int backend_count: Number of backends the Load Balancer has.
        :param _builtins.str created_at: Date on which the Load Balancer was created.
        :param _builtins.str description: The description of the Load Balancer.
        :param _builtins.int frontend_count: Number of frontends the Load Balancer has.
        :param _builtins.str id: The ID of the Load Balancer.
        :param Sequence['GetLbsLbInstanceArgs'] instances: List of underlying Instances.
        :param Sequence['GetLbsLbIpArgs'] ips: List of IPs attached to the Load Balancer.
        :param _builtins.str name: The Load Balancer name to filter for. Load Balancers with a matching name are listed.
        :param _builtins.str organization_id: The ID of the Organization the Load Balancer is associated with.
        :param _builtins.int private_network_count: Number of Private Networks attached to the Load balancer.
        :param _builtins.str project_id: The ID of the Project the Load Balancer is associated with.
        :param _builtins.int route_count: Number of routes the Load balancer has.
        :param _builtins.str ssl_compatibility_level: Determines the minimal SSL version which needs to be supported on the client side.
        :param _builtins.str status: The state of the Load Balancer Instance. Possible values are: `unknown`, `ready`, `pending`, `stopped`, `error`, `locked` and `migrating`.
        :param _builtins.str subscriber: The subscriber information.
        :param Sequence[_builtins.str] tags: List of tags to filter for. Load Balancers with these exact tags are listed.
        :param _builtins.str type: The offer type of the Load Balancer.
        :param _builtins.str updated_at: Date on which the Load Balancer was updated.
        :param _builtins.str zone: `zone`) The zone in which the Load Balancers exist.
        """
        pulumi.set(__self__, "backend_count", backend_count)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "frontend_count", frontend_count)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "private_network_count", private_network_count)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "route_count", route_count)
        pulumi.set(__self__, "ssl_compatibility_level", ssl_compatibility_level)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subscriber", subscriber)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "updated_at", updated_at)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="backendCount")
    def backend_count(self) -> _builtins.int:
        """
        Number of backends the Load Balancer has.
        """
        return pulumi.get(self, "backend_count")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Date on which the Load Balancer was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Load Balancer.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="frontendCount")
    def frontend_count(self) -> _builtins.int:
        """
        Number of frontends the Load Balancer has.
        """
        return pulumi.get(self, "frontend_count")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Load Balancer.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetLbsLbInstanceResult']:
        """
        List of underlying Instances.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Sequence['outputs.GetLbsLbIpResult']:
        """
        List of IPs attached to the Load Balancer.
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Load Balancer name to filter for. Load Balancers with a matching name are listed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        The ID of the Organization the Load Balancer is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="privateNetworkCount")
    def private_network_count(self) -> _builtins.int:
        """
        Number of Private Networks attached to the Load balancer.
        """
        return pulumi.get(self, "private_network_count")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The ID of the Project the Load Balancer is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="routeCount")
    def route_count(self) -> _builtins.int:
        """
        Number of routes the Load balancer has.
        """
        return pulumi.get(self, "route_count")

    @_builtins.property
    @pulumi.getter(name="sslCompatibilityLevel")
    def ssl_compatibility_level(self) -> _builtins.str:
        """
        Determines the minimal SSL version which needs to be supported on the client side.
        """
        return pulumi.get(self, "ssl_compatibility_level")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The state of the Load Balancer Instance. Possible values are: `unknown`, `ready`, `pending`, `stopped`, `error`, `locked` and `migrating`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def subscriber(self) -> _builtins.str:
        """
        The subscriber information.
        """
        return pulumi.get(self, "subscriber")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        List of tags to filter for. Load Balancers with these exact tags are listed.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The offer type of the Load Balancer.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Date on which the Load Balancer was updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        `zone`) The zone in which the Load Balancers exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetLbsLbInstanceResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 id: _builtins.str,
                 ip_address: _builtins.str,
                 status: _builtins.str,
                 updated_at: _builtins.str,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str created_at: Date on which the Load Balancer was created.
        :param _builtins.str id: The ID of the Load Balancer.
        :param _builtins.str ip_address: IP address of the instance
        :param _builtins.str status: The state of the Load Balancer Instance. Possible values are: `unknown`, `ready`, `pending`, `stopped`, `error`, `locked` and `migrating`.
        :param _builtins.str updated_at: Date on which the Load Balancer was updated.
        :param _builtins.str zone: `zone`) The zone in which the Load Balancers exist.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Date on which the Load Balancer was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Load Balancer.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        IP address of the instance
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The state of the Load Balancer Instance. Possible values are: `unknown`, `ready`, `pending`, `stopped`, `error`, `locked` and `migrating`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Date on which the Load Balancer was updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        `zone`) The zone in which the Load Balancers exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetLbsLbIpResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 ip_address: _builtins.str,
                 lb_id: _builtins.str,
                 organization_id: _builtins.str,
                 project_id: _builtins.str,
                 reverse: _builtins.str,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The ID of the Load Balancer.
        :param _builtins.str ip_address: IP address
        :param _builtins.str lb_id: UUID of the load balancer attached to the IP
        :param _builtins.str organization_id: The ID of the Organization the Load Balancer is associated with.
        :param _builtins.str project_id: The ID of the Project the Load Balancer is associated with.
        :param _builtins.str reverse: Reverse DNS attached to the IP
        :param _builtins.str zone: `zone`) The zone in which the Load Balancers exist.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "lb_id", lb_id)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "reverse", reverse)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Load Balancer.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        IP address
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> _builtins.str:
        """
        UUID of the load balancer attached to the IP
        """
        return pulumi.get(self, "lb_id")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        The ID of the Organization the Load Balancer is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The ID of the Project the Load Balancer is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def reverse(self) -> _builtins.str:
        """
        Reverse DNS attached to the IP
        """
        return pulumi.get(self, "reverse")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        `zone`) The zone in which the Load Balancers exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetLoadbalancerCertificateCustomCertificateResult(dict):
    def __init__(__self__, *,
                 certificate_chain: _builtins.str):
        """
        :param _builtins.str certificate_chain: The full PEM-formatted certificate chain
        """
        pulumi.set(__self__, "certificate_chain", certificate_chain)

    @_builtins.property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> _builtins.str:
        """
        The full PEM-formatted certificate chain
        """
        return pulumi.get(self, "certificate_chain")


@pulumi.output_type
class GetLoadbalancerCertificateLetsencryptResult(dict):
    def __init__(__self__, *,
                 common_name: _builtins.str,
                 subject_alternative_names: Sequence[_builtins.str]):
        """
        :param _builtins.str common_name: The main domain name of the certificate
        :param Sequence[_builtins.str] subject_alternative_names: The alternative domain names of the certificate
        """
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> _builtins.str:
        """
        The main domain name of the certificate
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Sequence[_builtins.str]:
        """
        The alternative domain names of the certificate
        """
        return pulumi.get(self, "subject_alternative_names")


@pulumi.output_type
class GetLoadbalancerPrivateIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The private IP address
        :param _builtins.str id: The ID of the Load Balancer.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The private IP address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Load Balancer.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetLoadbalancerPrivateNetworkResult(dict):
    def __init__(__self__, *,
                 dhcp_config: _builtins.bool,
                 ipam_ids: Sequence[_builtins.str],
                 private_network_id: _builtins.str,
                 static_configs: Sequence[_builtins.str],
                 status: _builtins.str,
                 zone: _builtins.str):
        """
        :param _builtins.bool dhcp_config: Set to true if you want to let DHCP assign IP addresses
        :param Sequence[_builtins.str] ipam_ids: IPAM ID of a pre-reserved IP address to assign to the Load Balancer on this Private Network
        :param _builtins.str private_network_id: The Private Network ID
        :param Sequence[_builtins.str] static_configs: Define an IP address in the subnet of your private network that will be assigned to your load balancer instance
        :param _builtins.str status: The status of private network connection
        :param _builtins.str zone: (Defaults to provider `zone`) The zone in which the Load Balancer exists.
        """
        pulumi.set(__self__, "dhcp_config", dhcp_config)
        pulumi.set(__self__, "ipam_ids", ipam_ids)
        pulumi.set(__self__, "private_network_id", private_network_id)
        pulumi.set(__self__, "static_configs", static_configs)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="dhcpConfig")
    def dhcp_config(self) -> _builtins.bool:
        """
        Set to true if you want to let DHCP assign IP addresses
        """
        return pulumi.get(self, "dhcp_config")

    @_builtins.property
    @pulumi.getter(name="ipamIds")
    def ipam_ids(self) -> Sequence[_builtins.str]:
        """
        IPAM ID of a pre-reserved IP address to assign to the Load Balancer on this Private Network
        """
        return pulumi.get(self, "ipam_ids")

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> _builtins.str:
        """
        The Private Network ID
        """
        return pulumi.get(self, "private_network_id")

    @_builtins.property
    @pulumi.getter(name="staticConfigs")
    def static_configs(self) -> Sequence[_builtins.str]:
        """
        Define an IP address in the subnet of your private network that will be assigned to your load balancer instance
        """
        return pulumi.get(self, "static_configs")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of private network connection
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        (Defaults to provider `zone`) The zone in which the Load Balancer exists.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetMongoDbInstancePrivateIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The private IPv4 address
        :param _builtins.str id: The ID of the MongoDB® Instance.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The private IPv4 address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the MongoDB® Instance.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetMongoDbInstancePrivateNetworkResult(dict):
    def __init__(__self__, *,
                 dns_records: Sequence[_builtins.str],
                 id: _builtins.str,
                 ips: Sequence[_builtins.str],
                 pn_id: _builtins.str,
                 port: _builtins.int):
        """
        :param Sequence[_builtins.str] dns_records: List of DNS records for your endpoint
        :param _builtins.str id: The ID of the MongoDB® Instance.
        :param Sequence[_builtins.str] ips: List of IP addresses for your endpoint
        :param _builtins.str pn_id: The private network ID
        :param _builtins.int port: TCP port of the endpoint
        """
        pulumi.set(__self__, "dns_records", dns_records)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "pn_id", pn_id)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="dnsRecords")
    def dns_records(self) -> Sequence[_builtins.str]:
        """
        List of DNS records for your endpoint
        """
        return pulumi.get(self, "dns_records")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the MongoDB® Instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Sequence[_builtins.str]:
        """
        List of IP addresses for your endpoint
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> _builtins.str:
        """
        The private network ID
        """
        return pulumi.get(self, "pn_id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        TCP port of the endpoint
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetMongoDbInstancePublicNetworkResult(dict):
    def __init__(__self__, *,
                 dns_record: _builtins.str,
                 id: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str dns_record: The DNS record of your endpoint
        :param _builtins.str id: The ID of the MongoDB® Instance.
        :param _builtins.int port: TCP port of the endpoint
        """
        pulumi.set(__self__, "dns_record", dns_record)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="dnsRecord")
    def dns_record(self) -> _builtins.str:
        """
        The DNS record of your endpoint
        """
        return pulumi.get(self, "dns_record")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the MongoDB® Instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        TCP port of the endpoint
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetObjectBucketCorsRuleResult(dict):
    def __init__(__self__, *,
                 allowed_headers: Sequence[_builtins.str],
                 allowed_methods: Sequence[_builtins.str],
                 allowed_origins: Sequence[_builtins.str],
                 expose_headers: Sequence[_builtins.str],
                 max_age_seconds: _builtins.int):
        """
        :param Sequence[_builtins.str] allowed_headers: Allowed headers in the CORS rule
        :param Sequence[_builtins.str] allowed_methods: Allowed HTTP methods allowed in the CORS rule
        :param Sequence[_builtins.str] allowed_origins: Allowed origins allowed in the CORS rule
        :param Sequence[_builtins.str] expose_headers: Exposed headers in the CORS rule
        :param _builtins.int max_age_seconds: Max age of the CORS rule
        """
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "expose_headers", expose_headers)
        pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[_builtins.str]:
        """
        Allowed headers in the CORS rule
        """
        return pulumi.get(self, "allowed_headers")

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[_builtins.str]:
        """
        Allowed HTTP methods allowed in the CORS rule
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[_builtins.str]:
        """
        Allowed origins allowed in the CORS rule
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Sequence[_builtins.str]:
        """
        Exposed headers in the CORS rule
        """
        return pulumi.get(self, "expose_headers")

    @_builtins.property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> _builtins.int:
        """
        Max age of the CORS rule
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class GetObjectBucketLifecycleRuleResult(dict):
    def __init__(__self__, *,
                 abort_incomplete_multipart_upload_days: _builtins.int,
                 enabled: _builtins.bool,
                 expirations: Sequence['outputs.GetObjectBucketLifecycleRuleExpirationResult'],
                 id: _builtins.str,
                 prefix: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 transitions: Sequence['outputs.GetObjectBucketLifecycleRuleTransitionResult']):
        """
        :param _builtins.int abort_incomplete_multipart_upload_days: Specifies the number of days after initiating a multipart upload when the multipart upload must be completed
        :param _builtins.bool enabled: Specifies if the configuration rule is Enabled or Disabled
        :param Sequence['GetObjectBucketLifecycleRuleExpirationArgs'] expirations: Specifies a period in the object's expire
        :param _builtins.str id: The unique identifier of the bucket.
        :param _builtins.str prefix: The prefix identifying one or more objects to which the rule applies
        :param Mapping[str, _builtins.str] tags: The tags associated with the bucket lifecycle
        :param Sequence['GetObjectBucketLifecycleRuleTransitionArgs'] transitions: Define when objects transition to another storage class
        """
        pulumi.set(__self__, "abort_incomplete_multipart_upload_days", abort_incomplete_multipart_upload_days)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "expirations", expirations)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "transitions", transitions)

    @_builtins.property
    @pulumi.getter(name="abortIncompleteMultipartUploadDays")
    def abort_incomplete_multipart_upload_days(self) -> _builtins.int:
        """
        Specifies the number of days after initiating a multipart upload when the multipart upload must be completed
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload_days")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Specifies if the configuration rule is Enabled or Disabled
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def expirations(self) -> Sequence['outputs.GetObjectBucketLifecycleRuleExpirationResult']:
        """
        Specifies a period in the object's expire
        """
        return pulumi.get(self, "expirations")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier of the bucket.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        The prefix identifying one or more objects to which the rule applies
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tags associated with the bucket lifecycle
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def transitions(self) -> Sequence['outputs.GetObjectBucketLifecycleRuleTransitionResult']:
        """
        Define when objects transition to another storage class
        """
        return pulumi.get(self, "transitions")


@pulumi.output_type
class GetObjectBucketLifecycleRuleExpirationResult(dict):
    def __init__(__self__, *,
                 days: _builtins.int):
        """
        :param _builtins.int days: Specifies the number of days after object creation when the specific rule action takes effect
        """
        pulumi.set(__self__, "days", days)

    @_builtins.property
    @pulumi.getter
    def days(self) -> _builtins.int:
        """
        Specifies the number of days after object creation when the specific rule action takes effect
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class GetObjectBucketLifecycleRuleTransitionResult(dict):
    def __init__(__self__, *,
                 days: _builtins.int,
                 storage_class: _builtins.str):
        """
        :param _builtins.int days: Specifies the number of days after object creation when the specific rule action takes effect
        :param _builtins.str storage_class: Specifies the Scaleway Object Storage class to which you want the object to transition
        """
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "storage_class", storage_class)

    @_builtins.property
    @pulumi.getter
    def days(self) -> _builtins.int:
        """
        Specifies the number of days after object creation when the specific rule action takes effect
        """
        return pulumi.get(self, "days")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        Specifies the Scaleway Object Storage class to which you want the object to transition
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class GetObjectBucketVersioningResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool):
        """
        :param _builtins.bool enabled: Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state
        """
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetRedisClusterAclResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 id: _builtins.str,
                 ip: _builtins.str):
        """
        :param _builtins.str description: Description of the rule.
        :param _builtins.str id: The ID of the Redis cluster.
        :param _builtins.str ip: IPv4 network address of the rule (IP network in a CIDR format).
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Redis cluster.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        IPv4 network address of the rule (IP network in a CIDR format).
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class GetRedisClusterPrivateIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The private IPv4 address
        :param _builtins.str id: The ID of the Redis cluster.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The private IPv4 address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Redis cluster.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetRedisClusterPrivateNetworkResult(dict):
    def __init__(__self__, *,
                 endpoint_id: _builtins.str,
                 id: _builtins.str,
                 ips: Sequence[_builtins.str],
                 port: _builtins.int,
                 service_ips: Sequence[_builtins.str],
                 zone: _builtins.str):
        """
        :param _builtins.str endpoint_id: The ID of the endpoint.
        :param _builtins.str id: The ID of the Redis cluster.
        :param Sequence[_builtins.str] ips: List of IPv4 addresses of the endpoint.
        :param _builtins.int port: TCP port of the endpoint.
        :param Sequence[_builtins.str] service_ips: List of IPv4 addresses of the private network with a CIDR notation
        :param _builtins.str zone: `region`) The zone in which the server exists.
        """
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "service_ips", service_ips)
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> _builtins.str:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Redis cluster.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Sequence[_builtins.str]:
        """
        List of IPv4 addresses of the endpoint.
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="serviceIps")
    def service_ips(self) -> Sequence[_builtins.str]:
        """
        List of IPv4 addresses of the private network with a CIDR notation
        """
        return pulumi.get(self, "service_ips")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        `region`) The zone in which the server exists.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetRedisClusterPublicNetworkResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 ips: Sequence[_builtins.str],
                 port: _builtins.int):
        """
        :param _builtins.str id: The ID of the Redis cluster.
        :param Sequence[_builtins.str] ips: List of IPv4 addresses of the endpoint.
        :param _builtins.int port: TCP port of the endpoint.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Redis cluster.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Sequence[_builtins.str]:
        """
        List of IPv4 addresses of the endpoint.
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetSecretEphemeralPolicyResult(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 expires_once_accessed: _builtins.bool,
                 ttl: _builtins.str):
        """
        :param _builtins.str action: Action to perform when the version of a secret expires.
        :param _builtins.bool expires_once_accessed: True if the secret version expires after a single user access.
        :param _builtins.str ttl: Time frame, from one second and up to one year, during which the secret's versions are valid. Has to be specified in Go Duration format
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "expires_once_accessed", expires_once_accessed)
        pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        Action to perform when the version of a secret expires.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="expiresOnceAccessed")
    def expires_once_accessed(self) -> _builtins.bool:
        """
        True if the secret version expires after a single user access.
        """
        return pulumi.get(self, "expires_once_accessed")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> _builtins.str:
        """
        Time frame, from one second and up to one year, during which the secret's versions are valid. Has to be specified in Go Duration format
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetSecretVersionResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 description: _builtins.str,
                 latest: _builtins.bool,
                 revision: _builtins.str,
                 secret_id: _builtins.str,
                 status: _builtins.str,
                 updated_at: _builtins.str):
        """
        :param _builtins.str created_at: Date and time of secret version's creation (RFC 3339 format)
        :param _builtins.str description: Description of the secret version
        :param _builtins.bool latest: Returns true if the version is the latest.
        :param _builtins.str revision: The revision of secret version
        :param _builtins.str secret_id: The ID of the secret.
               Only one of `name` and `secret_id` should be specified.
        :param _builtins.str status: Status of the secret version
        :param _builtins.str updated_at: Date and time of secret version's creation (RFC 3339 format)
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "latest", latest)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Date and time of secret version's creation (RFC 3339 format)
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the secret version
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def latest(self) -> _builtins.bool:
        """
        Returns true if the version is the latest.
        """
        return pulumi.get(self, "latest")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> _builtins.str:
        """
        The revision of secret version
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        The ID of the secret.
        Only one of `name` and `secret_id` should be specified.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the secret version
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Date and time of secret version's creation (RFC 3339 format)
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetTemDomainReputationResult(dict):
    def __init__(__self__, *,
                 previous_score: _builtins.int,
                 previous_scored_at: _builtins.str,
                 score: _builtins.int,
                 scored_at: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.int previous_score: The previously-calculated domain's reputation score
        :param _builtins.str previous_scored_at: Time and date the previous reputation score was calculated
        :param _builtins.int score: A range from 0 to 100 that determines your domain's reputation score
        :param _builtins.str scored_at: Time and date the score was calculated
        :param _builtins.str status: Status of the domain's reputation
        """
        pulumi.set(__self__, "previous_score", previous_score)
        pulumi.set(__self__, "previous_scored_at", previous_scored_at)
        pulumi.set(__self__, "score", score)
        pulumi.set(__self__, "scored_at", scored_at)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="previousScore")
    def previous_score(self) -> _builtins.int:
        """
        The previously-calculated domain's reputation score
        """
        return pulumi.get(self, "previous_score")

    @_builtins.property
    @pulumi.getter(name="previousScoredAt")
    def previous_scored_at(self) -> _builtins.str:
        """
        Time and date the previous reputation score was calculated
        """
        return pulumi.get(self, "previous_scored_at")

    @_builtins.property
    @pulumi.getter
    def score(self) -> _builtins.int:
        """
        A range from 0 to 100 that determines your domain's reputation score
        """
        return pulumi.get(self, "score")

    @_builtins.property
    @pulumi.getter(name="scoredAt")
    def scored_at(self) -> _builtins.str:
        """
        Time and date the score was calculated
        """
        return pulumi.get(self, "scored_at")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the domain's reputation
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetVpcGatewayNetworkIpamConfigResult(dict):
    def __init__(__self__, *,
                 ipam_ip_id: _builtins.str,
                 push_default_route: _builtins.bool):
        """
        :param _builtins.str ipam_ip_id: Use this IPAM-booked IP ID as the Gateway's IP in this Private Network
        :param _builtins.bool push_default_route: Defines whether the default route is enabled on that Gateway Network
        """
        pulumi.set(__self__, "ipam_ip_id", ipam_ip_id)
        pulumi.set(__self__, "push_default_route", push_default_route)

    @_builtins.property
    @pulumi.getter(name="ipamIpId")
    def ipam_ip_id(self) -> _builtins.str:
        """
        Use this IPAM-booked IP ID as the Gateway's IP in this Private Network
        """
        return pulumi.get(self, "ipam_ip_id")

    @_builtins.property
    @pulumi.getter(name="pushDefaultRoute")
    def push_default_route(self) -> _builtins.bool:
        """
        Defines whether the default route is enabled on that Gateway Network
        """
        return pulumi.get(self, "push_default_route")


@pulumi.output_type
class GetVpcGatewayNetworkPrivateIpResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str address: The private IPv4 address.
        :param _builtins.str id: The ID of the IPv4 address resource.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The private IPv4 address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the IPv4 address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetVpcPrivateNetworkIpv4SubnetResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 created_at: _builtins.str,
                 id: _builtins.str,
                 prefix_length: _builtins.int,
                 subnet: _builtins.str,
                 subnet_mask: _builtins.str,
                 updated_at: _builtins.str):
        """
        :param _builtins.str address: The network address of the subnet in dotted decimal notation, e.g., '192.168.0.0' for a '192.168.0.0/24' subnet
        :param _builtins.str created_at: The date and time of the creation of the subnet
        :param _builtins.str id: The ID of the Private Network.
        :param _builtins.int prefix_length: The length of the network prefix, e.g., 24 for a 255.255.255.0 mask
        :param _builtins.str subnet: The subnet CIDR
        :param _builtins.str subnet_mask: The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        :param _builtins.str updated_at: The date and time of the last update of the subnet
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "prefix_length", prefix_length)
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "subnet_mask", subnet_mask)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The network address of the subnet in dotted decimal notation, e.g., '192.168.0.0' for a '192.168.0.0/24' subnet
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date and time of the creation of the subnet
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Private Network.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> _builtins.int:
        """
        The length of the network prefix, e.g., 24 for a 255.255.255.0 mask
        """
        return pulumi.get(self, "prefix_length")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> _builtins.str:
        """
        The subnet CIDR
        """
        return pulumi.get(self, "subnet")

    @_builtins.property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> _builtins.str:
        """
        The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        """
        return pulumi.get(self, "subnet_mask")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The date and time of the last update of the subnet
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetVpcPrivateNetworkIpv6SubnetResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 created_at: _builtins.str,
                 id: _builtins.str,
                 prefix_length: _builtins.int,
                 subnet: _builtins.str,
                 subnet_mask: _builtins.str,
                 updated_at: _builtins.str):
        """
        :param _builtins.str address: The network address of the subnet in dotted decimal notation, e.g., '192.168.0.0' for a '192.168.0.0/24' subnet
        :param _builtins.str created_at: The date and time of the creation of the subnet
        :param _builtins.str id: The ID of the Private Network.
        :param _builtins.int prefix_length: The length of the network prefix, e.g., 24 for a 255.255.255.0 mask
        :param _builtins.str subnet: The subnet CIDR
        :param _builtins.str subnet_mask: The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        :param _builtins.str updated_at: The date and time of the last update of the subnet
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "prefix_length", prefix_length)
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "subnet_mask", subnet_mask)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The network address of the subnet in dotted decimal notation, e.g., '192.168.0.0' for a '192.168.0.0/24' subnet
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date and time of the creation of the subnet
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Private Network.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> _builtins.int:
        """
        The length of the network prefix, e.g., 24 for a 255.255.255.0 mask
        """
        return pulumi.get(self, "prefix_length")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> _builtins.str:
        """
        The subnet CIDR
        """
        return pulumi.get(self, "subnet")

    @_builtins.property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> _builtins.str:
        """
        The subnet mask expressed in dotted decimal notation, e.g., '255.255.255.0' for a /24 subnet
        """
        return pulumi.get(self, "subnet_mask")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The date and time of the last update of the subnet
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetVpcRoutesRouteResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 description: _builtins.str,
                 destination: _builtins.str,
                 id: _builtins.str,
                 nexthop_ip: _builtins.str,
                 nexthop_name: _builtins.str,
                 nexthop_private_network_id: _builtins.str,
                 nexthop_resource_id: _builtins.str,
                 nexthop_resource_type: _builtins.str,
                 tags: Sequence[_builtins.str],
                 vpc_id: _builtins.str,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str created_at: The date on which the route was created (RFC 3339 format).
        :param _builtins.str description: The description of the route.
        :param _builtins.str destination: The destination IP or IP range of the route.
        :param _builtins.str id: The ID of the route.
               > **Important:** route IDs are regional, which means they are of the form `{region}/{id}`, e.g. `fr-par/11111111-1111-1111-1111-111111111111
        :param _builtins.str nexthop_ip: The IP of the route's next hop.
        :param _builtins.str nexthop_name: The name of the route's next hop.
        :param _builtins.str nexthop_private_network_id: The next hop private network ID to filter for. routes with a similar next hop private network ID are listed.
        :param _builtins.str nexthop_resource_id: The next hop resource ID to filter for. routes with a similar next hop resource ID are listed.
        :param _builtins.str nexthop_resource_type: The next hop resource type to filter for. routes with a similar next hop resource type are listed.
        :param Sequence[_builtins.str] tags: List of tags to filter for. routes with these exact tags are listed.
        :param _builtins.str vpc_id: The VPC ID to filter for. routes with a similar VPC ID are listed.
        :param _builtins.str region: `region`). The region in which the routes exist.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "nexthop_ip", nexthop_ip)
        pulumi.set(__self__, "nexthop_name", nexthop_name)
        pulumi.set(__self__, "nexthop_private_network_id", nexthop_private_network_id)
        pulumi.set(__self__, "nexthop_resource_id", nexthop_resource_id)
        pulumi.set(__self__, "nexthop_resource_type", nexthop_resource_type)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date on which the route was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the route.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        """
        The destination IP or IP range of the route.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the route.
        > **Important:** route IDs are regional, which means they are of the form `{region}/{id}`, e.g. `fr-par/11111111-1111-1111-1111-111111111111
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="nexthopIp")
    def nexthop_ip(self) -> _builtins.str:
        """
        The IP of the route's next hop.
        """
        return pulumi.get(self, "nexthop_ip")

    @_builtins.property
    @pulumi.getter(name="nexthopName")
    def nexthop_name(self) -> _builtins.str:
        """
        The name of the route's next hop.
        """
        return pulumi.get(self, "nexthop_name")

    @_builtins.property
    @pulumi.getter(name="nexthopPrivateNetworkId")
    def nexthop_private_network_id(self) -> _builtins.str:
        """
        The next hop private network ID to filter for. routes with a similar next hop private network ID are listed.
        """
        return pulumi.get(self, "nexthop_private_network_id")

    @_builtins.property
    @pulumi.getter(name="nexthopResourceId")
    def nexthop_resource_id(self) -> _builtins.str:
        """
        The next hop resource ID to filter for. routes with a similar next hop resource ID are listed.
        """
        return pulumi.get(self, "nexthop_resource_id")

    @_builtins.property
    @pulumi.getter(name="nexthopResourceType")
    def nexthop_resource_type(self) -> _builtins.str:
        """
        The next hop resource type to filter for. routes with a similar next hop resource type are listed.
        """
        return pulumi.get(self, "nexthop_resource_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        List of tags to filter for. routes with these exact tags are listed.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The VPC ID to filter for. routes with a similar VPC ID are listed.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        `region`). The region in which the routes exist.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetVpcsVpcResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 id: _builtins.str,
                 is_default: _builtins.bool,
                 name: _builtins.str,
                 organization_id: _builtins.str,
                 project_id: _builtins.str,
                 tags: Sequence[_builtins.str],
                 update_at: _builtins.str,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str created_at: Date and time of VPC's creation (RFC 3339 format).
        :param _builtins.str id: The associated VPC ID.
               > **Important:** VPC IDs are regional, which means they are of the form `{region}/{id}`, e.g. `fr-par/11111111-1111-1111-1111-111111111111
        :param _builtins.bool is_default: Defines whether the VPC is the default one for its Project.
        :param _builtins.str name: The VPC name to filter for. VPCs with a similar name are listed.
        :param _builtins.str organization_id: The Organization ID the VPC is associated with.
        :param _builtins.str project_id: The ID of the Project the VPC is associated with.
        :param Sequence[_builtins.str] tags: List of tags to filter for. VPCs with these exact tags are listed.
        :param _builtins.str update_at: Date on which the VPC was last updated (RFC 3339 format)
        :param _builtins.str region: `region`). The region in which the VPCs exist.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "update_at", update_at)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Date and time of VPC's creation (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The associated VPC ID.
        > **Important:** VPC IDs are regional, which means they are of the form `{region}/{id}`, e.g. `fr-par/11111111-1111-1111-1111-111111111111
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Defines whether the VPC is the default one for its Project.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The VPC name to filter for. VPCs with a similar name are listed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        The Organization ID the VPC is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The ID of the Project the VPC is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        List of tags to filter for. VPCs with these exact tags are listed.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updateAt")
    def update_at(self) -> _builtins.str:
        """
        Date on which the VPC was last updated (RFC 3339 format)
        """
        return pulumi.get(self, "update_at")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        `region`). The region in which the VPCs exist.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetWebHostOfferOfferResult(dict):
    def __init__(__self__, *,
                 available: _builtins.bool,
                 billing_operation_path: _builtins.str,
                 control_panel_name: _builtins.str,
                 end_of_life: _builtins.bool,
                 id: _builtins.str,
                 name: _builtins.str,
                 options: Sequence['outputs.GetWebHostOfferOfferOptionResult'],
                 price: _builtins.str,
                 quota_warning: _builtins.str):
        """
        :param _builtins.bool available: Indicates if the offer is available.
        :param _builtins.str billing_operation_path: The billing operation identifier for the option.
        :param _builtins.str control_panel_name: The name of the control panel (e.g., Cpanel or Plesk).
        :param _builtins.bool end_of_life: Indicates if the offer is deprecated or no longer supported.
        :param _builtins.str id: The unique identifier of the option.
        :param _builtins.str name: The offer name. Only one of `name` and `offer_id` should be specified.
        :param Sequence['GetWebHostOfferOfferOptionArgs'] options: A list of available options for the offer:
        :param _builtins.str price: The offer price.
        :param _builtins.str quota_warning: Warning information regarding quota limitations for the option.
        """
        pulumi.set(__self__, "available", available)
        pulumi.set(__self__, "billing_operation_path", billing_operation_path)
        pulumi.set(__self__, "control_panel_name", control_panel_name)
        pulumi.set(__self__, "end_of_life", end_of_life)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "price", price)
        pulumi.set(__self__, "quota_warning", quota_warning)

    @_builtins.property
    @pulumi.getter
    def available(self) -> _builtins.bool:
        """
        Indicates if the offer is available.
        """
        return pulumi.get(self, "available")

    @_builtins.property
    @pulumi.getter(name="billingOperationPath")
    def billing_operation_path(self) -> _builtins.str:
        """
        The billing operation identifier for the option.
        """
        return pulumi.get(self, "billing_operation_path")

    @_builtins.property
    @pulumi.getter(name="controlPanelName")
    def control_panel_name(self) -> _builtins.str:
        """
        The name of the control panel (e.g., Cpanel or Plesk).
        """
        return pulumi.get(self, "control_panel_name")

    @_builtins.property
    @pulumi.getter(name="endOfLife")
    def end_of_life(self) -> _builtins.bool:
        """
        Indicates if the offer is deprecated or no longer supported.
        """
        return pulumi.get(self, "end_of_life")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier of the option.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The offer name. Only one of `name` and `offer_id` should be specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def options(self) -> Sequence['outputs.GetWebHostOfferOfferOptionResult']:
        """
        A list of available options for the offer:
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def price(self) -> _builtins.str:
        """
        The offer price.
        """
        return pulumi.get(self, "price")

    @_builtins.property
    @pulumi.getter(name="quotaWarning")
    def quota_warning(self) -> _builtins.str:
        """
        Warning information regarding quota limitations for the option.
        """
        return pulumi.get(self, "quota_warning")


@pulumi.output_type
class GetWebHostOfferOfferOptionResult(dict):
    def __init__(__self__, *,
                 billing_operation_path: _builtins.str,
                 current_value: _builtins.int,
                 id: _builtins.str,
                 max_value: _builtins.int,
                 min_value: _builtins.int,
                 name: _builtins.str,
                 price: _builtins.str,
                 quota_warning: _builtins.str):
        """
        :param _builtins.str billing_operation_path: The billing operation identifier for the option.
        :param _builtins.int current_value: The current value set for the option.
        :param _builtins.str id: The unique identifier of the option.
        :param _builtins.int max_value: The maximum allowed value for the option.
        :param _builtins.int min_value: The minimum value for the option.
        :param _builtins.str name: The offer name. Only one of `name` and `offer_id` should be specified.
        :param _builtins.str price: The offer price.
        :param _builtins.str quota_warning: Warning information regarding quota limitations for the option.
        """
        pulumi.set(__self__, "billing_operation_path", billing_operation_path)
        pulumi.set(__self__, "current_value", current_value)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "max_value", max_value)
        pulumi.set(__self__, "min_value", min_value)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "price", price)
        pulumi.set(__self__, "quota_warning", quota_warning)

    @_builtins.property
    @pulumi.getter(name="billingOperationPath")
    def billing_operation_path(self) -> _builtins.str:
        """
        The billing operation identifier for the option.
        """
        return pulumi.get(self, "billing_operation_path")

    @_builtins.property
    @pulumi.getter(name="currentValue")
    def current_value(self) -> _builtins.int:
        """
        The current value set for the option.
        """
        return pulumi.get(self, "current_value")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier of the option.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> _builtins.int:
        """
        The maximum allowed value for the option.
        """
        return pulumi.get(self, "max_value")

    @_builtins.property
    @pulumi.getter(name="minValue")
    def min_value(self) -> _builtins.int:
        """
        The minimum value for the option.
        """
        return pulumi.get(self, "min_value")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The offer name. Only one of `name` and `offer_id` should be specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def price(self) -> _builtins.str:
        """
        The offer price.
        """
        return pulumi.get(self, "price")

    @_builtins.property
    @pulumi.getter(name="quotaWarning")
    def quota_warning(self) -> _builtins.str:
        """
        Warning information regarding quota limitations for the option.
        """
        return pulumi.get(self, "quota_warning")


@pulumi.output_type
class GetWebHostOfferProductResult(dict):
    def __init__(__self__, *,
                 databases_quota: _builtins.int,
                 email_accounts_quota: _builtins.int,
                 email_storage_quota: _builtins.int,
                 hosting_storage_quota: _builtins.int,
                 name: _builtins.str,
                 option: _builtins.bool,
                 ram: _builtins.int,
                 support_included: _builtins.bool,
                 v_cpu: _builtins.int):
        """
        :param _builtins.int databases_quota: The quota of databases.
        :param _builtins.int email_accounts_quota: The quota of email accounts.
        :param _builtins.int email_storage_quota: The quota of email storage.
        :param _builtins.int hosting_storage_quota: The quota of hosting storage.
        :param _builtins.str name: The offer name. Only one of `name` and `offer_id` should be specified.
        :param _builtins.bool option: The product option.
        :param _builtins.int ram: The capacity of the memory in GB.
        :param _builtins.bool support_included: If support is included.
        :param _builtins.int v_cpu: The number of cores.
        """
        pulumi.set(__self__, "databases_quota", databases_quota)
        pulumi.set(__self__, "email_accounts_quota", email_accounts_quota)
        pulumi.set(__self__, "email_storage_quota", email_storage_quota)
        pulumi.set(__self__, "hosting_storage_quota", hosting_storage_quota)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "option", option)
        pulumi.set(__self__, "ram", ram)
        pulumi.set(__self__, "support_included", support_included)
        pulumi.set(__self__, "v_cpu", v_cpu)

    @_builtins.property
    @pulumi.getter(name="databasesQuota")
    def databases_quota(self) -> _builtins.int:
        """
        The quota of databases.
        """
        return pulumi.get(self, "databases_quota")

    @_builtins.property
    @pulumi.getter(name="emailAccountsQuota")
    def email_accounts_quota(self) -> _builtins.int:
        """
        The quota of email accounts.
        """
        return pulumi.get(self, "email_accounts_quota")

    @_builtins.property
    @pulumi.getter(name="emailStorageQuota")
    def email_storage_quota(self) -> _builtins.int:
        """
        The quota of email storage.
        """
        return pulumi.get(self, "email_storage_quota")

    @_builtins.property
    @pulumi.getter(name="hostingStorageQuota")
    def hosting_storage_quota(self) -> _builtins.int:
        """
        The quota of hosting storage.
        """
        return pulumi.get(self, "hosting_storage_quota")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The offer name. Only one of `name` and `offer_id` should be specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def option(self) -> _builtins.bool:
        """
        The product option.
        """
        return pulumi.get(self, "option")

    @_builtins.property
    @pulumi.getter
    def ram(self) -> _builtins.int:
        """
        The capacity of the memory in GB.
        """
        return pulumi.get(self, "ram")

    @_builtins.property
    @pulumi.getter(name="supportIncluded")
    def support_included(self) -> _builtins.bool:
        """
        If support is included.
        """
        return pulumi.get(self, "support_included")

    @_builtins.property
    @pulumi.getter(name="vCpu")
    def v_cpu(self) -> _builtins.int:
        """
        The number of cores.
        """
        return pulumi.get(self, "v_cpu")


@pulumi.output_type
class GetWebhostingCpanelUrlResult(dict):
    def __init__(__self__, *,
                 dashboard: _builtins.str,
                 webmail: _builtins.str):
        """
        :param _builtins.str dashboard: URL to connect to dashboard interface
        :param _builtins.str webmail: URL to connect to Webmail interface
        """
        pulumi.set(__self__, "dashboard", dashboard)
        pulumi.set(__self__, "webmail", webmail)

    @_builtins.property
    @pulumi.getter
    def dashboard(self) -> _builtins.str:
        """
        URL to connect to dashboard interface
        """
        return pulumi.get(self, "dashboard")

    @_builtins.property
    @pulumi.getter
    def webmail(self) -> _builtins.str:
        """
        URL to connect to Webmail interface
        """
        return pulumi.get(self, "webmail")


@pulumi.output_type
class GetWebhostingNameServerResult(dict):
    def __init__(__self__, *,
                 hostname: _builtins.str,
                 is_default: _builtins.bool,
                 status: _builtins.str):
        """
        :param _builtins.str hostname: Hostname of the server
        :param _builtins.bool is_default: Whether or not the webhosting is the default one
        :param _builtins.str status: Status of the nameserver
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        Hostname of the server
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Whether or not the webhosting is the default one
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the nameserver
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetWebhostingOptionResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str id: ID of the active option
        :param _builtins.str name: Name of the option
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the active option
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the option
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetWebhostingRecordResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 priority: _builtins.int,
                 status: _builtins.str,
                 ttl: _builtins.int,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Name of the DNS record
        :param _builtins.int priority: Priority of DNS records associated with the webhosting.
        :param _builtins.str status: Status of the hosting record
        :param _builtins.int ttl: Time to live in seconds of the record
        :param _builtins.str type: Type of the DNS record
        :param _builtins.str value: Value of the DNS record
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the DNS record
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Priority of DNS records associated with the webhosting.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the hosting record
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> _builtins.int:
        """
        Time to live in seconds of the record
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the DNS record
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the DNS record
        """
        return pulumi.get(self, "value")


