# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecretArgs', 'Secret']

@pulumi.input_type
class SecretArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ephemeral_policies: Optional[pulumi.Input[Sequence[pulumi.Input['SecretEphemeralPolicyArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protected: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Secret resource.
        :param pulumi.Input[_builtins.str] description: Description of the secret (e.g. `my-new-description`).
        :param pulumi.Input[Sequence[pulumi.Input['SecretEphemeralPolicyArgs']]] ephemeral_policies: Ephemeral policy of the secret. Policy that defines whether/when a secret's versions expire. By default, the policy is applied to all the secret's versions.
        :param pulumi.Input[_builtins.str] name: Name of the secret (e.g. `my-secret`).
        :param pulumi.Input[_builtins.str] path: Path of the secret, defaults to `/`.
        :param pulumi.Input[_builtins.str] project_id: The project ID containing is the secret.
        :param pulumi.Input[_builtins.bool] protected: True if secret protection is enabled on a given secret. A protected secret cannot be deleted.
        :param pulumi.Input[_builtins.str] region: `region`) The region
               in which the resource exists.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags of the secret (e.g. `["tag", "secret"]`).
        :param pulumi.Input[_builtins.str] type: Type of the secret. If not specified, the type is Opaque. Available values can be found in [SDK Constants](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/secret/v1beta1#pkg-constants).
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ephemeral_policies is not None:
            pulumi.set(__self__, "ephemeral_policies", ephemeral_policies)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if protected is not None:
            pulumi.set(__self__, "protected", protected)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the secret (e.g. `my-new-description`).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ephemeralPolicies")
    def ephemeral_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretEphemeralPolicyArgs']]]]:
        """
        Ephemeral policy of the secret. Policy that defines whether/when a secret's versions expire. By default, the policy is applied to all the secret's versions.
        """
        return pulumi.get(self, "ephemeral_policies")

    @ephemeral_policies.setter
    def ephemeral_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretEphemeralPolicyArgs']]]]):
        pulumi.set(self, "ephemeral_policies", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the secret (e.g. `my-secret`).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path of the secret, defaults to `/`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project ID containing is the secret.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def protected(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if secret protection is enabled on a given secret. A protected secret cannot be deleted.
        """
        return pulumi.get(self, "protected")

    @protected.setter
    def protected(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "protected", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region
        in which the resource exists.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags of the secret (e.g. `["tag", "secret"]`).
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the secret. If not specified, the type is Opaque. Available values can be found in [SDK Constants](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/secret/v1beta1#pkg-constants).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _SecretState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ephemeral_policies: Optional[pulumi.Input[Sequence[pulumi.Input['SecretEphemeralPolicyArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protected: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 version_count: Optional[pulumi.Input[_builtins.int]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input['SecretVersionArgs']]]] = None):
        """
        Input properties used for looking up and filtering Secret resources.
        :param pulumi.Input[_builtins.str] created_at: Date and time of the secret's creation (in RFC 3339 format).
        :param pulumi.Input[_builtins.str] description: Description of the secret (e.g. `my-new-description`).
        :param pulumi.Input[Sequence[pulumi.Input['SecretEphemeralPolicyArgs']]] ephemeral_policies: Ephemeral policy of the secret. Policy that defines whether/when a secret's versions expire. By default, the policy is applied to all the secret's versions.
        :param pulumi.Input[_builtins.str] name: Name of the secret (e.g. `my-secret`).
        :param pulumi.Input[_builtins.str] path: Path of the secret, defaults to `/`.
        :param pulumi.Input[_builtins.str] project_id: The project ID containing is the secret.
        :param pulumi.Input[_builtins.bool] protected: True if secret protection is enabled on a given secret. A protected secret cannot be deleted.
        :param pulumi.Input[_builtins.str] region: `region`) The region
               in which the resource exists.
        :param pulumi.Input[_builtins.str] status: The status of the secret.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags of the secret (e.g. `["tag", "secret"]`).
        :param pulumi.Input[_builtins.str] type: Type of the secret. If not specified, the type is Opaque. Available values can be found in [SDK Constants](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/secret/v1beta1#pkg-constants).
        :param pulumi.Input[_builtins.str] updated_at: Date and time of the secret's last update (in RFC 3339 format).
        :param pulumi.Input[_builtins.int] version_count: The amount of secret versions.
        :param pulumi.Input[Sequence[pulumi.Input['SecretVersionArgs']]] versions: List of the versions of the secret
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ephemeral_policies is not None:
            pulumi.set(__self__, "ephemeral_policies", ephemeral_policies)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if protected is not None:
            pulumi.set(__self__, "protected", protected)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if version_count is not None:
            pulumi.set(__self__, "version_count", version_count)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time of the secret's creation (in RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the secret (e.g. `my-new-description`).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ephemeralPolicies")
    def ephemeral_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretEphemeralPolicyArgs']]]]:
        """
        Ephemeral policy of the secret. Policy that defines whether/when a secret's versions expire. By default, the policy is applied to all the secret's versions.
        """
        return pulumi.get(self, "ephemeral_policies")

    @ephemeral_policies.setter
    def ephemeral_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretEphemeralPolicyArgs']]]]):
        pulumi.set(self, "ephemeral_policies", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the secret (e.g. `my-secret`).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path of the secret, defaults to `/`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project ID containing is the secret.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def protected(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if secret protection is enabled on a given secret. A protected secret cannot be deleted.
        """
        return pulumi.get(self, "protected")

    @protected.setter
    def protected(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "protected", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region
        in which the resource exists.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the secret.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags of the secret (e.g. `["tag", "secret"]`).
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the secret. If not specified, the type is Opaque. Available values can be found in [SDK Constants](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/secret/v1beta1#pkg-constants).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time of the secret's last update (in RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="versionCount")
    def version_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of secret versions.
        """
        return pulumi.get(self, "version_count")

    @version_count.setter
    def version_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version_count", value)

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretVersionArgs']]]]:
        """
        List of the versions of the secret
        """
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretVersionArgs']]]]):
        pulumi.set(self, "versions", value)


warnings.warn("""scaleway.index/secret.Secret has been deprecated in favor of scaleway.secrets/secret.Secret""", DeprecationWarning)


@pulumi.type_token("scaleway:index/secret:Secret")
class Secret(pulumi.CustomResource):
    warnings.warn("""scaleway.index/secret.Secret has been deprecated in favor of scaleway.secrets/secret.Secret""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ephemeral_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretEphemeralPolicyArgs', 'SecretEphemeralPolicyArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protected: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        This section explains how to import a secret using the `{region}/{id}` format.

        bash

        ```sh
        $ pulumi import scaleway:index/secret:Secret main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the secret (e.g. `my-new-description`).
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretEphemeralPolicyArgs', 'SecretEphemeralPolicyArgsDict']]]] ephemeral_policies: Ephemeral policy of the secret. Policy that defines whether/when a secret's versions expire. By default, the policy is applied to all the secret's versions.
        :param pulumi.Input[_builtins.str] name: Name of the secret (e.g. `my-secret`).
        :param pulumi.Input[_builtins.str] path: Path of the secret, defaults to `/`.
        :param pulumi.Input[_builtins.str] project_id: The project ID containing is the secret.
        :param pulumi.Input[_builtins.bool] protected: True if secret protection is enabled on a given secret. A protected secret cannot be deleted.
        :param pulumi.Input[_builtins.str] region: `region`) The region
               in which the resource exists.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags of the secret (e.g. `["tag", "secret"]`).
        :param pulumi.Input[_builtins.str] type: Type of the secret. If not specified, the type is Opaque. Available values can be found in [SDK Constants](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/secret/v1beta1#pkg-constants).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SecretArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        This section explains how to import a secret using the `{region}/{id}` format.

        bash

        ```sh
        $ pulumi import scaleway:index/secret:Secret main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param SecretArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ephemeral_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretEphemeralPolicyArgs', 'SecretEphemeralPolicyArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protected: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""Secret is deprecated: scaleway.index/secret.Secret has been deprecated in favor of scaleway.secrets/secret.Secret""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretArgs.__new__(SecretArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["ephemeral_policies"] = ephemeral_policies
            __props__.__dict__["name"] = name
            __props__.__dict__["path"] = path
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["protected"] = protected
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["version_count"] = None
            __props__.__dict__["versions"] = None
        super(Secret, __self__).__init__(
            'scaleway:index/secret:Secret',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            ephemeral_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretEphemeralPolicyArgs', 'SecretEphemeralPolicyArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            protected: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            version_count: Optional[pulumi.Input[_builtins.int]] = None,
            versions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecretVersionArgs', 'SecretVersionArgsDict']]]]] = None) -> 'Secret':
        """
        Get an existing Secret resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: Date and time of the secret's creation (in RFC 3339 format).
        :param pulumi.Input[_builtins.str] description: Description of the secret (e.g. `my-new-description`).
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretEphemeralPolicyArgs', 'SecretEphemeralPolicyArgsDict']]]] ephemeral_policies: Ephemeral policy of the secret. Policy that defines whether/when a secret's versions expire. By default, the policy is applied to all the secret's versions.
        :param pulumi.Input[_builtins.str] name: Name of the secret (e.g. `my-secret`).
        :param pulumi.Input[_builtins.str] path: Path of the secret, defaults to `/`.
        :param pulumi.Input[_builtins.str] project_id: The project ID containing is the secret.
        :param pulumi.Input[_builtins.bool] protected: True if secret protection is enabled on a given secret. A protected secret cannot be deleted.
        :param pulumi.Input[_builtins.str] region: `region`) The region
               in which the resource exists.
        :param pulumi.Input[_builtins.str] status: The status of the secret.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags of the secret (e.g. `["tag", "secret"]`).
        :param pulumi.Input[_builtins.str] type: Type of the secret. If not specified, the type is Opaque. Available values can be found in [SDK Constants](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/secret/v1beta1#pkg-constants).
        :param pulumi.Input[_builtins.str] updated_at: Date and time of the secret's last update (in RFC 3339 format).
        :param pulumi.Input[_builtins.int] version_count: The amount of secret versions.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecretVersionArgs', 'SecretVersionArgsDict']]]] versions: List of the versions of the secret
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretState.__new__(_SecretState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["ephemeral_policies"] = ephemeral_policies
        __props__.__dict__["name"] = name
        __props__.__dict__["path"] = path
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["protected"] = protected
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["version_count"] = version_count
        __props__.__dict__["versions"] = versions
        return Secret(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time of the secret's creation (in RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the secret (e.g. `my-new-description`).
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ephemeralPolicies")
    def ephemeral_policies(self) -> pulumi.Output[Optional[Sequence['outputs.SecretEphemeralPolicy']]]:
        """
        Ephemeral policy of the secret. Policy that defines whether/when a secret's versions expire. By default, the policy is applied to all the secret's versions.
        """
        return pulumi.get(self, "ephemeral_policies")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the secret (e.g. `my-secret`).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path of the secret, defaults to `/`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The project ID containing is the secret.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def protected(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        True if secret protection is enabled on a given secret. A protected secret cannot be deleted.
        """
        return pulumi.get(self, "protected")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `region`) The region
        in which the resource exists.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the secret.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags of the secret (e.g. `["tag", "secret"]`).
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type of the secret. If not specified, the type is Opaque. Available values can be found in [SDK Constants](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/secret/v1beta1#pkg-constants).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time of the secret's last update (in RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="versionCount")
    def version_count(self) -> pulumi.Output[_builtins.int]:
        """
        The amount of secret versions.
        """
        return pulumi.get(self, "version_count")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> pulumi.Output[Sequence['outputs.SecretVersion']]:
        """
        List of the versions of the secret
        """
        return pulumi.get(self, "versions")

