# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'SecretEphemeralPolicyArgs',
    'SecretEphemeralPolicyArgsDict',
    'SecretVersionArgs',
    'SecretVersionArgsDict',
]

MYPY = False

if not MYPY:
    class SecretEphemeralPolicyArgsDict(TypedDict):
        action: pulumi.Input[_builtins.str]
        """
        Action to perform when the version of a secret expires. Available values can be found in [SDK constants](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/secret/v1beta1#pkg-constants).
        """
        expires_once_accessed: NotRequired[pulumi.Input[_builtins.bool]]
        """
        True if the secret version expires after a single user access.
        """
        ttl: NotRequired[pulumi.Input[_builtins.str]]
        """
        Time frame, from one second and up to one year, during which the secret's versions are valid. Has to be specified in [Go Duration format](https://pkg.go.dev/time#ParseDuration) (ex: "30m", "24h").
        """
elif False:
    SecretEphemeralPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecretEphemeralPolicyArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 expires_once_accessed: Optional[pulumi.Input[_builtins.bool]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] action: Action to perform when the version of a secret expires. Available values can be found in [SDK constants](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/secret/v1beta1#pkg-constants).
        :param pulumi.Input[_builtins.bool] expires_once_accessed: True if the secret version expires after a single user access.
        :param pulumi.Input[_builtins.str] ttl: Time frame, from one second and up to one year, during which the secret's versions are valid. Has to be specified in [Go Duration format](https://pkg.go.dev/time#ParseDuration) (ex: "30m", "24h").
        """
        pulumi.set(__self__, "action", action)
        if expires_once_accessed is not None:
            pulumi.set(__self__, "expires_once_accessed", expires_once_accessed)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        Action to perform when the version of a secret expires. Available values can be found in [SDK constants](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/secret/v1beta1#pkg-constants).
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="expiresOnceAccessed")
    def expires_once_accessed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if the secret version expires after a single user access.
        """
        return pulumi.get(self, "expires_once_accessed")

    @expires_once_accessed.setter
    def expires_once_accessed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "expires_once_accessed", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time frame, from one second and up to one year, during which the secret's versions are valid. Has to be specified in [Go Duration format](https://pkg.go.dev/time#ParseDuration) (ex: "30m", "24h").
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ttl", value)


if not MYPY:
    class SecretVersionArgsDict(TypedDict):
        created_at: NotRequired[pulumi.Input[_builtins.str]]
        """
        Date and time of the secret's creation (in RFC 3339 format).
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        Description of the secret (e.g. `my-new-description`).
        """
        latest: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Returns true if the version is the latest.
        """
        revision: NotRequired[pulumi.Input[_builtins.str]]
        """
        The revision of secret version
        """
        secret_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The secret ID associated with this version
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        The status of the secret.
        """
        updated_at: NotRequired[pulumi.Input[_builtins.str]]
        """
        Date and time of the secret's last update (in RFC 3339 format).
        """
elif False:
    SecretVersionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecretVersionArgs:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 latest: Optional[pulumi.Input[_builtins.bool]] = None,
                 revision: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] created_at: Date and time of the secret's creation (in RFC 3339 format).
        :param pulumi.Input[_builtins.str] description: Description of the secret (e.g. `my-new-description`).
        :param pulumi.Input[_builtins.bool] latest: Returns true if the version is the latest.
        :param pulumi.Input[_builtins.str] revision: The revision of secret version
        :param pulumi.Input[_builtins.str] secret_id: The secret ID associated with this version
        :param pulumi.Input[_builtins.str] status: The status of the secret.
        :param pulumi.Input[_builtins.str] updated_at: Date and time of the secret's last update (in RFC 3339 format).
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if latest is not None:
            pulumi.set(__self__, "latest", latest)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time of the secret's creation (in RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the secret (e.g. `my-new-description`).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def latest(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Returns true if the version is the latest.
        """
        return pulumi.get(self, "latest")

    @latest.setter
    def latest(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "latest", value)

    @_builtins.property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The revision of secret version
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revision", value)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret ID associated with this version
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the secret.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time of the secret's last update (in RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


