# -*- coding: utf-8 -*-


from __future__ import print_function
import sys

from kobo.client import ClientCommand


class Add_User(ClientCommand):
    """add a new user"""
    enabled = True
    admin = True


    def options(self):
        self.parser.usage = "%%prog %s [options] <user>" % self.normalized_name

        self.parser.add_option(
            "--admin",
            default=False,
            action="store_true",
            help="grant admin privileges"
        )


    def run(self, *args, **kwargs):
        if len(args) < 1:
            self.parser.error("Please specify a user")

        username = kwargs.pop("username", None)
        password = kwargs.pop("password", None)
        hub = kwargs.pop("hub", None)
        admin = kwargs.pop("admin", False)
        user = args[0]

        self.set_hub(username, password, hub)
        try:
            self.hub.admin.add_user(user, admin)
        except Exception as ex:
            print(str(ex))
            sys.exit(1)
