# Viblr SDK - Context as a Service

**Perfect Prompts, First Try** - Enhance your AI prompts with rich context from connected sources.

## 🚀 Quick Start

### Installation

```bash
pip install -r requirements.txt
```

### Basic Usage

```python
from viblr_sdk import ViblrClient

# Initialize client
client = ViblrClient(api_key="your_api_key")

# Search for context
response = client.search(
    query="How to handle authentication errors?",
    max_results=5
)

print(f"Enhanced prompt: {response.enhanced_prompt}")
print(f"Citations: {response.search_results}")
```

## 🔧 Advanced Usage

### Search with Filters

```python
# Filter by specific sources
response = client.search(
    query="Recent changes to login system",
    sources=["gmail", "github"],
    content_types=["email", "code"],
    max_results=10
)

# Get raw results instead of enhanced prompt
raw_response = client.search(
    query="test query",
    output_format="raw_results"
)
```

### Processing Options

```python
# Enable advanced processing
response = client.search(
    query="Analyze customer feedback",
    processing={
        "sentiment": True,
        "keywords": True,
        "summary": True,
        "textrank": True  # For high-quality context (slower)
    }
)

print(f"Sentiment: {response.processing.sentiment}")
print(f"Keywords: {response.processing.keywords}")
```

### Different Output Formats

```python
# Enhanced prompt (default)
enhanced = client.search(query="test", output_format="enhanced_prompt")

# Raw search results
raw = client.search(query="test", output_format="raw_results")

# Processed results only
processed = client.search(query="test", output_format="processed_results")
```

## 🧪 Testing

### Run the Example

```bash
python example_app.py
```

## 📚 API Reference

### ViblrClient

#### `search(query, max_results=5, sources=None, content_types=None, processing=None, output_format="enhanced_prompt")`

Search for context and enhance prompts.

**Parameters:**
- `query` (str): The search query
- `max_results` (int): Maximum number of results to return (default: 5)
- `sources` (List[str], optional): Filter by sources (e.g., ['gmail', 'github'])
- `content_types` (List[str], optional): Filter by content types (e.g., ['email', 'code'])
- `processing` (Dict, optional): Processing options (sentiment, keywords, summary, textrank)
- `output_format` (str): Output format - 'enhanced_prompt', 'raw_results', 'processed_results'

**Returns:**
- `ViblrResponse`: Response object with enhanced_prompt, search_results, metadata

**Raises:**
- `ViblrAPIError`: API request failed
- `ViblrAuthError`: Authentication failed

### ViblrResponse

Response object containing:
- `enhanced_prompt` (str): Enhanced prompt with context
- `search_results` (List[Dict]): Raw search results with citations
- `status` (str): Response status
- `metadata` (Dict): Additional metadata (intent analysis, processing results, etc.)

## 🎯 Use Cases

### 1. AI Chatbots
Enhance user prompts with project context before sending to AI models.

### 2. Code Review Assistants
Add code context, recent changes, and team discussions to review requests.

### 3. Customer Support
Enhance support tickets with customer history and product context.

### 4. Documentation Assistants
Add project documentation and code context to documentation requests.

## 🔒 Authentication

The SDK uses API key authentication. Get your API key from the Viblr dashboard.

## 📊 Context Sources

Supported context sources:
- **Gmail**: Email communications
- **GitHub**: Code repositories, issues, pull requests
- **Slack**: Team conversations and channels
- **Jira**: Project management and tickets
- **Confluence**: Documentation and knowledge base
- **More coming soon...**

## 🚀 Getting Started

1. **Install the SDK**: `pip install -r requirements.txt`
2. **Get API Key**: Sign up at Viblr dashboard
3. **Connect Sources**: Link your Gmail, GitHub, Slack, Jira, etc.
4. **Search Context**: Use the SDK in your AI applications

## 📞 Support

- **Documentation**: [Viblr Docs](https://docs.viblr.dev)
- **Support**: support@viblr.dev
- **GitHub**: [Viblr SDK](https://github.com/viblr/viblr-sdk)

## 🎉 Perfect Prompts, First Try

Stop explaining your work to AI. Let Viblr provide the context AI needs to give you amazing results immediately.