"""
Viblr SDK Exceptions
"""


class ViblrError(Exception):
    """Base exception for all Viblr SDK errors"""
    pass


class ViblrAPIError(ViblrError):
    """Raised when API request fails"""
    pass


class ViblrAuthError(ViblrError):
    """Raised when authentication fails"""
    pass


class ViblrTimeoutError(ViblrError):
    """Raised when request times out"""
    pass


class ViblrQuotaError(ViblrError):
    """Raised when API quota is exceeded"""
    pass