import typing as t

from ry._types import Buffer

@t.final
class xxh32:  # noqa: N801
    name: t.Literal["xxh32"]
    digest_size: t.Literal[4]
    block_size: t.Literal[16]

    def __init__(self, data: Buffer = ..., *, seed: int | None = ...) -> None: ...
    def update(self, data: Buffer) -> None: ...
    def digest(self) -> bytes: ...
    def hexdigest(self) -> str: ...
    def intdigest(self) -> int: ...
    def copy(self) -> t.Self: ...
    def reset(self, seed: int | None = ...) -> None: ...
    @property
    def seed(self) -> int: ...
    @staticmethod
    def oneshot(data: Buffer, *, seed: int = 0) -> int: ...

@t.final
class xxh64:  # noqa: N801
    name: t.Literal["xxh64"]
    digest_size: t.Literal[8]
    block_size: t.Literal[32]

    def __init__(
        self, data: Buffer | None = None, *, seed: int | None = ...
    ) -> None: ...
    def update(self, data: Buffer) -> None: ...
    def digest(self) -> bytes: ...
    def hexdigest(self) -> str: ...
    def intdigest(self) -> int: ...
    def copy(self) -> t.Self: ...
    def reset(self, seed: int | None = ...) -> None: ...
    @property
    def seed(self) -> int: ...
    @staticmethod
    def oneshot(data: Buffer, *, seed: int = 0) -> int: ...

@t.final
class xxh3_64:  # noqa: N801
    name: t.Literal["xxh3_64"]
    digest_size: t.Literal[8]
    block_size: t.Literal[32]

    def __init__(
        self,
        data: Buffer = ...,
        *,
        seed: int | None = ...,
        secret: bytes | None = ...,
    ) -> None: ...
    def update(self, data: Buffer) -> None: ...
    def digest(self) -> bytes: ...
    def hexdigest(self) -> str: ...
    def intdigest(self) -> int: ...
    @property
    def seed(self) -> int: ...
    def digest128(self) -> bytes: ...
    def hexdigest128(self) -> str: ...
    def intdigest128(self) -> int: ...
    def copy(self) -> t.Self: ...
    def reset(self) -> None: ...
    @staticmethod
    def oneshot(data: Buffer, *, seed: int = 0, secret: bytes | None = None) -> int: ...

@t.final
class xxh3_128:  # noqa: N801
    name: t.Literal["xxh3_128"]
    digest_size: t.Literal[16]
    block_size: t.Literal[64]

    def __init__(
        self,
        data: Buffer = ...,
        *,
        seed: int | None = ...,
        secret: bytes | None = ...,
    ) -> None: ...
    def update(self, data: Buffer) -> None: ...
    def digest(self) -> bytes: ...
    def hexdigest(self) -> str: ...
    def intdigest(self) -> int: ...
    @property
    def seed(self) -> int: ...
    def digest128(self) -> bytes: ...
    def hexdigest128(self) -> str: ...
    def intdigest128(self) -> int: ...
    def copy(self) -> t.Self: ...
    def reset(self) -> None: ...
    @staticmethod
    def oneshot(data: Buffer, *, seed: int = 0, secret: bytes | None = None) -> int: ...

xxh128 = xxh3_128

# -----------------------------------------------------------------------------
# ONE-SHOT FUNCTIONS
# -----------------------------------------------------------------------------

# xxh32
def xxh32_digest(data: Buffer, *, seed: int | None = None) -> bytes: ...
def xxh32_hexdigest(data: Buffer, *, seed: int | None = None) -> str: ...
def xxh32_intdigest(data: Buffer, *, seed: int | None = None) -> int: ...

# xxh64
def xxh64_digest(data: Buffer, *, seed: int | None = None) -> bytes: ...
def xxh64_hexdigest(data: Buffer, *, seed: int | None = None) -> str: ...
def xxh64_intdigest(data: Buffer, *, seed: int | None = None) -> int: ...

# xxh128
def xxh128_digest(data: Buffer, *, seed: int | None = None) -> bytes: ...
def xxh128_hexdigest(data: Buffer, *, seed: int | None = None) -> str: ...
def xxh128_intdigest(data: Buffer, *, seed: int | None = None) -> int: ...

# xxh3
def xxh3_64_digest(data: Buffer, *, seed: int | None = None) -> bytes: ...
def xxh3_64_intdigest(data: Buffer, *, seed: int | None = None) -> int: ...
def xxh3_64_hexdigest(data: Buffer, *, seed: int | None = None) -> str: ...

# xxh128
def xxh3_128_digest(data: Buffer, *, seed: int | None = None) -> bytes: ...
def xxh3_128_intdigest(data: Buffer, *, seed: int | None = None) -> int: ...
def xxh3_128_hexdigest(data: Buffer, *, seed: int | None = None) -> str: ...
