import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AntiddosV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1#app_type_id AntiddosV1#app_type_id}
    */
    readonly appTypeId: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1#cleaning_access_pos_id AntiddosV1#cleaning_access_pos_id}
    */
    readonly cleaningAccessPosId: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1#enable_l7 AntiddosV1#enable_l7}
    */
    readonly enableL7: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1#floating_ip_id AntiddosV1#floating_ip_id}
    */
    readonly floatingIpId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1#http_request_pos_id AntiddosV1#http_request_pos_id}
    */
    readonly httpRequestPosId: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1#id AntiddosV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1#region AntiddosV1#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1#traffic_pos_id AntiddosV1#traffic_pos_id}
    */
    readonly trafficPosId: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1#timeouts AntiddosV1#timeouts}
    */
    readonly timeouts?: AntiddosV1Timeouts;
}
export interface AntiddosV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1#create AntiddosV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1#delete AntiddosV1#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1#update AntiddosV1#update}
    */
    readonly update?: string;
}
export declare function antiddosV1TimeoutsToTerraform(struct?: AntiddosV1TimeoutsOutputReference | AntiddosV1Timeouts | cdktf.IResolvable): any;
export declare class AntiddosV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AntiddosV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AntiddosV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1 opentelekomcloud_antiddos_v1}
*/
export declare class AntiddosV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_antiddos_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1 opentelekomcloud_antiddos_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AntiddosV1Config
    */
    constructor(scope: Construct, id: string, config: AntiddosV1Config);
    private _appTypeId?;
    get appTypeId(): number;
    set appTypeId(value: number);
    get appTypeIdInput(): number | undefined;
    private _cleaningAccessPosId?;
    get cleaningAccessPosId(): number;
    set cleaningAccessPosId(value: number);
    get cleaningAccessPosIdInput(): number | undefined;
    private _enableL7?;
    get enableL7(): boolean | cdktf.IResolvable;
    set enableL7(value: boolean | cdktf.IResolvable);
    get enableL7Input(): boolean | cdktf.IResolvable | undefined;
    private _floatingIpId?;
    get floatingIpId(): string;
    set floatingIpId(value: string);
    get floatingIpIdInput(): string | undefined;
    private _httpRequestPosId?;
    get httpRequestPosId(): number;
    set httpRequestPosId(value: number);
    get httpRequestPosIdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _trafficPosId?;
    get trafficPosId(): number;
    set trafficPosId(value: number);
    get trafficPosIdInput(): number | undefined;
    private _timeouts;
    get timeouts(): AntiddosV1TimeoutsOutputReference;
    putTimeouts(value: AntiddosV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AntiddosV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
