import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AsGroupV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#available_zones AsGroupV1#available_zones}
    */
    readonly availableZones?: string[];
    /**
    * The cooling duration, in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#cool_down_time AsGroupV1#cool_down_time}
    */
    readonly coolDownTime?: number;
    /**
    * Whether to delete instances when they are removed from the AS group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#delete_instances AsGroupV1#delete_instances}
    */
    readonly deleteInstances?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#delete_publicip AsGroupV1#delete_publicip}
    */
    readonly deletePublicip?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#desire_instance_number AsGroupV1#desire_instance_number}
    */
    readonly desireInstanceNumber?: number;
    /**
    * The grace period for instance health check, in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#health_periodic_audit_grace_period AsGroupV1#health_periodic_audit_grace_period}
    */
    readonly healthPeriodicAuditGracePeriod?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#health_periodic_audit_method AsGroupV1#health_periodic_audit_method}
    */
    readonly healthPeriodicAuditMethod?: string;
    /**
    * The health check period for instances, in minutes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#health_periodic_audit_time AsGroupV1#health_periodic_audit_time}
    */
    readonly healthPeriodicAuditTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#id AsGroupV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#instance_terminate_policy AsGroupV1#instance_terminate_policy}
    */
    readonly instanceTerminatePolicy?: string;
    /**
    * The system supports the binding of up to six classic LB listeners, the IDs of which are separated using a comma.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#lb_listener_id AsGroupV1#lb_listener_id}
    */
    readonly lbListenerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#max_instance_number AsGroupV1#max_instance_number}
    */
    readonly maxInstanceNumber?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#min_instance_number AsGroupV1#min_instance_number}
    */
    readonly minInstanceNumber?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#notifications AsGroupV1#notifications}
    */
    readonly notifications?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#region AsGroupV1#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#scaling_configuration_id AsGroupV1#scaling_configuration_id}
    */
    readonly scalingConfigurationId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#scaling_group_name AsGroupV1#scaling_group_name}
    */
    readonly scalingGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#tags AsGroupV1#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#vpc_id AsGroupV1#vpc_id}
    */
    readonly vpcId: string;
    /**
    * lbaas_listeners block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#lbaas_listeners AsGroupV1#lbaas_listeners}
    */
    readonly lbaasListeners?: AsGroupV1LbaasListeners[] | cdktf.IResolvable;
    /**
    * networks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#networks AsGroupV1#networks}
    */
    readonly networks: AsGroupV1Networks[] | cdktf.IResolvable;
    /**
    * security_groups block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#security_groups AsGroupV1#security_groups}
    */
    readonly securityGroups?: AsGroupV1SecurityGroups;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#timeouts AsGroupV1#timeouts}
    */
    readonly timeouts?: AsGroupV1Timeouts;
}
export interface AsGroupV1LbaasListeners {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#pool_id AsGroupV1#pool_id}
    */
    readonly poolId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#protocol_port AsGroupV1#protocol_port}
    */
    readonly protocolPort: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#weight AsGroupV1#weight}
    */
    readonly weight?: number;
}
export declare function asGroupV1LbaasListenersToTerraform(struct?: AsGroupV1LbaasListeners | cdktf.IResolvable): any;
export declare class AsGroupV1LbaasListenersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AsGroupV1LbaasListeners | cdktf.IResolvable | undefined;
    set internalValue(value: AsGroupV1LbaasListeners | cdktf.IResolvable | undefined);
    private _poolId?;
    get poolId(): string;
    set poolId(value: string);
    get poolIdInput(): string | undefined;
    private _protocolPort?;
    get protocolPort(): number;
    set protocolPort(value: number);
    get protocolPortInput(): number | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
}
export declare class AsGroupV1LbaasListenersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AsGroupV1LbaasListeners[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AsGroupV1LbaasListenersOutputReference;
}
export interface AsGroupV1Networks {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#id AsGroupV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export declare function asGroupV1NetworksToTerraform(struct?: AsGroupV1Networks | cdktf.IResolvable): any;
export declare class AsGroupV1NetworksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AsGroupV1Networks | cdktf.IResolvable | undefined;
    set internalValue(value: AsGroupV1Networks | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
}
export declare class AsGroupV1NetworksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AsGroupV1Networks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AsGroupV1NetworksOutputReference;
}
export interface AsGroupV1SecurityGroups {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#id AsGroupV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export declare function asGroupV1SecurityGroupsToTerraform(struct?: AsGroupV1SecurityGroupsOutputReference | AsGroupV1SecurityGroups): any;
export declare class AsGroupV1SecurityGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AsGroupV1SecurityGroups | undefined;
    set internalValue(value: AsGroupV1SecurityGroups | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
}
export interface AsGroupV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#create AsGroupV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1#delete AsGroupV1#delete}
    */
    readonly delete?: string;
}
export declare function asGroupV1TimeoutsToTerraform(struct?: AsGroupV1TimeoutsOutputReference | AsGroupV1Timeouts | cdktf.IResolvable): any;
export declare class AsGroupV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AsGroupV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AsGroupV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1 opentelekomcloud_as_group_v1}
*/
export declare class AsGroupV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_as_group_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1 opentelekomcloud_as_group_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AsGroupV1Config
    */
    constructor(scope: Construct, id: string, config: AsGroupV1Config);
    private _availableZones?;
    get availableZones(): string[];
    set availableZones(value: string[]);
    resetAvailableZones(): void;
    get availableZonesInput(): string[] | undefined;
    private _coolDownTime?;
    get coolDownTime(): number;
    set coolDownTime(value: number);
    resetCoolDownTime(): void;
    get coolDownTimeInput(): number | undefined;
    get currentInstanceNumber(): number;
    private _deleteInstances?;
    get deleteInstances(): string;
    set deleteInstances(value: string);
    resetDeleteInstances(): void;
    get deleteInstancesInput(): string | undefined;
    private _deletePublicip?;
    get deletePublicip(): boolean | cdktf.IResolvable;
    set deletePublicip(value: boolean | cdktf.IResolvable);
    resetDeletePublicip(): void;
    get deletePublicipInput(): boolean | cdktf.IResolvable | undefined;
    private _desireInstanceNumber?;
    get desireInstanceNumber(): number;
    set desireInstanceNumber(value: number);
    resetDesireInstanceNumber(): void;
    get desireInstanceNumberInput(): number | undefined;
    private _healthPeriodicAuditGracePeriod?;
    get healthPeriodicAuditGracePeriod(): number;
    set healthPeriodicAuditGracePeriod(value: number);
    resetHealthPeriodicAuditGracePeriod(): void;
    get healthPeriodicAuditGracePeriodInput(): number | undefined;
    private _healthPeriodicAuditMethod?;
    get healthPeriodicAuditMethod(): string;
    set healthPeriodicAuditMethod(value: string);
    resetHealthPeriodicAuditMethod(): void;
    get healthPeriodicAuditMethodInput(): string | undefined;
    private _healthPeriodicAuditTime?;
    get healthPeriodicAuditTime(): number;
    set healthPeriodicAuditTime(value: number);
    resetHealthPeriodicAuditTime(): void;
    get healthPeriodicAuditTimeInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceTerminatePolicy?;
    get instanceTerminatePolicy(): string;
    set instanceTerminatePolicy(value: string);
    resetInstanceTerminatePolicy(): void;
    get instanceTerminatePolicyInput(): string | undefined;
    get instances(): string[];
    private _lbListenerId?;
    get lbListenerId(): string;
    set lbListenerId(value: string);
    resetLbListenerId(): void;
    get lbListenerIdInput(): string | undefined;
    private _maxInstanceNumber?;
    get maxInstanceNumber(): number;
    set maxInstanceNumber(value: number);
    resetMaxInstanceNumber(): void;
    get maxInstanceNumberInput(): number | undefined;
    private _minInstanceNumber?;
    get minInstanceNumber(): number;
    set minInstanceNumber(value: number);
    resetMinInstanceNumber(): void;
    get minInstanceNumberInput(): number | undefined;
    private _notifications?;
    get notifications(): string[];
    set notifications(value: string[]);
    resetNotifications(): void;
    get notificationsInput(): string[] | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _scalingConfigurationId?;
    get scalingConfigurationId(): string;
    set scalingConfigurationId(value: string);
    resetScalingConfigurationId(): void;
    get scalingConfigurationIdInput(): string | undefined;
    private _scalingGroupName?;
    get scalingGroupName(): string;
    set scalingGroupName(value: string);
    get scalingGroupNameInput(): string | undefined;
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
    private _lbaasListeners;
    get lbaasListeners(): AsGroupV1LbaasListenersList;
    putLbaasListeners(value: AsGroupV1LbaasListeners[] | cdktf.IResolvable): void;
    resetLbaasListeners(): void;
    get lbaasListenersInput(): cdktf.IResolvable | AsGroupV1LbaasListeners[] | undefined;
    private _networks;
    get networks(): AsGroupV1NetworksList;
    putNetworks(value: AsGroupV1Networks[] | cdktf.IResolvable): void;
    get networksInput(): cdktf.IResolvable | AsGroupV1Networks[] | undefined;
    private _securityGroups;
    get securityGroups(): AsGroupV1SecurityGroupsOutputReference;
    putSecurityGroups(value: AsGroupV1SecurityGroups): void;
    resetSecurityGroups(): void;
    get securityGroupsInput(): AsGroupV1SecurityGroups | undefined;
    private _timeouts;
    get timeouts(): AsGroupV1TimeoutsOutputReference;
    putTimeouts(value: AsGroupV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AsGroupV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
