import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AsPolicyV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#alarm_id AsPolicyV2#alarm_id}
    */
    readonly alarmId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#cool_down_time AsPolicyV2#cool_down_time}
    */
    readonly coolDownTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#id AsPolicyV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#region AsPolicyV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#scaling_policy_name AsPolicyV2#scaling_policy_name}
    */
    readonly scalingPolicyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#scaling_policy_type AsPolicyV2#scaling_policy_type}
    */
    readonly scalingPolicyType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#scaling_resource_id AsPolicyV2#scaling_resource_id}
    */
    readonly scalingResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#scaling_resource_type AsPolicyV2#scaling_resource_type}
    */
    readonly scalingResourceType: string;
    /**
    * scaling_policy_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#scaling_policy_action AsPolicyV2#scaling_policy_action}
    */
    readonly scalingPolicyAction?: AsPolicyV2ScalingPolicyAction[] | cdktf.IResolvable;
    /**
    * scheduled_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#scheduled_policy AsPolicyV2#scheduled_policy}
    */
    readonly scheduledPolicy?: AsPolicyV2ScheduledPolicy[] | cdktf.IResolvable;
}
export interface AsPolicyV2Metadata {
}
export declare function asPolicyV2MetadataToTerraform(struct?: AsPolicyV2Metadata): any;
export declare class AsPolicyV2MetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AsPolicyV2Metadata | undefined;
    set internalValue(value: AsPolicyV2Metadata | undefined);
    get bandwidthShareType(): string;
    get eipAddress(): string;
    get eipId(): string;
}
export declare class AsPolicyV2MetadataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AsPolicyV2MetadataOutputReference;
}
export interface AsPolicyV2ScalingPolicyAction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#limits AsPolicyV2#limits}
    */
    readonly limits?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#operation AsPolicyV2#operation}
    */
    readonly operation?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#percentage AsPolicyV2#percentage}
    */
    readonly percentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#size AsPolicyV2#size}
    */
    readonly size?: number;
}
export declare function asPolicyV2ScalingPolicyActionToTerraform(struct?: AsPolicyV2ScalingPolicyAction | cdktf.IResolvable): any;
export declare class AsPolicyV2ScalingPolicyActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AsPolicyV2ScalingPolicyAction | cdktf.IResolvable | undefined;
    set internalValue(value: AsPolicyV2ScalingPolicyAction | cdktf.IResolvable | undefined);
    private _limits?;
    get limits(): number;
    set limits(value: number);
    resetLimits(): void;
    get limitsInput(): number | undefined;
    private _operation?;
    get operation(): string;
    set operation(value: string);
    resetOperation(): void;
    get operationInput(): string | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
}
export declare class AsPolicyV2ScalingPolicyActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AsPolicyV2ScalingPolicyAction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AsPolicyV2ScalingPolicyActionOutputReference;
}
export interface AsPolicyV2ScheduledPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#end_time AsPolicyV2#end_time}
    */
    readonly endTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#launch_time AsPolicyV2#launch_time}
    */
    readonly launchTime: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#recurrence_type AsPolicyV2#recurrence_type}
    */
    readonly recurrenceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#recurrence_value AsPolicyV2#recurrence_value}
    */
    readonly recurrenceValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#start_time AsPolicyV2#start_time}
    */
    readonly startTime?: string;
}
export declare function asPolicyV2ScheduledPolicyToTerraform(struct?: AsPolicyV2ScheduledPolicy | cdktf.IResolvable): any;
export declare class AsPolicyV2ScheduledPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AsPolicyV2ScheduledPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: AsPolicyV2ScheduledPolicy | cdktf.IResolvable | undefined);
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    resetEndTime(): void;
    get endTimeInput(): string | undefined;
    private _launchTime?;
    get launchTime(): string;
    set launchTime(value: string);
    get launchTimeInput(): string | undefined;
    private _recurrenceType?;
    get recurrenceType(): string;
    set recurrenceType(value: string);
    resetRecurrenceType(): void;
    get recurrenceTypeInput(): string | undefined;
    private _recurrenceValue?;
    get recurrenceValue(): string;
    set recurrenceValue(value: string);
    resetRecurrenceValue(): void;
    get recurrenceValueInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
}
export declare class AsPolicyV2ScheduledPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AsPolicyV2ScheduledPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AsPolicyV2ScheduledPolicyOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2 opentelekomcloud_as_policy_v2}
*/
export declare class AsPolicyV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_as_policy_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2 opentelekomcloud_as_policy_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AsPolicyV2Config
    */
    constructor(scope: Construct, id: string, config: AsPolicyV2Config);
    private _alarmId?;
    get alarmId(): string;
    set alarmId(value: string);
    resetAlarmId(): void;
    get alarmIdInput(): string | undefined;
    private _coolDownTime?;
    get coolDownTime(): number;
    set coolDownTime(value: number);
    resetCoolDownTime(): void;
    get coolDownTimeInput(): number | undefined;
    get createTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): AsPolicyV2MetadataList;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _scalingPolicyName?;
    get scalingPolicyName(): string;
    set scalingPolicyName(value: string);
    get scalingPolicyNameInput(): string | undefined;
    private _scalingPolicyType?;
    get scalingPolicyType(): string;
    set scalingPolicyType(value: string);
    get scalingPolicyTypeInput(): string | undefined;
    private _scalingResourceId?;
    get scalingResourceId(): string;
    set scalingResourceId(value: string);
    get scalingResourceIdInput(): string | undefined;
    private _scalingResourceType?;
    get scalingResourceType(): string;
    set scalingResourceType(value: string);
    get scalingResourceTypeInput(): string | undefined;
    private _scalingPolicyAction;
    get scalingPolicyAction(): AsPolicyV2ScalingPolicyActionList;
    putScalingPolicyAction(value: AsPolicyV2ScalingPolicyAction[] | cdktf.IResolvable): void;
    resetScalingPolicyAction(): void;
    get scalingPolicyActionInput(): cdktf.IResolvable | AsPolicyV2ScalingPolicyAction[] | undefined;
    private _scheduledPolicy;
    get scheduledPolicy(): AsPolicyV2ScheduledPolicyList;
    putScheduledPolicy(value: AsPolicyV2ScheduledPolicy[] | cdktf.IResolvable): void;
    resetScheduledPolicy(): void;
    get scheduledPolicyInput(): cdktf.IResolvable | AsPolicyV2ScheduledPolicy[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
