import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CceClusterV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#annotations CceClusterV3#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#authenticating_proxy_ca CceClusterV3#authenticating_proxy_ca}
    */
    readonly authenticatingProxyCa?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#authentication_mode CceClusterV3#authentication_mode}
    */
    readonly authenticationMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#billing_mode CceClusterV3#billing_mode}
    */
    readonly billingMode?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#cluster_type CceClusterV3#cluster_type}
    */
    readonly clusterType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#cluster_version CceClusterV3#cluster_version}
    */
    readonly clusterVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#container_network_cidr CceClusterV3#container_network_cidr}
    */
    readonly containerNetworkCidr?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#container_network_type CceClusterV3#container_network_type}
    */
    readonly containerNetworkType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#description CceClusterV3#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#eip CceClusterV3#eip}
    */
    readonly eip?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#eni_subnet_cidr CceClusterV3#eni_subnet_cidr}
    */
    readonly eniSubnetCidr?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#eni_subnet_id CceClusterV3#eni_subnet_id}
    */
    readonly eniSubnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#extend_param CceClusterV3#extend_param}
    */
    readonly extendParam?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#flavor_id CceClusterV3#flavor_id}
    */
    readonly flavorId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#highway_subnet_id CceClusterV3#highway_subnet_id}
    */
    readonly highwaySubnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#id CceClusterV3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#ignore_addons CceClusterV3#ignore_addons}
    */
    readonly ignoreAddons?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#kubernetes_svc_ip_range CceClusterV3#kubernetes_svc_ip_range}
    */
    readonly kubernetesSvcIpRange?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#labels CceClusterV3#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#multi_az CceClusterV3#multi_az}
    */
    readonly multiAz?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#name CceClusterV3#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#no_addons CceClusterV3#no_addons}
    */
    readonly noAddons?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#region CceClusterV3#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#subnet_id CceClusterV3#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#vpc_id CceClusterV3#vpc_id}
    */
    readonly vpcId: string;
    /**
    * authenticating_proxy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#authenticating_proxy CceClusterV3#authenticating_proxy}
    */
    readonly authenticatingProxy?: CceClusterV3AuthenticatingProxy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#timeouts CceClusterV3#timeouts}
    */
    readonly timeouts?: CceClusterV3Timeouts;
}
export interface CceClusterV3CertificateClusters {
}
export declare function cceClusterV3CertificateClustersToTerraform(struct?: CceClusterV3CertificateClusters): any;
export declare class CceClusterV3CertificateClustersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CceClusterV3CertificateClusters | undefined;
    set internalValue(value: CceClusterV3CertificateClusters | undefined);
    get certificateAuthorityData(): string;
    get name(): string;
    get server(): string;
}
export declare class CceClusterV3CertificateClustersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CceClusterV3CertificateClustersOutputReference;
}
export interface CceClusterV3CertificateUsers {
}
export declare function cceClusterV3CertificateUsersToTerraform(struct?: CceClusterV3CertificateUsers): any;
export declare class CceClusterV3CertificateUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CceClusterV3CertificateUsers | undefined;
    set internalValue(value: CceClusterV3CertificateUsers | undefined);
    get clientCertificateData(): string;
    get clientKeyData(): string;
    get name(): string;
}
export declare class CceClusterV3CertificateUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CceClusterV3CertificateUsersOutputReference;
}
export interface CceClusterV3AuthenticatingProxy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#ca CceClusterV3#ca}
    */
    readonly ca: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#cert CceClusterV3#cert}
    */
    readonly cert: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#private_key CceClusterV3#private_key}
    */
    readonly privateKey: string;
}
export declare function cceClusterV3AuthenticatingProxyToTerraform(struct?: CceClusterV3AuthenticatingProxyOutputReference | CceClusterV3AuthenticatingProxy): any;
export declare class CceClusterV3AuthenticatingProxyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CceClusterV3AuthenticatingProxy | undefined;
    set internalValue(value: CceClusterV3AuthenticatingProxy | undefined);
    private _ca?;
    get ca(): string;
    set ca(value: string);
    get caInput(): string | undefined;
    private _cert?;
    get cert(): string;
    set cert(value: string);
    get certInput(): string | undefined;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    get privateKeyInput(): string | undefined;
}
export interface CceClusterV3Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#create CceClusterV3#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3#delete CceClusterV3#delete}
    */
    readonly delete?: string;
}
export declare function cceClusterV3TimeoutsToTerraform(struct?: CceClusterV3TimeoutsOutputReference | CceClusterV3Timeouts | cdktf.IResolvable): any;
export declare class CceClusterV3TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CceClusterV3Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CceClusterV3Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3 opentelekomcloud_cce_cluster_v3}
*/
export declare class CceClusterV3 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_cce_cluster_v3";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3 opentelekomcloud_cce_cluster_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CceClusterV3Config
    */
    constructor(scope: Construct, id: string, config: CceClusterV3Config);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _authenticatingProxyCa?;
    get authenticatingProxyCa(): string;
    set authenticatingProxyCa(value: string);
    resetAuthenticatingProxyCa(): void;
    get authenticatingProxyCaInput(): string | undefined;
    private _authenticationMode?;
    get authenticationMode(): string;
    set authenticationMode(value: string);
    resetAuthenticationMode(): void;
    get authenticationModeInput(): string | undefined;
    private _billingMode?;
    get billingMode(): number;
    set billingMode(value: number);
    resetBillingMode(): void;
    get billingModeInput(): number | undefined;
    private _certificateClusters;
    get certificateClusters(): CceClusterV3CertificateClustersList;
    private _certificateUsers;
    get certificateUsers(): CceClusterV3CertificateUsersList;
    private _clusterType?;
    get clusterType(): string;
    set clusterType(value: string);
    get clusterTypeInput(): string | undefined;
    private _clusterVersion?;
    get clusterVersion(): string;
    set clusterVersion(value: string);
    resetClusterVersion(): void;
    get clusterVersionInput(): string | undefined;
    private _containerNetworkCidr?;
    get containerNetworkCidr(): string;
    set containerNetworkCidr(value: string);
    resetContainerNetworkCidr(): void;
    get containerNetworkCidrInput(): string | undefined;
    private _containerNetworkType?;
    get containerNetworkType(): string;
    set containerNetworkType(value: string);
    get containerNetworkTypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _eip?;
    get eip(): string;
    set eip(value: string);
    resetEip(): void;
    get eipInput(): string | undefined;
    private _eniSubnetCidr?;
    get eniSubnetCidr(): string;
    set eniSubnetCidr(value: string);
    resetEniSubnetCidr(): void;
    get eniSubnetCidrInput(): string | undefined;
    private _eniSubnetId?;
    get eniSubnetId(): string;
    set eniSubnetId(value: string);
    resetEniSubnetId(): void;
    get eniSubnetIdInput(): string | undefined;
    private _extendParam?;
    get extendParam(): {
        [key: string]: string;
    };
    set extendParam(value: {
        [key: string]: string;
    });
    resetExtendParam(): void;
    get extendParamInput(): {
        [key: string]: string;
    } | undefined;
    get external(): string;
    get externalOtc(): string;
    private _flavorId?;
    get flavorId(): string;
    set flavorId(value: string);
    get flavorIdInput(): string | undefined;
    private _highwaySubnetId?;
    get highwaySubnetId(): string;
    set highwaySubnetId(value: string);
    resetHighwaySubnetId(): void;
    get highwaySubnetIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoreAddons?;
    get ignoreAddons(): boolean | cdktf.IResolvable;
    set ignoreAddons(value: boolean | cdktf.IResolvable);
    resetIgnoreAddons(): void;
    get ignoreAddonsInput(): boolean | cdktf.IResolvable | undefined;
    get installedAddons(): string[];
    get internal(): string;
    get kubeProxyMode(): string;
    private _kubernetesSvcIpRange?;
    get kubernetesSvcIpRange(): string;
    set kubernetesSvcIpRange(value: string);
    resetKubernetesSvcIpRange(): void;
    get kubernetesSvcIpRangeInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _multiAz?;
    get multiAz(): boolean | cdktf.IResolvable;
    set multiAz(value: boolean | cdktf.IResolvable);
    resetMultiAz(): void;
    get multiAzInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _noAddons?;
    get noAddons(): boolean | cdktf.IResolvable;
    set noAddons(value: boolean | cdktf.IResolvable);
    resetNoAddons(): void;
    get noAddonsInput(): boolean | cdktf.IResolvable | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get securityGroupControl(): string;
    get securityGroupNode(): string;
    get status(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
    private _authenticatingProxy;
    get authenticatingProxy(): CceClusterV3AuthenticatingProxyOutputReference;
    putAuthenticatingProxy(value: CceClusterV3AuthenticatingProxy): void;
    resetAuthenticatingProxy(): void;
    get authenticatingProxyInput(): CceClusterV3AuthenticatingProxy | undefined;
    private _timeouts;
    get timeouts(): CceClusterV3TimeoutsOutputReference;
    putTimeouts(value: CceClusterV3Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CceClusterV3Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
