import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CceNodeV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#annotations CceNodeV3#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#availability_zone CceNodeV3#availability_zone}
    */
    readonly availabilityZone: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#bandwidth_charge_mode CceNodeV3#bandwidth_charge_mode}
    */
    readonly bandwidthChargeMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#bandwidth_size CceNodeV3#bandwidth_size}
    */
    readonly bandwidthSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#billing_mode CceNodeV3#billing_mode}
    */
    readonly billingMode?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#cluster_id CceNodeV3#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#docker_base_size CceNodeV3#docker_base_size}
    */
    readonly dockerBaseSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#docker_lvm_config_override CceNodeV3#docker_lvm_config_override}
    */
    readonly dockerLvmConfigOverride?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#ecs_performance_type CceNodeV3#ecs_performance_type}
    */
    readonly ecsPerformanceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#eip_count CceNodeV3#eip_count}
    */
    readonly eipCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#eip_ids CceNodeV3#eip_ids}
    */
    readonly eipIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#extend_param_charging_mode CceNodeV3#extend_param_charging_mode}
    */
    readonly extendParamChargingMode?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#flavor_id CceNodeV3#flavor_id}
    */
    readonly flavorId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#id CceNodeV3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#iptype CceNodeV3#iptype}
    */
    readonly iptype?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#k8s_tags CceNodeV3#k8s_tags}
    */
    readonly k8STags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#key_pair CceNodeV3#key_pair}
    */
    readonly keyPair: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#labels CceNodeV3#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#max_pods CceNodeV3#max_pods}
    */
    readonly maxPods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#name CceNodeV3#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#order_id CceNodeV3#order_id}
    */
    readonly orderId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#os CceNodeV3#os}
    */
    readonly os?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#postinstall CceNodeV3#postinstall}
    */
    readonly postinstall?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#preinstall CceNodeV3#preinstall}
    */
    readonly preinstall?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#private_ip CceNodeV3#private_ip}
    */
    readonly privateIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#product_id CceNodeV3#product_id}
    */
    readonly productId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#public_key CceNodeV3#public_key}
    */
    readonly publicKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#region CceNodeV3#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#sharetype CceNodeV3#sharetype}
    */
    readonly sharetype?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#subnet_id CceNodeV3#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#tags CceNodeV3#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * data_volumes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#data_volumes CceNodeV3#data_volumes}
    */
    readonly dataVolumes: CceNodeV3DataVolumes[] | cdktf.IResolvable;
    /**
    * root_volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#root_volume CceNodeV3#root_volume}
    */
    readonly rootVolume: CceNodeV3RootVolume;
    /**
    * taints block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#taints CceNodeV3#taints}
    */
    readonly taints?: CceNodeV3Taints[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#timeouts CceNodeV3#timeouts}
    */
    readonly timeouts?: CceNodeV3Timeouts;
}
export interface CceNodeV3DataVolumes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#extend_param CceNodeV3#extend_param}
    */
    readonly extendParam?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#kms_id CceNodeV3#kms_id}
    */
    readonly kmsId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#size CceNodeV3#size}
    */
    readonly size: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#volumetype CceNodeV3#volumetype}
    */
    readonly volumetype: string;
}
export declare function cceNodeV3DataVolumesToTerraform(struct?: CceNodeV3DataVolumes | cdktf.IResolvable): any;
export declare class CceNodeV3DataVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CceNodeV3DataVolumes | cdktf.IResolvable | undefined;
    set internalValue(value: CceNodeV3DataVolumes | cdktf.IResolvable | undefined);
    private _extendParam?;
    get extendParam(): string;
    set extendParam(value: string);
    resetExtendParam(): void;
    get extendParamInput(): string | undefined;
    private _kmsId?;
    get kmsId(): string;
    set kmsId(value: string);
    resetKmsId(): void;
    get kmsIdInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    get sizeInput(): number | undefined;
    private _volumetype?;
    get volumetype(): string;
    set volumetype(value: string);
    get volumetypeInput(): string | undefined;
}
export declare class CceNodeV3DataVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CceNodeV3DataVolumes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CceNodeV3DataVolumesOutputReference;
}
export interface CceNodeV3RootVolume {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#extend_param CceNodeV3#extend_param}
    */
    readonly extendParam?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#size CceNodeV3#size}
    */
    readonly size: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#volumetype CceNodeV3#volumetype}
    */
    readonly volumetype: string;
}
export declare function cceNodeV3RootVolumeToTerraform(struct?: CceNodeV3RootVolumeOutputReference | CceNodeV3RootVolume): any;
export declare class CceNodeV3RootVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CceNodeV3RootVolume | undefined;
    set internalValue(value: CceNodeV3RootVolume | undefined);
    private _extendParam?;
    get extendParam(): string;
    set extendParam(value: string);
    resetExtendParam(): void;
    get extendParamInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    get sizeInput(): number | undefined;
    private _volumetype?;
    get volumetype(): string;
    set volumetype(value: string);
    get volumetypeInput(): string | undefined;
}
export interface CceNodeV3Taints {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#effect CceNodeV3#effect}
    */
    readonly effect: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#key CceNodeV3#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#value CceNodeV3#value}
    */
    readonly value: string;
}
export declare function cceNodeV3TaintsToTerraform(struct?: CceNodeV3Taints | cdktf.IResolvable): any;
export declare class CceNodeV3TaintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CceNodeV3Taints | cdktf.IResolvable | undefined;
    set internalValue(value: CceNodeV3Taints | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class CceNodeV3TaintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CceNodeV3Taints[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CceNodeV3TaintsOutputReference;
}
export interface CceNodeV3Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#create CceNodeV3#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3#delete CceNodeV3#delete}
    */
    readonly delete?: string;
}
export declare function cceNodeV3TimeoutsToTerraform(struct?: CceNodeV3TimeoutsOutputReference | CceNodeV3Timeouts | cdktf.IResolvable): any;
export declare class CceNodeV3TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CceNodeV3Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CceNodeV3Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3 opentelekomcloud_cce_node_v3}
*/
export declare class CceNodeV3 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_cce_node_v3";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3 opentelekomcloud_cce_node_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CceNodeV3Config
    */
    constructor(scope: Construct, id: string, config: CceNodeV3Config);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    get availabilityZoneInput(): string | undefined;
    private _bandwidthChargeMode?;
    get bandwidthChargeMode(): string;
    set bandwidthChargeMode(value: string);
    resetBandwidthChargeMode(): void;
    get bandwidthChargeModeInput(): string | undefined;
    private _bandwidthSize?;
    get bandwidthSize(): number;
    set bandwidthSize(value: number);
    resetBandwidthSize(): void;
    get bandwidthSizeInput(): number | undefined;
    private _billingMode?;
    get billingMode(): number;
    set billingMode(value: number);
    resetBillingMode(): void;
    get billingModeInput(): number | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _dockerBaseSize?;
    get dockerBaseSize(): number;
    set dockerBaseSize(value: number);
    resetDockerBaseSize(): void;
    get dockerBaseSizeInput(): number | undefined;
    private _dockerLvmConfigOverride?;
    get dockerLvmConfigOverride(): string;
    set dockerLvmConfigOverride(value: string);
    resetDockerLvmConfigOverride(): void;
    get dockerLvmConfigOverrideInput(): string | undefined;
    private _ecsPerformanceType?;
    get ecsPerformanceType(): string;
    set ecsPerformanceType(value: string);
    resetEcsPerformanceType(): void;
    get ecsPerformanceTypeInput(): string | undefined;
    private _eipCount?;
    get eipCount(): number;
    set eipCount(value: number);
    resetEipCount(): void;
    get eipCountInput(): number | undefined;
    private _eipIds?;
    get eipIds(): string[];
    set eipIds(value: string[]);
    resetEipIds(): void;
    get eipIdsInput(): string[] | undefined;
    private _extendParamChargingMode?;
    get extendParamChargingMode(): number;
    set extendParamChargingMode(value: number);
    resetExtendParamChargingMode(): void;
    get extendParamChargingModeInput(): number | undefined;
    private _flavorId?;
    get flavorId(): string;
    set flavorId(value: string);
    get flavorIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _iptype?;
    get iptype(): string;
    set iptype(value: string);
    resetIptype(): void;
    get iptypeInput(): string | undefined;
    private _k8STags?;
    get k8STags(): {
        [key: string]: string;
    };
    set k8STags(value: {
        [key: string]: string;
    });
    resetK8STags(): void;
    get k8STagsInput(): {
        [key: string]: string;
    } | undefined;
    private _keyPair?;
    get keyPair(): string;
    set keyPair(value: string);
    get keyPairInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _maxPods?;
    get maxPods(): number;
    set maxPods(value: number);
    resetMaxPods(): void;
    get maxPodsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _orderId?;
    get orderId(): string;
    set orderId(value: string);
    resetOrderId(): void;
    get orderIdInput(): string | undefined;
    private _os?;
    get os(): string;
    set os(value: string);
    resetOs(): void;
    get osInput(): string | undefined;
    private _postinstall?;
    get postinstall(): string;
    set postinstall(value: string);
    resetPostinstall(): void;
    get postinstallInput(): string | undefined;
    private _preinstall?;
    get preinstall(): string;
    set preinstall(value: string);
    resetPreinstall(): void;
    get preinstallInput(): string | undefined;
    private _privateIp?;
    get privateIp(): string;
    set privateIp(value: string);
    resetPrivateIp(): void;
    get privateIpInput(): string | undefined;
    private _productId?;
    get productId(): string;
    set productId(value: string);
    resetProductId(): void;
    get productIdInput(): string | undefined;
    get publicIp(): string;
    private _publicKey?;
    get publicKey(): string;
    set publicKey(value: string);
    resetPublicKey(): void;
    get publicKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get serverId(): string;
    private _sharetype?;
    get sharetype(): string;
    set sharetype(value: string);
    resetSharetype(): void;
    get sharetypeInput(): string | undefined;
    get status(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _dataVolumes;
    get dataVolumes(): CceNodeV3DataVolumesList;
    putDataVolumes(value: CceNodeV3DataVolumes[] | cdktf.IResolvable): void;
    get dataVolumesInput(): cdktf.IResolvable | CceNodeV3DataVolumes[] | undefined;
    private _rootVolume;
    get rootVolume(): CceNodeV3RootVolumeOutputReference;
    putRootVolume(value: CceNodeV3RootVolume): void;
    get rootVolumeInput(): CceNodeV3RootVolume | undefined;
    private _taints;
    get taints(): CceNodeV3TaintsList;
    putTaints(value: CceNodeV3Taints[] | cdktf.IResolvable): void;
    resetTaints(): void;
    get taintsInput(): cdktf.IResolvable | CceNodeV3Taints[] | undefined;
    private _timeouts;
    get timeouts(): CceNodeV3TimeoutsOutputReference;
    putTimeouts(value: CceNodeV3Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CceNodeV3Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
