import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CesAlarmruleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#alarm_action_enabled CesAlarmrule#alarm_action_enabled}
    */
    readonly alarmActionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#alarm_description CesAlarmrule#alarm_description}
    */
    readonly alarmDescription?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#alarm_enabled CesAlarmrule#alarm_enabled}
    */
    readonly alarmEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#alarm_level CesAlarmrule#alarm_level}
    */
    readonly alarmLevel?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#alarm_name CesAlarmrule#alarm_name}
    */
    readonly alarmName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#id CesAlarmrule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * alarm_actions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#alarm_actions CesAlarmrule#alarm_actions}
    */
    readonly alarmActions?: CesAlarmruleAlarmActions[] | cdktf.IResolvable;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#condition CesAlarmrule#condition}
    */
    readonly condition: CesAlarmruleCondition;
    /**
    * insufficientdata_actions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#insufficientdata_actions CesAlarmrule#insufficientdata_actions}
    */
    readonly insufficientdataActions?: CesAlarmruleInsufficientdataActions[] | cdktf.IResolvable;
    /**
    * metric block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#metric CesAlarmrule#metric}
    */
    readonly metric: CesAlarmruleMetric;
    /**
    * ok_actions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#ok_actions CesAlarmrule#ok_actions}
    */
    readonly okActions?: CesAlarmruleOkActions[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#timeouts CesAlarmrule#timeouts}
    */
    readonly timeouts?: CesAlarmruleTimeouts;
}
export interface CesAlarmruleAlarmActions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#notification_list CesAlarmrule#notification_list}
    */
    readonly notificationList: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#type CesAlarmrule#type}
    */
    readonly type: string;
}
export declare function cesAlarmruleAlarmActionsToTerraform(struct?: CesAlarmruleAlarmActions | cdktf.IResolvable): any;
export declare class CesAlarmruleAlarmActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CesAlarmruleAlarmActions | cdktf.IResolvable | undefined;
    set internalValue(value: CesAlarmruleAlarmActions | cdktf.IResolvable | undefined);
    private _notificationList?;
    get notificationList(): string[];
    set notificationList(value: string[]);
    get notificationListInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class CesAlarmruleAlarmActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CesAlarmruleAlarmActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CesAlarmruleAlarmActionsOutputReference;
}
export interface CesAlarmruleCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#comparison_operator CesAlarmrule#comparison_operator}
    */
    readonly comparisonOperator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#count CesAlarmrule#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#filter CesAlarmrule#filter}
    */
    readonly filter: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#period CesAlarmrule#period}
    */
    readonly period: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#unit CesAlarmrule#unit}
    */
    readonly unit?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#value CesAlarmrule#value}
    */
    readonly value: number;
}
export declare function cesAlarmruleConditionToTerraform(struct?: CesAlarmruleConditionOutputReference | CesAlarmruleCondition): any;
export declare class CesAlarmruleConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CesAlarmruleCondition | undefined;
    set internalValue(value: CesAlarmruleCondition | undefined);
    private _comparisonOperator?;
    get comparisonOperator(): string;
    set comparisonOperator(value: string);
    get comparisonOperatorInput(): string | undefined;
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    private _period?;
    get period(): number;
    set period(value: number);
    get periodInput(): number | undefined;
    private _unit?;
    get unit(): string;
    set unit(value: string);
    resetUnit(): void;
    get unitInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export interface CesAlarmruleInsufficientdataActions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#notification_list CesAlarmrule#notification_list}
    */
    readonly notificationList: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#type CesAlarmrule#type}
    */
    readonly type: string;
}
export declare function cesAlarmruleInsufficientdataActionsToTerraform(struct?: CesAlarmruleInsufficientdataActions | cdktf.IResolvable): any;
export declare class CesAlarmruleInsufficientdataActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CesAlarmruleInsufficientdataActions | cdktf.IResolvable | undefined;
    set internalValue(value: CesAlarmruleInsufficientdataActions | cdktf.IResolvable | undefined);
    private _notificationList?;
    get notificationList(): string[];
    set notificationList(value: string[]);
    get notificationListInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class CesAlarmruleInsufficientdataActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CesAlarmruleInsufficientdataActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CesAlarmruleInsufficientdataActionsOutputReference;
}
export interface CesAlarmruleMetricDimensions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#name CesAlarmrule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#value CesAlarmrule#value}
    */
    readonly value: string;
}
export declare function cesAlarmruleMetricDimensionsToTerraform(struct?: CesAlarmruleMetricDimensions | cdktf.IResolvable): any;
export declare class CesAlarmruleMetricDimensionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CesAlarmruleMetricDimensions | cdktf.IResolvable | undefined;
    set internalValue(value: CesAlarmruleMetricDimensions | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class CesAlarmruleMetricDimensionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CesAlarmruleMetricDimensions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CesAlarmruleMetricDimensionsOutputReference;
}
export interface CesAlarmruleMetric {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#metric_name CesAlarmrule#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#namespace CesAlarmrule#namespace}
    */
    readonly namespace: string;
    /**
    * dimensions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#dimensions CesAlarmrule#dimensions}
    */
    readonly dimensions: CesAlarmruleMetricDimensions[] | cdktf.IResolvable;
}
export declare function cesAlarmruleMetricToTerraform(struct?: CesAlarmruleMetricOutputReference | CesAlarmruleMetric): any;
export declare class CesAlarmruleMetricOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CesAlarmruleMetric | undefined;
    set internalValue(value: CesAlarmruleMetric | undefined);
    private _metricName?;
    get metricName(): string;
    set metricName(value: string);
    get metricNameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _dimensions;
    get dimensions(): CesAlarmruleMetricDimensionsList;
    putDimensions(value: CesAlarmruleMetricDimensions[] | cdktf.IResolvable): void;
    get dimensionsInput(): cdktf.IResolvable | CesAlarmruleMetricDimensions[] | undefined;
}
export interface CesAlarmruleOkActions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#notification_list CesAlarmrule#notification_list}
    */
    readonly notificationList: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#type CesAlarmrule#type}
    */
    readonly type: string;
}
export declare function cesAlarmruleOkActionsToTerraform(struct?: CesAlarmruleOkActions | cdktf.IResolvable): any;
export declare class CesAlarmruleOkActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CesAlarmruleOkActions | cdktf.IResolvable | undefined;
    set internalValue(value: CesAlarmruleOkActions | cdktf.IResolvable | undefined);
    private _notificationList?;
    get notificationList(): string[];
    set notificationList(value: string[]);
    get notificationListInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class CesAlarmruleOkActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CesAlarmruleOkActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CesAlarmruleOkActionsOutputReference;
}
export interface CesAlarmruleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#create CesAlarmrule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#delete CesAlarmrule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#update CesAlarmrule#update}
    */
    readonly update?: string;
}
export declare function cesAlarmruleTimeoutsToTerraform(struct?: CesAlarmruleTimeoutsOutputReference | CesAlarmruleTimeouts | cdktf.IResolvable): any;
export declare class CesAlarmruleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CesAlarmruleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CesAlarmruleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule opentelekomcloud_ces_alarmrule}
*/
export declare class CesAlarmrule extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_ces_alarmrule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule opentelekomcloud_ces_alarmrule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CesAlarmruleConfig
    */
    constructor(scope: Construct, id: string, config: CesAlarmruleConfig);
    private _alarmActionEnabled?;
    get alarmActionEnabled(): boolean | cdktf.IResolvable;
    set alarmActionEnabled(value: boolean | cdktf.IResolvable);
    resetAlarmActionEnabled(): void;
    get alarmActionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _alarmDescription?;
    get alarmDescription(): string;
    set alarmDescription(value: string);
    resetAlarmDescription(): void;
    get alarmDescriptionInput(): string | undefined;
    private _alarmEnabled?;
    get alarmEnabled(): boolean | cdktf.IResolvable;
    set alarmEnabled(value: boolean | cdktf.IResolvable);
    resetAlarmEnabled(): void;
    get alarmEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _alarmLevel?;
    get alarmLevel(): number;
    set alarmLevel(value: number);
    resetAlarmLevel(): void;
    get alarmLevelInput(): number | undefined;
    private _alarmName?;
    get alarmName(): string;
    set alarmName(value: string);
    get alarmNameInput(): string | undefined;
    get alarmState(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get updateTime(): number;
    private _alarmActions;
    get alarmActions(): CesAlarmruleAlarmActionsList;
    putAlarmActions(value: CesAlarmruleAlarmActions[] | cdktf.IResolvable): void;
    resetAlarmActions(): void;
    get alarmActionsInput(): cdktf.IResolvable | CesAlarmruleAlarmActions[] | undefined;
    private _condition;
    get condition(): CesAlarmruleConditionOutputReference;
    putCondition(value: CesAlarmruleCondition): void;
    get conditionInput(): CesAlarmruleCondition | undefined;
    private _insufficientdataActions;
    get insufficientdataActions(): CesAlarmruleInsufficientdataActionsList;
    putInsufficientdataActions(value: CesAlarmruleInsufficientdataActions[] | cdktf.IResolvable): void;
    resetInsufficientdataActions(): void;
    get insufficientdataActionsInput(): cdktf.IResolvable | CesAlarmruleInsufficientdataActions[] | undefined;
    private _metric;
    get metric(): CesAlarmruleMetricOutputReference;
    putMetric(value: CesAlarmruleMetric): void;
    get metricInput(): CesAlarmruleMetric | undefined;
    private _okActions;
    get okActions(): CesAlarmruleOkActionsList;
    putOkActions(value: CesAlarmruleOkActions[] | cdktf.IResolvable): void;
    resetOkActions(): void;
    get okActionsInput(): cdktf.IResolvable | CesAlarmruleOkActions[] | undefined;
    private _timeouts;
    get timeouts(): CesAlarmruleTimeoutsOutputReference;
    putTimeouts(value: CesAlarmruleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CesAlarmruleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
