import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeFloatingipAssociateV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_associate_v2#fixed_ip ComputeFloatingipAssociateV2#fixed_ip}
    */
    readonly fixedIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_associate_v2#floating_ip ComputeFloatingipAssociateV2#floating_ip}
    */
    readonly floatingIp: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_associate_v2#id ComputeFloatingipAssociateV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_associate_v2#instance_id ComputeFloatingipAssociateV2#instance_id}
    */
    readonly instanceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_associate_v2#region ComputeFloatingipAssociateV2#region}
    */
    readonly region?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_associate_v2 opentelekomcloud_compute_floatingip_associate_v2}
*/
export declare class ComputeFloatingipAssociateV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_compute_floatingip_associate_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_associate_v2 opentelekomcloud_compute_floatingip_associate_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeFloatingipAssociateV2Config
    */
    constructor(scope: Construct, id: string, config: ComputeFloatingipAssociateV2Config);
    private _fixedIp?;
    get fixedIp(): string;
    set fixedIp(value: string);
    resetFixedIp(): void;
    get fixedIpInput(): string | undefined;
    private _floatingIp?;
    get floatingIp(): string;
    set floatingIp(value: string);
    get floatingIpInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    get instanceIdInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
