import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeSecgroupV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2#description ComputeSecgroupV2#description}
    */
    readonly description: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2#id ComputeSecgroupV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2#name ComputeSecgroupV2#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2#region ComputeSecgroupV2#region}
    */
    readonly region?: string;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2#rule ComputeSecgroupV2#rule}
    */
    readonly rule?: ComputeSecgroupV2Rule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2#timeouts ComputeSecgroupV2#timeouts}
    */
    readonly timeouts?: ComputeSecgroupV2Timeouts;
}
export interface ComputeSecgroupV2Rule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2#cidr ComputeSecgroupV2#cidr}
    */
    readonly cidr?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2#from_group_id ComputeSecgroupV2#from_group_id}
    */
    readonly fromGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2#from_port ComputeSecgroupV2#from_port}
    */
    readonly fromPort: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2#ip_protocol ComputeSecgroupV2#ip_protocol}
    */
    readonly ipProtocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2#self ComputeSecgroupV2#self}
    */
    readonly selfAttribute?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2#to_port ComputeSecgroupV2#to_port}
    */
    readonly toPort: number;
}
export declare function computeSecgroupV2RuleToTerraform(struct?: ComputeSecgroupV2Rule | cdktf.IResolvable): any;
export declare class ComputeSecgroupV2RuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeSecgroupV2Rule | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeSecgroupV2Rule | cdktf.IResolvable | undefined);
    private _cidr?;
    get cidr(): string;
    set cidr(value: string);
    resetCidr(): void;
    get cidrInput(): string | undefined;
    private _fromGroupId?;
    get fromGroupId(): string;
    set fromGroupId(value: string);
    resetFromGroupId(): void;
    get fromGroupIdInput(): string | undefined;
    private _fromPort?;
    get fromPort(): number;
    set fromPort(value: number);
    get fromPortInput(): number | undefined;
    get id(): string;
    private _ipProtocol?;
    get ipProtocol(): string;
    set ipProtocol(value: string);
    get ipProtocolInput(): string | undefined;
    private _self?;
    get selfAttribute(): boolean | cdktf.IResolvable;
    set selfAttribute(value: boolean | cdktf.IResolvable);
    resetSelfAttribute(): void;
    get selfAttributeInput(): boolean | cdktf.IResolvable | undefined;
    private _toPort?;
    get toPort(): number;
    set toPort(value: number);
    get toPortInput(): number | undefined;
}
export declare class ComputeSecgroupV2RuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeSecgroupV2Rule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeSecgroupV2RuleOutputReference;
}
export interface ComputeSecgroupV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2#delete ComputeSecgroupV2#delete}
    */
    readonly delete?: string;
}
export declare function computeSecgroupV2TimeoutsToTerraform(struct?: ComputeSecgroupV2TimeoutsOutputReference | ComputeSecgroupV2Timeouts | cdktf.IResolvable): any;
export declare class ComputeSecgroupV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSecgroupV2Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeSecgroupV2Timeouts | cdktf.IResolvable | undefined);
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2 opentelekomcloud_compute_secgroup_v2}
*/
export declare class ComputeSecgroupV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_compute_secgroup_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2 opentelekomcloud_compute_secgroup_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeSecgroupV2Config
    */
    constructor(scope: Construct, id: string, config: ComputeSecgroupV2Config);
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _rule;
    get rule(): ComputeSecgroupV2RuleList;
    putRule(value: ComputeSecgroupV2Rule[] | cdktf.IResolvable): void;
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | ComputeSecgroupV2Rule[] | undefined;
    private _timeouts;
    get timeouts(): ComputeSecgroupV2TimeoutsOutputReference;
    putTimeouts(value: ComputeSecgroupV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeSecgroupV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
