import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CssSnapshotConfigurationV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1#automatic CssSnapshotConfigurationV1#automatic}
    */
    readonly automatic?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1#cluster_id CssSnapshotConfigurationV1#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1#id CssSnapshotConfigurationV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1#configuration CssSnapshotConfigurationV1#configuration}
    */
    readonly configuration?: CssSnapshotConfigurationV1Configuration;
    /**
    * creation_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1#creation_policy CssSnapshotConfigurationV1#creation_policy}
    */
    readonly creationPolicy?: CssSnapshotConfigurationV1CreationPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1#timeouts CssSnapshotConfigurationV1#timeouts}
    */
    readonly timeouts?: CssSnapshotConfigurationV1Timeouts;
}
export interface CssSnapshotConfigurationV1Configuration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1#agency CssSnapshotConfigurationV1#agency}
    */
    readonly agency: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1#bucket CssSnapshotConfigurationV1#bucket}
    */
    readonly bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1#kms_id CssSnapshotConfigurationV1#kms_id}
    */
    readonly kmsId?: string;
}
export declare function cssSnapshotConfigurationV1ConfigurationToTerraform(struct?: CssSnapshotConfigurationV1ConfigurationOutputReference | CssSnapshotConfigurationV1Configuration): any;
export declare class CssSnapshotConfigurationV1ConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CssSnapshotConfigurationV1Configuration | undefined;
    set internalValue(value: CssSnapshotConfigurationV1Configuration | undefined);
    private _agency?;
    get agency(): string;
    set agency(value: string);
    get agencyInput(): string | undefined;
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _kmsId?;
    get kmsId(): string;
    set kmsId(value: string);
    resetKmsId(): void;
    get kmsIdInput(): string | undefined;
}
export interface CssSnapshotConfigurationV1CreationPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1#delete_auto CssSnapshotConfigurationV1#delete_auto}
    */
    readonly deleteAuto?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1#enable CssSnapshotConfigurationV1#enable}
    */
    readonly enable: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1#keepday CssSnapshotConfigurationV1#keepday}
    */
    readonly keepday: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1#period CssSnapshotConfigurationV1#period}
    */
    readonly period: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1#prefix CssSnapshotConfigurationV1#prefix}
    */
    readonly prefix: string;
}
export declare function cssSnapshotConfigurationV1CreationPolicyToTerraform(struct?: CssSnapshotConfigurationV1CreationPolicyOutputReference | CssSnapshotConfigurationV1CreationPolicy): any;
export declare class CssSnapshotConfigurationV1CreationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CssSnapshotConfigurationV1CreationPolicy | undefined;
    set internalValue(value: CssSnapshotConfigurationV1CreationPolicy | undefined);
    private _deleteAuto?;
    get deleteAuto(): boolean | cdktf.IResolvable;
    set deleteAuto(value: boolean | cdktf.IResolvable);
    resetDeleteAuto(): void;
    get deleteAutoInput(): boolean | cdktf.IResolvable | undefined;
    private _enable?;
    get enable(): boolean | cdktf.IResolvable;
    set enable(value: boolean | cdktf.IResolvable);
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    private _keepday?;
    get keepday(): number;
    set keepday(value: number);
    get keepdayInput(): number | undefined;
    private _period?;
    get period(): string;
    set period(value: string);
    get periodInput(): string | undefined;
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    get prefixInput(): string | undefined;
}
export interface CssSnapshotConfigurationV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1#create CssSnapshotConfigurationV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1#update CssSnapshotConfigurationV1#update}
    */
    readonly update?: string;
}
export declare function cssSnapshotConfigurationV1TimeoutsToTerraform(struct?: CssSnapshotConfigurationV1TimeoutsOutputReference | CssSnapshotConfigurationV1Timeouts | cdktf.IResolvable): any;
export declare class CssSnapshotConfigurationV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CssSnapshotConfigurationV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CssSnapshotConfigurationV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1 opentelekomcloud_css_snapshot_configuration_v1}
*/
export declare class CssSnapshotConfigurationV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_css_snapshot_configuration_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1 opentelekomcloud_css_snapshot_configuration_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CssSnapshotConfigurationV1Config
    */
    constructor(scope: Construct, id: string, config: CssSnapshotConfigurationV1Config);
    private _automatic?;
    get automatic(): boolean | cdktf.IResolvable;
    set automatic(value: boolean | cdktf.IResolvable);
    resetAutomatic(): void;
    get automaticInput(): boolean | cdktf.IResolvable | undefined;
    get basePath(): string;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _configuration;
    get configuration(): CssSnapshotConfigurationV1ConfigurationOutputReference;
    putConfiguration(value: CssSnapshotConfigurationV1Configuration): void;
    resetConfiguration(): void;
    get configurationInput(): CssSnapshotConfigurationV1Configuration | undefined;
    private _creationPolicy;
    get creationPolicy(): CssSnapshotConfigurationV1CreationPolicyOutputReference;
    putCreationPolicy(value: CssSnapshotConfigurationV1CreationPolicy): void;
    resetCreationPolicy(): void;
    get creationPolicyInput(): CssSnapshotConfigurationV1CreationPolicy | undefined;
    private _timeouts;
    get timeouts(): CssSnapshotConfigurationV1TimeoutsOutputReference;
    putTimeouts(value: CssSnapshotConfigurationV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CssSnapshotConfigurationV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
