import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CtsTrackerV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1#bucket_name CtsTrackerV1#bucket_name}
    */
    readonly bucketName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1#file_prefix_name CtsTrackerV1#file_prefix_name}
    */
    readonly filePrefixName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1#id CtsTrackerV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1#is_send_all_key_operation CtsTrackerV1#is_send_all_key_operation}
    */
    readonly isSendAllKeyOperation?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1#is_support_smn CtsTrackerV1#is_support_smn}
    */
    readonly isSupportSmn: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1#need_notify_user_list CtsTrackerV1#need_notify_user_list}
    */
    readonly needNotifyUserList?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1#operations CtsTrackerV1#operations}
    */
    readonly operations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1#project_name CtsTrackerV1#project_name}
    */
    readonly projectName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1#region CtsTrackerV1#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1#status CtsTrackerV1#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1#topic_id CtsTrackerV1#topic_id}
    */
    readonly topicId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1#timeouts CtsTrackerV1#timeouts}
    */
    readonly timeouts?: CtsTrackerV1Timeouts;
}
export interface CtsTrackerV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1#create CtsTrackerV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1#delete CtsTrackerV1#delete}
    */
    readonly delete?: string;
}
export declare function ctsTrackerV1TimeoutsToTerraform(struct?: CtsTrackerV1TimeoutsOutputReference | CtsTrackerV1Timeouts | cdktf.IResolvable): any;
export declare class CtsTrackerV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CtsTrackerV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CtsTrackerV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1 opentelekomcloud_cts_tracker_v1}
*/
export declare class CtsTrackerV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "opentelekomcloud_cts_tracker_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1 opentelekomcloud_cts_tracker_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CtsTrackerV1Config
    */
    constructor(scope: Construct, id: string, config: CtsTrackerV1Config);
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _filePrefixName?;
    get filePrefixName(): string;
    set filePrefixName(value: string);
    resetFilePrefixName(): void;
    get filePrefixNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isSendAllKeyOperation?;
    get isSendAllKeyOperation(): boolean | cdktf.IResolvable;
    set isSendAllKeyOperation(value: boolean | cdktf.IResolvable);
    resetIsSendAllKeyOperation(): void;
    get isSendAllKeyOperationInput(): boolean | cdktf.IResolvable | undefined;
    private _isSupportSmn?;
    get isSupportSmn(): boolean | cdktf.IResolvable;
    set isSupportSmn(value: boolean | cdktf.IResolvable);
    get isSupportSmnInput(): boolean | cdktf.IResolvable | undefined;
    private _needNotifyUserList?;
    get needNotifyUserList(): string[];
    set needNotifyUserList(value: string[]);
    resetNeedNotifyUserList(): void;
    get needNotifyUserListInput(): string[] | undefined;
    private _operations?;
    get operations(): string[];
    set operations(value: string[]);
    resetOperations(): void;
    get operationsInput(): string[] | undefined;
    private _projectName?;
    get projectName(): string;
    set projectName(value: string);
    resetProjectName(): void;
    get projectNameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _topicId?;
    get topicId(): string;
    set topicId(value: string);
    resetTopicId(): void;
    get topicIdInput(): string | undefined;
    get trackerName(): string;
    private _timeouts;
    get timeouts(): CtsTrackerV1TimeoutsOutputReference;
    putTimeouts(value: CtsTrackerV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CtsTrackerV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
