import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudCceClusterV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3#cluster_type DataOpentelekomcloudCceClusterV3#cluster_type}
    */
    readonly clusterType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3#id DataOpentelekomcloudCceClusterV3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3#name DataOpentelekomcloudCceClusterV3#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3#region DataOpentelekomcloudCceClusterV3#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3#status DataOpentelekomcloudCceClusterV3#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3#vpc_id DataOpentelekomcloudCceClusterV3#vpc_id}
    */
    readonly vpcId?: string;
}
export interface DataOpentelekomcloudCceClusterV3CertificateClusters {
}
export declare function dataOpentelekomcloudCceClusterV3CertificateClustersToTerraform(struct?: DataOpentelekomcloudCceClusterV3CertificateClusters): any;
export declare class DataOpentelekomcloudCceClusterV3CertificateClustersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudCceClusterV3CertificateClusters | undefined;
    set internalValue(value: DataOpentelekomcloudCceClusterV3CertificateClusters | undefined);
    get certificateAuthorityData(): string;
    get name(): string;
    get server(): string;
}
export declare class DataOpentelekomcloudCceClusterV3CertificateClustersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudCceClusterV3CertificateClustersOutputReference;
}
export interface DataOpentelekomcloudCceClusterV3CertificateUsers {
}
export declare function dataOpentelekomcloudCceClusterV3CertificateUsersToTerraform(struct?: DataOpentelekomcloudCceClusterV3CertificateUsers): any;
export declare class DataOpentelekomcloudCceClusterV3CertificateUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudCceClusterV3CertificateUsers | undefined;
    set internalValue(value: DataOpentelekomcloudCceClusterV3CertificateUsers | undefined);
    get clientCertificateData(): string;
    get clientKeyData(): string;
    get name(): string;
}
export declare class DataOpentelekomcloudCceClusterV3CertificateUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudCceClusterV3CertificateUsersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3 opentelekomcloud_cce_cluster_v3}
*/
export declare class DataOpentelekomcloudCceClusterV3 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "opentelekomcloud_cce_cluster_v3";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3 opentelekomcloud_cce_cluster_v3} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudCceClusterV3Config = {}
    */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudCceClusterV3Config);
    get authenticationMode(): string;
    get billingMode(): number;
    private _certificateClusters;
    get certificateClusters(): DataOpentelekomcloudCceClusterV3CertificateClustersList;
    private _certificateUsers;
    get certificateUsers(): DataOpentelekomcloudCceClusterV3CertificateUsersList;
    private _clusterType?;
    get clusterType(): string;
    set clusterType(value: string);
    resetClusterType(): void;
    get clusterTypeInput(): string | undefined;
    get clusterVersion(): string;
    get containerNetworkCidr(): string;
    get containerNetworkType(): string;
    get description(): string;
    get eniSubnetCidr(): string;
    get eniSubnetId(): string;
    get external(): string;
    get externalOtc(): string;
    get flavorId(): string;
    get highwaySubnetId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get internal(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    get subnetId(): string;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    resetVpcId(): void;
    get vpcIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
