import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudCsbsBackupPolicyV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_policy_v1#id DataOpentelekomcloudCsbsBackupPolicyV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_policy_v1#name DataOpentelekomcloudCsbsBackupPolicyV1#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_policy_v1#region DataOpentelekomcloudCsbsBackupPolicyV1#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_policy_v1#status DataOpentelekomcloudCsbsBackupPolicyV1#status}
    */
    readonly status?: string;
}
export interface DataOpentelekomcloudCsbsBackupPolicyV1Resource {
}
export declare function dataOpentelekomcloudCsbsBackupPolicyV1ResourceToTerraform(struct?: DataOpentelekomcloudCsbsBackupPolicyV1Resource): any;
export declare class DataOpentelekomcloudCsbsBackupPolicyV1ResourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudCsbsBackupPolicyV1Resource | undefined;
    set internalValue(value: DataOpentelekomcloudCsbsBackupPolicyV1Resource | undefined);
    get id(): string;
    get name(): string;
    get type(): string;
}
export declare class DataOpentelekomcloudCsbsBackupPolicyV1ResourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudCsbsBackupPolicyV1ResourceOutputReference;
}
export interface DataOpentelekomcloudCsbsBackupPolicyV1ScheduledOperation {
}
export declare function dataOpentelekomcloudCsbsBackupPolicyV1ScheduledOperationToTerraform(struct?: DataOpentelekomcloudCsbsBackupPolicyV1ScheduledOperation): any;
export declare class DataOpentelekomcloudCsbsBackupPolicyV1ScheduledOperationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudCsbsBackupPolicyV1ScheduledOperation | undefined;
    set internalValue(value: DataOpentelekomcloudCsbsBackupPolicyV1ScheduledOperation | undefined);
    get description(): string;
    get enabled(): cdktf.IResolvable;
    get id(): string;
    get maxBackups(): number;
    get name(): string;
    get operationType(): string;
    get permanent(): cdktf.IResolvable;
    get retentionDurationDays(): number;
    get triggerId(): string;
    get triggerName(): string;
    get triggerPattern(): string;
    get triggerType(): string;
}
export declare class DataOpentelekomcloudCsbsBackupPolicyV1ScheduledOperationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudCsbsBackupPolicyV1ScheduledOperationOutputReference;
}
export interface DataOpentelekomcloudCsbsBackupPolicyV1Tags {
}
export declare function dataOpentelekomcloudCsbsBackupPolicyV1TagsToTerraform(struct?: DataOpentelekomcloudCsbsBackupPolicyV1Tags): any;
export declare class DataOpentelekomcloudCsbsBackupPolicyV1TagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudCsbsBackupPolicyV1Tags | undefined;
    set internalValue(value: DataOpentelekomcloudCsbsBackupPolicyV1Tags | undefined);
    get key(): string;
    get value(): string;
}
export declare class DataOpentelekomcloudCsbsBackupPolicyV1TagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudCsbsBackupPolicyV1TagsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_policy_v1 opentelekomcloud_csbs_backup_policy_v1}
*/
export declare class DataOpentelekomcloudCsbsBackupPolicyV1 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "opentelekomcloud_csbs_backup_policy_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_policy_v1 opentelekomcloud_csbs_backup_policy_v1} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudCsbsBackupPolicyV1Config = {}
    */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudCsbsBackupPolicyV1Config);
    private _common;
    get common(): cdktf.StringMap;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get providerId(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _resource;
    get resource(): DataOpentelekomcloudCsbsBackupPolicyV1ResourceList;
    private _scheduledOperation;
    get scheduledOperation(): DataOpentelekomcloudCsbsBackupPolicyV1ScheduledOperationList;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _tags;
    get tags(): DataOpentelekomcloudCsbsBackupPolicyV1TagsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
