import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudCssFlavorV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1#id DataOpentelekomcloudCssFlavorV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1#min_cpu DataOpentelekomcloudCssFlavorV1#min_cpu}
    */
    readonly minCpu?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1#min_ram DataOpentelekomcloudCssFlavorV1#min_ram}
    */
    readonly minRam?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1#name DataOpentelekomcloudCssFlavorV1#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1#type DataOpentelekomcloudCssFlavorV1#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1#version DataOpentelekomcloudCssFlavorV1#version}
    */
    readonly version?: string;
    /**
    * disk_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1#disk_range DataOpentelekomcloudCssFlavorV1#disk_range}
    */
    readonly diskRange?: DataOpentelekomcloudCssFlavorV1DiskRange;
}
export interface DataOpentelekomcloudCssFlavorV1DiskRange {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1#min_from DataOpentelekomcloudCssFlavorV1#min_from}
    */
    readonly minFrom?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1#min_to DataOpentelekomcloudCssFlavorV1#min_to}
    */
    readonly minTo?: number;
}
export declare function dataOpentelekomcloudCssFlavorV1DiskRangeToTerraform(struct?: DataOpentelekomcloudCssFlavorV1DiskRangeOutputReference | DataOpentelekomcloudCssFlavorV1DiskRange): any;
export declare class DataOpentelekomcloudCssFlavorV1DiskRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataOpentelekomcloudCssFlavorV1DiskRange | undefined;
    set internalValue(value: DataOpentelekomcloudCssFlavorV1DiskRange | undefined);
    get from(): number;
    private _minFrom?;
    get minFrom(): number;
    set minFrom(value: number);
    resetMinFrom(): void;
    get minFromInput(): number | undefined;
    private _minTo?;
    get minTo(): number;
    set minTo(value: number);
    resetMinTo(): void;
    get minToInput(): number | undefined;
    get to(): number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1 opentelekomcloud_css_flavor_v1}
*/
export declare class DataOpentelekomcloudCssFlavorV1 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "opentelekomcloud_css_flavor_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1 opentelekomcloud_css_flavor_v1} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudCssFlavorV1Config = {}
    */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudCssFlavorV1Config);
    get cpu(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _minCpu?;
    get minCpu(): number;
    set minCpu(value: number);
    resetMinCpu(): void;
    get minCpuInput(): number | undefined;
    private _minRam?;
    get minRam(): number;
    set minRam(value: number);
    resetMinRam(): void;
    get minRamInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get ram(): number;
    get region(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _diskRange;
    get diskRange(): DataOpentelekomcloudCssFlavorV1DiskRangeOutputReference;
    putDiskRange(value: DataOpentelekomcloudCssFlavorV1DiskRange): void;
    resetDiskRange(): void;
    get diskRangeInput(): DataOpentelekomcloudCssFlavorV1DiskRange | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
