import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudDdsInstanceV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3#datastore_type DataOpentelekomcloudDdsInstanceV3#datastore_type}
    */
    readonly datastoreType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3#id DataOpentelekomcloudDdsInstanceV3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3#instance_id DataOpentelekomcloudDdsInstanceV3#instance_id}
    */
    readonly instanceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3#name DataOpentelekomcloudDdsInstanceV3#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3#subnet_id DataOpentelekomcloudDdsInstanceV3#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3#vpc_id DataOpentelekomcloudDdsInstanceV3#vpc_id}
    */
    readonly vpcId?: string;
}
export interface DataOpentelekomcloudDdsInstanceV3BackupStrategy {
}
export declare function dataOpentelekomcloudDdsInstanceV3BackupStrategyToTerraform(struct?: DataOpentelekomcloudDdsInstanceV3BackupStrategy): any;
export declare class DataOpentelekomcloudDdsInstanceV3BackupStrategyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudDdsInstanceV3BackupStrategy | undefined;
    set internalValue(value: DataOpentelekomcloudDdsInstanceV3BackupStrategy | undefined);
    get keepDays(): number;
    get startTime(): string;
}
export declare class DataOpentelekomcloudDdsInstanceV3BackupStrategyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudDdsInstanceV3BackupStrategyOutputReference;
}
export interface DataOpentelekomcloudDdsInstanceV3Datastore {
}
export declare function dataOpentelekomcloudDdsInstanceV3DatastoreToTerraform(struct?: DataOpentelekomcloudDdsInstanceV3Datastore): any;
export declare class DataOpentelekomcloudDdsInstanceV3DatastoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudDdsInstanceV3Datastore | undefined;
    set internalValue(value: DataOpentelekomcloudDdsInstanceV3Datastore | undefined);
    get storageEngine(): string;
    get type(): string;
    get version(): string;
}
export declare class DataOpentelekomcloudDdsInstanceV3DatastoreList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudDdsInstanceV3DatastoreOutputReference;
}
export interface DataOpentelekomcloudDdsInstanceV3Nodes {
}
export declare function dataOpentelekomcloudDdsInstanceV3NodesToTerraform(struct?: DataOpentelekomcloudDdsInstanceV3Nodes): any;
export declare class DataOpentelekomcloudDdsInstanceV3NodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudDdsInstanceV3Nodes | undefined;
    set internalValue(value: DataOpentelekomcloudDdsInstanceV3Nodes | undefined);
    get id(): string;
    get name(): string;
    get privateIp(): string;
    get publicIp(): string;
    get role(): string;
    get status(): string;
    get type(): string;
}
export declare class DataOpentelekomcloudDdsInstanceV3NodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudDdsInstanceV3NodesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3 opentelekomcloud_dds_instance_v3}
*/
export declare class DataOpentelekomcloudDdsInstanceV3 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "opentelekomcloud_dds_instance_v3";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3 opentelekomcloud_dds_instance_v3} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudDdsInstanceV3Config = {}
    */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudDdsInstanceV3Config);
    private _backupStrategy;
    get backupStrategy(): DataOpentelekomcloudDdsInstanceV3BackupStrategyList;
    private _datastore;
    get datastore(): DataOpentelekomcloudDdsInstanceV3DatastoreList;
    private _datastoreType?;
    get datastoreType(): string;
    set datastoreType(value: string);
    resetDatastoreType(): void;
    get datastoreTypeInput(): string | undefined;
    get dbUsername(): string;
    get diskEncryptionId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    resetInstanceId(): void;
    get instanceIdInput(): string | undefined;
    get mode(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nodes;
    get nodes(): DataOpentelekomcloudDdsInstanceV3NodesList;
    get payMode(): string;
    get port(): number;
    get region(): string;
    get securityGroupId(): string;
    get ssl(): cdktf.IResolvable;
    get status(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    resetVpcId(): void;
    get vpcIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
