import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudDehServerV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/deh_server_v1#dedicated_host_id DataOpentelekomcloudDehServerV1#dedicated_host_id}
    */
    readonly dedicatedHostId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/deh_server_v1#id DataOpentelekomcloudDehServerV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/deh_server_v1#region DataOpentelekomcloudDehServerV1#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/deh_server_v1#server_id DataOpentelekomcloudDehServerV1#server_id}
    */
    readonly serverId?: string;
    /**
    * addresses block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/deh_server_v1#addresses DataOpentelekomcloudDehServerV1#addresses}
    */
    readonly addresses?: DataOpentelekomcloudDehServerV1Addresses[] | cdktf.IResolvable;
}
export interface DataOpentelekomcloudDehServerV1Addresses {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/deh_server_v1#fixed_ip_v4 DataOpentelekomcloudDehServerV1#fixed_ip_v4}
    */
    readonly fixedIpV4?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/deh_server_v1#name DataOpentelekomcloudDehServerV1#name}
    */
    readonly name?: string;
}
export declare function dataOpentelekomcloudDehServerV1AddressesToTerraform(struct?: DataOpentelekomcloudDehServerV1Addresses | cdktf.IResolvable): any;
export declare class DataOpentelekomcloudDehServerV1AddressesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudDehServerV1Addresses | cdktf.IResolvable | undefined;
    set internalValue(value: DataOpentelekomcloudDehServerV1Addresses | cdktf.IResolvable | undefined);
    private _fixedIpV4?;
    get fixedIpV4(): string;
    set fixedIpV4(value: string);
    resetFixedIpV4(): void;
    get fixedIpV4Input(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class DataOpentelekomcloudDehServerV1AddressesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataOpentelekomcloudDehServerV1Addresses[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudDehServerV1AddressesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/deh_server_v1 opentelekomcloud_deh_server_v1}
*/
export declare class DataOpentelekomcloudDehServerV1 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "opentelekomcloud_deh_server_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/deh_server_v1 opentelekomcloud_deh_server_v1} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudDehServerV1Config = {}
    */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudDehServerV1Config);
    private _dedicatedHostId?;
    get dedicatedHostId(): string;
    set dedicatedHostId(value: string);
    resetDedicatedHostId(): void;
    get dedicatedHostIdInput(): string | undefined;
    private _flavor;
    get flavor(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): cdktf.StringMap;
    get name(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _serverId?;
    get serverId(): string;
    set serverId(value: string);
    resetServerId(): void;
    get serverIdInput(): string | undefined;
    get status(): string;
    get tenantId(): string;
    get userId(): string;
    private _addresses;
    get addresses(): DataOpentelekomcloudDehServerV1AddressesList;
    putAddresses(value: DataOpentelekomcloudDehServerV1Addresses[] | cdktf.IResolvable): void;
    resetAddresses(): void;
    get addressesInput(): cdktf.IResolvable | DataOpentelekomcloudDehServerV1Addresses[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
