import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudDnsNameserversV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dns_nameservers_v2#id DataOpentelekomcloudDnsNameserversV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dns_nameservers_v2#zone_id DataOpentelekomcloudDnsNameserversV2#zone_id}
    */
    readonly zoneId?: string;
    /**
    * nameservers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dns_nameservers_v2#nameservers DataOpentelekomcloudDnsNameserversV2#nameservers}
    */
    readonly nameservers?: DataOpentelekomcloudDnsNameserversV2Nameservers[] | cdktf.IResolvable;
}
export interface DataOpentelekomcloudDnsNameserversV2Nameservers {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dns_nameservers_v2#hostname DataOpentelekomcloudDnsNameserversV2#hostname}
    */
    readonly hostname?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dns_nameservers_v2#priority DataOpentelekomcloudDnsNameserversV2#priority}
    */
    readonly priority?: number;
}
export declare function dataOpentelekomcloudDnsNameserversV2NameserversToTerraform(struct?: DataOpentelekomcloudDnsNameserversV2Nameservers | cdktf.IResolvable): any;
export declare class DataOpentelekomcloudDnsNameserversV2NameserversOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudDnsNameserversV2Nameservers | cdktf.IResolvable | undefined;
    set internalValue(value: DataOpentelekomcloudDnsNameserversV2Nameservers | cdktf.IResolvable | undefined);
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
}
export declare class DataOpentelekomcloudDnsNameserversV2NameserversList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataOpentelekomcloudDnsNameserversV2Nameservers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudDnsNameserversV2NameserversOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dns_nameservers_v2 opentelekomcloud_dns_nameservers_v2}
*/
export declare class DataOpentelekomcloudDnsNameserversV2 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "opentelekomcloud_dns_nameservers_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dns_nameservers_v2 opentelekomcloud_dns_nameservers_v2} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudDnsNameserversV2Config = {}
    */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudDnsNameserversV2Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
    private _nameservers;
    get nameservers(): DataOpentelekomcloudDnsNameserversV2NameserversList;
    putNameservers(value: DataOpentelekomcloudDnsNameserversV2Nameservers[] | cdktf.IResolvable): void;
    resetNameservers(): void;
    get nameserversInput(): cdktf.IResolvable | DataOpentelekomcloudDnsNameserversV2Nameservers[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
