import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudIdentityAuthScopeV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_auth_scope_v3#id DataOpentelekomcloudIdentityAuthScopeV3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_auth_scope_v3#name DataOpentelekomcloudIdentityAuthScopeV3#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_auth_scope_v3#region DataOpentelekomcloudIdentityAuthScopeV3#region}
    */
    readonly region?: string;
}
export interface DataOpentelekomcloudIdentityAuthScopeV3Roles {
}
export declare function dataOpentelekomcloudIdentityAuthScopeV3RolesToTerraform(struct?: DataOpentelekomcloudIdentityAuthScopeV3Roles): any;
export declare class DataOpentelekomcloudIdentityAuthScopeV3RolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudIdentityAuthScopeV3Roles | undefined;
    set internalValue(value: DataOpentelekomcloudIdentityAuthScopeV3Roles | undefined);
    get roleId(): string;
    get roleName(): string;
}
export declare class DataOpentelekomcloudIdentityAuthScopeV3RolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudIdentityAuthScopeV3RolesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_auth_scope_v3 opentelekomcloud_identity_auth_scope_v3}
*/
export declare class DataOpentelekomcloudIdentityAuthScopeV3 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "opentelekomcloud_identity_auth_scope_v3";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_auth_scope_v3 opentelekomcloud_identity_auth_scope_v3} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudIdentityAuthScopeV3Config
    */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudIdentityAuthScopeV3Config);
    get domainId(): string;
    get domainName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get projectDomainId(): string;
    get projectDomainName(): string;
    get projectId(): string;
    get projectName(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _roles;
    get roles(): DataOpentelekomcloudIdentityAuthScopeV3RolesList;
    get userDomainId(): string;
    get userDomainName(): string;
    get userId(): string;
    get userName(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
