import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudLbListenerV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_listener_v3#client_ca_tls_container_ref DataOpentelekomcloudLbListenerV3#client_ca_tls_container_ref}
    */
    readonly clientCaTlsContainerRef?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_listener_v3#client_timeout DataOpentelekomcloudLbListenerV3#client_timeout}
    */
    readonly clientTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_listener_v3#default_pool_id DataOpentelekomcloudLbListenerV3#default_pool_id}
    */
    readonly defaultPoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_listener_v3#default_tls_container_ref DataOpentelekomcloudLbListenerV3#default_tls_container_ref}
    */
    readonly defaultTlsContainerRef?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_listener_v3#description DataOpentelekomcloudLbListenerV3#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_listener_v3#id DataOpentelekomcloudLbListenerV3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_listener_v3#keep_alive_timeout DataOpentelekomcloudLbListenerV3#keep_alive_timeout}
    */
    readonly keepAliveTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_listener_v3#loadbalancer_id DataOpentelekomcloudLbListenerV3#loadbalancer_id}
    */
    readonly loadbalancerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_listener_v3#member_address DataOpentelekomcloudLbListenerV3#member_address}
    */
    readonly memberAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_listener_v3#member_device_id DataOpentelekomcloudLbListenerV3#member_device_id}
    */
    readonly memberDeviceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_listener_v3#member_timeout DataOpentelekomcloudLbListenerV3#member_timeout}
    */
    readonly memberTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_listener_v3#name DataOpentelekomcloudLbListenerV3#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_listener_v3#protocol DataOpentelekomcloudLbListenerV3#protocol}
    */
    readonly protocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_listener_v3#protocol_port DataOpentelekomcloudLbListenerV3#protocol_port}
    */
    readonly protocolPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_listener_v3#tls_ciphers_policy DataOpentelekomcloudLbListenerV3#tls_ciphers_policy}
    */
    readonly tlsCiphersPolicy?: string;
}
export interface DataOpentelekomcloudLbListenerV3InsertHeaders {
}
export declare function dataOpentelekomcloudLbListenerV3InsertHeadersToTerraform(struct?: DataOpentelekomcloudLbListenerV3InsertHeaders): any;
export declare class DataOpentelekomcloudLbListenerV3InsertHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudLbListenerV3InsertHeaders | undefined;
    set internalValue(value: DataOpentelekomcloudLbListenerV3InsertHeaders | undefined);
    get forwardElbIp(): cdktf.IResolvable;
    get forwardedForPort(): cdktf.IResolvable;
    get forwardedHost(): cdktf.IResolvable;
    get forwardedPort(): cdktf.IResolvable;
}
export declare class DataOpentelekomcloudLbListenerV3InsertHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudLbListenerV3InsertHeadersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_listener_v3 opentelekomcloud_lb_listener_v3}
*/
export declare class DataOpentelekomcloudLbListenerV3 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "opentelekomcloud_lb_listener_v3";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_listener_v3 opentelekomcloud_lb_listener_v3} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudLbListenerV3Config = {}
    */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudLbListenerV3Config);
    get adminStateUp(): cdktf.IResolvable;
    private _clientCaTlsContainerRef?;
    get clientCaTlsContainerRef(): string;
    set clientCaTlsContainerRef(value: string);
    resetClientCaTlsContainerRef(): void;
    get clientCaTlsContainerRefInput(): string | undefined;
    private _clientTimeout?;
    get clientTimeout(): number;
    set clientTimeout(value: number);
    resetClientTimeout(): void;
    get clientTimeoutInput(): number | undefined;
    get createdAt(): string;
    private _defaultPoolId?;
    get defaultPoolId(): string;
    set defaultPoolId(value: string);
    resetDefaultPoolId(): void;
    get defaultPoolIdInput(): string | undefined;
    private _defaultTlsContainerRef?;
    get defaultTlsContainerRef(): string;
    set defaultTlsContainerRef(value: string);
    resetDefaultTlsContainerRef(): void;
    get defaultTlsContainerRefInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get http2Enable(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _insertHeaders;
    get insertHeaders(): DataOpentelekomcloudLbListenerV3InsertHeadersList;
    private _keepAliveTimeout?;
    get keepAliveTimeout(): number;
    set keepAliveTimeout(value: number);
    resetKeepAliveTimeout(): void;
    get keepAliveTimeoutInput(): number | undefined;
    private _loadbalancerId?;
    get loadbalancerId(): string;
    set loadbalancerId(value: string);
    resetLoadbalancerId(): void;
    get loadbalancerIdInput(): string | undefined;
    private _memberAddress?;
    get memberAddress(): string;
    set memberAddress(value: string);
    resetMemberAddress(): void;
    get memberAddressInput(): string | undefined;
    private _memberDeviceId?;
    get memberDeviceId(): string;
    set memberDeviceId(value: string);
    resetMemberDeviceId(): void;
    get memberDeviceIdInput(): string | undefined;
    get memberRetryEnable(): cdktf.IResolvable;
    private _memberTimeout?;
    get memberTimeout(): number;
    set memberTimeout(value: number);
    resetMemberTimeout(): void;
    get memberTimeoutInput(): number | undefined;
    get memoryRetryEnable(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get projectId(): string;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _protocolPort?;
    get protocolPort(): number;
    set protocolPort(value: number);
    resetProtocolPort(): void;
    get protocolPortInput(): number | undefined;
    get sniContainerRefs(): string[];
    private _tags;
    get tags(): cdktf.StringMap;
    private _tlsCiphersPolicy?;
    get tlsCiphersPolicy(): string;
    set tlsCiphersPolicy(value: string);
    resetTlsCiphersPolicy(): void;
    get tlsCiphersPolicyInput(): string | undefined;
    get updatedAt(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
