import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudObsBucketConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/obs_bucket#bucket DataOpentelekomcloudObsBucket#bucket}
    */
    readonly bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/obs_bucket#id DataOpentelekomcloudObsBucket#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataOpentelekomcloudObsBucketCorsRule {
}
export declare function dataOpentelekomcloudObsBucketCorsRuleToTerraform(struct?: DataOpentelekomcloudObsBucketCorsRule): any;
export declare class DataOpentelekomcloudObsBucketCorsRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudObsBucketCorsRule | undefined;
    set internalValue(value: DataOpentelekomcloudObsBucketCorsRule | undefined);
    get allowedHeaders(): string[];
    get allowedMethods(): string[];
    get allowedOrigins(): string[];
    get exposeHeaders(): string[];
    get maxAgeSeconds(): number;
}
export declare class DataOpentelekomcloudObsBucketCorsRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudObsBucketCorsRuleOutputReference;
}
export interface DataOpentelekomcloudObsBucketEventNotificationsFilterRule {
}
export declare function dataOpentelekomcloudObsBucketEventNotificationsFilterRuleToTerraform(struct?: DataOpentelekomcloudObsBucketEventNotificationsFilterRule): any;
export declare class DataOpentelekomcloudObsBucketEventNotificationsFilterRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudObsBucketEventNotificationsFilterRule | undefined;
    set internalValue(value: DataOpentelekomcloudObsBucketEventNotificationsFilterRule | undefined);
    get name(): string;
    get value(): string;
}
export declare class DataOpentelekomcloudObsBucketEventNotificationsFilterRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudObsBucketEventNotificationsFilterRuleOutputReference;
}
export interface DataOpentelekomcloudObsBucketEventNotifications {
}
export declare function dataOpentelekomcloudObsBucketEventNotificationsToTerraform(struct?: DataOpentelekomcloudObsBucketEventNotifications): any;
export declare class DataOpentelekomcloudObsBucketEventNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudObsBucketEventNotifications | undefined;
    set internalValue(value: DataOpentelekomcloudObsBucketEventNotifications | undefined);
    get events(): string[];
    private _filterRule;
    get filterRule(): DataOpentelekomcloudObsBucketEventNotificationsFilterRuleList;
    get id(): string;
    get topic(): string;
}
export declare class DataOpentelekomcloudObsBucketEventNotificationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudObsBucketEventNotificationsOutputReference;
}
export interface DataOpentelekomcloudObsBucketLifecycleRuleExpiration {
}
export declare function dataOpentelekomcloudObsBucketLifecycleRuleExpirationToTerraform(struct?: DataOpentelekomcloudObsBucketLifecycleRuleExpiration): any;
export declare class DataOpentelekomcloudObsBucketLifecycleRuleExpirationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudObsBucketLifecycleRuleExpiration | undefined;
    set internalValue(value: DataOpentelekomcloudObsBucketLifecycleRuleExpiration | undefined);
    get days(): number;
}
export declare class DataOpentelekomcloudObsBucketLifecycleRuleExpirationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudObsBucketLifecycleRuleExpirationOutputReference;
}
export interface DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionExpiration {
}
export declare function dataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionExpirationToTerraform(struct?: DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionExpiration): any;
export declare class DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionExpirationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionExpiration | undefined;
    set internalValue(value: DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionExpiration | undefined);
    get days(): number;
}
export declare class DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionExpirationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionExpirationOutputReference;
}
export interface DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionTransition {
}
export declare function dataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionTransitionToTerraform(struct?: DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionTransition): any;
export declare class DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionTransitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionTransition | undefined;
    set internalValue(value: DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionTransition | undefined);
    get days(): number;
    get storageClass(): string;
}
export declare class DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionTransitionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionTransitionOutputReference;
}
export interface DataOpentelekomcloudObsBucketLifecycleRuleTransition {
}
export declare function dataOpentelekomcloudObsBucketLifecycleRuleTransitionToTerraform(struct?: DataOpentelekomcloudObsBucketLifecycleRuleTransition): any;
export declare class DataOpentelekomcloudObsBucketLifecycleRuleTransitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudObsBucketLifecycleRuleTransition | undefined;
    set internalValue(value: DataOpentelekomcloudObsBucketLifecycleRuleTransition | undefined);
    get days(): number;
    get storageClass(): string;
}
export declare class DataOpentelekomcloudObsBucketLifecycleRuleTransitionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudObsBucketLifecycleRuleTransitionOutputReference;
}
export interface DataOpentelekomcloudObsBucketLifecycleRule {
}
export declare function dataOpentelekomcloudObsBucketLifecycleRuleToTerraform(struct?: DataOpentelekomcloudObsBucketLifecycleRule): any;
export declare class DataOpentelekomcloudObsBucketLifecycleRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudObsBucketLifecycleRule | undefined;
    set internalValue(value: DataOpentelekomcloudObsBucketLifecycleRule | undefined);
    get enabled(): cdktf.IResolvable;
    private _expiration;
    get expiration(): DataOpentelekomcloudObsBucketLifecycleRuleExpirationList;
    get name(): string;
    private _noncurrentVersionExpiration;
    get noncurrentVersionExpiration(): DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionExpirationList;
    private _noncurrentVersionTransition;
    get noncurrentVersionTransition(): DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionTransitionList;
    get prefix(): string;
    private _transition;
    get transition(): DataOpentelekomcloudObsBucketLifecycleRuleTransitionList;
}
export declare class DataOpentelekomcloudObsBucketLifecycleRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudObsBucketLifecycleRuleOutputReference;
}
export interface DataOpentelekomcloudObsBucketLogging {
}
export declare function dataOpentelekomcloudObsBucketLoggingToTerraform(struct?: DataOpentelekomcloudObsBucketLogging): any;
export declare class DataOpentelekomcloudObsBucketLoggingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudObsBucketLogging | undefined;
    set internalValue(value: DataOpentelekomcloudObsBucketLogging | undefined);
    get targetBucket(): string;
    get targetPrefix(): string;
}
export declare class DataOpentelekomcloudObsBucketLoggingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudObsBucketLoggingOutputReference;
}
export interface DataOpentelekomcloudObsBucketServerSideEncryption {
}
export declare function dataOpentelekomcloudObsBucketServerSideEncryptionToTerraform(struct?: DataOpentelekomcloudObsBucketServerSideEncryption): any;
export declare class DataOpentelekomcloudObsBucketServerSideEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudObsBucketServerSideEncryption | undefined;
    set internalValue(value: DataOpentelekomcloudObsBucketServerSideEncryption | undefined);
    get algorithm(): string;
    get kmsKeyId(): string;
}
export declare class DataOpentelekomcloudObsBucketServerSideEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudObsBucketServerSideEncryptionOutputReference;
}
export interface DataOpentelekomcloudObsBucketWebsite {
}
export declare function dataOpentelekomcloudObsBucketWebsiteToTerraform(struct?: DataOpentelekomcloudObsBucketWebsite): any;
export declare class DataOpentelekomcloudObsBucketWebsiteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudObsBucketWebsite | undefined;
    set internalValue(value: DataOpentelekomcloudObsBucketWebsite | undefined);
    get errorDocument(): string;
    get indexDocument(): string;
    get redirectAllRequestsTo(): string;
    get routingRules(): string;
}
export declare class DataOpentelekomcloudObsBucketWebsiteList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudObsBucketWebsiteOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/obs_bucket opentelekomcloud_obs_bucket}
*/
export declare class DataOpentelekomcloudObsBucket extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "opentelekomcloud_obs_bucket";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/obs_bucket opentelekomcloud_obs_bucket} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudObsBucketConfig
    */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudObsBucketConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    get bucketDomainName(): string;
    private _corsRule;
    get corsRule(): DataOpentelekomcloudObsBucketCorsRuleList;
    private _eventNotifications;
    get eventNotifications(): DataOpentelekomcloudObsBucketEventNotificationsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lifecycleRule;
    get lifecycleRule(): DataOpentelekomcloudObsBucketLifecycleRuleList;
    private _logging;
    get logging(): DataOpentelekomcloudObsBucketLoggingList;
    get region(): string;
    private _serverSideEncryption;
    get serverSideEncryption(): DataOpentelekomcloudObsBucketServerSideEncryptionList;
    get storageClass(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get versioning(): cdktf.IResolvable;
    private _website;
    get website(): DataOpentelekomcloudObsBucketWebsiteList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
