import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudRdsFlavorsV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_flavors_v3#db_type DataOpentelekomcloudRdsFlavorsV3#db_type}
    */
    readonly dbType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_flavors_v3#db_version DataOpentelekomcloudRdsFlavorsV3#db_version}
    */
    readonly dbVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_flavors_v3#id DataOpentelekomcloudRdsFlavorsV3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_flavors_v3#instance_mode DataOpentelekomcloudRdsFlavorsV3#instance_mode}
    */
    readonly instanceMode: string;
}
export interface DataOpentelekomcloudRdsFlavorsV3Flavors {
}
export declare function dataOpentelekomcloudRdsFlavorsV3FlavorsToTerraform(struct?: DataOpentelekomcloudRdsFlavorsV3Flavors): any;
export declare class DataOpentelekomcloudRdsFlavorsV3FlavorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudRdsFlavorsV3Flavors | undefined;
    set internalValue(value: DataOpentelekomcloudRdsFlavorsV3Flavors | undefined);
    private _azStatus;
    get azStatus(): cdktf.StringMap;
    get memory(): number;
    get mode(): string;
    get name(): string;
    get vcpus(): string;
}
export declare class DataOpentelekomcloudRdsFlavorsV3FlavorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudRdsFlavorsV3FlavorsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_flavors_v3 opentelekomcloud_rds_flavors_v3}
*/
export declare class DataOpentelekomcloudRdsFlavorsV3 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "opentelekomcloud_rds_flavors_v3";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_flavors_v3 opentelekomcloud_rds_flavors_v3} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudRdsFlavorsV3Config
    */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudRdsFlavorsV3Config);
    private _dbType?;
    get dbType(): string;
    set dbType(value: string);
    get dbTypeInput(): string | undefined;
    private _dbVersion?;
    get dbVersion(): string;
    set dbVersion(value: string);
    get dbVersionInput(): string | undefined;
    private _flavors;
    get flavors(): DataOpentelekomcloudRdsFlavorsV3FlavorsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceMode?;
    get instanceMode(): string;
    set instanceMode(value: string);
    get instanceModeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
