import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudRdsInstanceV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_instance_v3#datastore_type DataOpentelekomcloudRdsInstanceV3#datastore_type}
    */
    readonly datastoreType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_instance_v3#id DataOpentelekomcloudRdsInstanceV3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_instance_v3#name DataOpentelekomcloudRdsInstanceV3#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_instance_v3#port DataOpentelekomcloudRdsInstanceV3#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_instance_v3#region DataOpentelekomcloudRdsInstanceV3#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_instance_v3#subnet_id DataOpentelekomcloudRdsInstanceV3#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_instance_v3#type DataOpentelekomcloudRdsInstanceV3#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_instance_v3#vpc_id DataOpentelekomcloudRdsInstanceV3#vpc_id}
    */
    readonly vpcId?: string;
}
export interface DataOpentelekomcloudRdsInstanceV3BackupStrategy {
}
export declare function dataOpentelekomcloudRdsInstanceV3BackupStrategyToTerraform(struct?: DataOpentelekomcloudRdsInstanceV3BackupStrategy): any;
export declare class DataOpentelekomcloudRdsInstanceV3BackupStrategyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudRdsInstanceV3BackupStrategy | undefined;
    set internalValue(value: DataOpentelekomcloudRdsInstanceV3BackupStrategy | undefined);
    get keepDays(): number;
    get startTime(): string;
}
export declare class DataOpentelekomcloudRdsInstanceV3BackupStrategyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudRdsInstanceV3BackupStrategyOutputReference;
}
export interface DataOpentelekomcloudRdsInstanceV3Nodes {
}
export declare function dataOpentelekomcloudRdsInstanceV3NodesToTerraform(struct?: DataOpentelekomcloudRdsInstanceV3Nodes): any;
export declare class DataOpentelekomcloudRdsInstanceV3NodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOpentelekomcloudRdsInstanceV3Nodes | undefined;
    set internalValue(value: DataOpentelekomcloudRdsInstanceV3Nodes | undefined);
    get availabilityZone(): string;
    get id(): string;
    get name(): string;
    get role(): string;
    get status(): string;
}
export declare class DataOpentelekomcloudRdsInstanceV3NodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOpentelekomcloudRdsInstanceV3NodesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_instance_v3 opentelekomcloud_rds_instance_v3}
*/
export declare class DataOpentelekomcloudRdsInstanceV3 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "opentelekomcloud_rds_instance_v3";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_instance_v3 opentelekomcloud_rds_instance_v3} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudRdsInstanceV3Config = {}
    */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudRdsInstanceV3Config);
    get availabilityZone(): string[];
    private _backupStrategy;
    get backupStrategy(): DataOpentelekomcloudRdsInstanceV3BackupStrategyList;
    get created(): string;
    private _datastoreType?;
    get datastoreType(): string;
    set datastoreType(value: string);
    resetDatastoreType(): void;
    get datastoreTypeInput(): string | undefined;
    get datastoreVersion(): string;
    get dbUsername(): string;
    get diskEncryptionId(): string;
    get fixedIp(): string;
    get flavor(): string;
    private _ha;
    get ha(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nodes;
    get nodes(): DataOpentelekomcloudRdsInstanceV3NodesList;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    get privateIps(): string[];
    get publicIps(): string[];
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get securityGroupId(): string;
    get status(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get timezone(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    get updated(): string;
    get volumeSize(): number;
    get volumeType(): string;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    resetVpcId(): void;
    get vpcIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
